import{s as Hs,o as Es,n as bn}from"../chunks/scheduler.c57aa7ef.js";import{S as Ys,i as qs,g as i,s as n,r as p,A as Ns,h as o,f as a,c as s,j as Fs,u as d,x as r,k as Tn,y as Ss,a as l,v as m,d as f,t as h,w as c}from"../chunks/index.394f8801.js";import{T as gn}from"../chunks/Tip.23dfb1a9.js";import{C as M}from"../chunks/CodeBlock.b5488637.js";import{H as y,E as Ps}from"../chunks/getInferenceSnippets.54bf47f2.js";function Ds(T){let u,g='For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.';return{c(){u=i("p"),u.innerHTML=g},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-9hfq4t"&&(u.innerHTML=g)},m(w,b){l(w,u,b)},p:bn,d(w){w&&a(u)}}}function Ks(T){let u,g='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){u=i("p"),u.innerHTML=g},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1nbpolx"&&(u.innerHTML=g)},m(w,b){l(w,u,b)},p:bn,d(w){w&&a(u)}}}function Os(T){let u,g="This feature is experimental and subject to change.";return{c(){u=i("p"),u.textContent=g},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-13dtfem"&&(u.textContent=g)},m(w,b){l(w,u,b)},p:bn,d(w){w&&a(u)}}}function ei(T){let u,g='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){u=i("p"),u.innerHTML=g},l(w){u=o(w,"P",{"data-svelte-h":!0}),r(u)!=="svelte-19y7vpj"&&(u.innerHTML=g)},m(w,b){l(w,u,b)},p:bn,d(w){w&&a(u)}}}function ti(T){let u,g,w,b,v,qt,k,Jn='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Nt,U,_n="This guide explores in more detail other options and features for using LoRA.",St,C,Pt,R,jn='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Dt,B,$n='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Kt,L,Ot,I,Zn="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",ea,W,ta,V,aa,G,vn='<a href="https://huggingface.co/papers/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',la,A,kn="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",na,x,sa,X,Un="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",ia,Q,oa,z,Cn='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',ra,F,pa,H,Rn=`<a href="https://huggingface.co/papers/2406.05223" rel="nofollow">CorDA</a> builds task-aware LoRA adapters from weight decomposition oriented by the context of downstream task to learn (instruction-previewed mode, IPM) or world knowledge to maintain (knowledge-preserved mode, KPM).
The KPM not only achieves better performance than LoRA on fine-tuning tasks, but also mitigates the catastrophic forgetting of pre-trained world knowledge.
When preserving pre-trained knowledge is not a concern,
the IPM is favored because it can further accelerate convergence and enhance the fine-tuning performance.`,da,E,Bn="You need to configure the initialization method to “corda”, and specify the mode of IPM or KPM and the dataset to collect covariance matrices.",ma,Y,fa,q,Ln='For detailed instruction on using CorDA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/corda_finetuning" rel="nofollow">these instructions</a>.',ha,N,ca,S,In='<a href="https://huggingface.co/papers/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',ua,P,Wn="You just need to pass a single additional option to use OLoRA:",Ma,D,wa,K,Vn='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',ya,O,ga,ee,Gn='<a href="https://huggingface.co/papers/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',ba,te,An='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/main/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',Ta,ae,Ja,le,xn="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",_a,ne,Xn='It is recommended to perform EVA initialization on an accelerator(e.g. CUDA GPU, Intel XPU) as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',ja,se,$a,ie,Qn='Then, call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',Za,oe,va,re,zn='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',ka,J,Ua,pe,Ca,de,Ra,me,Fn='When quantizing the base model for QLoRA training, consider using the <a href="https://huggingface.co/papers/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Ba,fe,Hn="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",La,he,Ia,ce,En="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Wa,ue,Va,Me,Yn='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Ga,we,qn="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratively updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Aa,ye,Nn="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",xa,ge,Sn="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Xa,_,Qa,be,za,Te,Pn='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Fa,Je,Ha,_e,Ea,je,Dn='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://huggingface.co/papers/2402.09353" rel="nofollow">https://huggingface.co/papers/2402.09353</a>.',Ya,$e,qa,Ze,Kn="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",Na,ve,Sa,ke,On="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",Pa,Ue,Da,Ce,es=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 ZE_AFFINITY_MASK=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,Ka,Re,ts='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',Oa,Be,el,Le,as='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',tl,Ie,al,We,ls='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',ll,Ve,nl,Ge,sl,Ae,ns='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://huggingface.co/papers/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',il,xe,ol,Xe,ss='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',rl,Qe,is=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,pl,ze,dl,Fe,os='By default, all layers targeted with LoRA will have the same rank <code>r</code> and the same <code>lora_alpha</code> (which determines the LoRA scaling), depending on what was specified in the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. In some cases, however, you may want to indicate different values for different layers. This is possible by passing the <code>rank_pattern</code> and <code>alpha_pattern</code> arguments to <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. These arguments should be dictionaries with the key being the layer name and the value being the rank/alpha value. The keys can be <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular expressions</a> (regex). All LoRA layers that are not explicitly mentioned in <code>rank_pattern</code> and <code>alpha_pattern</code> will take the default <code>r</code> and <code>lora_alpha</code> values.',ml,He,rs="To give an example, let’s assume that we have a model with the following structure:",fl,Ee,hl,Ye,ps="<li><code>rank_pattern={&quot;foo&quot;: 42}</code> will match all 3 <code>foo</code> layers. Neither <code>foobar</code> nor <code>barfoo</code> are matched.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42}</code> will only match the <code>foo</code> layer of the model, but neither <code>module.foo</code> nor <code>module.module.foo</code>. This is because the <code>^</code> means “start of string” when using regular expressions, and only <code>foo</code> starts with <code>&quot;foo&quot;</code>, the other layer names have prefixes.</li> <li><code>rank_pattern={&quot;^module.foo&quot;: 42}</code> matches only <code>module.foo</code>, but not <code>module.module.foo</code>, for the same reason.</li> <li><code>rank_pattern={&quot;module.foo&quot;: 42}</code> matches both <code>module.foo</code> and <code>module.module.foo</code>, but not <code>foo</code>.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42, &quot;^module.module.foo&quot;: 55}</code> matches <code>foo</code> and <code>module.module.foo</code>, respectively, but not <code>module.foo</code>.</li> <li>There is no need to indicate <code>$</code> to mark the end of the match, as this is added automatically by PEFT.</li>",cl,qe,ds="The same logic applies to <code>alpha_pattern</code>. If you’re in doubt, don’t try to get fancy with regular expressions — just pass the full name for each module with a different rank/alpha, preceded by the <code>^</code> prefix, and you should be good.",ul,Ne,Ml,j,wl,Se,ms='Generally, you should use <code>target_modules</code> to target the module (e.g. <code>nn.Linear</code>). However, in some circumstances, this is not possible. E.g., in many mixture of expert (MoE) layers in HF Transformers, instead of using <code>nn.Linear</code>, an <code>nn.Parameter</code> is used. PEFT normally overwrites the <code>forward</code> method for LoRA, but for <code>nn.Parameter</code>, there is none. Therefore, to apply LoRA to that parameter, it needs to be targeted with <code>target_parameters</code>. As an example, for <a href="https://huggingface.co/collections/meta-llama/llama-4-67f0c30d9fe03840bc9d0164" rel="nofollow">Llama4</a>, you can pass: <code>target_parameters=[&#39;feed_forward.experts.gate_up_proj&#39;, &#39;feed_forward.experts.down_proj]</code>.',yl,Pe,gl,De,fs="<li>At the moment, this argument allows to target 2-dim or 3-dim <code>nn.Parameter</code>s. It is assumed that in the case of a 3-dim parameter, the 0th dimension is the expert dimension.</li> <li>It is currently not possible to add multiple LoRA adapters (via <code>model.add_adapter</code> or <code>model.load_adapter</code>) that use <code>target_parameters</code> at the same time.</li>",bl,Ke,Tl,Oe,hs="LoRA training can optionally include special purpose optimizers. Currently PEFT supports LoRA-FA and LoRA+.",Jl,et,_l,tt,cs='LoRA training can be more effective and efficient using LoRA-FA, as described in <a href="https://huggingface.co/papers/2308.03303" rel="nofollow">LoRA-FA</a>. LoRA-FA reduces activation memory consumption by fixing the matrix A and only tuning the matrix B. During training, the gradient of B is optimized to approximate the full parameter fine-tuning gradient. Moreover, the memory consumption of LoRA-FA is not sensitive to the rank (since it erases the activation of $A$), therefore it can improve performance by enlarging lora rank without increasing memory consumption.',jl,at,$l,lt,Zl,nt,us='LoRA training can be optimized using <a href="https://huggingface.co/papers/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',vl,st,kl,it,Ul,ot,Ms='Sometimes it is necessary to not only change some layer’s weights but to add new tokens as well. With larger models this can be a memory-costly endeavour. PEFT LoRA adapters support the <code>trainable_token_indices</code> parameter which allows tuning of other tokens alongside fine-tuning of specific layers with LoRA. This method only trains the tokens you specify and leaves all other tokens untouched. This saves memory and doesn’t throw away learned context of existing token embeddings in contrast to when training the whole embedding matrix. Under the hood this method uses the layer of <a href="/docs/peft/main/en/package_reference/trainable_tokens#peft.TrainableTokensModel">TrainableTokensModel</a>.',Cl,rt,Rl,pt,ws="In the snippet below we show how to add new tokens to the model and how to train it alongside the other layers in the model.",Bl,dt,Ll,mt,ys=`The token weights are part of your adapter state dict and saved alongside the LoRA weights.
If we would have used full fine-tuning with <code>modules_to_save=[&#39;embed_tokens&#39;]</code> we would have stored the full embedding matrix in the checkpoint, leading to a much bigger file.`,Il,ft,gs="To give a bit of an indication how much VRAM can be saved, a rudimentary comparison of the above example was made between training the embedding matrix fully (<code>modules_to_save=[&quot;embed_tokens&quot;]</code>), using a LoRA for the embedding matrix (<code>target_modules=[..., &quot;embed_tokens&quot;]</code>, rank 32) and trainable tokens (<code>trainable_token_indices=[...]</code>, 6 tokens). Trainable tokens used about as much VRAM (15,562MB vs. 15,581MB) as LoRA while being specific to the tokens and saved ~1GB of VRAM over fully training the embedding matrix.",Wl,ht,Vl,ct,bs='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',Gl,ut,Ts="Below is a diagram that explains the intuition of LoRA adapter merging:",Al,$,Js='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',xl,Mt,_s="We show in the snippets below how to run that using PEFT.",Xl,wt,Ql,yt,js='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',zl,gt,Fl,bt,$s='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',Hl,Tt,Zs="First load the base model:",El,Jt,Yl,_t,vs="Then we load the first adapter:",ql,jt,Nl,$t,ks="Then load a different adapter and merge it with the first one:",Sl,Zt,Pl,Z,Dl,vt,Us="Now, perform inference:",Kl,kt,Ol,Ut,en,Ct,Cs='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',tn,Rt,an,Bt,Rs='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',ln,Lt,nn,It,sn,Wt,Bs="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",on,Vt,Ls="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",rn,Gt,pn,At,Is="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",dn,xt,mn,Xt,Ws="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",fn,Qt,Vs="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",hn,zt,cn,Ft,Gs="Using this feature has some drawbacks, namely:",un,Ht,As='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights were merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handful of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Mn,Et,wn,Yt,yn;return v=new y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),C=new y({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),L=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),W=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),V=new y({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),x=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),Q=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLik=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...)',wrap:!1}}),F=new y({props:{title:"CorDA",local:"corda",headingTag:"h3"}}),Y=new M({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwcnVuX21vZGVsKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBtb2RlbCU2MCUyMGFuZCUyMCU2MGRhdGFzZXQlNjAlMjBpcyUyMGluJTIwY29udGV4dC4uLiUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwoKipiYXRjaCklMEElMEElMEFjb3JkYV9jb25maWclMjAlM0QlMjBDb3JkYUNvbmZpZyglMEElMjAlMjAlMjAlMjBjb3JkYV9tZXRob2QlM0QlMjJrcG0lMjIlMkMlMEEpJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyY29yZGElMjIlMkMlMEElMjAlMjAlMjAlMjBjb3JkYV9jb25maWclM0Rjb3JkYV9jb25maWclMkMlMEEpJTBBcHJlcHJvY2Vzc19jb3JkYShtb2RlbCUyQyUyMGxvcmFfY29uZmlnJTJDJTIwcnVuX21vZGVsJTNEcnVuX21vZGVsKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_model</span>():
    <span class="hljs-comment"># Assume \`model\` and \`dataset\` is in context...</span>
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataset:
        model(**batch)


corda_config = CordaConfig(
    corda_method=<span class="hljs-string">&quot;kpm&quot;</span>,
)
lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;corda&quot;</span>,
    corda_config=corda_config,
)
preprocess_corda(model, lora_config, run_model=run_model)
peft_model = get_peft_model(model, lora_config)`,wrap:!1}}),N=new y({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),D=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),O=new y({props:{title:"EVA",local:"eva",headingTag:"h3"}}),ae=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),se=new M({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),oe=new M({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),J=new gn({props:{$$slots:{default:[Ds]},$$scope:{ctx:T}}}),pe=new y({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),de=new y({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),he=new y({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),ue=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),_=new gn({props:{$$slots:{default:[Ks]},$$scope:{ctx:T}}}),be=new y({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),Je=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),_e=new y({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),$e=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ve=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),Ue=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),Be=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),Ie=new y({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),Ve=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),Ge=new y({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),xe=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),ze=new y({props:{title:"Fine grained control over ranks and alpha (scaling)",local:"fine-grained-control-over-ranks-and-alpha-scaling",headingTag:"h3"}}),Ee=new M({props:{code:"cHJpbnQobW9kZWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)
Outer(
  (foo): Linear(...)
  (module): Middle(
    (foo): Linear(...)
    (foobar): Linear(...)
    (module): Inner(
      (foo): Linear(...)
      (barfoo): Linear(...)
    )
  )
)`,wrap:!1}}),Ne=new y({props:{title:"Targeting nn.Parameter directly",local:"targeting-nnparameter-directly",headingTag:"h3"}}),j=new gn({props:{warning:!0,$$slots:{default:[Os]},$$scope:{ctx:T}}}),Pe=new y({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),Ke=new y({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),et=new y({props:{title:"LoRA-FA Optimizer",local:"lora-fa-optimizer",headingTag:"h3"}}),at=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwcGVmdC5vcHRpbWl6ZXJzJTIwaW1wb3J0JTIwY3JlYXRlX2xvcmFmYV9vcHRpbWl6ZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVHJhaW5lciUyQyUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4pJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwY29uZmlnKSUwQSUwQW9wdGltaXplciUyMCUzRCUyMGNyZWF0ZV9sb3JhZmFfb3B0aW1pemVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0Q3ZS01JTJDJTBBKSUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRDEwMDAlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_lorafa_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, get_cosine_schedule_with_warmup

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)

config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_lorafa_optimizer(
    model=model,
    r=<span class="hljs-number">128</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lr=<span class="hljs-number">7e-5</span>,
)

scheduler = get_cosine_schedule_with_warmup(
    optimizer,
    num_warmup_steps=<span class="hljs-number">100</span>,
    num_training_steps=<span class="hljs-number">1000</span>,
)

trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),lt=new y({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),st=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),it=new y({props:{title:"Efficiently train tokens alongside LoRA",local:"efficiently-train-tokens-alongside-lora",headingTag:"h2"}}),rt=new M({props:{code:"JTIzJTIwZm9yJTIwbGF5ZXIlMjAnZW1iZWRfdG9rZW5zJyUwQWNvbmZpZyUyMCUzRCUyMExvcmFDb25maWcodHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlNUJpZHhfMSUyQyUyMGlkeF8yJTJDJTIwLi4uJTVEJTJDJTIwLi4uKSUwQSUwQSUyMyUyMHNwZWNpZmljJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYl90b2tlbnMnJTNBJTIwJTVCaWR4XzElMkMlMjBpZHhfMiUyQyUyMC4uLiU1RCU3RCUyQyUyMC4uLik=",highlighted:`<span class="hljs-comment"># for layer &#x27;embed_tokens&#x27;</span>
config = LoraConfig(trainable_token_indices=[idx_1, idx_2, ...], ...)

<span class="hljs-comment"># specific embedding layer</span>
config = LoraConfig(trainable_token_indices={<span class="hljs-string">&#x27;emb_tokens&#x27;</span>: [idx_1, idx_2, ...]}, ...)`,wrap:!1}}),dt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQSUyMyUyMHdlJTIwZGVmaW5lJTIwb3VyJTIwbmV3JTIwdG9rZW5zJTIwYW5kJTIwYWRkJTIwdGhlbSUyMHRvJTIwdGhlJTIwdG9rZW5pemVyJTIwYXMlMjBzcGVjaWFsJTIwdG9rZW5zJTBBc3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUInJTNDJTdDc3RhcnRfdGhpbmslN0MlM0UnJTJDJTIwJyUzQyU3Q3N0b3BfdGhpbmslN0MlM0UnJTVEJTBBdG9rZW5pemVyLmFkZF9zcGVjaWFsX3Rva2VucyglN0InYWRkaXRpb25hbF9zcGVjaWFsX3Rva2VucyclM0ElMjBzcGVjaWFsX3Rva2VucyU3RCklMEElMEElMjMlMjBtYWtlJTIwcm9vbSUyMGZvciUyMG5ldyUyMHRva2VucyUyMGluJTIwdGhlJTIwZW1iZWRkaW5nJTIwbWF0cml4JTIwaWYlMjBpdCUyMGlzbid0JTIwYmlnJTIwZW5vdWdoJTIwYWxyZWFkeSUwQWJhc2VfbW9kZWwucmVzaXplX3Rva2VuX2VtYmVkZGluZ3MobWF4KGxlbih0b2tlbml6ZXIpJTJDJTIwYmFzZV9tb2RlbC5tb2RlbC5lbWJlZF90b2tlbnMubnVtX2VtYmVkZGluZ3MpKSUwQSUwQSUyMyUyMHR5cGljYWwlMjBMb1JBJTIwY29uZmlnJTIwd2l0aCUyMCU2MHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTYwJTIwdGFyZ2V0aW5nJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMjAlNjBlbWJlZF90b2tlbnMlNjAlMEElMjMlMjBhbmQlMjBzcGVjaWZpY2FsbHklMjBvdXIlMjBuZXclMjB0b2tlbnMlMjB3ZSUyMGp1c3QlMjBhZGRlZCUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCdhbGwtbGluZWFyJyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYmVkX3Rva2VucyclM0ElMjB0b2tlbml6ZXIuY29udmVydF90b2tlbnNfdG9faWRzKHNwZWNpYWxfdG9rZW5zKSU3RCUyQyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoYmFzZV9tb2RlbCUyQyUyMGxvcmFfY29uZmlnKSUwQSUwQSUyMyUyMHByb2NlZWQlMjB0byUyMHRyYWluJTIwdGhlJTIwbW9kZWwlMjBsaWtlJTIwbm9ybWFsJTBBJTVCLi4uJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

<span class="hljs-comment"># we define our new tokens and add them to the tokenizer as special tokens</span>
special_tokens = [<span class="hljs-string">&#x27;&lt;|start_think|&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;|stop_think|&gt;&#x27;</span>]
tokenizer.add_special_tokens({<span class="hljs-string">&#x27;additional_special_tokens&#x27;</span>: special_tokens})

<span class="hljs-comment"># make room for new tokens in the embedding matrix if it isn&#x27;t big enough already</span>
base_model.resize_token_embeddings(<span class="hljs-built_in">max</span>(<span class="hljs-built_in">len</span>(tokenizer), base_model.model.embed_tokens.num_embeddings))

<span class="hljs-comment"># typical LoRA config with \`trainable_token_indices\` targeting embedding layer \`embed_tokens\`</span>
<span class="hljs-comment"># and specifically our new tokens we just added</span>
lora_config = LoraConfig(
    target_modules=<span class="hljs-string">&#x27;all-linear&#x27;</span>,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(special_tokens)},
)
peft_model = get_peft_model(base_model, lora_config)

<span class="hljs-comment"># proceed to train the model like normal</span>
[...]`,wrap:!1}}),ht=new y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),wt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),gt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Jt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),jt=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),Zt=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),Z=new gn({props:{$$slots:{default:[ei]},$$scope:{ctx:T}}}),kt=new M({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Ut=new y({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Rt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Lt=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),It=new y({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Gt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),xt=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),zt=new y({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),Et=new Ps({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){u=i("meta"),g=n(),w=i("p"),b=n(),p(v.$$.fragment),qt=n(),k=i("p"),k.innerHTML=Jn,Nt=n(),U=i("p"),U.textContent=_n,St=n(),p(C.$$.fragment),Pt=n(),R=i("p"),R.innerHTML=jn,Dt=n(),B=i("p"),B.innerHTML=$n,Kt=n(),p(L.$$.fragment),Ot=n(),I=i("p"),I.innerHTML=Zn,ea=n(),p(W.$$.fragment),ta=n(),p(V.$$.fragment),aa=n(),G=i("p"),G.innerHTML=vn,la=n(),A=i("p"),A.textContent=kn,na=n(),p(x.$$.fragment),sa=n(),X=i("p"),X.textContent=Un,ia=n(),p(Q.$$.fragment),oa=n(),z=i("p"),z.innerHTML=Cn,ra=n(),p(F.$$.fragment),pa=n(),H=i("p"),H.innerHTML=Rn,da=n(),E=i("p"),E.textContent=Bn,ma=n(),p(Y.$$.fragment),fa=n(),q=i("p"),q.innerHTML=Ln,ha=n(),p(N.$$.fragment),ca=n(),S=i("p"),S.innerHTML=In,ua=n(),P=i("p"),P.textContent=Wn,Ma=n(),p(D.$$.fragment),wa=n(),K=i("p"),K.innerHTML=Vn,ya=n(),p(O.$$.fragment),ga=n(),ee=i("p"),ee.innerHTML=Gn,ba=n(),te=i("p"),te.innerHTML=An,Ta=n(),p(ae.$$.fragment),Ja=n(),le=i("p"),le.innerHTML=xn,_a=n(),ne=i("p"),ne.innerHTML=Xn,ja=n(),p(se.$$.fragment),$a=n(),ie=i("p"),ie.innerHTML=Qn,Za=n(),p(oe.$$.fragment),va=n(),re=i("p"),re.innerHTML=zn,ka=n(),p(J.$$.fragment),Ua=n(),p(pe.$$.fragment),Ca=n(),p(de.$$.fragment),Ra=n(),me=i("p"),me.innerHTML=Fn,Ba=n(),fe=i("p"),fe.innerHTML=Hn,La=n(),p(he.$$.fragment),Ia=n(),ce=i("p"),ce.innerHTML=En,Wa=n(),p(ue.$$.fragment),Va=n(),Me=i("p"),Me.innerHTML=Yn,Ga=n(),we=i("p"),we.innerHTML=qn,Aa=n(),ye=i("p"),ye.innerHTML=Nn,xa=n(),ge=i("ul"),ge.innerHTML=Sn,Xa=n(),p(_.$$.fragment),Qa=n(),p(be.$$.fragment),za=n(),Te=i("p"),Te.innerHTML=Pn,Fa=n(),p(Je.$$.fragment),Ha=n(),p(_e.$$.fragment),Ea=n(),je=i("p"),je.innerHTML=Dn,Ya=n(),p($e.$$.fragment),qa=n(),Ze=i("p"),Ze.innerHTML=Kn,Na=n(),p(ve.$$.fragment),Sa=n(),ke=i("p"),ke.innerHTML=On,Pa=n(),p(Ue.$$.fragment),Da=n(),Ce=i("p"),Ce.innerHTML=es,Ka=n(),Re=i("table"),Re.innerHTML=ts,Oa=n(),p(Be.$$.fragment),el=n(),Le=i("ul"),Le.innerHTML=as,tl=n(),p(Ie.$$.fragment),al=n(),We=i("p"),We.innerHTML=ls,ll=n(),p(Ve.$$.fragment),nl=n(),p(Ge.$$.fragment),sl=n(),Ae=i("p"),Ae.innerHTML=ns,il=n(),p(xe.$$.fragment),ol=n(),Xe=i("p"),Xe.innerHTML=ss,rl=n(),Qe=i("p"),Qe.innerHTML=is,pl=n(),p(ze.$$.fragment),dl=n(),Fe=i("p"),Fe.innerHTML=os,ml=n(),He=i("p"),He.textContent=rs,fl=n(),p(Ee.$$.fragment),hl=n(),Ye=i("ul"),Ye.innerHTML=ps,cl=n(),qe=i("p"),qe.innerHTML=ds,ul=n(),p(Ne.$$.fragment),Ml=n(),p(j.$$.fragment),wl=n(),Se=i("p"),Se.innerHTML=ms,yl=n(),p(Pe.$$.fragment),gl=n(),De=i("ul"),De.innerHTML=fs,bl=n(),p(Ke.$$.fragment),Tl=n(),Oe=i("p"),Oe.textContent=hs,Jl=n(),p(et.$$.fragment),_l=n(),tt=i("p"),tt.innerHTML=cs,jl=n(),p(at.$$.fragment),$l=n(),p(lt.$$.fragment),Zl=n(),nt=i("p"),nt.innerHTML=us,vl=n(),p(st.$$.fragment),kl=n(),p(it.$$.fragment),Ul=n(),ot=i("p"),ot.innerHTML=Ms,Cl=n(),p(rt.$$.fragment),Rl=n(),pt=i("p"),pt.textContent=ws,Bl=n(),p(dt.$$.fragment),Ll=n(),mt=i("p"),mt.innerHTML=ys,Il=n(),ft=i("p"),ft.innerHTML=gs,Wl=n(),p(ht.$$.fragment),Vl=n(),ct=i("p"),ct.innerHTML=bs,Gl=n(),ut=i("p"),ut.textContent=Ts,Al=n(),$=i("div"),$.innerHTML=Js,xl=n(),Mt=i("p"),Mt.textContent=_s,Xl=n(),p(wt.$$.fragment),Ql=n(),yt=i("p"),yt.innerHTML=js,zl=n(),p(gt.$$.fragment),Fl=n(),bt=i("p"),bt.innerHTML=$s,Hl=n(),Tt=i("p"),Tt.textContent=Zs,El=n(),p(Jt.$$.fragment),Yl=n(),_t=i("p"),_t.textContent=vs,ql=n(),p(jt.$$.fragment),Nl=n(),$t=i("p"),$t.textContent=ks,Sl=n(),p(Zt.$$.fragment),Pl=n(),p(Z.$$.fragment),Dl=n(),vt=i("p"),vt.textContent=Us,Kl=n(),p(kt.$$.fragment),Ol=n(),p(Ut.$$.fragment),en=n(),Ct=i("p"),Ct.innerHTML=Cs,tn=n(),p(Rt.$$.fragment),an=n(),Bt=i("p"),Bt.innerHTML=Rs,ln=n(),p(Lt.$$.fragment),nn=n(),p(It.$$.fragment),sn=n(),Wt=i("p"),Wt.textContent=Bs,on=n(),Vt=i("p"),Vt.innerHTML=Ls,rn=n(),p(Gt.$$.fragment),pn=n(),At=i("p"),At.innerHTML=Is,dn=n(),p(xt.$$.fragment),mn=n(),Xt=i("p"),Xt.innerHTML=Ws,fn=n(),Qt=i("p"),Qt.innerHTML=Vs,hn=n(),p(zt.$$.fragment),cn=n(),Ft=i("p"),Ft.textContent=Gs,un=n(),Ht=i("ul"),Ht.innerHTML=As,Mn=n(),p(Et.$$.fragment),wn=n(),Yt=i("p"),this.h()},l(e){const t=Ns("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(a),g=s(e),w=o(e,"P",{}),Fs(w).forEach(a),b=s(e),d(v.$$.fragment,e),qt=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-38uxl6"&&(k.innerHTML=Jn),Nt=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-ovsn32"&&(U.textContent=_n),St=s(e),d(C.$$.fragment,e),Pt=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-j883mf"&&(R.innerHTML=jn),Dt=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1fujb7a"&&(B.innerHTML=$n),Kt=s(e),d(L.$$.fragment,e),Ot=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-mwvui1"&&(I.innerHTML=Zn),ea=s(e),d(W.$$.fragment,e),ta=s(e),d(V.$$.fragment,e),aa=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1dv6v3"&&(G.innerHTML=vn),la=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1hy0lgx"&&(A.textContent=kn),na=s(e),d(x.$$.fragment,e),sa=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-auzrbb"&&(X.textContent=Un),ia=s(e),d(Q.$$.fragment,e),oa=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-16k39wq"&&(z.innerHTML=Cn),ra=s(e),d(F.$$.fragment,e),pa=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-53sj5j"&&(H.innerHTML=Rn),da=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1s3c5rd"&&(E.textContent=Bn),ma=s(e),d(Y.$$.fragment,e),fa=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-19qemwc"&&(q.innerHTML=Ln),ha=s(e),d(N.$$.fragment,e),ca=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1iny7jf"&&(S.innerHTML=In),ua=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1j9g8qn"&&(P.textContent=Wn),Ma=s(e),d(D.$$.fragment,e),wa=s(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-sulxp4"&&(K.innerHTML=Vn),ya=s(e),d(O.$$.fragment,e),ga=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-zsbb0y"&&(ee.innerHTML=Gn),ba=s(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1gqkzq0"&&(te.innerHTML=An),Ta=s(e),d(ae.$$.fragment,e),Ja=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-168zxvb"&&(le.innerHTML=xn),_a=s(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-18j5yjn"&&(ne.innerHTML=Xn),ja=s(e),d(se.$$.fragment,e),$a=s(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-8ll8w8"&&(ie.innerHTML=Qn),Za=s(e),d(oe.$$.fragment,e),va=s(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-ryiojp"&&(re.innerHTML=zn),ka=s(e),d(J.$$.fragment,e),Ua=s(e),d(pe.$$.fragment,e),Ca=s(e),d(de.$$.fragment,e),Ra=s(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-icixot"&&(me.innerHTML=Fn),Ba=s(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-7f0aai"&&(fe.innerHTML=Hn),La=s(e),d(he.$$.fragment,e),Ia=s(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-14vtcq9"&&(ce.innerHTML=En),Wa=s(e),d(ue.$$.fragment,e),Va=s(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1nywyxh"&&(Me.innerHTML=Yn),Ga=s(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1m1yphh"&&(we.innerHTML=qn),Aa=s(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-yl8kok"&&(ye.innerHTML=Nn),xa=s(e),ge=o(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-12tl4fy"&&(ge.innerHTML=Sn),Xa=s(e),d(_.$$.fragment,e),Qa=s(e),d(be.$$.fragment,e),za=s(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-omuw13"&&(Te.innerHTML=Pn),Fa=s(e),d(Je.$$.fragment,e),Ha=s(e),d(_e.$$.fragment,e),Ea=s(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-x8nt61"&&(je.innerHTML=Dn),Ya=s(e),d($e.$$.fragment,e),qa=s(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-8wzhde"&&(Ze.innerHTML=Kn),Na=s(e),d(ve.$$.fragment,e),Sa=s(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-16lyt50"&&(ke.innerHTML=On),Pa=s(e),d(Ue.$$.fragment,e),Da=s(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-a1fvzo"&&(Ce.innerHTML=es),Ka=s(e),Re=o(e,"TABLE",{"data-svelte-h":!0}),r(Re)!=="svelte-1iyfgt7"&&(Re.innerHTML=ts),Oa=s(e),d(Be.$$.fragment,e),el=s(e),Le=o(e,"UL",{"data-svelte-h":!0}),r(Le)!=="svelte-1nce7z9"&&(Le.innerHTML=as),tl=s(e),d(Ie.$$.fragment,e),al=s(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-15vxux2"&&(We.innerHTML=ls),ll=s(e),d(Ve.$$.fragment,e),nl=s(e),d(Ge.$$.fragment,e),sl=s(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-ku1fuj"&&(Ae.innerHTML=ns),il=s(e),d(xe.$$.fragment,e),ol=s(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1ttqqw0"&&(Xe.innerHTML=ss),rl=s(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-foj0wd"&&(Qe.innerHTML=is),pl=s(e),d(ze.$$.fragment,e),dl=s(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-ed0v39"&&(Fe.innerHTML=os),ml=s(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-dtt8e"&&(He.textContent=rs),fl=s(e),d(Ee.$$.fragment,e),hl=s(e),Ye=o(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-1qf6hnm"&&(Ye.innerHTML=ps),cl=s(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-qh5siy"&&(qe.innerHTML=ds),ul=s(e),d(Ne.$$.fragment,e),Ml=s(e),d(j.$$.fragment,e),wl=s(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-jvkb1r"&&(Se.innerHTML=ms),yl=s(e),d(Pe.$$.fragment,e),gl=s(e),De=o(e,"UL",{"data-svelte-h":!0}),r(De)!=="svelte-1h2fpez"&&(De.innerHTML=fs),bl=s(e),d(Ke.$$.fragment,e),Tl=s(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-ws58tf"&&(Oe.textContent=hs),Jl=s(e),d(et.$$.fragment,e),_l=s(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-18tpzlm"&&(tt.innerHTML=cs),jl=s(e),d(at.$$.fragment,e),$l=s(e),d(lt.$$.fragment,e),Zl=s(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1i0u5p9"&&(nt.innerHTML=us),vl=s(e),d(st.$$.fragment,e),kl=s(e),d(it.$$.fragment,e),Ul=s(e),ot=o(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-iri31w"&&(ot.innerHTML=Ms),Cl=s(e),d(rt.$$.fragment,e),Rl=s(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-66nz7l"&&(pt.textContent=ws),Bl=s(e),d(dt.$$.fragment,e),Ll=s(e),mt=o(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-32mf1g"&&(mt.innerHTML=ys),Il=s(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-sspyjf"&&(ft.innerHTML=gs),Wl=s(e),d(ht.$$.fragment,e),Vl=s(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1c3h9aa"&&(ct.innerHTML=bs),Gl=s(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1wwmf5r"&&(ut.textContent=Ts),Al=s(e),$=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-1f6iuw5"&&($.innerHTML=Js),xl=s(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-hlzwis"&&(Mt.textContent=_s),Xl=s(e),d(wt.$$.fragment,e),Ql=s(e),yt=o(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-m3cr6r"&&(yt.innerHTML=js),zl=s(e),d(gt.$$.fragment,e),Fl=s(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-kbqhpl"&&(bt.innerHTML=$s),Hl=s(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1mwdwt1"&&(Tt.textContent=Zs),El=s(e),d(Jt.$$.fragment,e),Yl=s(e),_t=o(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1lnmg1d"&&(_t.textContent=vs),ql=s(e),d(jt.$$.fragment,e),Nl=s(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1n53hd9"&&($t.textContent=ks),Sl=s(e),d(Zt.$$.fragment,e),Pl=s(e),d(Z.$$.fragment,e),Dl=s(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-qwbdkg"&&(vt.textContent=Us),Kl=s(e),d(kt.$$.fragment,e),Ol=s(e),d(Ut.$$.fragment,e),en=s(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-ke62q2"&&(Ct.innerHTML=Cs),tn=s(e),d(Rt.$$.fragment,e),an=s(e),Bt=o(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-cvmoj6"&&(Bt.innerHTML=Rs),ln=s(e),d(Lt.$$.fragment,e),nn=s(e),d(It.$$.fragment,e),sn=s(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1fq5tpu"&&(Wt.textContent=Bs),on=s(e),Vt=o(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-lcywla"&&(Vt.innerHTML=Ls),rn=s(e),d(Gt.$$.fragment,e),pn=s(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-6wkyom"&&(At.innerHTML=Is),dn=s(e),d(xt.$$.fragment,e),mn=s(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1o40ch6"&&(Xt.innerHTML=Ws),fn=s(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-mqf2jo"&&(Qt.innerHTML=Vs),hn=s(e),d(zt.$$.fragment,e),cn=s(e),Ft=o(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-e0xhf6"&&(Ft.textContent=Gs),un=s(e),Ht=o(e,"UL",{"data-svelte-h":!0}),r(Ht)!=="svelte-brh7gh"&&(Ht.innerHTML=As),Mn=s(e),d(Et.$$.fragment,e),wn=s(e),Yt=o(e,"P",{}),Fs(Yt).forEach(a),this.h()},h(){Tn(u,"name","hf:doc:metadata"),Tn(u,"content",ai),Tn($,"class","flex justify-center")},m(e,t){Ss(document.head,u),l(e,g,t),l(e,w,t),l(e,b,t),m(v,e,t),l(e,qt,t),l(e,k,t),l(e,Nt,t),l(e,U,t),l(e,St,t),m(C,e,t),l(e,Pt,t),l(e,R,t),l(e,Dt,t),l(e,B,t),l(e,Kt,t),m(L,e,t),l(e,Ot,t),l(e,I,t),l(e,ea,t),m(W,e,t),l(e,ta,t),m(V,e,t),l(e,aa,t),l(e,G,t),l(e,la,t),l(e,A,t),l(e,na,t),m(x,e,t),l(e,sa,t),l(e,X,t),l(e,ia,t),m(Q,e,t),l(e,oa,t),l(e,z,t),l(e,ra,t),m(F,e,t),l(e,pa,t),l(e,H,t),l(e,da,t),l(e,E,t),l(e,ma,t),m(Y,e,t),l(e,fa,t),l(e,q,t),l(e,ha,t),m(N,e,t),l(e,ca,t),l(e,S,t),l(e,ua,t),l(e,P,t),l(e,Ma,t),m(D,e,t),l(e,wa,t),l(e,K,t),l(e,ya,t),m(O,e,t),l(e,ga,t),l(e,ee,t),l(e,ba,t),l(e,te,t),l(e,Ta,t),m(ae,e,t),l(e,Ja,t),l(e,le,t),l(e,_a,t),l(e,ne,t),l(e,ja,t),m(se,e,t),l(e,$a,t),l(e,ie,t),l(e,Za,t),m(oe,e,t),l(e,va,t),l(e,re,t),l(e,ka,t),m(J,e,t),l(e,Ua,t),m(pe,e,t),l(e,Ca,t),m(de,e,t),l(e,Ra,t),l(e,me,t),l(e,Ba,t),l(e,fe,t),l(e,La,t),m(he,e,t),l(e,Ia,t),l(e,ce,t),l(e,Wa,t),m(ue,e,t),l(e,Va,t),l(e,Me,t),l(e,Ga,t),l(e,we,t),l(e,Aa,t),l(e,ye,t),l(e,xa,t),l(e,ge,t),l(e,Xa,t),m(_,e,t),l(e,Qa,t),m(be,e,t),l(e,za,t),l(e,Te,t),l(e,Fa,t),m(Je,e,t),l(e,Ha,t),m(_e,e,t),l(e,Ea,t),l(e,je,t),l(e,Ya,t),m($e,e,t),l(e,qa,t),l(e,Ze,t),l(e,Na,t),m(ve,e,t),l(e,Sa,t),l(e,ke,t),l(e,Pa,t),m(Ue,e,t),l(e,Da,t),l(e,Ce,t),l(e,Ka,t),l(e,Re,t),l(e,Oa,t),m(Be,e,t),l(e,el,t),l(e,Le,t),l(e,tl,t),m(Ie,e,t),l(e,al,t),l(e,We,t),l(e,ll,t),m(Ve,e,t),l(e,nl,t),m(Ge,e,t),l(e,sl,t),l(e,Ae,t),l(e,il,t),m(xe,e,t),l(e,ol,t),l(e,Xe,t),l(e,rl,t),l(e,Qe,t),l(e,pl,t),m(ze,e,t),l(e,dl,t),l(e,Fe,t),l(e,ml,t),l(e,He,t),l(e,fl,t),m(Ee,e,t),l(e,hl,t),l(e,Ye,t),l(e,cl,t),l(e,qe,t),l(e,ul,t),m(Ne,e,t),l(e,Ml,t),m(j,e,t),l(e,wl,t),l(e,Se,t),l(e,yl,t),m(Pe,e,t),l(e,gl,t),l(e,De,t),l(e,bl,t),m(Ke,e,t),l(e,Tl,t),l(e,Oe,t),l(e,Jl,t),m(et,e,t),l(e,_l,t),l(e,tt,t),l(e,jl,t),m(at,e,t),l(e,$l,t),m(lt,e,t),l(e,Zl,t),l(e,nt,t),l(e,vl,t),m(st,e,t),l(e,kl,t),m(it,e,t),l(e,Ul,t),l(e,ot,t),l(e,Cl,t),m(rt,e,t),l(e,Rl,t),l(e,pt,t),l(e,Bl,t),m(dt,e,t),l(e,Ll,t),l(e,mt,t),l(e,Il,t),l(e,ft,t),l(e,Wl,t),m(ht,e,t),l(e,Vl,t),l(e,ct,t),l(e,Gl,t),l(e,ut,t),l(e,Al,t),l(e,$,t),l(e,xl,t),l(e,Mt,t),l(e,Xl,t),m(wt,e,t),l(e,Ql,t),l(e,yt,t),l(e,zl,t),m(gt,e,t),l(e,Fl,t),l(e,bt,t),l(e,Hl,t),l(e,Tt,t),l(e,El,t),m(Jt,e,t),l(e,Yl,t),l(e,_t,t),l(e,ql,t),m(jt,e,t),l(e,Nl,t),l(e,$t,t),l(e,Sl,t),m(Zt,e,t),l(e,Pl,t),m(Z,e,t),l(e,Dl,t),l(e,vt,t),l(e,Kl,t),m(kt,e,t),l(e,Ol,t),m(Ut,e,t),l(e,en,t),l(e,Ct,t),l(e,tn,t),m(Rt,e,t),l(e,an,t),l(e,Bt,t),l(e,ln,t),m(Lt,e,t),l(e,nn,t),m(It,e,t),l(e,sn,t),l(e,Wt,t),l(e,on,t),l(e,Vt,t),l(e,rn,t),m(Gt,e,t),l(e,pn,t),l(e,At,t),l(e,dn,t),m(xt,e,t),l(e,mn,t),l(e,Xt,t),l(e,fn,t),l(e,Qt,t),l(e,hn,t),m(zt,e,t),l(e,cn,t),l(e,Ft,t),l(e,un,t),l(e,Ht,t),l(e,Mn,t),m(Et,e,t),l(e,wn,t),l(e,Yt,t),yn=!0},p(e,[t]){const xs={};t&2&&(xs.$$scope={dirty:t,ctx:e}),J.$set(xs);const Xs={};t&2&&(Xs.$$scope={dirty:t,ctx:e}),_.$set(Xs);const Qs={};t&2&&(Qs.$$scope={dirty:t,ctx:e}),j.$set(Qs);const zs={};t&2&&(zs.$$scope={dirty:t,ctx:e}),Z.$set(zs)},i(e){yn||(f(v.$$.fragment,e),f(C.$$.fragment,e),f(L.$$.fragment,e),f(W.$$.fragment,e),f(V.$$.fragment,e),f(x.$$.fragment,e),f(Q.$$.fragment,e),f(F.$$.fragment,e),f(Y.$$.fragment,e),f(N.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(oe.$$.fragment,e),f(J.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(he.$$.fragment,e),f(ue.$$.fragment,e),f(_.$$.fragment,e),f(be.$$.fragment,e),f(Je.$$.fragment,e),f(_e.$$.fragment,e),f($e.$$.fragment,e),f(ve.$$.fragment,e),f(Ue.$$.fragment,e),f(Be.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(Ge.$$.fragment,e),f(xe.$$.fragment,e),f(ze.$$.fragment,e),f(Ee.$$.fragment,e),f(Ne.$$.fragment,e),f(j.$$.fragment,e),f(Pe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(at.$$.fragment,e),f(lt.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(rt.$$.fragment,e),f(dt.$$.fragment,e),f(ht.$$.fragment,e),f(wt.$$.fragment,e),f(gt.$$.fragment,e),f(Jt.$$.fragment,e),f(jt.$$.fragment,e),f(Zt.$$.fragment,e),f(Z.$$.fragment,e),f(kt.$$.fragment,e),f(Ut.$$.fragment,e),f(Rt.$$.fragment,e),f(Lt.$$.fragment,e),f(It.$$.fragment,e),f(Gt.$$.fragment,e),f(xt.$$.fragment,e),f(zt.$$.fragment,e),f(Et.$$.fragment,e),yn=!0)},o(e){h(v.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(W.$$.fragment,e),h(V.$$.fragment,e),h(x.$$.fragment,e),h(Q.$$.fragment,e),h(F.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(oe.$$.fragment,e),h(J.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(_.$$.fragment,e),h(be.$$.fragment,e),h(Je.$$.fragment,e),h(_e.$$.fragment,e),h($e.$$.fragment,e),h(ve.$$.fragment,e),h(Ue.$$.fragment,e),h(Be.$$.fragment,e),h(Ie.$$.fragment,e),h(Ve.$$.fragment,e),h(Ge.$$.fragment,e),h(xe.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(Ne.$$.fragment,e),h(j.$$.fragment,e),h(Pe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(at.$$.fragment,e),h(lt.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(ht.$$.fragment,e),h(wt.$$.fragment,e),h(gt.$$.fragment,e),h(Jt.$$.fragment,e),h(jt.$$.fragment,e),h(Zt.$$.fragment,e),h(Z.$$.fragment,e),h(kt.$$.fragment,e),h(Ut.$$.fragment,e),h(Rt.$$.fragment,e),h(Lt.$$.fragment,e),h(It.$$.fragment,e),h(Gt.$$.fragment,e),h(xt.$$.fragment,e),h(zt.$$.fragment,e),h(Et.$$.fragment,e),yn=!1},d(e){e&&(a(g),a(w),a(b),a(qt),a(k),a(Nt),a(U),a(St),a(Pt),a(R),a(Dt),a(B),a(Kt),a(Ot),a(I),a(ea),a(ta),a(aa),a(G),a(la),a(A),a(na),a(sa),a(X),a(ia),a(oa),a(z),a(ra),a(pa),a(H),a(da),a(E),a(ma),a(fa),a(q),a(ha),a(ca),a(S),a(ua),a(P),a(Ma),a(wa),a(K),a(ya),a(ga),a(ee),a(ba),a(te),a(Ta),a(Ja),a(le),a(_a),a(ne),a(ja),a($a),a(ie),a(Za),a(va),a(re),a(ka),a(Ua),a(Ca),a(Ra),a(me),a(Ba),a(fe),a(La),a(Ia),a(ce),a(Wa),a(Va),a(Me),a(Ga),a(we),a(Aa),a(ye),a(xa),a(ge),a(Xa),a(Qa),a(za),a(Te),a(Fa),a(Ha),a(Ea),a(je),a(Ya),a(qa),a(Ze),a(Na),a(Sa),a(ke),a(Pa),a(Da),a(Ce),a(Ka),a(Re),a(Oa),a(el),a(Le),a(tl),a(al),a(We),a(ll),a(nl),a(sl),a(Ae),a(il),a(ol),a(Xe),a(rl),a(Qe),a(pl),a(dl),a(Fe),a(ml),a(He),a(fl),a(hl),a(Ye),a(cl),a(qe),a(ul),a(Ml),a(wl),a(Se),a(yl),a(gl),a(De),a(bl),a(Tl),a(Oe),a(Jl),a(_l),a(tt),a(jl),a($l),a(Zl),a(nt),a(vl),a(kl),a(Ul),a(ot),a(Cl),a(Rl),a(pt),a(Bl),a(Ll),a(mt),a(Il),a(ft),a(Wl),a(Vl),a(ct),a(Gl),a(ut),a(Al),a($),a(xl),a(Mt),a(Xl),a(Ql),a(yt),a(zl),a(Fl),a(bt),a(Hl),a(Tt),a(El),a(Yl),a(_t),a(ql),a(Nl),a($t),a(Sl),a(Pl),a(Dl),a(vt),a(Kl),a(Ol),a(en),a(Ct),a(tn),a(an),a(Bt),a(ln),a(nn),a(sn),a(Wt),a(on),a(Vt),a(rn),a(pn),a(At),a(dn),a(mn),a(Xt),a(fn),a(Qt),a(hn),a(cn),a(Ft),a(un),a(Ht),a(Mn),a(wn),a(Yt)),a(u),c(v,e),c(C,e),c(L,e),c(W,e),c(V,e),c(x,e),c(Q,e),c(F,e),c(Y,e),c(N,e),c(D,e),c(O,e),c(ae,e),c(se,e),c(oe,e),c(J,e),c(pe,e),c(de,e),c(he,e),c(ue,e),c(_,e),c(be,e),c(Je,e),c(_e,e),c($e,e),c(ve,e),c(Ue,e),c(Be,e),c(Ie,e),c(Ve,e),c(Ge,e),c(xe,e),c(ze,e),c(Ee,e),c(Ne,e),c(j,e),c(Pe,e),c(Ke,e),c(et,e),c(at,e),c(lt,e),c(st,e),c(it,e),c(rt,e),c(dt,e),c(ht,e),c(wt,e),c(gt,e),c(Jt,e),c(jt,e),c(Zt,e),c(Z,e),c(kt,e),c(Ut,e),c(Rt,e),c(Lt,e),c(It,e),c(Gt,e),c(xt,e),c(zt,e),c(Et,e)}}}const ai='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"CorDA","local":"corda","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3},{"title":"Fine grained control over ranks and alpha (scaling)","local":"fine-grained-control-over-ranks-and-alpha-scaling","sections":[],"depth":3},{"title":"Targeting nn.Parameter directly","local":"targeting-nnparameter-directly","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA-FA Optimizer","local":"lora-fa-optimizer","sections":[],"depth":3},{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Efficiently train tokens alongside LoRA","local":"efficiently-train-tokens-alongside-lora","sections":[],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function li(T){return Es(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pi extends Ys{constructor(u){super(),qs(this,u,li,ti,Hs,{})}}export{pi as component};
