import{s as dl,o as ml,n as cl}from"../chunks/scheduler.c57aa7ef.js";import{S as yl,i as hl,g as m,s as a,r as o,A as ul,h as y,f as s,c as n,j as il,u as i,x as h,k as rl,y as Jl,a as t,v as r,d as M,t as c,w as d}from"../chunks/index.394f8801.js";import{T as Ml}from"../chunks/Tip.23dfb1a9.js";import{C as J}from"../chunks/CodeBlock.b5488637.js";import{H as te,E as wl}from"../chunks/getInferenceSnippets.54bf47f2.js";function fl(ae){let p,w='Some familiarity with the general process of training a sequence-to-sequence would be really helpful and allow you to focus on how to apply IA3. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/translation" rel="nofollow">Translation</a> and <a href="https://huggingface.co/docs/transformers/tasks/summarization" rel="nofollow">Summarization</a> guides first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!';return{c(){p=m("p"),p.innerHTML=w},l(u){p=y(u,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1nn7tj6"&&(p.innerHTML=w)},m(u,f){t(u,p,f)},p:cl,d(u){u&&s(p)}}}function Tl(ae){let p,w='Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of trainable parameters of <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!';return{c(){p=m("p"),p.innerHTML=w},l(u){p=y(u,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1f9ty5f"&&(p.innerHTML=w)},m(u,f){t(u,p,f)},p:cl,d(u){u&&s(p)}}}function Ul(ae){let p,w,u,f,j,pe,b,Ae='<a href="../conceptual_guides/ia3">IA3</a> multiplies the model’s activations (the keys and values in the self-attention and encoder-decoder attention blocks, and the intermediate activation of the position-wise feedforward network) by three learned vectors. This PEFT method introduces an even smaller number of trainable parameters than LoRA which introduces weight matrices instead of vectors. The original model’s parameters are kept frozen and only these vectors are updated. As a result, it is faster, cheaper and more efficient to finetune for a new downstream task.',oe,g,He="This guide will show you how to train a sequence-to-sequence model with IA3 to <em>generate a sentiment</em> given some financial news.",ie,T,re,I,Me,C,Fe='You’ll use the sentences_allagree subset of the <a href="https://huggingface.co/datasets/financial_phrasebank" rel="nofollow">financial_phrasebank</a> dataset. This subset contains financial news with 100% annotator agreement on the sentiment label. Take a look at the <a href="https://huggingface.co/datasets/financial_phrasebank/viewer/sentences_allagree" rel="nofollow">dataset viewer</a> for a better idea of the data and sentences you’ll be working with.',ce,_,Se='Load the dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function. This subset of the dataset only contains a train split, so use the <code>train_test_split</code> function to create a train and validation split. Create a new <code>text_label</code> column so it is easier to understand what the <code>label</code> values <code>0</code>, <code>1</code>, and <code>2</code> mean.',de,Z,me,k,qe="Load a tokenizer and create a preprocessing function that:",ye,G,Le="<li>tokenizes the inputs, pads and truncates the sequence to the <code>max_length</code></li> <li>apply the same tokenizer to the labels but with a shorter <code>max_length</code> that corresponds to the label</li> <li>mask the padding tokens</li>",he,W,ue,B,Ke='Use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function to apply the preprocessing function to the entire dataset.',Je,v,we,X,Pe='Create a training and evaluation <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>, and set <code>pin_memory=True</code> to speed up data transfer to the accelerator during training if your dataset samples are on a CPU.',fe,R,Te,$,Ue,V,De='Now you can load a pretrained model to use as the base model for IA3. This guide uses the <a href="https://huggingface.co/bigscience/mt0-large" rel="nofollow">bigscience/mt0-large</a> model, but you can use any sequence-to-sequence model you like.',je,N,be,Y,ge,Q,Oe='All PEFT methods need a configuration that contains and specifies all the parameters for how the PEFT method should be applied. Create an <a href="/docs/peft/main/en/package_reference/ia3#peft.IA3Config">IA3Config</a> with the task type and set the inference mode to <code>False</code>. You can find additional parameters for this configuration in the <a href="../package_reference/ia3#ia3config">API reference</a>.',Ie,U,Ce,z,el='Once the configuration is setup, pass it to the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',_e,E,Ze,x,ke,A,ll="Set up an optimizer and learning rate scheduler.",Ge,H,We,F,sl="Move the model to the accelerator and create a training loop that reports the loss and perplexity for each epoch.",Be,S,ve,q,Xe,L,tl='After training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',Re,K,$e,P,Ve,D,al='To load the model for inference, use the <a href="/docs/peft/main/en/package_reference/auto_class#peft.AutoPeftModel.from_pretrained">from_pretrained()</a> method. Let’s also load a sentence of financial news from the dataset to generate a sentiment for.',Ne,O,Ye,ee,nl='Call the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> method to generate the predicted sentiment label.',Qe,le,ze,se,Ee,ne,xe;return j=new te({props:{title:"IA3",local:"ia3",headingTag:"h1"}}),T=new Ml({props:{$$slots:{default:[fl]},$$scope:{ctx:ae}}}),I=new te({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),Z=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZmluYW5jaWFsX3BocmFzZWJhbmslMjIlMkMlMjAlMjJzZW50ZW5jZXNfYWxsYWdyZWUlMjIpJTBBZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQWRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUyMCUzRCUyMGRzJTVCJTIydGVzdCUyMiU1RCUwQWRlbCUyMGRzJTVCJTIydGVzdCUyMiU1RCUwQSUwQWNsYXNzZXMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMEFkcyUyMCUzRCUyMGRzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwJTdCJTIydGV4dF9sYWJlbCUyMiUzQSUyMCU1QmNsYXNzZXMlNUJsYWJlbCU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjB4JTVCJTIybGFiZWwlMjIlNUQlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSklMEElMEFkcyU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QidzZW50ZW5jZSclM0ElMjAnSXQlMjB3aWxsJTIwYmUlMjBvcGVyYXRlZCUyMGJ5JTIwTm9raWElMjAlMkMlMjBhbmQlMjBzdXBwb3J0ZWQlMjBieSUyMGl0cyUyME5va2lhJTIwTmV0QWN0JTIwbmV0d29yayUyMGFuZCUyMHNlcnZpY2UlMjBtYW5hZ2VtZW50JTIwc3lzdGVtJTIwLiclMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCd0ZXh0X2xhYmVsJyUzQSUyMCduZXV0cmFsJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;financial_phrasebank&quot;</span>, <span class="hljs-string">&quot;sentences_allagree&quot;</span>)
ds = ds[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
ds[<span class="hljs-string">&quot;validation&quot;</span>] = ds[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-keyword">del</span> ds[<span class="hljs-string">&quot;test&quot;</span>]

classes = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
ds = ds.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)

ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;sentence&#x27;</span>: <span class="hljs-string">&#x27;It will be operated by Nokia , and supported by its Nokia NetAct network and service management system .&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text_label&#x27;</span>: <span class="hljs-string">&#x27;neutral&#x27;</span>}`,wrap:!1}}),W=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0ZXh0X2NvbHVtbiUyMCUzRCUyMCUyMnNlbnRlbmNlJTIyJTBBbGFiZWxfY29sdW1uJTIwJTNEJTIwJTIydGV4dF9sYWJlbCUyMiUwQW1heF9sZW5ndGglMjAlM0QlMjAxMjglMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGbXQwLWxhcmdlJTIyKSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwZXhhbXBsZXMlNUJ0ZXh0X2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjBleGFtcGxlcyU1QmxhYmVsX2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihpbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEbWF4X2xlbmd0aCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0YXJnZXRzJTJDJTIwbWF4X2xlbmd0aCUzRDMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbHMlNUJsYWJlbHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1vZGVsX2lucHV0cw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

text_column = <span class="hljs-string">&quot;sentence&quot;</span>
label_column = <span class="hljs-string">&quot;text_label&quot;</span>
max_length = <span class="hljs-number">128</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    inputs = examples[text_column]
    targets = examples[label_column]
    model_inputs = tokenizer(inputs, max_length=max_length, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = tokenizer(targets, max_length=<span class="hljs-number">3</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    labels[labels == tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),v=new J({props:{code:"cHJvY2Vzc2VkX2RzJTIwJTNEJTIwZHMubWFwKCUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEZHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Zyb21fY2FjaGVfZmlsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZGVzYyUzRCUyMlJ1bm5pbmclMjB0b2tlbml6ZXIlMjBvbiUyMGRhdGFzZXQlMjIlMkMlMEEp",highlighted:`processed_ds = ds.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=ds[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),R=new J({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUwQSUwQXRyYWluX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUwQSUwQWJhdGNoX3NpemUlMjAlM0QlMjA4JTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdHJhaW5fZHMlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlJTBBKSUwQWV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZXZhbF9kcyUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> default_data_collator

train_ds = processed_ds[<span class="hljs-string">&quot;train&quot;</span>]
eval_ds = processed_ds[<span class="hljs-string">&quot;validation&quot;</span>]

batch_size = <span class="hljs-number">8</span>

train_dataloader = DataLoader(
    train_ds, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>
)
eval_dataloader = DataLoader(eval_ds, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),$=new te({props:{title:"Model",local:"model",headingTag:"h2"}}),N=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGbXQwLWxhcmdlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM

model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)`,wrap:!1}}),Y=new te({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),U=new Ml({props:{$$slots:{default:[Tl]},$$scope:{ctx:ae}}}),E=new J({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBJQTNDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwSUEzQ29uZmlnKHRhc2tfdHlwZSUzRCUyMlNFUV8yX1NFUV9MTSUyMiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWcpJTBBbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMnRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDI4MiUyQzYyNCUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDElMkMyMjklMkM4NjMlMkM5MzYlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjAyMjk4MDEwMzA2MDc2NjU1MyUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> IA3Config, get_peft_model

peft_config = IA3Config(task_type=<span class="hljs-string">&quot;SEQ_2_SEQ_LM&quot;</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 282,624 || all params: 1,229,863,936 || trainable%: 0.022980103060766553&quot;</span>`,wrap:!1}}),x=new te({props:{title:"Training",local:"training",headingTag:"h3"}}),H=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwZ2V0X2xpbmVhcl9zY2hlZHVsZV93aXRoX3dhcm11cCUwQSUwQWxyJTIwJTNEJTIwOGUtMyUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0RsciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBudW1fZXBvY2hzKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_linear_schedule_with_warmup

lr = <span class="hljs-number">8e-3</span>
num_epochs = <span class="hljs-number">3</span>

optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),S=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>
model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),q=new te({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),K=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBYWNjb3VudCUyMCUzRCUyMCUzQ3lvdXItaGYtYWNjb3VudC1uYW1lJTNFJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjIlN0JhY2NvdW50JTdEJTJGbXQwLWxhcmdlLWlhMyUyMiUwQW1vZGVsLnB1c2hfdG9faHViKHBlZnRfbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

account = &lt;your-hf-account-name&gt;
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/mt0-large-ia3&quot;</span>
model.push_to_hub(peft_model_id)`,wrap:!1}}),P=new te({props:{title:"Inference",local:"inference",headingTag:"h2"}}),O=new J({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b1BlZnRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTNDeW91ci1oZi1hY2NvdW50LW5hbWUlM0UlMkZtdDAtbGFyZ2UtaWEzJTIyKS50byhkZXZpY2UpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRm10MC1sYXJnZSUyMiklMEElMEFpJTIwJTNEJTIwMTUlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTVCdGV4dF9jb2x1bW4lNUQlNUJpJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChkcyU1QiUyMnZhbGlkYXRpb24lMjIlNUQlNUJ0ZXh0X2NvbHVtbiU1RCU1QmklNUQpJTBBJTIyVGhlJTIwcm9idXN0JTIwZ3Jvd3RoJTIwd2FzJTIwdGhlJTIwcmVzdWx0JTIwb2YlMjB0aGUlMjBpbmNsdXNpb24lMjBvZiUyMGNsb3RoaW5nJTIwY2hhaW4lMjBMaW5kZXglMjBpbiUyMHRoZSUyMEdyb3VwJTIwaW4lMjBEZWNlbWJlciUyMDIwMDclMjAuJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForSeq2SeqLM

device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

model = AutoPeftModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;&lt;your-hf-account-name&gt;/mt0-large-ia3&quot;</span>).to(device)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)

i = <span class="hljs-number">15</span>
inputs = tokenizer(ds[<span class="hljs-string">&quot;validation&quot;</span>][text_column][i], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(ds[<span class="hljs-string">&quot;validation&quot;</span>][text_column][i])
<span class="hljs-string">&quot;The robust growth was the result of the inclusion of clothing chain Lindex in the Group in December 2007 .&quot;</span>`,wrap:!1}}),le=new J({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIncG9zaXRpdmUnJTVE",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;positive&#x27;</span>]`,wrap:!1}}),se=new wl({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/ia3.md"}}),{c(){p=m("meta"),w=a(),u=m("p"),f=a(),o(j.$$.fragment),pe=a(),b=m("p"),b.innerHTML=Ae,oe=a(),g=m("p"),g.innerHTML=He,ie=a(),o(T.$$.fragment),re=a(),o(I.$$.fragment),Me=a(),C=m("p"),C.innerHTML=Fe,ce=a(),_=m("p"),_.innerHTML=Se,de=a(),o(Z.$$.fragment),me=a(),k=m("p"),k.textContent=qe,ye=a(),G=m("ol"),G.innerHTML=Le,he=a(),o(W.$$.fragment),ue=a(),B=m("p"),B.innerHTML=Ke,Je=a(),o(v.$$.fragment),we=a(),X=m("p"),X.innerHTML=Pe,fe=a(),o(R.$$.fragment),Te=a(),o($.$$.fragment),Ue=a(),V=m("p"),V.innerHTML=De,je=a(),o(N.$$.fragment),be=a(),o(Y.$$.fragment),ge=a(),Q=m("p"),Q.innerHTML=Oe,Ie=a(),o(U.$$.fragment),Ce=a(),z=m("p"),z.innerHTML=el,_e=a(),o(E.$$.fragment),Ze=a(),o(x.$$.fragment),ke=a(),A=m("p"),A.textContent=ll,Ge=a(),o(H.$$.fragment),We=a(),F=m("p"),F.textContent=sl,Be=a(),o(S.$$.fragment),ve=a(),o(q.$$.fragment),Xe=a(),L=m("p"),L.innerHTML=tl,Re=a(),o(K.$$.fragment),$e=a(),o(P.$$.fragment),Ve=a(),D=m("p"),D.innerHTML=al,Ne=a(),o(O.$$.fragment),Ye=a(),ee=m("p"),ee.innerHTML=nl,Qe=a(),o(le.$$.fragment),ze=a(),o(se.$$.fragment),Ee=a(),ne=m("p"),this.h()},l(e){const l=ul("svelte-u9bgzb",document.head);p=y(l,"META",{name:!0,content:!0}),l.forEach(s),w=n(e),u=y(e,"P",{}),il(u).forEach(s),f=n(e),i(j.$$.fragment,e),pe=n(e),b=y(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-s2qd7"&&(b.innerHTML=Ae),oe=n(e),g=y(e,"P",{"data-svelte-h":!0}),h(g)!=="svelte-xoc01f"&&(g.innerHTML=He),ie=n(e),i(T.$$.fragment,e),re=n(e),i(I.$$.fragment,e),Me=n(e),C=y(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-20qrnk"&&(C.innerHTML=Fe),ce=n(e),_=y(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-xnp209"&&(_.innerHTML=Se),de=n(e),i(Z.$$.fragment,e),me=n(e),k=y(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-aqyjx7"&&(k.textContent=qe),ye=n(e),G=y(e,"OL",{"data-svelte-h":!0}),h(G)!=="svelte-1xhy766"&&(G.innerHTML=Le),he=n(e),i(W.$$.fragment,e),ue=n(e),B=y(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-ww7yef"&&(B.innerHTML=Ke),Je=n(e),i(v.$$.fragment,e),we=n(e),X=y(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-kwwkxd"&&(X.innerHTML=Pe),fe=n(e),i(R.$$.fragment,e),Te=n(e),i($.$$.fragment,e),Ue=n(e),V=y(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-1d06z94"&&(V.innerHTML=De),je=n(e),i(N.$$.fragment,e),be=n(e),i(Y.$$.fragment,e),ge=n(e),Q=y(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-gbvacv"&&(Q.innerHTML=Oe),Ie=n(e),i(U.$$.fragment,e),Ce=n(e),z=y(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-mz5vce"&&(z.innerHTML=el),_e=n(e),i(E.$$.fragment,e),Ze=n(e),i(x.$$.fragment,e),ke=n(e),A=y(e,"P",{"data-svelte-h":!0}),h(A)!=="svelte-tlkvop"&&(A.textContent=ll),Ge=n(e),i(H.$$.fragment,e),We=n(e),F=y(e,"P",{"data-svelte-h":!0}),h(F)!=="svelte-166cxn8"&&(F.textContent=sl),Be=n(e),i(S.$$.fragment,e),ve=n(e),i(q.$$.fragment,e),Xe=n(e),L=y(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-q5liq1"&&(L.innerHTML=tl),Re=n(e),i(K.$$.fragment,e),$e=n(e),i(P.$$.fragment,e),Ve=n(e),D=y(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-19b2iba"&&(D.innerHTML=al),Ne=n(e),i(O.$$.fragment,e),Ye=n(e),ee=y(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1dkx89x"&&(ee.innerHTML=nl),Qe=n(e),i(le.$$.fragment,e),ze=n(e),i(se.$$.fragment,e),Ee=n(e),ne=y(e,"P",{}),il(ne).forEach(s),this.h()},h(){rl(p,"name","hf:doc:metadata"),rl(p,"content",jl)},m(e,l){Jl(document.head,p),t(e,w,l),t(e,u,l),t(e,f,l),r(j,e,l),t(e,pe,l),t(e,b,l),t(e,oe,l),t(e,g,l),t(e,ie,l),r(T,e,l),t(e,re,l),r(I,e,l),t(e,Me,l),t(e,C,l),t(e,ce,l),t(e,_,l),t(e,de,l),r(Z,e,l),t(e,me,l),t(e,k,l),t(e,ye,l),t(e,G,l),t(e,he,l),r(W,e,l),t(e,ue,l),t(e,B,l),t(e,Je,l),r(v,e,l),t(e,we,l),t(e,X,l),t(e,fe,l),r(R,e,l),t(e,Te,l),r($,e,l),t(e,Ue,l),t(e,V,l),t(e,je,l),r(N,e,l),t(e,be,l),r(Y,e,l),t(e,ge,l),t(e,Q,l),t(e,Ie,l),r(U,e,l),t(e,Ce,l),t(e,z,l),t(e,_e,l),r(E,e,l),t(e,Ze,l),r(x,e,l),t(e,ke,l),t(e,A,l),t(e,Ge,l),r(H,e,l),t(e,We,l),t(e,F,l),t(e,Be,l),r(S,e,l),t(e,ve,l),r(q,e,l),t(e,Xe,l),t(e,L,l),t(e,Re,l),r(K,e,l),t(e,$e,l),r(P,e,l),t(e,Ve,l),t(e,D,l),t(e,Ne,l),r(O,e,l),t(e,Ye,l),t(e,ee,l),t(e,Qe,l),r(le,e,l),t(e,ze,l),r(se,e,l),t(e,Ee,l),t(e,ne,l),xe=!0},p(e,[l]){const pl={};l&2&&(pl.$$scope={dirty:l,ctx:e}),T.$set(pl);const ol={};l&2&&(ol.$$scope={dirty:l,ctx:e}),U.$set(ol)},i(e){xe||(M(j.$$.fragment,e),M(T.$$.fragment,e),M(I.$$.fragment,e),M(Z.$$.fragment,e),M(W.$$.fragment,e),M(v.$$.fragment,e),M(R.$$.fragment,e),M($.$$.fragment,e),M(N.$$.fragment,e),M(Y.$$.fragment,e),M(U.$$.fragment,e),M(E.$$.fragment,e),M(x.$$.fragment,e),M(H.$$.fragment,e),M(S.$$.fragment,e),M(q.$$.fragment,e),M(K.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),xe=!0)},o(e){c(j.$$.fragment,e),c(T.$$.fragment,e),c(I.$$.fragment,e),c(Z.$$.fragment,e),c(W.$$.fragment,e),c(v.$$.fragment,e),c(R.$$.fragment,e),c($.$$.fragment,e),c(N.$$.fragment,e),c(Y.$$.fragment,e),c(U.$$.fragment,e),c(E.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(q.$$.fragment,e),c(K.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),xe=!1},d(e){e&&(s(w),s(u),s(f),s(pe),s(b),s(oe),s(g),s(ie),s(re),s(Me),s(C),s(ce),s(_),s(de),s(me),s(k),s(ye),s(G),s(he),s(ue),s(B),s(Je),s(we),s(X),s(fe),s(Te),s(Ue),s(V),s(je),s(be),s(ge),s(Q),s(Ie),s(Ce),s(z),s(_e),s(Ze),s(ke),s(A),s(Ge),s(We),s(F),s(Be),s(ve),s(Xe),s(L),s(Re),s($e),s(Ve),s(D),s(Ne),s(Ye),s(ee),s(Qe),s(ze),s(Ee),s(ne)),s(p),d(j,e),d(T,e),d(I,e),d(Z,e),d(W,e),d(v,e),d(R,e),d($,e),d(N,e),d(Y,e),d(U,e),d(E,e),d(x,e),d(H,e),d(S,e),d(q,e),d(K,e),d(P,e),d(O,e),d(le,e),d(se,e)}}}const jl='{"title":"IA3","local":"ia3","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function bl(ae){return ml(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends yl{constructor(p){super(),hl(this,p,bl,Ul,dl,{})}}export{kl as component};
