import{s as jl,n as cl,o as fl}from"../chunks/scheduler.362310b7.js";import{S as Al,i as yl,g as i,s,r,A as gl,h as o,f as l,c as a,j as hl,u as M,x as p,k as dl,y as vl,a as n,v as m,d as u,t as h,w as d}from"../chunks/index.57dfc70d.js";import{C as f}from"../chunks/CodeBlock.5d40996c.js";import{H as j,E as Tl}from"../chunks/getInferenceSnippets.a7e9309d.js";function Ul(Jt){let c,Ue,ve,be,A,$e,y,Nt="The Neuron backend allows the deployment of TGI on AWS Trainium and Inferentia family of chips.",we,g,Et="The following hardware targets are supported:",Ce,v,Zt="<li>Trainium 1,</li> <li>Inferentia 2.</li>",xe,T,Je,U,Rt="The basic TGI features are supported:",Ne,b,Lt='<li>continuous batching,</li> <li>token streaming,</li> <li>greedy search and multinomial sampling using <a href="https://huggingface.co/docs/transformers/generation_strategies#customize-text-generation" rel="nofollow">transformers</a>.</li>',Ee,$,Ze,w,_t=`The simplest way to deploy the NeuronX TGI service for a specific model is to follow the
deployment instructions in the model card:`,Re,C,Vt="<li>click on the “Deploy” button on the right,</li> <li>select your deployment service (“Inference Endpoints” and “SageMaker” are supported),</li> <li>select “AWS Trainum &amp; Inferentia”,</li> <li>follow the instructions.</li>",Le,x,_e,J,St="The service is launched simply by running the text-generation-inference container with two sets of parameters:",Ve,N,Se,E,It="<li>system parameters are used to map ports, volumes and devices between the host and the service,</li> <li>service parameters are forwarded to the <code>text-generation-launcher</code>.</li>",Ie,Z,Ht="When deploying a service, you will need a pre-compiled Neuron model. The Neuron TGI backend supports two main modes of operation:",He,R,Wt="<li>you can either deploy the service on a model that has already been exported to Neuron,</li> <li>or alternatively you can take advantage of the Neuron Model Cache to export your own model.</li>",We,L,Xe,_,Xt=`Whenever you launch a TGI service, we highly recommend you to mount a shared volume mounted as <code>/data</code> in the container: this is where
the models will be cached to speed up further instantiations of the service.`,Ge,V,Gt=`Note also that enough neuron devices should be made visible to the container, knowing that each neuron device has two cores (so when deploying on two cores you need to expose at least one device).
The recommended way to expose a device in a production environment is to use explicitly the <code>--device</code> option (e.g <code>--device /dev/neuron0</code>) repeated as many time as there are devices to be exposed.`,ke,S,kt="Note: alternatively, for a quick local test it is also possible to launch the service in <code>privileged</code> mode to get access to all neuron devices.",ze,I,zt="Finally, you might want to export the <code>HF_TOKEN</code> if you want to access gated repositories.",Fe,H,Ft="Here is an example of a service instantiation exposing only the first device:",Pe,W,Qe,X,Ye,G,Pt='We maintain a Neuron Model Cache of the most popular architecture and deployment parameters under <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache" rel="nofollow">aws-neuron/optimum-neuron-cache</a>.',Be,k,Qt="If you just want to try the service quickly using a model without exporting it to Neuron first, it is thus still possible, pending some conditions:",qe,z,Yt="<li>you must specify the export parameters when launching the service (or use default parameters),</li> <li>the model configuration must be cached.</li>",Oe,F,Bt="The snippet below shows how you can deploy a service from a hub standard model:",De,P,Ke,Q,et,Y,qt='Alternatively, you can first <a href="https://huggingface.co/docs/optimum-neuron/main/en/guides/export_model#exporting-neuron-models-using-text-generation-inference" rel="nofollow">export the model to neuron format</a> locally.',tt,B,Ot="You can then deploy the service inside the shared volume:",lt,q,nt,O,Dt="Note: You don’t need to specify any service parameters, as they will all be deduced from the model export configuration. You must however expose enough devices to match the number of cores specified during the export phase.",st,D,at,K,Kt="The easiest way to share a neuron model inside your organization is to push it on the Hugging Face hub, so that it can be deployed directly without requiring an export.",it,ee,el="The snippet below shows how you can deploy a service from a hub neuron model:",ot,te,pt,le,rt,ne,tl="Use the following command to list the available service parameters:",Mt,se,mt,ae,ll="The configuration of an inference endpoint is always a compromise between throughput and latency: serving more requests in parallel will allow a higher throughput, but it will increase the latency.",ut,ie,nl="The neuron models have static input dimensions <code>[batch_size, max_length]</code>.",ht,oe,sl="This adds several restrictions to the following parameters:",dt,pe,al="<li><code>--max-batch-size</code> must be set to <code>batch size</code>,</li> <li><code>--max-input-length</code> must be lower than <code>max_length</code>,</li> <li><code>--max-total-tokens</code> must be set to <code>max_length</code> (it is per-request).</li>",jt,re,il="Although not strictly necessary, but important for efficient prefilling:",ct,Me,ol="<li><code>--max-batch-prefill-tokens</code> should be set to <code>batch_size</code> * <code>max-input-length</code>.</li>",ft,me,At,ue,pl="As seen in the previous paragraph, neuron model static batch size has a direct influence on the endpoint latency and throughput.",yt,he,rl='Please refer to <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text-generation-inference</a> for optimization hints.',gt,de,Ml=`Note that the main constraint is to be able to fit the model for the specified <code>batch_size</code> within the total device memory available
on your instance (16GB per neuron core, with 2 cores per device).`,vt,je,Tt,ce,ml="You can query the model using either the <code>/generate</code> or <code>/generate_stream</code> routes:",Ut,fe,bt,Ae,$t,ye,ul="Note: replace 127.0.0.1:8080 with your actual IP address and port.",wt,ge,Ct,Te,xt;return A=new j({props:{title:"Neuron backend for AWS Trainium and Inferentia",local:"neuron-backend-for-aws-trainium-and-inferentia",headingTag:"h1"}}),T=new j({props:{title:"Features",local:"features",headingTag:"h2"}}),$=new j({props:{title:"Deploy the service from the Hugging Face hub",local:"deploy-the-service-from-the-hugging-face-hub",headingTag:"h2"}}),x=new j({props:{title:"Deploy the service on a dedicated host",local:"deploy-the-service-on-a-dedicated-host",headingTag:"h2"}}),N=new f({props:{code:"ZG9ja2VyJTIwcnVuJTIwJTNDc3lzdGVtX3BhcmFtZXRlcnMlM0UlMjBnaGNyLmlvJTJGaHVnZ2luZ2ZhY2UlMkZ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTNBMy4zLjQtbmV1cm9uJTIwJTNDc2VydmljZV9wYXJhbWV0ZXJzJTNF",highlighted:'<span class="hljs-attribute">docker</span> run &lt;system_parameters&gt; ghcr.io/huggingface/text-generation-inference:<span class="hljs-number">3</span>.<span class="hljs-number">3</span>.<span class="hljs-number">4</span>-neuron &lt;service_parameters&gt;',wrap:!1}}),L=new j({props:{title:"Common system parameters",local:"common-system-parameters",headingTag:"h3"}}),W=new f({props:{code:"ZG9ja2VyJTIwcnVuJTIwLXAlMjA4MDgwJTNBODAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtdiUyMCUyNChwd2QpJTJGZGF0YSUzQSUyRmRhdGElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtZSUyMEhGX1RPS0VOJTNEJTI0JTdCSEZfVE9LRU4lN0QlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBnaGNyLmlvJTJGaHVnZ2luZ2ZhY2UlMkZ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTNBJTNDVkVSU0lPTiUzRS1uZXVyb24lMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0NzZXJ2aWNlX3BhcmFtZXRlcnMlM0U=",highlighted:`docker run -p <span class="hljs-number">8080</span>:<span class="hljs-number">80</span> \\
       -v $(pwd)<span class="hljs-regexp">/data:/</span>data \\
       --device=<span class="hljs-regexp">/dev/</span>neuron0 \\
       -e HF_TOKEN=<span class="hljs-variable">\${HF_TOKEN}</span> \\
       ghcr.io<span class="hljs-regexp">/huggingface/</span>text-generation-inference:&lt;VERSION&gt;-neuron \\
       &lt;service_parameters&gt;`,wrap:!1}}),X=new j({props:{title:"Using a standard model from the 🤗 HuggingFace Hub (recommended)",local:"using-a-standard-model-from-the--huggingface-hub-recommended",headingTag:"h3"}}),P=new f({props:{code:"ZXhwb3J0JTIwSEZfVE9LRU4lM0QlM0NZT1VSX1RPS0VOJTNFJTBBZG9ja2VyJTIwcnVuJTIwLXAlMjA4MDgwJTNBODAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtdiUyMCUyNChwd2QpJTJGZGF0YSUzQSUyRmRhdGElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjIlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjMlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtZSUyMEhGX1RPS0VOJTNEJTI0JTdCSEZfVE9LRU4lN0QlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtZSUyMEhGX0FVVE9fQ0FTVF9UWVBFJTNEJTIyZnAxNiUyMiUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMC1lJTIwSEZfTlVNX0NPUkVTJTNEOCUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMGdoY3IuaW8lMkZodWdnaW5nZmFjZSUyRnRleHQtZ2VuZXJhdGlvbi1pbmZlcmVuY2UlM0ElM0NWRVJTSU9OJTNFLW5ldXJvbiUyMCU1QyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMC0tbW9kZWwtaWQlMjBtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwLS1tYXgtYmF0Y2gtc2l6ZSUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLW1heC1pbnB1dC1sZW5ndGglMjAzMTY0JTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwLS1tYXgtdG90YWwtdG9rZW5zJTIwNDA5Ng==",highlighted:`<span class="hljs-built_in">export</span> <span class="hljs-attribute">HF_TOKEN</span>=&lt;YOUR_TOKEN&gt;
docker <span class="hljs-built_in">run</span> -p 8080:80 \\
       -v $(pwd)/data:/data \\
       <span class="hljs-attribute">--device</span>=/dev/neuron0 \\
       <span class="hljs-attribute">--device</span>=/dev/neuron1 \\
       <span class="hljs-attribute">--device</span>=/dev/neuron2 \\
       <span class="hljs-attribute">--device</span>=/dev/neuron3 \\
       -e <span class="hljs-attribute">HF_TOKEN</span>=<span class="hljs-variable">\${HF_TOKEN}</span> \\
       -e <span class="hljs-attribute">HF_AUTO_CAST_TYPE</span>=<span class="hljs-string">&quot;fp16&quot;</span> \\
       -e <span class="hljs-attribute">HF_NUM_CORES</span>=8 \\
       ghcr.io/huggingface/text-generation-inference:&lt;VERSION&gt;-neuron \\
       --model-id meta-llama/Meta-Llama-3-8B \\
       --max-batch-size 1 \\
       --max-input-length 3164 \\
       --max-total-tokens 4096`,wrap:!1}}),Q=new j({props:{title:"Using a model exported to a local path",local:"using-a-model-exported-to-a-local-path",headingTag:"h3"}}),q=new f({props:{code:"ZG9ja2VyJTIwcnVuJTIwLXAlMjA4MDgwJTNBODAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtdiUyMCUyNChwd2QpJTJGZGF0YSUzQSUyRmRhdGElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBnaGNyLmlvJTJGaHVnZ2luZ2ZhY2UlMkZ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTNBJTNDVkVSU0lPTiUzRS1uZXVyb24lMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLW1vZGVsLWlkJTIwJTJGZGF0YSUyRiUzQ25ldXJvbl9tb2RlbF9wYXRoJTNF",highlighted:`docker run -p <span class="hljs-number">8080</span>:<span class="hljs-number">80</span> \\
       -v $(pwd)<span class="hljs-regexp">/data:/</span>data \\
       --device=<span class="hljs-regexp">/dev/</span>neuron0 \\
       --device=<span class="hljs-regexp">/dev/</span>neuron1 \\
       ghcr.io<span class="hljs-regexp">/huggingface/</span>text-generation-inference:&lt;VERSION&gt;-neuron \\
       --model-id <span class="hljs-regexp">/data/</span>&lt;neuron_model_path&gt;`,wrap:!1}}),D=new j({props:{title:"Using a neuron model from the 🤗 HuggingFace Hub",local:"using-a-neuron-model-from-the--huggingface-hub",headingTag:"h3"}}),te=new f({props:{code:"ZG9ja2VyJTIwcnVuJTIwLXAlMjA4MDgwJTNBODAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtdiUyMCUyNChwd2QpJTJGZGF0YSUzQSUyRmRhdGElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjAlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLWRldmljZSUzRCUyRmRldiUyRm5ldXJvbjElMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtZSUyMEhGX1RPS0VOJTNEJTI0JTdCSEZfVE9LRU4lN0QlMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjBnaGNyLmlvJTJGaHVnZ2luZ2ZhY2UlMkZ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTNBJTNDVkVSU0lPTiUzRS1uZXVyb24lMjAlNUMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAtLW1vZGVsLWlkJTIwJTNDb3JnYW5pemF0aW9uJTNFJTJGJTNDbmV1cm9uLW1vZGVsJTNF",highlighted:`docker run -p <span class="hljs-number">8080</span>:<span class="hljs-number">80</span> \\
       -v $(pwd)<span class="hljs-regexp">/data:/</span>data \\
       --device=<span class="hljs-regexp">/dev/</span>neuron0 \\
       --device=<span class="hljs-regexp">/dev/</span>neuron1 \\
       -e HF_TOKEN=<span class="hljs-variable">\${HF_TOKEN}</span> \\
       ghcr.io<span class="hljs-regexp">/huggingface/</span>text-generation-inference:&lt;VERSION&gt;-neuron \\
       --model-id &lt;organization&gt;/&lt;neuron-model&gt;`,wrap:!1}}),le=new j({props:{title:"Choosing service parameters",local:"choosing-service-parameters",headingTag:"h3"}}),se=new f({props:{code:"ZG9ja2VyJTIwcnVuJTIwZ2hjci5pbyUyRmh1Z2dpbmdmYWNlJTJGdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUzQSUzQ1ZFUlNJT04lM0UtbmV1cm9uJTIwLS1oZWxw",highlighted:'docker <span class="hljs-built_in">run</span> ghcr.io/huggingface/<span class="hljs-built_in">text</span>-generation-inference:&lt;VERSION&gt;-neuron <span class="hljs-comment">--help</span>',wrap:!1}}),me=new j({props:{title:"Choosing the correct batch size",local:"choosing-the-correct-batch-size",headingTag:"h3"}}),je=new j({props:{title:"Query the service",local:"query-the-service",headingTag:"h2"}}),fe=new f({props:{code:"Y3VybCUyMDEyNy4wLjAuMSUzQTgwODAlMkZnZW5lcmF0ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiUyQyUyMnBhcmFtZXRlcnMlMjIlM0ElN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQTIwJTdEJTdEJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJ0NvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbic=",highlighted:`curl <span class="hljs-number">127</span><span class="hljs-variable">.0</span><span class="hljs-variable">.0</span><span class="hljs-variable">.1</span>:<span class="hljs-number">8080</span>/<span class="hljs-keyword">generate</span> \\
    -X POST \\
    -d &#x27;{<span class="hljs-string">&quot;inputs&quot;</span>:<span class="hljs-string">&quot;What is Deep Learning?&quot;</span>,<span class="hljs-string">&quot;parameters&quot;</span>:{<span class="hljs-string">&quot;max_new_tokens&quot;</span>:<span class="hljs-number">20</span>}}&#x27; \\
    -H &#x27;Content-Type: application/json&#x27;`,wrap:!1}}),Ae=new f({props:{code:"Y3VybCUyMDEyNy4wLjAuMSUzQTgwODAlMkZnZW5lcmF0ZV9zdHJlYW0lMjAlNUMlMEElMjAlMjAlMjAlMjAtWCUyMFBPU1QlMjAlNUMlMEElMjAlMjAlMjAlMjAtZCUyMCclN0IlMjJpbnB1dHMlMjIlM0ElMjJXaGF0JTIwaXMlMjBEZWVwJTIwTGVhcm5pbmclM0YlMjIlMkMlMjJwYXJhbWV0ZXJzJTIyJTNBJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0EyMCU3RCU3RCclMjAlNUMlMEElMjAlMjAlMjAlMjAtSCUyMCdDb250ZW50LVR5cGUlM0ElMjBhcHBsaWNhdGlvbiUyRmpzb24n",highlighted:`curl <span class="hljs-number">127.0</span>.<span class="hljs-number">0.1</span>:<span class="hljs-number">8080</span>/generate_stream \\
    -X POST \\
    -d &#x27;{<span class="hljs-string">&quot;inputs&quot;</span>:<span class="hljs-string">&quot;What is Deep Learning?&quot;</span>,<span class="hljs-string">&quot;parameters&quot;</span>:{<span class="hljs-string">&quot;max_new_tokens&quot;</span>:<span class="hljs-number">20</span>}}&#x27; \\
    -H <span class="hljs-symbol">&#x27;Content</span>-<span class="hljs-keyword">Type</span>: application/json&#x27;`,wrap:!1}}),ge=new Tl({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/backends/neuron.md"}}),{c(){c=i("meta"),Ue=s(),ve=i("p"),be=s(),r(A.$$.fragment),$e=s(),y=i("p"),y.textContent=Nt,we=s(),g=i("p"),g.textContent=Et,Ce=s(),v=i("ul"),v.innerHTML=Zt,xe=s(),r(T.$$.fragment),Je=s(),U=i("p"),U.textContent=Rt,Ne=s(),b=i("ul"),b.innerHTML=Lt,Ee=s(),r($.$$.fragment),Ze=s(),w=i("p"),w.textContent=_t,Re=s(),C=i("ul"),C.innerHTML=Vt,Le=s(),r(x.$$.fragment),_e=s(),J=i("p"),J.textContent=St,Ve=s(),r(N.$$.fragment),Se=s(),E=i("ul"),E.innerHTML=It,Ie=s(),Z=i("p"),Z.textContent=Ht,He=s(),R=i("ul"),R.innerHTML=Wt,We=s(),r(L.$$.fragment),Xe=s(),_=i("p"),_.innerHTML=Xt,Ge=s(),V=i("p"),V.innerHTML=Gt,ke=s(),S=i("p"),S.innerHTML=kt,ze=s(),I=i("p"),I.innerHTML=zt,Fe=s(),H=i("p"),H.textContent=Ft,Pe=s(),r(W.$$.fragment),Qe=s(),r(X.$$.fragment),Ye=s(),G=i("p"),G.innerHTML=Pt,Be=s(),k=i("p"),k.textContent=Qt,qe=s(),z=i("ul"),z.innerHTML=Yt,Oe=s(),F=i("p"),F.textContent=Bt,De=s(),r(P.$$.fragment),Ke=s(),r(Q.$$.fragment),et=s(),Y=i("p"),Y.innerHTML=qt,tt=s(),B=i("p"),B.textContent=Ot,lt=s(),r(q.$$.fragment),nt=s(),O=i("p"),O.textContent=Dt,st=s(),r(D.$$.fragment),at=s(),K=i("p"),K.textContent=Kt,it=s(),ee=i("p"),ee.textContent=el,ot=s(),r(te.$$.fragment),pt=s(),r(le.$$.fragment),rt=s(),ne=i("p"),ne.textContent=tl,Mt=s(),r(se.$$.fragment),mt=s(),ae=i("p"),ae.textContent=ll,ut=s(),ie=i("p"),ie.innerHTML=nl,ht=s(),oe=i("p"),oe.textContent=sl,dt=s(),pe=i("ul"),pe.innerHTML=al,jt=s(),re=i("p"),re.textContent=il,ct=s(),Me=i("ul"),Me.innerHTML=ol,ft=s(),r(me.$$.fragment),At=s(),ue=i("p"),ue.textContent=pl,yt=s(),he=i("p"),he.innerHTML=rl,gt=s(),de=i("p"),de.innerHTML=Ml,vt=s(),r(je.$$.fragment),Tt=s(),ce=i("p"),ce.innerHTML=ml,Ut=s(),r(fe.$$.fragment),bt=s(),r(Ae.$$.fragment),$t=s(),ye=i("p"),ye.textContent=ul,wt=s(),r(ge.$$.fragment),Ct=s(),Te=i("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),Ue=a(e),ve=o(e,"P",{}),hl(ve).forEach(l),be=a(e),M(A.$$.fragment,e),$e=a(e),y=o(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-bpcans"&&(y.textContent=Nt),we=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-xh1zjg"&&(g.textContent=Et),Ce=a(e),v=o(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-1ga935p"&&(v.innerHTML=Zt),xe=a(e),M(T.$$.fragment,e),Je=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-92sdri"&&(U.textContent=Rt),Ne=a(e),b=o(e,"UL",{"data-svelte-h":!0}),p(b)!=="svelte-eolvwz"&&(b.innerHTML=Lt),Ee=a(e),M($.$$.fragment,e),Ze=a(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-5gu30n"&&(w.textContent=_t),Re=a(e),C=o(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-1x9hcty"&&(C.innerHTML=Vt),Le=a(e),M(x.$$.fragment,e),_e=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-12pce8y"&&(J.textContent=St),Ve=a(e),M(N.$$.fragment,e),Se=a(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-pga4tt"&&(E.innerHTML=It),Ie=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1fcgvol"&&(Z.textContent=Ht),He=a(e),R=o(e,"UL",{"data-svelte-h":!0}),p(R)!=="svelte-1ukmtj"&&(R.innerHTML=Wt),We=a(e),M(L.$$.fragment,e),Xe=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1sg8eys"&&(_.innerHTML=Xt),Ge=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-hy12dz"&&(V.innerHTML=Gt),ke=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-52puqq"&&(S.innerHTML=kt),ze=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-uy1fc2"&&(I.innerHTML=zt),Fe=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1lcs0p7"&&(H.textContent=Ft),Pe=a(e),M(W.$$.fragment,e),Qe=a(e),M(X.$$.fragment,e),Ye=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-h1icm0"&&(G.innerHTML=Pt),Be=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-m6edyy"&&(k.textContent=Qt),qe=a(e),z=o(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-16293mf"&&(z.innerHTML=Yt),Oe=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-x98j2h"&&(F.textContent=Bt),De=a(e),M(P.$$.fragment,e),Ke=a(e),M(Q.$$.fragment,e),et=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1wzd1lp"&&(Y.innerHTML=qt),tt=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-8yjel3"&&(B.textContent=Ot),lt=a(e),M(q.$$.fragment,e),nt=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-y0ssef"&&(O.textContent=Dt),st=a(e),M(D.$$.fragment,e),at=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-tb6hms"&&(K.textContent=Kt),it=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-mpiqsr"&&(ee.textContent=el),ot=a(e),M(te.$$.fragment,e),pt=a(e),M(le.$$.fragment,e),rt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1ghlgzs"&&(ne.textContent=tl),Mt=a(e),M(se.$$.fragment,e),mt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1havrf1"&&(ae.textContent=ll),ut=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-k21pnr"&&(ie.innerHTML=nl),ht=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1988e1e"&&(oe.textContent=sl),dt=a(e),pe=o(e,"UL",{"data-svelte-h":!0}),p(pe)!=="svelte-17qmkgo"&&(pe.innerHTML=al),jt=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-2q9qa9"&&(re.textContent=il),ct=a(e),Me=o(e,"UL",{"data-svelte-h":!0}),p(Me)!=="svelte-1kej086"&&(Me.innerHTML=ol),ft=a(e),M(me.$$.fragment,e),At=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1h7cm8g"&&(ue.textContent=pl),yt=a(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-9it6jv"&&(he.innerHTML=rl),gt=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1xydlhh"&&(de.innerHTML=Ml),vt=a(e),M(je.$$.fragment,e),Tt=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-ij2xvf"&&(ce.innerHTML=ml),Ut=a(e),M(fe.$$.fragment,e),bt=a(e),M(Ae.$$.fragment,e),$t=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-14t3tlb"&&(ye.textContent=ul),wt=a(e),M(ge.$$.fragment,e),Ct=a(e),Te=o(e,"P",{}),hl(Te).forEach(l),this.h()},h(){dl(c,"name","hf:doc:metadata"),dl(c,"content",bl)},m(e,t){vl(document.head,c),n(e,Ue,t),n(e,ve,t),n(e,be,t),m(A,e,t),n(e,$e,t),n(e,y,t),n(e,we,t),n(e,g,t),n(e,Ce,t),n(e,v,t),n(e,xe,t),m(T,e,t),n(e,Je,t),n(e,U,t),n(e,Ne,t),n(e,b,t),n(e,Ee,t),m($,e,t),n(e,Ze,t),n(e,w,t),n(e,Re,t),n(e,C,t),n(e,Le,t),m(x,e,t),n(e,_e,t),n(e,J,t),n(e,Ve,t),m(N,e,t),n(e,Se,t),n(e,E,t),n(e,Ie,t),n(e,Z,t),n(e,He,t),n(e,R,t),n(e,We,t),m(L,e,t),n(e,Xe,t),n(e,_,t),n(e,Ge,t),n(e,V,t),n(e,ke,t),n(e,S,t),n(e,ze,t),n(e,I,t),n(e,Fe,t),n(e,H,t),n(e,Pe,t),m(W,e,t),n(e,Qe,t),m(X,e,t),n(e,Ye,t),n(e,G,t),n(e,Be,t),n(e,k,t),n(e,qe,t),n(e,z,t),n(e,Oe,t),n(e,F,t),n(e,De,t),m(P,e,t),n(e,Ke,t),m(Q,e,t),n(e,et,t),n(e,Y,t),n(e,tt,t),n(e,B,t),n(e,lt,t),m(q,e,t),n(e,nt,t),n(e,O,t),n(e,st,t),m(D,e,t),n(e,at,t),n(e,K,t),n(e,it,t),n(e,ee,t),n(e,ot,t),m(te,e,t),n(e,pt,t),m(le,e,t),n(e,rt,t),n(e,ne,t),n(e,Mt,t),m(se,e,t),n(e,mt,t),n(e,ae,t),n(e,ut,t),n(e,ie,t),n(e,ht,t),n(e,oe,t),n(e,dt,t),n(e,pe,t),n(e,jt,t),n(e,re,t),n(e,ct,t),n(e,Me,t),n(e,ft,t),m(me,e,t),n(e,At,t),n(e,ue,t),n(e,yt,t),n(e,he,t),n(e,gt,t),n(e,de,t),n(e,vt,t),m(je,e,t),n(e,Tt,t),n(e,ce,t),n(e,Ut,t),m(fe,e,t),n(e,bt,t),m(Ae,e,t),n(e,$t,t),n(e,ye,t),n(e,wt,t),m(ge,e,t),n(e,Ct,t),n(e,Te,t),xt=!0},p:cl,i(e){xt||(u(A.$$.fragment,e),u(T.$$.fragment,e),u($.$$.fragment,e),u(x.$$.fragment,e),u(N.$$.fragment,e),u(L.$$.fragment,e),u(W.$$.fragment,e),u(X.$$.fragment,e),u(P.$$.fragment,e),u(Q.$$.fragment,e),u(q.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(me.$$.fragment,e),u(je.$$.fragment,e),u(fe.$$.fragment,e),u(Ae.$$.fragment,e),u(ge.$$.fragment,e),xt=!0)},o(e){h(A.$$.fragment,e),h(T.$$.fragment,e),h($.$$.fragment,e),h(x.$$.fragment,e),h(N.$$.fragment,e),h(L.$$.fragment,e),h(W.$$.fragment,e),h(X.$$.fragment,e),h(P.$$.fragment,e),h(Q.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(me.$$.fragment,e),h(je.$$.fragment,e),h(fe.$$.fragment,e),h(Ae.$$.fragment,e),h(ge.$$.fragment,e),xt=!1},d(e){e&&(l(Ue),l(ve),l(be),l($e),l(y),l(we),l(g),l(Ce),l(v),l(xe),l(Je),l(U),l(Ne),l(b),l(Ee),l(Ze),l(w),l(Re),l(C),l(Le),l(_e),l(J),l(Ve),l(Se),l(E),l(Ie),l(Z),l(He),l(R),l(We),l(Xe),l(_),l(Ge),l(V),l(ke),l(S),l(ze),l(I),l(Fe),l(H),l(Pe),l(Qe),l(Ye),l(G),l(Be),l(k),l(qe),l(z),l(Oe),l(F),l(De),l(Ke),l(et),l(Y),l(tt),l(B),l(lt),l(nt),l(O),l(st),l(at),l(K),l(it),l(ee),l(ot),l(pt),l(rt),l(ne),l(Mt),l(mt),l(ae),l(ut),l(ie),l(ht),l(oe),l(dt),l(pe),l(jt),l(re),l(ct),l(Me),l(ft),l(At),l(ue),l(yt),l(he),l(gt),l(de),l(vt),l(Tt),l(ce),l(Ut),l(bt),l($t),l(ye),l(wt),l(Ct),l(Te)),l(c),d(A,e),d(T,e),d($,e),d(x,e),d(N,e),d(L,e),d(W,e),d(X,e),d(P,e),d(Q,e),d(q,e),d(D,e),d(te,e),d(le,e),d(se,e),d(me,e),d(je,e),d(fe,e),d(Ae,e),d(ge,e)}}}const bl='{"title":"Neuron backend for AWS Trainium and Inferentia","local":"neuron-backend-for-aws-trainium-and-inferentia","sections":[{"title":"Features","local":"features","sections":[],"depth":2},{"title":"Deploy the service from the Hugging Face hub","local":"deploy-the-service-from-the-hugging-face-hub","sections":[],"depth":2},{"title":"Deploy the service on a dedicated host","local":"deploy-the-service-on-a-dedicated-host","sections":[{"title":"Common system parameters","local":"common-system-parameters","sections":[],"depth":3},{"title":"Using a standard model from the 🤗 HuggingFace Hub (recommended)","local":"using-a-standard-model-from-the--huggingface-hub-recommended","sections":[],"depth":3},{"title":"Using a model exported to a local path","local":"using-a-model-exported-to-a-local-path","sections":[],"depth":3},{"title":"Using a neuron model from the 🤗 HuggingFace Hub","local":"using-a-neuron-model-from-the--huggingface-hub","sections":[],"depth":3},{"title":"Choosing service parameters","local":"choosing-service-parameters","sections":[],"depth":3},{"title":"Choosing the correct batch size","local":"choosing-the-correct-batch-size","sections":[],"depth":3}],"depth":2},{"title":"Query the service","local":"query-the-service","sections":[],"depth":2}],"depth":1}';function $l(Jt){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nl extends Al{constructor(c){super(),yl(this,c,$l,Ul,jl,{})}}export{Nl as component};
