import{s as ln,f as sn,n as dn,o as cn}from"../chunks/scheduler.d627b047.js";import{S as pn,i as mn,g as i,s as n,r as p,A as gn,h as s,f as a,c as o,j as b,u as m,x as d,k as v,y as l,a as r,v as g,d as h,t as u,w as f}from"../chunks/index.73c51727.js";import{D as y}from"../chunks/Docstring.488b7ad2.js";import{C as Ta}from"../chunks/CodeBlock.b1cdc5f6.js";import{H as C,E as hn}from"../chunks/EditOnGithub.859b9ebc.js";function un($a){let P,Ke,Ye,et,q,tt,I,wa='<a href="https://huggingface.co/models?other=cpo,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-CPO-blue"/></a>',at,H,nt,E,Oa='Contrastive Preference Optimization (CPO) as introduced in the paper <a href="https://huggingface.co/papers/2401.08417" rel="nofollow">Contrastive Preference Optimization: Pushing the Boundaries of LLM Performance in Machine Translation</a> by <a href="https://huggingface.co/haoranxu" rel="nofollow">Haoran Xu</a>, <a href="https://huggingface.co/amrsharaf" rel="nofollow">Amr Sharaf</a>, <a href="https://huggingface.co/yunmochen" rel="nofollow">Yunmo Chen</a>, Weiting Tan, Lingfeng Shen, Benjamin Van Durme, <a href="https://huggingface.co/Kenton" rel="nofollow">Kenton Murray</a>, and <a href="https://huggingface.co/ykim362" rel="nofollow">Young Jin Kim</a>. At a high-level, CPO trains models to avoid generating adequate, but not perfect translations in Machine Translation (MT) tasks. However, CPO is a general approximation of the DPO loss and can be applied to other domains, such as chat.',ot,S,xa="CPO aims to mitigate two fundamental shortcomings of SFT. First, SFT’s methodology of minimizing the discrepancy between predicted outputs and gold-standard references inherently caps model performance at the quality level of the training data. Secondly, SFT lacks a mechanism to prevent the model from rejecting mistakes in translations. The CPO objective is derived from the DPO objective.",rt,B,lt,D,Pa='This example demonstrates how to train a model using the CPO method. We use the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen 0.5B model</a> as the base model. We use the preference data from the <a href="https://huggingface.co/datasets/openbmb/UltraFeedback" rel="nofollow">UltraFeedback dataset</a>. You can view the data in the dataset here:',it,w,Ma,st,J,ka="Below is the script to train the model:",dt,A,ct,Z,Na="Execute the script using the following command:",pt,Q,mt,R,gt,V,Fa='CPO requires a <a href="dataset_formats#preference">preference dataset</a>. The <a href="/docs/trl/v0.15.0/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.',ht,X,ut,Y,La='We provide an example script to train a model using the CPO method. The script is available in <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/cpo.py" rel="nofollow"><code>examples/scripts/cpo.py</code></a>',ft,G,Ua='To test the CPO script with the <a href="https://huggingface.co/Qwen/Qwen2-0.5B-Instruct" rel="nofollow">Qwen2 0.5B model</a> on the <a href="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized" rel="nofollow">UltraFeedback dataset</a>, run the following command:',_t,K,vt,ee,bt,te,za="While training and evaluating we record the following reward metrics:",yt,ae,ja="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>nll_loss</code>: the mean negative log likelihood loss of the policy model for the chosen responses</li>",Ct,ne,Tt,oe,$t,re,Wa='The <a href="https://huggingface.co/papers/2405.14734" rel="nofollow">SimPO</a> method is also implemented in the <a href="/docs/trl/v0.15.0/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a>. SimPO is an alternative loss that adds a reward margin, allows for length normalization, and does not use BC regularization. To use this loss, we can use SimPO easily by turning on <code>loss_type=&quot;simpo&quot;</code> and <code>cpo_alpha=0.0</code> in the <a href="/docs/trl/v0.15.0/en/cpo_trainer#trl.CPOConfig">CPOConfig</a>.',wt,le,Ot,ie,qa='We also offer the combined use of CPO and SimPO, which enables more stable training and improved performance. Learn more details at <a href="https://github.com/fe1ixxu/CPO_SIMPO" rel="nofollow">CPO-SimPO GitHub</a>. To use this method, simply enable SimPO by setting <code>loss_type=&quot;simpo&quot;</code> and a non-zero <code>cpo_alpha</code> in the <a href="/docs/trl/v0.15.0/en/cpo_trainer#trl.CPOConfig">CPOConfig</a>.',xt,se,Pt,de,Ia='The CPO algorithm supports several loss functions. The loss function can be set using the <code>loss_type</code> parameter in the <a href="/docs/trl/v0.15.0/en/cpo_trainer#trl.CPOConfig">CPOConfig</a>. The following loss functions are supported:',Mt,ce,Ha='<thead><tr><th><code>loss_type=</code></th> <th>Description</th></tr></thead> <tbody><tr><td><code>&quot;sigmoid&quot;</code> (default)</td> <td>Given the preference data, we can fit a binary classifier according to the Bradley-Terry model and in fact the <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> authors propose the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.</td></tr> <tr><td><code>&quot;hinge&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper. In this case, the <code>beta</code> is the reciprocal of the margin.</td></tr> <tr><td><code>&quot;ipo&quot;</code></td> <td>The <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the DPO algorithms and identify an issue with overfitting and propose an alternative loss. In this case, the <code>beta</code> is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike DPO which is summed only).</td></tr></tbody>',kt,pe,Nt,me,Ea=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,Ft,ge,Sa=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. <a href="https://huggingface.co/docs/transformers/v4.49.0/en/model_doc/mixtral#transformers.MixtralConfig" rel="nofollow">MixtralConfig</a>).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: <code>0.001</code>) in the model config.`,Lt,he,Ut,c,ue,Qt,Ne,Ba="Initialize CPOTrainer.",Rt,M,fe,Vt,Fe,Da=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,Xt,O,_e,Yt,Le,Ja="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Gt,Ue,Aa="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Kt,k,ve,ea,ze,Za="Concatenate the chosen and rejected inputs into a single tensor.",ta,N,be,aa,je,Qa="Compute the CPO loss for a batch of policy and reference model log probabilities.",na,F,ye,oa,We,Ra="Creates a draft of a model card using the information available to the <code>Trainer</code>.",ra,x,Ce,la,qe,Va=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,ia,Ie,Xa="Works both with or without labels.",sa,L,Te,da,He,Ya="Generate samples from the model and reference model for the given batch of inputs.",ca,U,$e,pa,Ee,Ga="Compute the log probabilities of the given labels under the given logits.",ma,z,we,ga,Se,Ka="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",ha,j,Oe,ua,Be,en="Log <code>logs</code> on the various objects watching training, including stored metrics.",fa,T,xe,_a,De,tn="Tokenize a single row from a CPO specific dataset.",va,Je,an=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,ba,Ae,nn=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,zt,Pe,jt,$,Me,ya,Ze,on='Configuration class for the <a href="/docs/trl/v0.15.0/en/cpo_trainer#trl.CPOTrainer">CPOTrainer</a>.',Ca,Qe,rn=`Using <a href="https://huggingface.co/docs/transformers/v4.49.0/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Wt,ke,qt,Ge,It;return q=new C({props:{title:"CPO Trainer",local:"cpo-trainer",headingTag:"h1"}}),H=new C({props:{title:"Overview",local:"overview",headingTag:"h2"}}),B=new C({props:{title:"Quick start",local:"quick-start",headingTag:"h2"}}),A=new Ta({props:{code:"JTIzJTIwdHJhaW5fY3BvLnB5JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMENQT0NvbmZpZyUyQyUyMENQT1RyYWluZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIpJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBDUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLTAuNUItQ1BPJTIyJTJDJTIwbG9nZ2luZ19zdGVwcyUzRDEwKSUwQXRyYWluZXIlMjAlM0QlMjBDUE9UcmFpbmVyKG1vZGVsJTNEbW9kZWwlMkMlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMHByb2Nlc3NpbmdfY2xhc3MlM0R0b2tlbml6ZXIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># train_cpo.py</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> CPOConfig, CPOTrainer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>)
train_dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = CPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2-0.5B-CPO&quot;</span>, logging_steps=<span class="hljs-number">10</span>)
trainer = CPOTrainer(model=model, args=training_args, processing_class=tokenizer, train_dataset=train_dataset)
trainer.train()`,wrap:!1}}),Q=new Ta({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2Nwby5weQ==",highlighted:"accelerate launch train_cpo.py",wrap:!1}}),R=new C({props:{title:"Expected dataset type",local:"expected-dataset-type",headingTag:"h2"}}),X=new C({props:{title:"Example script",local:"example-script",headingTag:"h2"}}),K=new Ta({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGV4YW1wbGVzJTJGc2NyaXB0cyUyRmNwby5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHRybC1saWIlMkZ1bHRyYWZlZWRiYWNrX2JpbmFyaXplZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbnVtX3RyYWluX2Vwb2NocyUyMDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxvZ2dpbmdfc3RlcHMlMjAyNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUyMFF3ZW4yLTAuNUItQ1BP",highlighted:`accelerate launch examples/scripts/cpo.py \\
    --model_name_or_path Qwen/Qwen2-0.5B-Instruct \\
    --dataset_name trl-lib/ultrafeedback_binarized \\
    --num_train_epochs 1 \\
    --logging_steps 25 \\
    --output_dir Qwen2-0.5B-CPO`,wrap:!1}}),ee=new C({props:{title:"Logged metrics",local:"logged-metrics",headingTag:"h2"}}),ne=new C({props:{title:"CPO variants",local:"cpo-variants",headingTag:"h2"}}),oe=new C({props:{title:"Simple Preference Optimization (SimPO)",local:"simple-preference-optimization-simpo",headingTag:"h3"}}),le=new C({props:{title:"CPO-SimPO",local:"cpo-simpo",headingTag:"h3"}}),se=new C({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),pe=new C({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),he=new C({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),ue=new y({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"args",val:": typing.Optional[trl.trainer.cpo_config.CPOConfig] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], transformers.modeling_utils.PreTrainedModel]] = None"},{name:"callbacks",val:": typing.Optional[list[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"peft_config",val:": typing.Optional[dict] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], dict]] = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.`,name:"processing_class"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>list[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L75"}}),fe=new y({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L375"}}),_e=new y({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L722"}}),ve=new y({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": typing.Optional[torch.device] = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.concatenated_inputs.batch",description:"<strong>batch</strong> &#x2014; A batch of data. Must contain the keys &#x2018;chosen_input_ids&#x2019; and &#x2018;rejected_input_ids&#x2019;, which are tensors of shape (batch_size, sequence_length).",name:"batch"},{anchor:"trl.CPOTrainer.concatenated_inputs.is_encoder_decoder",description:"<strong>is_encoder_decoder</strong> &#x2014; Whether the model is an encoder-decoder model.",name:"is_encoder_decoder"},{anchor:"trl.CPOTrainer.concatenated_inputs.label_pad_token_id",description:"<strong>label_pad_token_id</strong> &#x2014; The label pad token id.",name:"label_pad_token_id"},{anchor:"trl.CPOTrainer.concatenated_inputs.padding_value",description:"<strong>padding_value</strong> &#x2014; The padding value to use for the concatenated inputs_ids.",name:"padding_value"},{anchor:"trl.CPOTrainer.concatenated_inputs.device",description:"<strong>device</strong> &#x2014; The device for the concatenated inputs.",name:"device"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L571",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),be=new y({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],parametersDescription:[{anchor:"trl.CPOTrainer.cpo_loss.policy_chosen_logps",description:"<strong>policy_chosen_logps</strong> &#x2014; Log probabilities of the policy model for the chosen responses. Shape: (batch_size,)",name:"policy_chosen_logps"},{anchor:"trl.CPOTrainer.cpo_loss.policy_rejected_logps",description:"<strong>policy_rejected_logps</strong> &#x2014; Log probabilities of the policy model for the rejected responses. Shape: (batch_size,)",name:"policy_rejected_logps"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L633",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ye=new y({props:{name:"create_model_card",anchor:"trl.CPOTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, list[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the model.`,name:"model_name"},{anchor:"trl.CPOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.CPOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L1025"}}),Ce=new y({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L930"}}),Te=new y({props:{name:"generate_from_model",anchor:"trl.CPOTrainer.generate_from_model",parameters:[{name:"model",val:""},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L870"}}),$e=new y({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],parametersDescription:[{anchor:"trl.CPOTrainer.get_batch_logps.logits",description:"<strong>logits</strong> &#x2014; Logits of the model (unnormalized). Shape: (batch_size, sequence_length, vocab_size)",name:"logits"},{anchor:"trl.CPOTrainer.get_batch_logps.labels",description:"<strong>labels</strong> &#x2014; Labels for which to compute the log probabilities. Label tokens with a value of label_pad_token_id are ignored. Shape: (batch_size, sequence_length)",name:"labels"},{anchor:"trl.CPOTrainer.get_batch_logps.average_log_prob",description:"<strong>average_log_prob</strong> &#x2014; If True, return the average log probability per (non-masked) token. Otherwise, return the sum of the log probabilities of the (non-masked) tokens.",name:"average_log_prob"},{anchor:"trl.CPOTrainer.get_batch_logps.label_pad_token_id",description:"<strong>label_pad_token_id</strong> &#x2014; The label pad token id.",name:"label_pad_token_id"},{anchor:"trl.CPOTrainer.get_batch_logps.is_encoder_decoder",description:"<strong>is_encoder_decoder</strong> &#x2014; Whether the model is an encoder-decoder model.",name:"is_encoder_decoder"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L684",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),we=new y({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": dict"},{name:"train_eval",val:": typing.Literal['train', 'eval'] = 'train'"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L797"}}),Oe=new y({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": dict"},{name:"start_time",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"},{anchor:"trl.CPOTrainer.log.start_time",description:`<strong>start_time</strong> (<code>float</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Start time of the training.`,name:"start_time"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L980"}}),xe=new y({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, NoneType] = None"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_trainer.py#L425"}}),Pe=new C({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),Me=new y({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 1e-06"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": typing.List[str] = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = None"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"max_length",val:": typing.Optional[int] = 1024"},{name:"max_prompt_length",val:": typing.Optional[int] = 512"},{name:"max_completion_length",val:": typing.Optional[int] = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0.0"},{name:"loss_type",val:": str = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"cpo_alpha",val:": float = 1.0"},{name:"simpo_gamma",val:": float = 0.5"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"trl.CPOConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1e-6</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/v4.49.0/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model. For the IPO loss (<code>loss_type=&quot;ipo&quot;</code>), &#x3B2; is the regularization parameter denoted by &#x3C4; in
the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">paper</a>.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.0</code>) &#x2014;
Label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sigmoid&quot;</code>) &#x2014;
Type of loss to use. Possible values are:</p>
<ul>
<li><code>&quot;sigmoid&quot;</code>: sigmoid loss from the original <a href="https://huggingface.co/papers/2305.18290" rel="nofollow">DPO</a> paper.</li>
<li><code>&quot;hinge&quot;</code>: hinge loss on the normalized likelihood from the <a href="https://huggingface.co/papers/2305.10425" rel="nofollow">SLiC</a> paper.</li>
<li><code>&quot;ipo&quot;</code>: IPO loss from the <a href="https://huggingface.co/papers/2310.12036" rel="nofollow">IPO</a> paper.</li>
<li><code>&quot;simpo&quot;</code>: SimPO loss from the <a href="https://huggingface.co/papers/2405.14734" rel="nofollow">SimPO</a> paper.</li>
</ul>`,name:"loss_type"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.cpo_alpha",description:`<strong>cpo_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1.0</code>) &#x2014;
Weight of the BC regularizer in CPO training.`,name:"cpo_alpha"},{anchor:"trl.CPOConfig.simpo_gamma",description:`<strong>simpo_gamma</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.5</code>) &#x2014;
Target reward margin for the SimPO loss, used only when the <code>loss_type=&quot;simpo&quot;</code>.`,name:"simpo_gamma"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>,<em>optional</em>,  defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from the model to W&amp;B or Comet during evaluation.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/v0.15.0/trl/trainer/cpo_config.py#L21"}}),ke=new hn({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/cpo_trainer.md"}}),{c(){P=i("meta"),Ke=n(),Ye=i("p"),et=n(),p(q.$$.fragment),tt=n(),I=i("p"),I.innerHTML=wa,at=n(),p(H.$$.fragment),nt=n(),E=i("p"),E.innerHTML=Oa,ot=n(),S=i("p"),S.textContent=xa,rt=n(),p(B.$$.fragment),lt=n(),D=i("p"),D.innerHTML=Pa,it=n(),w=i("iframe"),st=n(),J=i("p"),J.textContent=ka,dt=n(),p(A.$$.fragment),ct=n(),Z=i("p"),Z.textContent=Na,pt=n(),p(Q.$$.fragment),mt=n(),p(R.$$.fragment),gt=n(),V=i("p"),V.innerHTML=Fa,ht=n(),p(X.$$.fragment),ut=n(),Y=i("p"),Y.innerHTML=La,ft=n(),G=i("p"),G.innerHTML=Ua,_t=n(),p(K.$$.fragment),vt=n(),p(ee.$$.fragment),bt=n(),te=i("p"),te.textContent=za,yt=n(),ae=i("ul"),ae.innerHTML=ja,Ct=n(),p(ne.$$.fragment),Tt=n(),p(oe.$$.fragment),$t=n(),re=i("p"),re.innerHTML=Wa,wt=n(),p(le.$$.fragment),Ot=n(),ie=i("p"),ie.innerHTML=qa,xt=n(),p(se.$$.fragment),Pt=n(),de=i("p"),de.innerHTML=Ia,Mt=n(),ce=i("table"),ce.innerHTML=Ha,kt=n(),p(pe.$$.fragment),Nt=n(),me=i("p"),me.innerHTML=Ea,Ft=n(),ge=i("p"),ge.innerHTML=Sa,Lt=n(),p(he.$$.fragment),Ut=n(),c=i("div"),p(ue.$$.fragment),Qt=n(),Ne=i("p"),Ne.textContent=Ba,Rt=n(),M=i("div"),p(fe.$$.fragment),Vt=n(),Fe=i("p"),Fe.innerHTML=Da,Xt=n(),O=i("div"),p(_e.$$.fragment),Yt=n(),Le=i("p"),Le.textContent=Ja,Gt=n(),Ue=i("p"),Ue.textContent=Aa,Kt=n(),k=i("div"),p(ve.$$.fragment),ea=n(),ze=i("p"),ze.textContent=Za,ta=n(),N=i("div"),p(be.$$.fragment),aa=n(),je=i("p"),je.textContent=Qa,na=n(),F=i("div"),p(ye.$$.fragment),oa=n(),We=i("p"),We.innerHTML=Ra,ra=n(),x=i("div"),p(Ce.$$.fragment),la=n(),qe=i("p"),qe.innerHTML=Va,ia=n(),Ie=i("p"),Ie.textContent=Xa,sa=n(),L=i("div"),p(Te.$$.fragment),da=n(),He=i("p"),He.textContent=Ya,ca=n(),U=i("div"),p($e.$$.fragment),pa=n(),Ee=i("p"),Ee.textContent=Ga,ma=n(),z=i("div"),p(we.$$.fragment),ga=n(),Se=i("p"),Se.textContent=Ka,ha=n(),j=i("div"),p(Oe.$$.fragment),ua=n(),Be=i("p"),Be.innerHTML=en,fa=n(),T=i("div"),p(xe.$$.fragment),_a=n(),De=i("p"),De.textContent=tn,va=n(),Je=i("p"),Je.textContent=an,ba=n(),Ae=i("p"),Ae.textContent=nn,zt=n(),p(Pe.$$.fragment),jt=n(),$=i("div"),p(Me.$$.fragment),ya=n(),Ze=i("p"),Ze.innerHTML=on,Ca=n(),Qe=i("p"),Qe.innerHTML=rn,Wt=n(),p(ke.$$.fragment),qt=n(),Ge=i("p"),this.h()},l(e){const t=gn("svelte-u9bgzb",document.head);P=s(t,"META",{name:!0,content:!0}),t.forEach(a),Ke=o(e),Ye=s(e,"P",{}),b(Ye).forEach(a),et=o(e),m(q.$$.fragment,e),tt=o(e),I=s(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-l2wng"&&(I.innerHTML=wa),at=o(e),m(H.$$.fragment,e),nt=o(e),E=s(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-9lwoy4"&&(E.innerHTML=Oa),ot=o(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-10wbspk"&&(S.textContent=xa),rt=o(e),m(B.$$.fragment,e),lt=o(e),D=s(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-16abj0b"&&(D.innerHTML=Pa),it=o(e),w=s(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),b(w).forEach(a),st=o(e),J=s(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-uqytq6"&&(J.textContent=ka),dt=o(e),m(A.$$.fragment,e),ct=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-15hino8"&&(Z.textContent=Na),pt=o(e),m(Q.$$.fragment,e),mt=o(e),m(R.$$.fragment,e),gt=o(e),V=s(e,"P",{"data-svelte-h":!0}),d(V)!=="svelte-70n87l"&&(V.innerHTML=Fa),ht=o(e),m(X.$$.fragment,e),ut=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-89szq"&&(Y.innerHTML=La),ft=o(e),G=s(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1u4mdq5"&&(G.innerHTML=Ua),_t=o(e),m(K.$$.fragment,e),vt=o(e),m(ee.$$.fragment,e),bt=o(e),te=s(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-132s7j9"&&(te.textContent=za),yt=o(e),ae=s(e,"UL",{"data-svelte-h":!0}),d(ae)!=="svelte-yjg2sp"&&(ae.innerHTML=ja),Ct=o(e),m(ne.$$.fragment,e),Tt=o(e),m(oe.$$.fragment,e),$t=o(e),re=s(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1ynks2r"&&(re.innerHTML=Wa),wt=o(e),m(le.$$.fragment,e),Ot=o(e),ie=s(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1my7oyr"&&(ie.innerHTML=qa),xt=o(e),m(se.$$.fragment,e),Pt=o(e),de=s(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-8xgj2f"&&(de.innerHTML=Ia),Mt=o(e),ce=s(e,"TABLE",{"data-svelte-h":!0}),d(ce)!=="svelte-geackf"&&(ce.innerHTML=Ha),kt=o(e),m(pe.$$.fragment,e),Nt=o(e),me=s(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-14px1ga"&&(me.innerHTML=Ea),Ft=o(e),ge=s(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-z2ii65"&&(ge.innerHTML=Sa),Lt=o(e),m(he.$$.fragment,e),Ut=o(e),c=s(e,"DIV",{class:!0});var _=b(c);m(ue.$$.fragment,_),Qt=o(_),Ne=s(_,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1qqtmoh"&&(Ne.textContent=Ba),Rt=o(_),M=s(_,"DIV",{class:!0});var Ht=b(M);m(fe.$$.fragment,Ht),Vt=o(Ht),Fe=s(Ht,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-mcz8nm"&&(Fe.innerHTML=Da),Ht.forEach(a),Xt=o(_),O=s(_,"DIV",{class:!0});var Re=b(O);m(_e.$$.fragment,Re),Yt=o(Re),Le=s(Re,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-16i1nac"&&(Le.textContent=Ja),Gt=o(Re),Ue=s(Re,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-tgti68"&&(Ue.textContent=Aa),Re.forEach(a),Kt=o(_),k=s(_,"DIV",{class:!0});var Et=b(k);m(ve.$$.fragment,Et),ea=o(Et),ze=s(Et,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1cvsgkk"&&(ze.textContent=Za),Et.forEach(a),ta=o(_),N=s(_,"DIV",{class:!0});var St=b(N);m(be.$$.fragment,St),aa=o(St),je=s(St,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1l2rxe2"&&(je.textContent=Qa),St.forEach(a),na=o(_),F=s(_,"DIV",{class:!0});var Bt=b(F);m(ye.$$.fragment,Bt),oa=o(Bt),We=s(Bt,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1mh859w"&&(We.innerHTML=Ra),Bt.forEach(a),ra=o(_),x=s(_,"DIV",{class:!0});var Ve=b(x);m(Ce.$$.fragment,Ve),la=o(Ve),qe=s(Ve,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-8qlty5"&&(qe.innerHTML=Va),ia=o(Ve),Ie=s(Ve,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1tyo99t"&&(Ie.textContent=Xa),Ve.forEach(a),sa=o(_),L=s(_,"DIV",{class:!0});var Dt=b(L);m(Te.$$.fragment,Dt),da=o(Dt),He=s(Dt,"P",{"data-svelte-h":!0}),d(He)!=="svelte-18uwvbi"&&(He.textContent=Ya),Dt.forEach(a),ca=o(_),U=s(_,"DIV",{class:!0});var Jt=b(U);m($e.$$.fragment,Jt),pa=o(Jt),Ee=s(Jt,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-4nmimv"&&(Ee.textContent=Ga),Jt.forEach(a),ma=o(_),z=s(_,"DIV",{class:!0});var At=b(z);m(we.$$.fragment,At),ga=o(At),Se=s(At,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-4kzfyw"&&(Se.textContent=Ka),At.forEach(a),ha=o(_),j=s(_,"DIV",{class:!0});var Zt=b(j);m(Oe.$$.fragment,Zt),ua=o(Zt),Be=s(Zt,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-nqksfz"&&(Be.innerHTML=en),Zt.forEach(a),fa=o(_),T=s(_,"DIV",{class:!0});var W=b(T);m(xe.$$.fragment,W),_a=o(W),De=s(W,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1a53vwp"&&(De.textContent=tn),va=o(W),Je=s(W,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1mn1gnw"&&(Je.textContent=an),ba=o(W),Ae=s(W,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1xvpyih"&&(Ae.textContent=nn),W.forEach(a),_.forEach(a),zt=o(e),m(Pe.$$.fragment,e),jt=o(e),$=s(e,"DIV",{class:!0});var Xe=b($);m(Me.$$.fragment,Xe),ya=o(Xe),Ze=s(Xe,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-7gf1m3"&&(Ze.innerHTML=on),Ca=o(Xe),Qe=s(Xe,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-2adg1n"&&(Qe.innerHTML=rn),Xe.forEach(a),Wt=o(e),m(ke.$$.fragment,e),qt=o(e),Ge=s(e,"P",{}),b(Ge).forEach(a),this.h()},h(){v(P,"name","hf:doc:metadata"),v(P,"content",fn),sn(w.src,Ma="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized/embed/viewer/default/train?row=0")||v(w,"src",Ma),v(w,"frameborder","0"),v(w,"width","100%"),v(w,"height","560px"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,P),r(e,Ke,t),r(e,Ye,t),r(e,et,t),g(q,e,t),r(e,tt,t),r(e,I,t),r(e,at,t),g(H,e,t),r(e,nt,t),r(e,E,t),r(e,ot,t),r(e,S,t),r(e,rt,t),g(B,e,t),r(e,lt,t),r(e,D,t),r(e,it,t),r(e,w,t),r(e,st,t),r(e,J,t),r(e,dt,t),g(A,e,t),r(e,ct,t),r(e,Z,t),r(e,pt,t),g(Q,e,t),r(e,mt,t),g(R,e,t),r(e,gt,t),r(e,V,t),r(e,ht,t),g(X,e,t),r(e,ut,t),r(e,Y,t),r(e,ft,t),r(e,G,t),r(e,_t,t),g(K,e,t),r(e,vt,t),g(ee,e,t),r(e,bt,t),r(e,te,t),r(e,yt,t),r(e,ae,t),r(e,Ct,t),g(ne,e,t),r(e,Tt,t),g(oe,e,t),r(e,$t,t),r(e,re,t),r(e,wt,t),g(le,e,t),r(e,Ot,t),r(e,ie,t),r(e,xt,t),g(se,e,t),r(e,Pt,t),r(e,de,t),r(e,Mt,t),r(e,ce,t),r(e,kt,t),g(pe,e,t),r(e,Nt,t),r(e,me,t),r(e,Ft,t),r(e,ge,t),r(e,Lt,t),g(he,e,t),r(e,Ut,t),r(e,c,t),g(ue,c,null),l(c,Qt),l(c,Ne),l(c,Rt),l(c,M),g(fe,M,null),l(M,Vt),l(M,Fe),l(c,Xt),l(c,O),g(_e,O,null),l(O,Yt),l(O,Le),l(O,Gt),l(O,Ue),l(c,Kt),l(c,k),g(ve,k,null),l(k,ea),l(k,ze),l(c,ta),l(c,N),g(be,N,null),l(N,aa),l(N,je),l(c,na),l(c,F),g(ye,F,null),l(F,oa),l(F,We),l(c,ra),l(c,x),g(Ce,x,null),l(x,la),l(x,qe),l(x,ia),l(x,Ie),l(c,sa),l(c,L),g(Te,L,null),l(L,da),l(L,He),l(c,ca),l(c,U),g($e,U,null),l(U,pa),l(U,Ee),l(c,ma),l(c,z),g(we,z,null),l(z,ga),l(z,Se),l(c,ha),l(c,j),g(Oe,j,null),l(j,ua),l(j,Be),l(c,fa),l(c,T),g(xe,T,null),l(T,_a),l(T,De),l(T,va),l(T,Je),l(T,ba),l(T,Ae),r(e,zt,t),g(Pe,e,t),r(e,jt,t),r(e,$,t),g(Me,$,null),l($,ya),l($,Ze),l($,Ca),l($,Qe),r(e,Wt,t),g(ke,e,t),r(e,qt,t),r(e,Ge,t),It=!0},p:dn,i(e){It||(h(q.$$.fragment,e),h(H.$$.fragment,e),h(B.$$.fragment,e),h(A.$$.fragment,e),h(Q.$$.fragment,e),h(R.$$.fragment,e),h(X.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(Ce.$$.fragment,e),h(Te.$$.fragment,e),h($e.$$.fragment,e),h(we.$$.fragment,e),h(Oe.$$.fragment,e),h(xe.$$.fragment,e),h(Pe.$$.fragment,e),h(Me.$$.fragment,e),h(ke.$$.fragment,e),It=!0)},o(e){u(q.$$.fragment,e),u(H.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(Q.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(Ce.$$.fragment,e),u(Te.$$.fragment,e),u($e.$$.fragment,e),u(we.$$.fragment,e),u(Oe.$$.fragment,e),u(xe.$$.fragment,e),u(Pe.$$.fragment,e),u(Me.$$.fragment,e),u(ke.$$.fragment,e),It=!1},d(e){e&&(a(Ke),a(Ye),a(et),a(tt),a(I),a(at),a(nt),a(E),a(ot),a(S),a(rt),a(lt),a(D),a(it),a(w),a(st),a(J),a(dt),a(ct),a(Z),a(pt),a(mt),a(gt),a(V),a(ht),a(ut),a(Y),a(ft),a(G),a(_t),a(vt),a(bt),a(te),a(yt),a(ae),a(Ct),a(Tt),a($t),a(re),a(wt),a(Ot),a(ie),a(xt),a(Pt),a(de),a(Mt),a(ce),a(kt),a(Nt),a(me),a(Ft),a(ge),a(Lt),a(Ut),a(c),a(zt),a(jt),a($),a(Wt),a(qt),a(Ge)),a(P),f(q,e),f(H,e),f(B,e),f(A,e),f(Q,e),f(R,e),f(X,e),f(K,e),f(ee,e),f(ne,e),f(oe,e),f(le,e),f(se,e),f(pe,e),f(he,e),f(ue),f(fe),f(_e),f(ve),f(be),f(ye),f(Ce),f(Te),f($e),f(we),f(Oe),f(xe),f(Pe,e),f(Me),f(ke,e)}}}const fn='{"title":"CPO Trainer","local":"cpo-trainer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Quick start","local":"quick-start","sections":[],"depth":2},{"title":"Expected dataset type","local":"expected-dataset-type","sections":[],"depth":2},{"title":"Example script","local":"example-script","sections":[],"depth":2},{"title":"Logged metrics","local":"logged-metrics","sections":[],"depth":2},{"title":"CPO variants","local":"cpo-variants","sections":[{"title":"Simple Preference Optimization (SimPO)","local":"simple-preference-optimization-simpo","sections":[],"depth":3},{"title":"CPO-SimPO","local":"cpo-simpo","sections":[],"depth":3}],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2}],"depth":1}';function _n($a){return cn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $n extends pn{constructor(P){super(),mn(this,P,_n,un,ln,{})}}export{$n as component};
