import{s as tt,o as lt,n as st}from"../chunks/scheduler.00bde567.js";import{S as at,i as nt,g as i,s as a,r as d,A as it,h as p,f as l,c as n,j as Oe,u,x as o,k as et,y as pt,a as s,v as m,d as h,t as f,w as M}from"../chunks/index.752e2ff6.js";import{T as ot}from"../chunks/Tip.6fda87e9.js";import{C as E}from"../chunks/CodeBlock.e62cd1dc.js";import{H as ge}from"../chunks/Heading.476d3364.js";function rt(K){let r,y=`This is only needed when trying to perform an action such as gathering the results, where the data on each device
needs to be the same length. Basic inference does not require this.`;return{c(){r=i("p"),r.textContent=y},l(c){r=p(c,"P",{"data-svelte-h":!0}),o(r)!=="svelte-rtowy2"&&(r.textContent=y)},m(c,L){s(c,r,L)},p:st,d(c){c&&l(r)}}}function ct(K){let r,y,c,L,j,O,b,Xe=`Distributed inference is a common use case, especially with natural language processing (NLP) models. Users often want to
send a number of different prompts, each to a different GPU, and then get the results back. This also has other cases
outside of just NLP, however for this tutorial we will focus on just this idea of each GPU receiving a different prompt,
and then returning the results.`,ee,U,te,Z,_e="Normally when doing this, users send the model to a specific device to load it from the CPU, and then move each prompt to a different device.",le,J,xe="A basic pipeline using the <code>diffusers</code> library might look something like so:",se,T,ae,v,We="Followed then by performing inference based on the specific prompt:",ne,B,ie,$,Qe="One will notice how we have to check the rank to know what prompt to send, which can be a bit tedious.",pe,C,Ne=`A user might then also think that with 🤗 Accelerate, using the <code>Accelerator</code> to prepare a dataloader for such a task might also be
a simple way to manage this. (To learn more, check out the relevant section in the <a href="../quicktour#distributed-evaluation">Quick Tour</a>)`,oe,G,Se="Can it manage it? Yes. Does it add unneeded extra code however: also yes.",re,k,ce,g,Ie=`With 🤗 Accelerate, we can simplify this process by using the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.split_between_processes">Accelerator.split_between_processes()</a> context manager (which also exists in <code>PartialState</code> and <code>AcceleratorState</code>).
This function will automatically split whatever data you pass to it (be it a prompt, a set of tensors, a dictionary of the prior data, etc.) across all the processes (with a potential
to be padded) for you to use right away.`,de,X,Ae="Let’s rewrite the above example using this context manager:",ue,_,me,x,Pe="And then to launch the code, we can use the 🤗 Accelerate:",he,W,Re="If you have generated a config file to be used using <code>accelerate config</code>:",fe,Q,Me,N,Fe="If you have a specific config file you want to use:",we,S,ye,I,He="Or if don’t want to make any config files and launch on two GPUs:",je,A,Ye="<p>Note: You will get some warnings about values being guessed based on your system. To remove these you can do <code>accelerate config default</code> or go through <code>accelerate config</code> to create a config file.</p>",be,P,Ue,R,ze="We’ve now reduced the boilerplate code needed to split this data to a few lines of code quite easily.",Ze,F,qe="But what if we have an odd distribution of prompts to GPUs? For example, what if we have 3 prompts, but only 2 GPUs?",Je,H,Ve=`Under the context manager, the first GPU would receive the first two prompts and the second GPU the third, ensuring that
all prompts are split and no overhead is needed.`,Te,Y,Ee=`<em>However</em>, what if we then wanted to do something with the results of <em>all the GPUs</em>? (Say gather them all and perform some kind of post processing)
You can pass in <code>apply_padding=True</code> to ensure that the lists of prompts are padded to the same length, with extra data being taken
from the last sample. This way all GPUs will have the same number of prompts, and you can then gather the results.`,ve,w,Be,z,Le="For instance:",$e,q,Ce,V,De=`On the first GPU, the prompts will be <code>[&quot;a dog&quot;, &quot;a cat&quot;]</code>, and on the second GPU it will be <code>[&quot;a chicken&quot;, &quot;a chicken&quot;]</code>.
Make sure to drop the final sample, as it will be a duplicate of the previous one.`,Ge,D,ke;return j=new ge({props:{title:"Distributed Inference with 🤗 Accelerate",local:"distributed-inference-with--accelerate",headingTag:"h1"}}),U=new ge({props:{title:"The Problem",local:"the-problem",headingTag:"h2"}}),T=new E({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)`,wrap:!1}}),B=new E({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMjAlMjAlMjAlMjBwaXBlLnRvKHJhbmspJTBBJTBBJTIwJTIwJTIwJTIwaWYlMjB0b3JjaC5kaXN0cmlidXRlZC5nZXRfcmFuaygpJTIwJTNEJTNEJTIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb21wdCUyMCUzRCUyMCUyMmElMjBkb2clMjIlMEElMjAlMjAlMjAlMjBlbGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwY2F0JTIyJTBBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXN1bHQuc2F2ZShmJTIycmVzdWx0XyU3QnJhbmslN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)
    pipe.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    result = pipe(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{rank}</span>.png&quot;</span>)`,wrap:!1}}),k=new ge({props:{title:"The Solution",local:"the-solution",headingTag:"h2"}}),_=new E({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMjAlMjAlMjMlMjBDYW4lMjBhbHNvJTIwYmUlMjBBY2NlbGVyYXRvciUyMG9yJTIwQWNjZWxlcmF0b3JTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGlzdHJpYnV0ZWRfc3RhdGUlMjAlM0QlMjBQYXJ0aWFsU3RhdGUoKSUwQXBpcGUudG8oZGlzdHJpYnV0ZWRfc3RhdGUuZGV2aWNlKSUwQSUwQSUyMyUyMEFzc3VtZSUyMHR3byUyMHByb2Nlc3NlcyUwQXdpdGglMjBkaXN0cmlidXRlZF9zdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiU1RCklMjBhcyUyMHByb21wdCUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdCUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmVzdWx0LnNhdmUoZiUyMnJlc3VsdF8lN0JkaXN0cmlidXRlZF9zdGF0ZS5wcm9jZXNzX2luZGV4JTdELnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState  <span class="hljs-comment"># Can also be Accelerator or AcceleratorState</span>
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
distributed_state = PartialState()
pipe.to(distributed_state.device)

<span class="hljs-comment"># Assume two processes</span>
<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipe(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),Q=new E({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMGRpc3RyaWJ1dGVkX2luZmVyZW5jZS5weQ==",highlighted:"accelerate launch distributed_inference.py",wrap:!1}}),S=new E({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjBteV9jb25maWcuanNvbiUyMGRpc3RyaWJ1dGVkX2luZmVyZW5jZS5weQ==",highlighted:"accelerate launch --config_file my_config.json distributed_inference.py",wrap:!1}}),P=new E({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUyMDIlMjBkaXN0cmlidXRlZF9pbmZlcmVuY2UucHk=",highlighted:"accelerate launch --num_processes 2 distributed_inference.py",wrap:!1}}),w=new ot({props:{$$slots:{default:[rt]},$$scope:{ctx:K}}}),q=new E({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMjAlMjAlMjMlMjBDYW4lMjBhbHNvJTIwYmUlMjBBY2NlbGVyYXRvciUyMG9yJTIwQWNjZWxlcmF0b3JTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBZGlzdHJpYnV0ZWRfc3RhdGUlMjAlM0QlMjBQYXJ0aWFsU3RhdGUoKSUwQXBpcGUudG8oZGlzdHJpYnV0ZWRfc3RhdGUuZGV2aWNlKSUwQSUwQSUyMyUyMEFzc3VtZSUyMHR3byUyMHByb2Nlc3NlcyUwQXdpdGglMjBkaXN0cmlidXRlZF9zdGF0ZS5zcGxpdF9iZXR3ZWVuX3Byb2Nlc3NlcyglNUIlMjJhJTIwZG9nJTIyJTJDJTIwJTIyYSUyMGNhdCUyMiUyQyUyMCUyMmElMjBjaGlja2VuJTIyJTVEJTJDJTIwYXBwbHlfcGFkZGluZyUzRFRydWUpJTIwYXMlMjBwcm9tcHQlM0ElMEElMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState  <span class="hljs-comment"># Can also be Accelerator or AcceleratorState</span>
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16)
distributed_state = PartialState()
pipe.to(distributed_state.device)

<span class="hljs-comment"># Assume two processes</span>
<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a chicken&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> prompt:
    result = pipe(prompt).images`,wrap:!1}}),{c(){r=i("meta"),y=a(),c=i("p"),L=a(),d(j.$$.fragment),O=a(),b=i("p"),b.textContent=Xe,ee=a(),d(U.$$.fragment),te=a(),Z=i("p"),Z.textContent=_e,le=a(),J=i("p"),J.innerHTML=xe,se=a(),d(T.$$.fragment),ae=a(),v=i("p"),v.textContent=We,ne=a(),d(B.$$.fragment),ie=a(),$=i("p"),$.textContent=Qe,pe=a(),C=i("p"),C.innerHTML=Ne,oe=a(),G=i("p"),G.textContent=Se,re=a(),d(k.$$.fragment),ce=a(),g=i("p"),g.innerHTML=Ie,de=a(),X=i("p"),X.textContent=Ae,ue=a(),d(_.$$.fragment),me=a(),x=i("p"),x.textContent=Pe,he=a(),W=i("p"),W.innerHTML=Re,fe=a(),d(Q.$$.fragment),Me=a(),N=i("p"),N.textContent=Fe,we=a(),d(S.$$.fragment),ye=a(),I=i("p"),I.textContent=He,je=a(),A=i("blockquote"),A.innerHTML=Ye,be=a(),d(P.$$.fragment),Ue=a(),R=i("p"),R.textContent=ze,Ze=a(),F=i("p"),F.textContent=qe,Je=a(),H=i("p"),H.textContent=Ve,Te=a(),Y=i("p"),Y.innerHTML=Ee,ve=a(),d(w.$$.fragment),Be=a(),z=i("p"),z.textContent=Le,$e=a(),d(q.$$.fragment),Ce=a(),V=i("p"),V.innerHTML=De,Ge=a(),D=i("p"),this.h()},l(e){const t=it("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(l),y=n(e),c=p(e,"P",{}),Oe(c).forEach(l),L=n(e),u(j.$$.fragment,e),O=n(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1dlrf99"&&(b.textContent=Xe),ee=n(e),u(U.$$.fragment,e),te=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1qi053h"&&(Z.textContent=_e),le=n(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-rhvic4"&&(J.innerHTML=xe),se=n(e),u(T.$$.fragment,e),ae=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1dzspg1"&&(v.textContent=We),ne=n(e),u(B.$$.fragment,e),ie=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1ov43u6"&&($.textContent=Qe),pe=n(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-9e0vlr"&&(C.innerHTML=Ne),oe=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-12rt8sz"&&(G.textContent=Se),re=n(e),u(k.$$.fragment,e),ce=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-40o8ya"&&(g.innerHTML=Ie),de=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-8uk323"&&(X.textContent=Ae),ue=n(e),u(_.$$.fragment,e),me=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-12mtl64"&&(x.textContent=Pe),he=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-glszdf"&&(W.innerHTML=Re),fe=n(e),u(Q.$$.fragment,e),Me=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1beq8se"&&(N.textContent=Fe),we=n(e),u(S.$$.fragment,e),ye=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-52p69u"&&(I.textContent=He),je=n(e),A=p(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(A)!=="svelte-ix7ij8"&&(A.innerHTML=Ye),be=n(e),u(P.$$.fragment,e),Ue=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-ui4crb"&&(R.textContent=ze),Ze=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-dyqt5a"&&(F.textContent=qe),Je=n(e),H=p(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1o56krx"&&(H.textContent=Ve),Te=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1y9mak3"&&(Y.innerHTML=Ee),ve=n(e),u(w.$$.fragment,e),Be=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-4vay6o"&&(z.textContent=Le),$e=n(e),u(q.$$.fragment,e),Ce=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-42h08l"&&(V.innerHTML=De),Ge=n(e),D=p(e,"P",{}),Oe(D).forEach(l),this.h()},h(){et(r,"name","hf:doc:metadata"),et(r,"content",dt)},m(e,t){pt(document.head,r),s(e,y,t),s(e,c,t),s(e,L,t),m(j,e,t),s(e,O,t),s(e,b,t),s(e,ee,t),m(U,e,t),s(e,te,t),s(e,Z,t),s(e,le,t),s(e,J,t),s(e,se,t),m(T,e,t),s(e,ae,t),s(e,v,t),s(e,ne,t),m(B,e,t),s(e,ie,t),s(e,$,t),s(e,pe,t),s(e,C,t),s(e,oe,t),s(e,G,t),s(e,re,t),m(k,e,t),s(e,ce,t),s(e,g,t),s(e,de,t),s(e,X,t),s(e,ue,t),m(_,e,t),s(e,me,t),s(e,x,t),s(e,he,t),s(e,W,t),s(e,fe,t),m(Q,e,t),s(e,Me,t),s(e,N,t),s(e,we,t),m(S,e,t),s(e,ye,t),s(e,I,t),s(e,je,t),s(e,A,t),s(e,be,t),m(P,e,t),s(e,Ue,t),s(e,R,t),s(e,Ze,t),s(e,F,t),s(e,Je,t),s(e,H,t),s(e,Te,t),s(e,Y,t),s(e,ve,t),m(w,e,t),s(e,Be,t),s(e,z,t),s(e,$e,t),m(q,e,t),s(e,Ce,t),s(e,V,t),s(e,Ge,t),s(e,D,t),ke=!0},p(e,[t]){const Ke={};t&2&&(Ke.$$scope={dirty:t,ctx:e}),w.$set(Ke)},i(e){ke||(h(j.$$.fragment,e),h(U.$$.fragment,e),h(T.$$.fragment,e),h(B.$$.fragment,e),h(k.$$.fragment,e),h(_.$$.fragment,e),h(Q.$$.fragment,e),h(S.$$.fragment,e),h(P.$$.fragment,e),h(w.$$.fragment,e),h(q.$$.fragment,e),ke=!0)},o(e){f(j.$$.fragment,e),f(U.$$.fragment,e),f(T.$$.fragment,e),f(B.$$.fragment,e),f(k.$$.fragment,e),f(_.$$.fragment,e),f(Q.$$.fragment,e),f(S.$$.fragment,e),f(P.$$.fragment,e),f(w.$$.fragment,e),f(q.$$.fragment,e),ke=!1},d(e){e&&(l(y),l(c),l(L),l(O),l(b),l(ee),l(te),l(Z),l(le),l(J),l(se),l(ae),l(v),l(ne),l(ie),l($),l(pe),l(C),l(oe),l(G),l(re),l(ce),l(g),l(de),l(X),l(ue),l(me),l(x),l(he),l(W),l(fe),l(Me),l(N),l(we),l(ye),l(I),l(je),l(A),l(be),l(Ue),l(R),l(Ze),l(F),l(Je),l(H),l(Te),l(Y),l(ve),l(Be),l(z),l($e),l(Ce),l(V),l(Ge),l(D)),l(r),M(j,e),M(U,e),M(T,e),M(B,e),M(k,e),M(_,e),M(Q,e),M(S,e),M(P,e),M(w,e),M(q,e)}}}const dt='{"title":"Distributed Inference with 🤗 Accelerate","local":"distributed-inference-with--accelerate","sections":[{"title":"The Problem","local":"the-problem","sections":[],"depth":2},{"title":"The Solution","local":"the-solution","sections":[],"depth":2}],"depth":1}';function ut(K){return lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends at{constructor(r){super(),nt(this,r,ut,ct,tt,{})}}export{yt as component};
