import{s as cs,o as hs,n as Se}from"../chunks/scheduler.00bde567.js";import{S as us,i as fs,g as o,s as n,r as d,A as ys,h as p,f as l,c as a,j as ms,u as c,x as r,k as ds,y as Ms,a as s,v as h,d as u,t as f,w as y}from"../chunks/index.752e2ff6.js";import{T as Ne}from"../chunks/Tip.6fda87e9.js";import{Y as ws}from"../chunks/Youtube.d03669de.js";import{C as $}from"../chunks/CodeBlock.e62cd1dc.js";import{H as U}from"../chunks/Heading.476d3364.js";function $s(g){let i,M="This API is quite new and still in its experimental stage. While we strive to provide a stable API, it’s possible some small parts of the public API will change in the future.";return{c(){i=o("p"),i.textContent=M},l(m){i=p(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1yc3yd7"&&(i.textContent=M)},m(m,w){s(m,i,w)},p:Se,d(m){m&&l(i)}}}function gs(g){let i,M="You can’t move a model initialized like this on CPU or another device directly, since it doesn’t have any data. It’s also very likely that a forward pass with that empty model will fail, as not all operations are supported on the meta device.";return{c(){i=o("p"),i.textContent=M},l(m){i=p(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-vdgsa6"&&(i.textContent=M)},m(m,w){s(m,i,w)},p:Se,d(m){m&&l(i)}}}function bs(g){let i,M="This only supports the inference of your model, not training. Most of the computation happens behind <code>torch.no_grad()</code> context managers to avoid spending some GPU memory with intermediate activations.";return{c(){i=o("p"),i.innerHTML=M},l(m){i=p(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1a0gshx"&&(i.innerHTML=M)},m(m,w){s(m,i,w)},p:Se,d(m){m&&l(i)}}}function vs(g){let i,M="You can derive all sizes of the model (and thus compute a <code>device_map</code>) on a model that is on the meta device.";return{c(){i=o("p"),i.innerHTML=M},l(m){i=p(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1r7jnyr"&&(i.innerHTML=M)},m(m,w){s(m,i,w)},p:Se,d(m){m&&l(i)}}}function Us(g){let i,M="The options <code>&quot;auto&quot;</code> and <code>&quot;balanced&quot;</code> produce the same results for now, but the behavior of <code>&quot;auto&quot;</code> might change in the future if we find a strategy that makes more sense, while <code>&quot;balanced&quot;</code> will stay stable.";return{c(){i=o("p"),i.innerHTML=M},l(m){i=p(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-vyehzb"&&(i.innerHTML=M)},m(m,w){s(m,i,w)},p:Se,d(m){m&&l(i)}}}function js(g){let i,M="When a first allocation happens in PyTorch, it loads CUDA kernels which take about 1-2GB of memory depending on the GPU. Therefore you always have less usable memory than the actual size of the GPU. To see how much memory is actually used do <code>torch.ones(1).cuda()</code> and look at the memory usage.",m,w,j="Therefore when you create memory maps with <code>max_memory</code> make sure to adjust the available memory accordingly to avoid out-of-memory errors.";return{c(){i=o("p"),i.innerHTML=M,m=n(),w=o("p"),w.innerHTML=j},l(b){i=p(b,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1l1ovnr"&&(i.innerHTML=M),m=a(b),w=p(b,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1sybea"&&(w.innerHTML=j)},m(b,v){s(b,i,v),s(b,m,v),s(b,w,v)},p:Se,d(b){b&&(l(i),l(m),l(w))}}}function _s(g){let i,M="To be the most efficient, make sure your device map puts the parameters on the GPUs in a sequential manner (e.g. don’t put one of the first weights on GPU 0, then weights on GPU 1 and the last weight back to GPU 0) to avoid making many transfers of data between the GPUs.";return{c(){i=o("p"),i.textContent=M},l(m){i=p(m,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1j5mha8"&&(i.textContent=M)},m(m,w){s(m,i,w)},p:Se,d(m){m&&l(i)}}}function ks(g){let i,M,m,w,j,b,v,wl="When loading a pre-trained model in PyTorch, the usual workflow looks like this:",Ve,q,Fe,P,$l="In plain English, those steps are:",De,Z,gl="<li>Create the model with randomly initialized weights</li> <li>Load the model weights (in a dictionary usually called a state dict) from the disk</li> <li>Load those weights inside the model</li>",Ke,W,bl="While this works very well for regularly sized models, this workflow has some clear limitations when we deal with a huge model: in step 1, we load a full version of the model in RAM, and spend some time randomly initializing the weights (which will be discarded in step 3). In step 2, we load another full version of the model in RAM, with the pre-trained weights. If you’re loading a model with 6 billion parameters, this means you will need 24GB of RAM for each copy of the model, so 48GB in total (half of it to load the model in FP16).",Oe,_,et,I,tt,B,lt,A,st,Q,nt,R,vl='The first tool 🤗 Accelerate introduces to help with big models is a context manager <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a> that helps you initialize a model without using any RAM so that step 1 can be done on models of any size. Here is how it works:',at,z,it,X,Ul="For instance:",ot,E,pt,L,jl="initializes an empty model with a bit more than 100B parameters. Behind the scenes, this relies on the meta device introduced in PyTorch 1.9. During the initialization under the context manager, each time a parameter is created, it is instantly moved to that device.",rt,k,mt,H,dt,N,_l="It’s possible your model is so big that even a single copy won’t fit in RAM. That doesn’t mean it can’t be loaded: if you have one or several GPUs, this is more memory available to store your model. In this case, it’s better if your checkpoint is split into several smaller files that we call checkpoint shards.",ct,S,kl='🤗 Accelerate will handle sharded checkpoints as long as you follow the following format: your checkpoint should be in a folder, with several files containing the partial state dicts, and there should be an index in the JSON format that contains a dictionary mapping parameter names to the file containing their weights. You can easily shard your model with <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a>. For instance, we could have a folder containing:',ht,Y,ut,V,Tl="with index.json being the following file:",ft,F,yt,D,Cl="and <code>first_state_dict.bin</code> containing the weights for <code>&quot;linear1.weight&quot;</code> and <code>&quot;linear1.bias&quot;</code>, <code>second_state_dict.bin</code> the ones for <code>&quot;linear2.weight&quot;</code> and <code>&quot;linear2.bias&quot;</code>",Mt,K,wt,O,Jl='The second tool 🤗 Accelerate introduces is a function <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>, that will allow you to load a checkpoint inside your empty model. This supports full checkpoints (a single file containing the whole state dict) as well as sharded checkpoints. It will also automatically dispatch those weights across the devices you have available (GPUs, CPU RAM), so if you are loading a sharded checkpoint, the maximum RAM usage will be the size of the biggest shard.',$t,ee,xl='If you want to use big model inference with 🤗 Transformers models, check out this <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#large-model-loading" rel="nofollow">documentation</a>.',gt,te,Gl='Here is how we can use this to load the <a href="https://huggingface.co/marcsun13/gpt2-xl-linear-sharded" rel="nofollow">GPT2-1.5B</a> model.',bt,le,ql="Let’s download the sharded version of this model.",vt,se,Ut,ne,jt,ae,Pl="In order to initialize the model, we will use the library minGPT.",_t,ie,kt,oe,Tt,pe,Zl="Then, load the checkpoint we just downloaded with:",Ct,re,Jt,me,Wl="By passing <code>device_map=&quot;auto&quot;</code>, we tell 🤗 Accelerate to determine automatically where to put each layer of the model depending on the available resources:",xt,de,Il="<li>first, we use the maximum space available on the GPU(s)</li> <li>if we still need space, we store the remaining weights on the CPU</li> <li>if there is not enough RAM, we store the remaining weights on the hard drive as memory-mapped tensors</li>",Gt,ce,qt,he,Bl=`This parameter will indicate that some of the modules with the name <code>&quot;Block&quot;</code> should not be split across different devices. You should set here all blocks that
include a residual connection of some kind.`,Pt,ue,Zt,fe,Al="You can see the <code>device_map</code> that 🤗 Accelerate picked by accessing the <code>hf_device_map</code> attribute of your model:",Wt,ye,It,Me,Bt,we,Ql="It’s fully possible to create your own device map for the layers to use as well, specifying the GPU device to use (a number), <code>&quot;cpu&quot;</code>, or <code>&quot;disk&quot;</code> and pass this in:",At,$e,Qt,ge,Rt,be,Rl="Now that we have done this, our model lies across several devices, and maybe the hard drive. But it can still be used as a regular PyTorch model:",zt,ve,Xt,Ue,zl="Behind the scenes, 🤗 Accelerate added hooks to the model, so that:",Et,je,Xl="<li>at each layer, the inputs are put on the right device (so even if your model is spread across several GPUs, it works)</li> <li>for the weights offloaded on the CPU, they are put on a GPU just before the forward pass and cleaned up just after</li> <li>for the weights offloaded on the hard drive, they are loaded in RAM then put on a GPU just before the forward pass and cleaned up just after</li>",Lt,_e,El="This way, your model can run for inference even if it doesn’t fit on one of the GPUs or the CPU RAM!",Ht,T,Nt,ke,St,Te,Ll="You can let 🤗 Accelerate handle the device map computation by setting <code>device_map</code> to one of the supported options (<code>&quot;auto&quot;</code>, <code>&quot;balanced&quot;</code>, <code>&quot;balanced_low_0&quot;</code>, <code>&quot;sequential&quot;</code>) or create one yourself if you want more control over where each layer should go.",Yt,C,Vt,Ce,Hl="All the options will produce the same result when you don’t have enough GPU memory to accommodate the whole model (which is to fit everything that can on the GPU, then offload weights on the CPU or even on the disk if there is not enough RAM).",Ft,Je,Nl="When you have more GPU memory available than the model size, here is the difference between each option:",Dt,xe,Sl="<li><code>&quot;auto&quot;</code> and <code>&quot;balanced&quot;</code> evenly split the model on all available GPUs, making it possible for you to use a batch size greater than 1.</li> <li><code>&quot;balanced_low_0&quot;</code> evenly splits the model on all GPUs except the first one, and only puts on GPU 0 what does not fit on the others. This option is great when you need to use GPU 0 for some processing of the outputs, like when using the <code>generate</code> function for Transformers models</li> <li><code>&quot;sequential&quot;</code> will fit what it can on GPU 0, then move on GPU 1 and so forth (so won’t use the last GPUs if it doesn’t need to).</li>",Kt,J,Ot,Ge,Yl='First note that you can limit the memory used on each GPU by using the <code>max_memory</code> argument (available in <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.infer_auto_device_map">infer_auto_device_map()</a> and in all functions using it). When setting <code>max_memory</code>, you should pass along a dictionary containing the GPU identifiers (for instance <code>0</code>, <code>1</code> etc.) and the <code>&quot;cpu&quot;</code> key for the maximum RAM you want to use for CPU offload. The values can either be an integer (in bytes) or a string representing a number with its unit, such as <code>&quot;10GiB&quot;</code> or <code>&quot;10GB&quot;</code>.',el,qe,Vl="Here is an example where we don’t want to use more than 10GiB on each of the two GPUs and no more than 30GiB of CPU RAM for the model weights:",tl,Pe,ll,x,sl,Ze,Fl="Additionally, if you do some additional operations with your outputs without placing them back on the CPU (for instance inside the <code>generate</code> method of Transformers) and if you placed your inputs on a GPU, that GPU will consume more memory than the others (Accelerate always place the output back to the device of the input). Therefore if you would like to optimize the maximum batch size and you have many GPUs, give the first GPU less memory. For example, with BLOOM-176B on 8x80 A100 setup, the close-to-ideal map is:",nl,We,al,Ie,Dl="as you can see we gave the remaining 7 GPUs ~50% more memory than GPU 0.",il,Be,Kl="If you opt to fully design the <code>device_map</code> yourself, it should be a dictionary with keys being module names of your model and values being a valid device identifier (for instance an integer for the GPUs) or <code>&quot;cpu&quot;</code> for CPU offload, <code>&quot;disk&quot;</code> for disk offload. The keys need to cover the whole model, you can then define your device map as you wish: for instance, if your model has two blocks (let’s say <code>block1</code> and <code>block2</code>) which each contain three linear layers (let’s say <code>linear1</code>, <code>linear2</code> and <code>linear3</code>), a valid device map can be:",ol,Ae,pl,Qe,Ol="another one that is valid could be:",rl,Re,ml,ze,es="On the other hand, this one is not valid as it does not cover every parameter of the model:",dl,Xe,cl,G,hl,Ee,ul,Le,ts="We are aware of the current limitations in the API:",fl,He,ls='<li>While this could theoretically work on just one CPU with potential disk offload, you need at least one GPU to run this API. This will be fixed in further development.</li> <li><a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.infer_auto_device_map">infer_auto_device_map()</a> (or <code>device_map=&quot;auto&quot;</code> in <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>) tries to maximize GPU and CPU RAM it sees available when you execute it. While PyTorch is very good at managing GPU RAM efficiently (and giving it back when not needed), it’s not entirely true with Python and CPU RAM. Therefore, an automatically computed device map might be too intense on the CPU. Move a few modules to the disk device if you get crashes due to a lack of RAM.</li> <li><a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.infer_auto_device_map">infer_auto_device_map()</a> (or <code>device_map=&quot;auto&quot;</code> in <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a>) attributes devices sequentially (to avoid moving things back and forth) so if your first layer is bigger than the size of the GPU you have, it will end up with everything on the CPU/Disk.</li> <li><a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_and_dispatch">load_checkpoint_and_dispatch()</a> and <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.load_checkpoint_in_model">load_checkpoint_in_model()</a> do not perform any check on the correctness of your state dict compared to your model at the moment (this will be fixed in a future version), so you may get some weird errors if trying to load a checkpoint with mismatched or missing keys.</li> <li>The model parallelism used when your model is split on several GPUs is naive and not optimized, meaning that only one GPU works at a given time and the other sits idle.</li> <li>When weights are offloaded on the CPU/hard drive, there is no pre-fetching (yet, we will work on this for future versions) which means the weights are put on the GPU when they are needed and not before.</li> <li>Hard-drive offloading might be very slow if the hardware you run on does not have fast communication between disk and CPU (like NVMes).</li>',yl,Ye,Ml;return j=new U({props:{title:"Handling big models for inference",local:"handling-big-models-for-inference",headingTag:"h1"}}),q=new $({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFteV9tb2RlbCUyMCUzRCUyME1vZGVsQ2xhc3MoLi4uKSUwQXN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKGNoZWNrcG9pbnRfZmlsZSklMEFteV9tb2RlbC5sb2FkX3N0YXRlX2RpY3Qoc3RhdGVfZGljdCk=",highlighted:`<span class="hljs-keyword">import</span> torch

my_model = ModelClass(...)
state_dict = torch.load(checkpoint_file)
my_model.load_state_dict(state_dict)`,wrap:!1}}),_=new Ne({props:{warning:!0,$$slots:{default:[$s]},$$scope:{ctx:g}}}),I=new U({props:{title:"How the Process Works: A Quick Overview",local:"how-the-process-works-a-quick-overview",headingTag:"h2"}}),B=new ws({props:{id:"MWCSGj9jEAo"}}),A=new U({props:{title:"How the Process Works: Working with Code",local:"how-the-process-works-working-with-code",headingTag:"h2"}}),Q=new U({props:{title:"Instantiating an empty model",local:"instantiating-an-empty-model",headingTag:"h3"}}),z=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEElMEF3aXRoJTIwaW5pdF9lbXB0eV93ZWlnaHRzKCklM0ElMEElMjAlMjAlMjAlMjBteV9tb2RlbCUyMCUzRCUyME1vZGVsQ2xhc3MoLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights

<span class="hljs-keyword">with</span> init_empty_weights():
    my_model = ModelClass(...)`,wrap:!1}}),E=new $({props:{code:"d2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBubi5TZXF1ZW50aWFsKColNUJubi5MaW5lYXIoMTAwMDAlMkMlMjAxMDAwMCklMjBmb3IlMjBfJTIwaW4lMjByYW5nZSgxMDAwKSU1RCk=",highlighted:`<span class="hljs-keyword">with</span> init_empty_weights():
    model = nn.Sequential(*[nn.Linear(<span class="hljs-number">10000</span>, <span class="hljs-number">10000</span>) <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)])`,wrap:!1}}),k=new Ne({props:{warning:!0,$$slots:{default:[gs]},$$scope:{ctx:g}}}),H=new U({props:{title:"Sharded checkpoints",local:"sharded-checkpoints",headingTag:"h3"}}),Y=new $({props:{code:"Zmlyc3Rfc3RhdGVfZGljdC5iaW4lMEFpbmRleC5qc29uJTBBc2Vjb25kX3N0YXRlX2RpY3QuYmlu",highlighted:`first_state_dict.bin
index.json
second_state_dict.bin`,wrap:!1}}),F=new $({props:{code:"JTdCJTBBJTIwJTIwJTIybGluZWFyMS53ZWlnaHQlMjIlM0ElMjAlMjJmaXJzdF9zdGF0ZV9kaWN0LmJpbiUyMiUyQyUwQSUyMCUyMCUyMmxpbmVhcjEuYmlhcyUyMiUzQSUyMCUyMmZpcnN0X3N0YXRlX2RpY3QuYmluJTIyJTJDJTBBJTIwJTIwJTIybGluZWFyMi53ZWlnaHQlMjIlM0ElMjAlMjJzZWNvbmRfc3RhdGVfZGljdC5iaW4lMjIlMkMlMEElMjAlMjAlMjJsaW5lYXIyLmJpYXMlMjIlM0ElMjAlMjJzZWNvbmRfc3RhdGVfZGljdC5iaW4lMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;linear1.weight&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;first_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear1.bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;first_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear2.weight&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;second_state_dict.bin&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;linear2.bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;second_state_dict.bin&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),K=new U({props:{title:"Loading weights",local:"loading-weights",headingTag:"h3"}}),se=new $({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:"pip install huggingface_hub",wrap:!1}}),ne=new $({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1hcmNzdW4xMyUyRmdwdDIteGwtbGluZWFyLXNoYXJkZWQlMjIlMEF3ZWlnaHRzX2xvY2F0aW9uJTIwJTNEJTIwc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRGNoZWNrcG9pbnQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
checkpoint = <span class="hljs-string">&quot;marcsun13/gpt2-xl-linear-sharded&quot;</span>
weights_location = snapshot_download(repo_id=checkpoint)`,wrap:!1}}),ie=new $({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZrYXJwYXRoeSUyRm1pbkdQVC5naXQlMEFwaXAlMjBpbnN0YWxsJTIwbWluR1BUJTJG",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/karpathy/minGPT.git
pip install minGPT/`,wrap:!1}}),oe=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwbWluZ3B0Lm1vZGVsJTIwaW1wb3J0JTIwR1BUJTBBJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwR1BULmdldF9kZWZhdWx0X2NvbmZpZygpJTBBbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlMjAlM0QlMjAnZ3B0Mi14bCclMEFtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUyMCUzRCUyMDUwMjU3JTBBbW9kZWxfY29uZmlnLmJsb2NrX3NpemUlMjAlM0QlMjAxMDI0JTBBJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwbW9kZWwlMjAlM0QlMjBHUFQobW9kZWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    model = GPT(model_config)`,wrap:!1}}),re=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoJTBBJTBBbW9kZWwlMjAlM0QlMjBsb2FkX2NoZWNrcG9pbnRfYW5kX2Rpc3BhdGNoKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwY2hlY2twb2ludCUzRHdlaWdodHNfbG9jYXRpb24lMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG5vX3NwbGl0X21vZHVsZV9jbGFzc2VzJTNEJTVCJ0Jsb2NrJyU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> load_checkpoint_and_dispatch

model = load_checkpoint_and_dispatch(
    model, checkpoint=weights_location, device_map=<span class="hljs-string">&quot;auto&quot;</span>, no_split_module_classes=[<span class="hljs-string">&#x27;Block&#x27;</span>]
)`,wrap:!1}}),ce=new U({props:{title:"no_split_module_classes",local:"nosplitmoduleclasses",headingTag:"h4"}}),ue=new U({props:{title:"The device_map",local:"the-devicemap",headingTag:"h4"}}),ye=new $({props:{code:"bW9kZWwuaGZfZGV2aWNlX21hcA==",highlighted:"model.hf_device_map",wrap:!1}}),Me=new $({props:{code:"JTdCJ3RyYW5zZm9ybWVyLnd0ZSclM0ElMjAwJTJDJTBBJTIwJ3RyYW5zZm9ybWVyLndwZSclM0ElMjAwJTJDJTBBJTIwJ3RyYW5zZm9ybWVyLmRyb3AnJTNBJTIwMCUyQyUwQSUyMCd0cmFuc2Zvcm1lci5oLjAnJTNBJTIwMCUyQyUwQSUyMC4uLiUwQSUyMCd0cmFuc2Zvcm1lci5oLjIxJyUzQSUyMDAlMkMlMjAlMEElMjAndHJhbnNmb3JtZXIuaC4yMiclM0ElMjAxJTJDJTIwJTBBJTIwJ3RyYW5zZm9ybWVyLmguMjMnJTNBJTIwMSUyQyUyMCUwQSUyMCd0cmFuc2Zvcm1lci5oLjI0JyUzQSUyMDElMkMlMEElMjAuLi4lMEElMjAndHJhbnNmb3JtZXIuaC40NyclM0ElMjAxJTJDJTIwJTBBJTIwJ3RyYW5zZm9ybWVyLmxuX2YnJTNBJTIwMSUyQyUyMCUwQSUyMCdsbV9oZWFkJyUzQSUyMDElN0Q=",highlighted:`{<span class="hljs-string">&#x27;transformer.wte&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.wpe&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.drop&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;transformer.h.0&#x27;</span>: <span class="hljs-number">0</span>,
 ...
 <span class="hljs-string">&#x27;transformer.h.21&#x27;</span>: <span class="hljs-number">0</span>, 
 <span class="hljs-string">&#x27;transformer.h.22&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.h.23&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.h.24&#x27;</span>: <span class="hljs-number">1</span>,
 ...
 <span class="hljs-string">&#x27;transformer.h.47&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;transformer.ln_f&#x27;</span>: <span class="hljs-number">1</span>, 
 <span class="hljs-string">&#x27;lm_head&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),$e=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLnd0ZSUyMiUzQSUyMCUyMmNwdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndwZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5kcm9wJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIuaC4wJTIyJTNBJTIwJTIyZGlzayUyMiUwQSU3RCUwQSUwQW1vZGVsJTIwJTNEJTIwbG9hZF9jaGVja3BvaW50X2FuZF9kaXNwYXRjaCglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMGNoZWNrcG9pbnQlM0R3ZWlnaHRzX2xvY2F0aW9uJTJDJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMEEpJTBB",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.wte&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.wpe&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.drop&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h.0&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>
}

model = load_checkpoint_and_dispatch(
    model, checkpoint=weights_location, device_map=device_map
)
`,wrap:!1}}),ge=new U({props:{title:"Run the model",local:"run-the-model",headingTag:"h3"}}),ve=new $({props:{code:"ZnJvbSUyMG1pbmdwdC5icGUlMjBpbXBvcnQlMjBCUEVUb2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBCUEVUb2tlbml6ZXIoKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwbmFtZSUyMGlzJTIyKS50bygwKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSh4MSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSklNUIwJTVEJTBBdG9rZW5pemVyLmRlY29kZShvdXRwdXRzLmNwdSgpLnNxdWVlemUoKSk=",highlighted:`<span class="hljs-keyword">from</span> mingpt.bpe <span class="hljs-keyword">import</span> BPETokenizer
tokenizer = BPETokenizer()
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>).to(<span class="hljs-number">0</span>)

outputs = model.generate(x1, max_new_tokens=<span class="hljs-number">10</span>, do_sample=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
tokenizer.decode(outputs.cpu().squeeze())`,wrap:!1}}),T=new Ne({props:{warning:!0,$$slots:{default:[bs]},$$scope:{ctx:g}}}),ke=new U({props:{title:"Designing a device map",local:"designing-a-device-map",headingTag:"h3"}}),C=new Ne({props:{$$slots:{default:[vs]},$$scope:{ctx:g}}}),J=new Ne({props:{$$slots:{default:[Us]},$$scope:{ctx:g}}}),Pe=new $({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbmZlcl9hdXRvX2RldmljZV9tYXAlMEElMEFkZXZpY2VfbWFwJTIwJTNEJTIwaW5mZXJfYXV0b19kZXZpY2VfbWFwKG15X21vZGVsJTJDJTIwbWF4X21lbW9yeSUzRCU3QjAlM0ElMjAlMjIxMEdpQiUyMiUyQyUyMDElM0ElMjAlMjIxMEdpQiUyMiUyQyUyMCUyMmNwdSUyMiUzQSUyMCUyMjMwR2lCJTIyJTdEKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> infer_auto_device_map

device_map = infer_auto_device_map(my_model, max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;10GiB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;10GiB&quot;</span>, <span class="hljs-string">&quot;cpu&quot;</span>: <span class="hljs-string">&quot;30GiB&quot;</span>})`,wrap:!1}}),x=new Ne({props:{warning:!0,$$slots:{default:[js]},$$scope:{ctx:g}}}),We=new $({props:{code:"bWF4X21lbW9yeSUyMCUzRCUyMCU3QjAlM0ElMjAlMjIzMEdJQiUyMiUyQyUyMDElM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDIlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDMlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDQlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDUlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDYlM0ElMjAlMjI0NkdJQiUyMiUyQyUyMDclM0ElMjAlMjI0NkdJQiUyMiU3RA==",highlighted:'max_memory = {<span class="hljs-number">0</span>: <span class="hljs-string">&quot;30GIB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">2</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">3</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">4</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">5</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">6</span>: <span class="hljs-string">&quot;46GIB&quot;</span>, <span class="hljs-number">7</span>: <span class="hljs-string">&quot;46GIB&quot;</span>}',wrap:!1}}),Ae=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIlMjIlM0ElMjAxJTdE",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),Re=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMiUyMiUzQSUyMDElMkMlMjAlMjJibG9jazIubGluZWFyMyUyMiUzQSUyMDElN0Q=",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear2&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;block2.linear3&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),Xe=new $({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUyMmJsb2NrMSUyMiUzQSUyMDAlMkMlMjAlMjJibG9jazIubGluZWFyMSUyMiUzQSUyMDElMkMlMjAlMjJibG9jazIubGluZWFyMiUyMiUzQSUyMDElN0Q=",highlighted:'device_map = {<span class="hljs-string">&quot;block1&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;block2.linear1&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;block2.linear2&quot;</span>: <span class="hljs-number">1</span>}',wrap:!1}}),G=new Ne({props:{$$slots:{default:[_s]},$$scope:{ctx:g}}}),Ee=new U({props:{title:"Limits and further development",local:"limits-and-further-development",headingTag:"h2"}}),{c(){i=o("meta"),M=n(),m=o("p"),w=n(),d(j.$$.fragment),b=n(),v=o("p"),v.textContent=wl,Ve=n(),d(q.$$.fragment),Fe=n(),P=o("p"),P.textContent=$l,De=n(),Z=o("ol"),Z.innerHTML=gl,Ke=n(),W=o("p"),W.textContent=bl,Oe=n(),d(_.$$.fragment),et=n(),d(I.$$.fragment),tt=n(),d(B.$$.fragment),lt=n(),d(A.$$.fragment),st=n(),d(Q.$$.fragment),nt=n(),R=o("p"),R.innerHTML=vl,at=n(),d(z.$$.fragment),it=n(),X=o("p"),X.textContent=Ul,ot=n(),d(E.$$.fragment),pt=n(),L=o("p"),L.textContent=jl,rt=n(),d(k.$$.fragment),mt=n(),d(H.$$.fragment),dt=n(),N=o("p"),N.textContent=_l,ct=n(),S=o("p"),S.innerHTML=kl,ht=n(),d(Y.$$.fragment),ut=n(),V=o("p"),V.textContent=Tl,ft=n(),d(F.$$.fragment),yt=n(),D=o("p"),D.innerHTML=Cl,Mt=n(),d(K.$$.fragment),wt=n(),O=o("p"),O.innerHTML=Jl,$t=n(),ee=o("p"),ee.innerHTML=xl,gt=n(),te=o("p"),te.innerHTML=Gl,bt=n(),le=o("p"),le.textContent=ql,vt=n(),d(se.$$.fragment),Ut=n(),d(ne.$$.fragment),jt=n(),ae=o("p"),ae.textContent=Pl,_t=n(),d(ie.$$.fragment),kt=n(),d(oe.$$.fragment),Tt=n(),pe=o("p"),pe.textContent=Zl,Ct=n(),d(re.$$.fragment),Jt=n(),me=o("p"),me.innerHTML=Wl,xt=n(),de=o("ul"),de.innerHTML=Il,Gt=n(),d(ce.$$.fragment),qt=n(),he=o("p"),he.innerHTML=Bl,Pt=n(),d(ue.$$.fragment),Zt=n(),fe=o("p"),fe.innerHTML=Al,Wt=n(),d(ye.$$.fragment),It=n(),d(Me.$$.fragment),Bt=n(),we=o("p"),we.innerHTML=Ql,At=n(),d($e.$$.fragment),Qt=n(),d(ge.$$.fragment),Rt=n(),be=o("p"),be.textContent=Rl,zt=n(),d(ve.$$.fragment),Xt=n(),Ue=o("p"),Ue.textContent=zl,Et=n(),je=o("ul"),je.innerHTML=Xl,Lt=n(),_e=o("p"),_e.textContent=El,Ht=n(),d(T.$$.fragment),Nt=n(),d(ke.$$.fragment),St=n(),Te=o("p"),Te.innerHTML=Ll,Yt=n(),d(C.$$.fragment),Vt=n(),Ce=o("p"),Ce.textContent=Hl,Ft=n(),Je=o("p"),Je.textContent=Nl,Dt=n(),xe=o("ul"),xe.innerHTML=Sl,Kt=n(),d(J.$$.fragment),Ot=n(),Ge=o("p"),Ge.innerHTML=Yl,el=n(),qe=o("p"),qe.textContent=Vl,tl=n(),d(Pe.$$.fragment),ll=n(),d(x.$$.fragment),sl=n(),Ze=o("p"),Ze.innerHTML=Fl,nl=n(),d(We.$$.fragment),al=n(),Ie=o("p"),Ie.textContent=Dl,il=n(),Be=o("p"),Be.innerHTML=Kl,ol=n(),d(Ae.$$.fragment),pl=n(),Qe=o("p"),Qe.textContent=Ol,rl=n(),d(Re.$$.fragment),ml=n(),ze=o("p"),ze.textContent=es,dl=n(),d(Xe.$$.fragment),cl=n(),d(G.$$.fragment),hl=n(),d(Ee.$$.fragment),ul=n(),Le=o("p"),Le.textContent=ts,fl=n(),He=o("ul"),He.innerHTML=ls,yl=n(),Ye=o("p"),this.h()},l(e){const t=ys("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(l),M=a(e),m=p(e,"P",{}),ms(m).forEach(l),w=a(e),c(j.$$.fragment,e),b=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1yyj096"&&(v.textContent=wl),Ve=a(e),c(q.$$.fragment,e),Fe=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-jnckpv"&&(P.textContent=$l),De=a(e),Z=p(e,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-11v868"&&(Z.innerHTML=gl),Ke=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1mmkmja"&&(W.textContent=bl),Oe=a(e),c(_.$$.fragment,e),et=a(e),c(I.$$.fragment,e),tt=a(e),c(B.$$.fragment,e),lt=a(e),c(A.$$.fragment,e),st=a(e),c(Q.$$.fragment,e),nt=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1b44k0t"&&(R.innerHTML=vl),at=a(e),c(z.$$.fragment,e),it=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-4vay6o"&&(X.textContent=Ul),ot=a(e),c(E.$$.fragment,e),pt=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1mwzmvc"&&(L.textContent=jl),rt=a(e),c(k.$$.fragment,e),mt=a(e),c(H.$$.fragment,e),dt=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-13afm5q"&&(N.textContent=_l),ct=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-12zzutz"&&(S.innerHTML=kl),ht=a(e),c(Y.$$.fragment,e),ut=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1resniz"&&(V.textContent=Tl),ft=a(e),c(F.$$.fragment,e),yt=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1wl1rhb"&&(D.innerHTML=Cl),Mt=a(e),c(K.$$.fragment,e),wt=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-dulik3"&&(O.innerHTML=Jl),$t=a(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-gg1omy"&&(ee.innerHTML=xl),gt=a(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-de38z1"&&(te.innerHTML=Gl),bt=a(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-q7q9oj"&&(le.textContent=ql),vt=a(e),c(se.$$.fragment,e),Ut=a(e),c(ne.$$.fragment,e),jt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-9hv0ru"&&(ae.textContent=Pl),_t=a(e),c(ie.$$.fragment,e),kt=a(e),c(oe.$$.fragment,e),Tt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-l7qwnt"&&(pe.textContent=Zl),Ct=a(e),c(re.$$.fragment,e),Jt=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-o7kc16"&&(me.innerHTML=Wl),xt=a(e),de=p(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-11opk3r"&&(de.innerHTML=Il),Gt=a(e),c(ce.$$.fragment,e),qt=a(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1xo69nf"&&(he.innerHTML=Bl),Pt=a(e),c(ue.$$.fragment,e),Zt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-uy2xoa"&&(fe.innerHTML=Al),Wt=a(e),c(ye.$$.fragment,e),It=a(e),c(Me.$$.fragment,e),Bt=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-11gz870"&&(we.innerHTML=Ql),At=a(e),c($e.$$.fragment,e),Qt=a(e),c(ge.$$.fragment,e),Rt=a(e),be=p(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1d1z3sn"&&(be.textContent=Rl),zt=a(e),c(ve.$$.fragment,e),Xt=a(e),Ue=p(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-lh30ey"&&(Ue.textContent=zl),Et=a(e),je=p(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-1macllt"&&(je.innerHTML=Xl),Lt=a(e),_e=p(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-2f3qjg"&&(_e.textContent=El),Ht=a(e),c(T.$$.fragment,e),Nt=a(e),c(ke.$$.fragment,e),St=a(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-q28p5z"&&(Te.innerHTML=Ll),Yt=a(e),c(C.$$.fragment,e),Vt=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-185xrjm"&&(Ce.textContent=Hl),Ft=a(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-isobvw"&&(Je.textContent=Nl),Dt=a(e),xe=p(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-gk7g7m"&&(xe.innerHTML=Sl),Kt=a(e),c(J.$$.fragment,e),Ot=a(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-10fpoqb"&&(Ge.innerHTML=Yl),el=a(e),qe=p(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1btz7o0"&&(qe.textContent=Vl),tl=a(e),c(Pe.$$.fragment,e),ll=a(e),c(x.$$.fragment,e),sl=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1wm631f"&&(Ze.innerHTML=Fl),nl=a(e),c(We.$$.fragment,e),al=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1epndkt"&&(Ie.textContent=Dl),il=a(e),Be=p(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-6j84en"&&(Be.innerHTML=Kl),ol=a(e),c(Ae.$$.fragment,e),pl=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1niaejq"&&(Qe.textContent=Ol),rl=a(e),c(Re.$$.fragment,e),ml=a(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-u50du7"&&(ze.textContent=es),dl=a(e),c(Xe.$$.fragment,e),cl=a(e),c(G.$$.fragment,e),hl=a(e),c(Ee.$$.fragment,e),ul=a(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1rkjfcc"&&(Le.textContent=ts),fl=a(e),He=p(e,"UL",{"data-svelte-h":!0}),r(He)!=="svelte-prx226"&&(He.innerHTML=ls),yl=a(e),Ye=p(e,"P",{}),ms(Ye).forEach(l),this.h()},h(){ds(i,"name","hf:doc:metadata"),ds(i,"content",Ts)},m(e,t){Ms(document.head,i),s(e,M,t),s(e,m,t),s(e,w,t),h(j,e,t),s(e,b,t),s(e,v,t),s(e,Ve,t),h(q,e,t),s(e,Fe,t),s(e,P,t),s(e,De,t),s(e,Z,t),s(e,Ke,t),s(e,W,t),s(e,Oe,t),h(_,e,t),s(e,et,t),h(I,e,t),s(e,tt,t),h(B,e,t),s(e,lt,t),h(A,e,t),s(e,st,t),h(Q,e,t),s(e,nt,t),s(e,R,t),s(e,at,t),h(z,e,t),s(e,it,t),s(e,X,t),s(e,ot,t),h(E,e,t),s(e,pt,t),s(e,L,t),s(e,rt,t),h(k,e,t),s(e,mt,t),h(H,e,t),s(e,dt,t),s(e,N,t),s(e,ct,t),s(e,S,t),s(e,ht,t),h(Y,e,t),s(e,ut,t),s(e,V,t),s(e,ft,t),h(F,e,t),s(e,yt,t),s(e,D,t),s(e,Mt,t),h(K,e,t),s(e,wt,t),s(e,O,t),s(e,$t,t),s(e,ee,t),s(e,gt,t),s(e,te,t),s(e,bt,t),s(e,le,t),s(e,vt,t),h(se,e,t),s(e,Ut,t),h(ne,e,t),s(e,jt,t),s(e,ae,t),s(e,_t,t),h(ie,e,t),s(e,kt,t),h(oe,e,t),s(e,Tt,t),s(e,pe,t),s(e,Ct,t),h(re,e,t),s(e,Jt,t),s(e,me,t),s(e,xt,t),s(e,de,t),s(e,Gt,t),h(ce,e,t),s(e,qt,t),s(e,he,t),s(e,Pt,t),h(ue,e,t),s(e,Zt,t),s(e,fe,t),s(e,Wt,t),h(ye,e,t),s(e,It,t),h(Me,e,t),s(e,Bt,t),s(e,we,t),s(e,At,t),h($e,e,t),s(e,Qt,t),h(ge,e,t),s(e,Rt,t),s(e,be,t),s(e,zt,t),h(ve,e,t),s(e,Xt,t),s(e,Ue,t),s(e,Et,t),s(e,je,t),s(e,Lt,t),s(e,_e,t),s(e,Ht,t),h(T,e,t),s(e,Nt,t),h(ke,e,t),s(e,St,t),s(e,Te,t),s(e,Yt,t),h(C,e,t),s(e,Vt,t),s(e,Ce,t),s(e,Ft,t),s(e,Je,t),s(e,Dt,t),s(e,xe,t),s(e,Kt,t),h(J,e,t),s(e,Ot,t),s(e,Ge,t),s(e,el,t),s(e,qe,t),s(e,tl,t),h(Pe,e,t),s(e,ll,t),h(x,e,t),s(e,sl,t),s(e,Ze,t),s(e,nl,t),h(We,e,t),s(e,al,t),s(e,Ie,t),s(e,il,t),s(e,Be,t),s(e,ol,t),h(Ae,e,t),s(e,pl,t),s(e,Qe,t),s(e,rl,t),h(Re,e,t),s(e,ml,t),s(e,ze,t),s(e,dl,t),h(Xe,e,t),s(e,cl,t),h(G,e,t),s(e,hl,t),h(Ee,e,t),s(e,ul,t),s(e,Le,t),s(e,fl,t),s(e,He,t),s(e,yl,t),s(e,Ye,t),Ml=!0},p(e,[t]){const ss={};t&2&&(ss.$$scope={dirty:t,ctx:e}),_.$set(ss);const ns={};t&2&&(ns.$$scope={dirty:t,ctx:e}),k.$set(ns);const as={};t&2&&(as.$$scope={dirty:t,ctx:e}),T.$set(as);const is={};t&2&&(is.$$scope={dirty:t,ctx:e}),C.$set(is);const os={};t&2&&(os.$$scope={dirty:t,ctx:e}),J.$set(os);const ps={};t&2&&(ps.$$scope={dirty:t,ctx:e}),x.$set(ps);const rs={};t&2&&(rs.$$scope={dirty:t,ctx:e}),G.$set(rs)},i(e){Ml||(u(j.$$.fragment,e),u(q.$$.fragment,e),u(_.$$.fragment,e),u(I.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(Q.$$.fragment,e),u(z.$$.fragment,e),u(E.$$.fragment,e),u(k.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(K.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(Me.$$.fragment,e),u($e.$$.fragment,e),u(ge.$$.fragment,e),u(ve.$$.fragment,e),u(T.$$.fragment,e),u(ke.$$.fragment,e),u(C.$$.fragment,e),u(J.$$.fragment,e),u(Pe.$$.fragment,e),u(x.$$.fragment,e),u(We.$$.fragment,e),u(Ae.$$.fragment,e),u(Re.$$.fragment,e),u(Xe.$$.fragment,e),u(G.$$.fragment,e),u(Ee.$$.fragment,e),Ml=!0)},o(e){f(j.$$.fragment,e),f(q.$$.fragment,e),f(_.$$.fragment,e),f(I.$$.fragment,e),f(B.$$.fragment,e),f(A.$$.fragment,e),f(Q.$$.fragment,e),f(z.$$.fragment,e),f(E.$$.fragment,e),f(k.$$.fragment,e),f(H.$$.fragment,e),f(Y.$$.fragment,e),f(F.$$.fragment,e),f(K.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f(Me.$$.fragment,e),f($e.$$.fragment,e),f(ge.$$.fragment,e),f(ve.$$.fragment,e),f(T.$$.fragment,e),f(ke.$$.fragment,e),f(C.$$.fragment,e),f(J.$$.fragment,e),f(Pe.$$.fragment,e),f(x.$$.fragment,e),f(We.$$.fragment,e),f(Ae.$$.fragment,e),f(Re.$$.fragment,e),f(Xe.$$.fragment,e),f(G.$$.fragment,e),f(Ee.$$.fragment,e),Ml=!1},d(e){e&&(l(M),l(m),l(w),l(b),l(v),l(Ve),l(Fe),l(P),l(De),l(Z),l(Ke),l(W),l(Oe),l(et),l(tt),l(lt),l(st),l(nt),l(R),l(at),l(it),l(X),l(ot),l(pt),l(L),l(rt),l(mt),l(dt),l(N),l(ct),l(S),l(ht),l(ut),l(V),l(ft),l(yt),l(D),l(Mt),l(wt),l(O),l($t),l(ee),l(gt),l(te),l(bt),l(le),l(vt),l(Ut),l(jt),l(ae),l(_t),l(kt),l(Tt),l(pe),l(Ct),l(Jt),l(me),l(xt),l(de),l(Gt),l(qt),l(he),l(Pt),l(Zt),l(fe),l(Wt),l(It),l(Bt),l(we),l(At),l(Qt),l(Rt),l(be),l(zt),l(Xt),l(Ue),l(Et),l(je),l(Lt),l(_e),l(Ht),l(Nt),l(St),l(Te),l(Yt),l(Vt),l(Ce),l(Ft),l(Je),l(Dt),l(xe),l(Kt),l(Ot),l(Ge),l(el),l(qe),l(tl),l(ll),l(sl),l(Ze),l(nl),l(al),l(Ie),l(il),l(Be),l(ol),l(pl),l(Qe),l(rl),l(ml),l(ze),l(dl),l(cl),l(hl),l(ul),l(Le),l(fl),l(He),l(yl),l(Ye)),l(i),y(j,e),y(q,e),y(_,e),y(I,e),y(B,e),y(A,e),y(Q,e),y(z,e),y(E,e),y(k,e),y(H,e),y(Y,e),y(F,e),y(K,e),y(se,e),y(ne,e),y(ie,e),y(oe,e),y(re,e),y(ce,e),y(ue,e),y(ye,e),y(Me,e),y($e,e),y(ge,e),y(ve,e),y(T,e),y(ke,e),y(C,e),y(J,e),y(Pe,e),y(x,e),y(We,e),y(Ae,e),y(Re,e),y(Xe,e),y(G,e),y(Ee,e)}}}const Ts='{"title":"Handling big models for inference","local":"handling-big-models-for-inference","sections":[{"title":"How the Process Works: A Quick Overview","local":"how-the-process-works-a-quick-overview","sections":[],"depth":2},{"title":"How the Process Works: Working with Code","local":"how-the-process-works-working-with-code","sections":[{"title":"Instantiating an empty model","local":"instantiating-an-empty-model","sections":[],"depth":3},{"title":"Sharded checkpoints","local":"sharded-checkpoints","sections":[],"depth":3},{"title":"Loading weights","local":"loading-weights","sections":[{"title":"no_split_module_classes","local":"nosplitmoduleclasses","sections":[],"depth":4},{"title":"The device_map","local":"the-devicemap","sections":[],"depth":4}],"depth":3},{"title":"Run the model","local":"run-the-model","sections":[],"depth":3},{"title":"Designing a device map","local":"designing-a-device-map","sections":[],"depth":3}],"depth":2},{"title":"Limits and further development","local":"limits-and-further-development","sections":[],"depth":2}],"depth":1}';function Cs(g){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ws extends us{constructor(i){super(),fs(this,i,Cs,ks,cs,{})}}export{Ws as component};
