import{s as Lt,o as At}from"../chunks/scheduler.6062bdaf.js";import{S as Dt,i as Kt,g as h,s as n,r as p,A as te,h as b,f as s,c as a,j as Pt,u as o,x as f,k as Ft,y as ee,a as l,v as r,d as m,t as c,w as u,m as qt,n as Yt}from"../chunks/index.4bca734e.js";import{T as Ot}from"../chunks/Tip.b9ac1f03.js";import{C as Y}from"../chunks/CodeBlock.fa01571c.js";import{H as J}from"../chunks/Heading.723dceba.js";function se(L){let i;return{c(){i=qt("For docker installation, the following base image is recommended: `rocm/pytorch:rocm5.7_ubuntu22.04_py3.10_pytorch_2.0.1`")},l(d){i=Yt(d,"For docker installation, the following base image is recommended: `rocm/pytorch:rocm5.7_ubuntu22.04_py3.10_pytorch_2.0.1`")},m(d,w){l(d,i,w)},d(d){d&&s(i)}}}function le(L){let i;return{c(){i=qt("To avoid conflicts between `onnxruntime` and `onnxruntime-rocm`, make sure the package `onnxruntime` is not installed by running `pip uninstall onnxruntime` prior to installing `onnxruntime-rocm`.")},l(d){i=Yt(d,"To avoid conflicts between `onnxruntime` and `onnxruntime-rocm`, make sure the package `onnxruntime` is not installed by running `pip uninstall onnxruntime` prior to installing `onnxruntime-rocm`.")},m(d,w){l(d,i,w)},d(d){d&&s(i)}}}function ne(L){let i,d,w,D,g,K,T,Vt="By default, ONNX Runtime runs inference on CPU devices. However, it is possible to place supported operations on an AMD Instinct GPU, while leaving any unsupported ones on CPU. In most cases, this allows costly operations to be placed on GPU and significantly accelerate inference.",tt,U,xt='Our testing involved AMD Instinct GPUs, and for specific GPU compatibility, please refer to the official support list of GPUs available <a href="https://rocm.docs.amd.com/en/latest/release/gpu_os_support.html" rel="nofollow">here</a>.',et,j,Gt="This guide will show you how to run inference on the <code>ROCMExecutionProvider</code> execution provider that ONNX Runtime supports for AMD GPUs.",st,$,lt,R,Nt="The following setup installs the ONNX Runtime support with ROCM Execution Provider with ROCm 5.7.",nt,v,at,C,It='To install ROCM 5.7, please follow the <a href="https://rocm.docs.amd.com/en/latest/deploy/linux/index.html" rel="nofollow">ROCm installation guide</a>.',it,Z,pt,V,Xt='Optimum ONNX Runtime integration relies on some functionalities of Transformers that require PyTorch. For now, we recommend to use Pytorch compiled against RoCm 5.7, that can be installed following <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch installation guide</a>:',ot,x,rt,M,mt,G,ct,N,ut,y,dt,I,ht,X,Wt="Before going further, run the following sample code to check whether the install was successful:",bt,W,ft,_,_t="In case this code runs gracefully, congratulations, the installation is successfull! If you encounter the following error or similar,",wt,B,Mt,k,Bt="then something is wrong with the ROCM or ONNX Runtime installation.",yt,E,Jt,S,kt="For ORT models, the use is straightforward. Simply specify the <code>provider</code> argument in the <code>ORTModel.from_pretrained()</code> method. Here’s an example:",gt,Q,Tt,z,Et=`The model can then be used with the common 🤗 Transformers API for inference and evaluation, such as <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/pipelines" rel="nofollow">pipelines</a>.
When using Transformers pipeline, note that the <code>device</code> argument should be set to perform pre- and post-processing on GPU, following the example below:`,Ut,H,jt,P,St="Additionally, you can pass the session option <code>log_severity_level = 0</code> (verbose), to check whether all nodes are indeed placed on the ROCM execution provider or not:",$t,F,Rt,O,vt,q,Qt="Coming soon!",Ct,A,Zt;return g=new J({props:{title:"Accelerated inference on AMD GPUs supported by ROCm",local:"accelerated-inference-on-amd-gpus-supported-by-rocm",headingTag:"h1"}}),$=new J({props:{title:"Installation",local:"installation",headingTag:"h2"}}),v=new J({props:{title:"1. ROCm Installation",local:"1-rocm-installation",headingTag:"h4"}}),Z=new J({props:{title:"2. PyTorch Installation with ROCm Support",local:"2-pytorch-installation-with-rocm-support",headingTag:"h4"}}),x=new Y({props:{code:"cGlwMyUyMGluc3RhbGwlMjAtLXByZSUyMHRvcmNoJTIwdG9yY2h2aXNpb24lMjB0b3JjaGF1ZGlvJTIwLS1pbmRleC11cmwlMjBodHRwcyUzQSUyRiUyRmRvd25sb2FkLnB5dG9yY2gub3JnJTJGd2hsJTJGbmlnaHRseSUyRnJvY201Ljc=",highlighted:"pip3 install --pre torch torchvision torchaudio --index-url https://download.pytorch.org/whl/nightly/rocm5.7",wrap:!1}}),M=new Ot({props:{$$slots:{default:[se]},$$scope:{ctx:L}}}),G=new J({props:{title:"3. ONNX Runtime installation with ROCm Execution Provider",local:"3-onnx-runtime-installation-with-rocm-execution-provider",headingTag:"h3"}}),N=new Y({props:{code:"JTIzJTIwcHJlLXJlcXVpc2l0ZXMlMEFwaXAlMjBpbnN0YWxsJTIwLVUlMjBwaXAlMEFwaXAlMjBpbnN0YWxsJTIwY21ha2UlMjBvbm54JTBBY3VybCUyMC0tcHJvdG8lMjAnJTNEaHR0cHMnJTIwLS10bHN2MS4yJTIwLXNTZiUyMGh0dHBzJTNBJTJGJTJGc2gucnVzdHVwLnJzJTIwJTdDJTIwc2glMEElMEElMjMlMjBJbnN0YWxsJTIwT05OWFJ1bnRpbWUlMjBmcm9tJTIwc291cmNlJTBBZ2l0JTIwY2xvbmUlMjAtLXJlY3Vyc2l2ZSUyMCUyMGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRlJPQ21Tb2Z0d2FyZVBsYXRmb3JtJTJGb25ueHJ1bnRpbWUuZ2l0JTBBZ2l0JTIwY2hlY2tvdXQlMjByb2NtNS43X2ludGVybmFsX3Rlc3RpbmdfZWlnZW4tMy40LnppcF9oYXNoJTBBY2QlMjBvbm54cnVudGltZSUwQSUwQS4lMkZidWlsZC5zaCUyMC0tY29uZmlnJTIwUmVsZWFzZSUyMC0tYnVpbGRfd2hlZWwlMjAtLXVwZGF0ZSUyMC0tYnVpbGQlMjAtLXBhcmFsbGVsJTIwLS1jbWFrZV9leHRyYV9kZWZpbmVzJTIwT05OWFJVTlRJTUVfVkVSU0lPTiUzRCUyNChjYXQlMjAuJTJGVkVSU0lPTl9OVU1CRVIpJTIwLS11c2Vfcm9jbSUyMC0tcm9jbV9ob21lJTNEJTJGb3B0JTJGcm9jbSUwQXBpcCUyMGluc3RhbGwlMjBidWlsZCUyRkxpbnV4JTJGUmVsZWFzZSUyRmRpc3QlMkYq",highlighted:`<span class="hljs-comment"># pre-requisites</span>
pip install -U pip
pip install cmake onnx
curl --proto <span class="hljs-string">&#x27;=https&#x27;</span> --tlsv1.2 -sSf https://sh.rustup.rs | sh

<span class="hljs-comment"># Install ONNXRuntime from source</span>
git <span class="hljs-built_in">clone</span> --recursive  https://github.com/ROCmSoftwarePlatform/onnxruntime.git
git checkout rocm5.7_internal_testing_eigen-3.4.zip_hash
<span class="hljs-built_in">cd</span> onnxruntime

./build.sh --config Release --build_wheel --update --build --parallel --cmake_extra_defines ONNXRUNTIME_VERSION=$(<span class="hljs-built_in">cat</span> ./VERSION_NUMBER) --use_rocm --rocm_home=/opt/rocm
pip install build/Linux/Release/dist/*`,wrap:!1}}),y=new Ot({props:{$$slots:{default:[le]},$$scope:{ctx:L}}}),I=new J({props:{title:"Checking the ROCm installation is successful",local:"checking-the-rocm-installation-is-successful",headingTag:"h3"}}),W=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIycGhpbHNjaG1pZCUyRnRpbnktYmVydC1zc3QyLWRpc3RpbGxlZCUyMiUyQyUwQSUyMCUyMGV4cG9ydCUzRFRydWUlMkMlMEElMjAlMjBwcm92aWRlciUzRCUyMlJPQ01FeGVjdXRpb25Qcm92aWRlciUyMiUyQyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJwaGlsc2NobWlkJTJGdGlueS1iZXJ0LXNzdDItZGlzdGlsbGVkJTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJleHBlY3RhdGlvbnMlMjB3ZXJlJTIwbG93JTJDJTIwYWN0dWFsJTIwZW5qb3ltZW50JTIwd2FzJTIwaGlnaCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFvdXRwdXRzJTIwJTNEJTIwb3J0X21vZGVsKCoqaW5wdXRzKSUwQWFzc2VydCUyMG9ydF9tb2RlbC5wcm92aWRlcnMlMjAlM0QlM0QlMjAlNUIlMjJST0NNRXhlY3V0aW9uUHJvdmlkZXIlMjIlMkMlMjAlMjJDUFVFeGVjdXRpb25Qcm92aWRlciUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;ROCMExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;philschmid/tiny-bert-sst2-distilled&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;expectations were low, actual enjoyment was high&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = ort_model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ort_model.providers == [<span class="hljs-string">&quot;ROCMExecutionProvider&quot;</span>, <span class="hljs-string">&quot;CPUExecutionProvider&quot;</span>]`,wrap:!1}}),B=new Y({props:{code:"VmFsdWVFcnJvciUzQSUyMEFza2VkJTIwdG8lMjB1c2UlMjBST0NNRXhlY3V0aW9uUHJvdmlkZXIlMjBhcyUyMGFuJTIwT05OWCUyMFJ1bnRpbWUlMjBleGVjdXRpb24lMjBwcm92aWRlciUyQyUyMGJ1dCUyMHRoZSUyMGF2YWlsYWJsZSUyMGV4ZWN1dGlvbiUyMHByb3ZpZGVycyUyMGFyZSUyMCU1QidDUFVFeGVjdXRpb25Qcm92aWRlciclNUQu",highlighted:'ValueError: Asked <span class="hljs-built_in">to</span> use ROCMExecutionProvider <span class="hljs-keyword">as</span> <span class="hljs-keyword">an</span> ONNX Runtime execution provider, but <span class="hljs-keyword">the</span> available execution providers are [<span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>].',wrap:!1}}),E=new J({props:{title:"Use ROCM Execution Provider with ORT models",local:"use-rocm-execution-provider-with-ort-models",headingTag:"h3"}}),Q=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMHByb3ZpZGVyJTNEJTIyUk9DTUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>  export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  provider=<span class="hljs-string">&quot;ROCMExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),H=new Y({props:{code:"ZnJvbSUyMG9wdGltdW0ucGlwZWxpbmVzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEb3J0X21vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTIwZGV2aWNlJTNEJTIyY3VkYSUzQTAlMjIpJTBBcmVzdWx0JTIwJTNEJTIwcGlwZSglMjJCb3RoJTIwdGhlJTIwbXVzaWMlMjBhbmQlMjB2aXN1YWwlMjB3ZXJlJTIwYXN0b3VuZGluZyUyQyUyMG5vdCUyMHRvJTIwbWVudGlvbiUyMHRoZSUyMGFjdG9ycyUyMHBlcmZvcm1hbmNlLiUyMiklMEFwcmludChyZXN1bHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.pipelines <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(task=<span class="hljs-string">&quot;text-classification&quot;</span>, model=ort_model, tokenizer=tokenizer, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = pipe(<span class="hljs-string">&quot;Both the music and visual were astounding, not to mention the actors performance.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)
<span class="hljs-comment"># printing: [{&#x27;label&#x27;: &#x27;POSITIVE&#x27;, &#x27;score&#x27;: 0.9997727274894c714}]</span>`,wrap:!1}}),F=new Y({props:{code:"aW1wb3J0JTIwb25ueHJ1bnRpbWUlMEElMEFzZXNzaW9uX29wdGlvbnMlMjAlM0QlMjBvbm54cnVudGltZS5TZXNzaW9uT3B0aW9ucygpJTBBc2Vzc2lvbl9vcHRpb25zLmxvZ19zZXZlcml0eV9sZXZlbCUyMCUzRCUyMDAlMEElMEFvcnRfbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHByb3ZpZGVyJTNEJTIyUk9DTUV4ZWN1dGlvblByb3ZpZGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2Vzc2lvbl9vcHRpb25zJTNEc2Vzc2lvbl9vcHRpb25zJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> onnxruntime

<span class="hljs-meta">&gt;&gt;&gt; </span>session_options = onnxruntime.SessionOptions()
<span class="hljs-meta">&gt;&gt;&gt; </span>session_options.log_severity_level = <span class="hljs-number">0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>,
<span class="hljs-meta">... </span>    export=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;ROCMExecutionProvider&quot;</span>,
<span class="hljs-meta">... </span>    session_options=session_options
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new J({props:{title:"Observed time gains",local:"observed-time-gains",headingTag:"h3"}}),{c(){i=h("meta"),d=n(),w=h("p"),D=n(),p(g.$$.fragment),K=n(),T=h("p"),T.textContent=Vt,tt=n(),U=h("p"),U.innerHTML=xt,et=n(),j=h("p"),j.innerHTML=Gt,st=n(),p($.$$.fragment),lt=n(),R=h("p"),R.textContent=Nt,nt=n(),p(v.$$.fragment),at=n(),C=h("p"),C.innerHTML=It,it=n(),p(Z.$$.fragment),pt=n(),V=h("p"),V.innerHTML=Xt,ot=n(),p(x.$$.fragment),rt=n(),p(M.$$.fragment),mt=n(),p(G.$$.fragment),ct=n(),p(N.$$.fragment),ut=n(),p(y.$$.fragment),dt=n(),p(I.$$.fragment),ht=n(),X=h("p"),X.textContent=Wt,bt=n(),p(W.$$.fragment),ft=n(),_=h("p"),_.textContent=_t,wt=n(),p(B.$$.fragment),Mt=n(),k=h("p"),k.textContent=Bt,yt=n(),p(E.$$.fragment),Jt=n(),S=h("p"),S.innerHTML=kt,gt=n(),p(Q.$$.fragment),Tt=n(),z=h("p"),z.innerHTML=Et,Ut=n(),p(H.$$.fragment),jt=n(),P=h("p"),P.innerHTML=St,$t=n(),p(F.$$.fragment),Rt=n(),p(O.$$.fragment),vt=n(),q=h("p"),q.textContent=Qt,Ct=n(),A=h("p"),this.h()},l(t){const e=te("svelte-u9bgzb",document.head);i=b(e,"META",{name:!0,content:!0}),e.forEach(s),d=a(t),w=b(t,"P",{}),Pt(w).forEach(s),D=a(t),o(g.$$.fragment,t),K=a(t),T=b(t,"P",{"data-svelte-h":!0}),f(T)!=="svelte-1ua7il2"&&(T.textContent=Vt),tt=a(t),U=b(t,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1gmc0d5"&&(U.innerHTML=xt),et=a(t),j=b(t,"P",{"data-svelte-h":!0}),f(j)!=="svelte-fubslz"&&(j.innerHTML=Gt),st=a(t),o($.$$.fragment,t),lt=a(t),R=b(t,"P",{"data-svelte-h":!0}),f(R)!=="svelte-19shrg9"&&(R.textContent=Nt),nt=a(t),o(v.$$.fragment,t),at=a(t),C=b(t,"P",{"data-svelte-h":!0}),f(C)!=="svelte-rl421s"&&(C.innerHTML=It),it=a(t),o(Z.$$.fragment,t),pt=a(t),V=b(t,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1ravp1j"&&(V.innerHTML=Xt),ot=a(t),o(x.$$.fragment,t),rt=a(t),o(M.$$.fragment,t),mt=a(t),o(G.$$.fragment,t),ct=a(t),o(N.$$.fragment,t),ut=a(t),o(y.$$.fragment,t),dt=a(t),o(I.$$.fragment,t),ht=a(t),X=b(t,"P",{"data-svelte-h":!0}),f(X)!=="svelte-ojb3z4"&&(X.textContent=Wt),bt=a(t),o(W.$$.fragment,t),ft=a(t),_=b(t,"P",{"data-svelte-h":!0}),f(_)!=="svelte-1clmmnk"&&(_.textContent=_t),wt=a(t),o(B.$$.fragment,t),Mt=a(t),k=b(t,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1fgo68"&&(k.textContent=Bt),yt=a(t),o(E.$$.fragment,t),Jt=a(t),S=b(t,"P",{"data-svelte-h":!0}),f(S)!=="svelte-tnexjl"&&(S.innerHTML=kt),gt=a(t),o(Q.$$.fragment,t),Tt=a(t),z=b(t,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1icvfx4"&&(z.innerHTML=Et),Ut=a(t),o(H.$$.fragment,t),jt=a(t),P=b(t,"P",{"data-svelte-h":!0}),f(P)!=="svelte-5v5qqy"&&(P.innerHTML=St),$t=a(t),o(F.$$.fragment,t),Rt=a(t),o(O.$$.fragment,t),vt=a(t),q=b(t,"P",{"data-svelte-h":!0}),f(q)!=="svelte-15n2n4z"&&(q.textContent=Qt),Ct=a(t),A=b(t,"P",{}),Pt(A).forEach(s),this.h()},h(){Ft(i,"name","hf:doc:metadata"),Ft(i,"content",ae)},m(t,e){ee(document.head,i),l(t,d,e),l(t,w,e),l(t,D,e),r(g,t,e),l(t,K,e),l(t,T,e),l(t,tt,e),l(t,U,e),l(t,et,e),l(t,j,e),l(t,st,e),r($,t,e),l(t,lt,e),l(t,R,e),l(t,nt,e),r(v,t,e),l(t,at,e),l(t,C,e),l(t,it,e),r(Z,t,e),l(t,pt,e),l(t,V,e),l(t,ot,e),r(x,t,e),l(t,rt,e),r(M,t,e),l(t,mt,e),r(G,t,e),l(t,ct,e),r(N,t,e),l(t,ut,e),r(y,t,e),l(t,dt,e),r(I,t,e),l(t,ht,e),l(t,X,e),l(t,bt,e),r(W,t,e),l(t,ft,e),l(t,_,e),l(t,wt,e),r(B,t,e),l(t,Mt,e),l(t,k,e),l(t,yt,e),r(E,t,e),l(t,Jt,e),l(t,S,e),l(t,gt,e),r(Q,t,e),l(t,Tt,e),l(t,z,e),l(t,Ut,e),r(H,t,e),l(t,jt,e),l(t,P,e),l(t,$t,e),r(F,t,e),l(t,Rt,e),r(O,t,e),l(t,vt,e),l(t,q,e),l(t,Ct,e),l(t,A,e),Zt=!0},p(t,[e]){const zt={};e&2&&(zt.$$scope={dirty:e,ctx:t}),M.$set(zt);const Ht={};e&2&&(Ht.$$scope={dirty:e,ctx:t}),y.$set(Ht)},i(t){Zt||(m(g.$$.fragment,t),m($.$$.fragment,t),m(v.$$.fragment,t),m(Z.$$.fragment,t),m(x.$$.fragment,t),m(M.$$.fragment,t),m(G.$$.fragment,t),m(N.$$.fragment,t),m(y.$$.fragment,t),m(I.$$.fragment,t),m(W.$$.fragment,t),m(B.$$.fragment,t),m(E.$$.fragment,t),m(Q.$$.fragment,t),m(H.$$.fragment,t),m(F.$$.fragment,t),m(O.$$.fragment,t),Zt=!0)},o(t){c(g.$$.fragment,t),c($.$$.fragment,t),c(v.$$.fragment,t),c(Z.$$.fragment,t),c(x.$$.fragment,t),c(M.$$.fragment,t),c(G.$$.fragment,t),c(N.$$.fragment,t),c(y.$$.fragment,t),c(I.$$.fragment,t),c(W.$$.fragment,t),c(B.$$.fragment,t),c(E.$$.fragment,t),c(Q.$$.fragment,t),c(H.$$.fragment,t),c(F.$$.fragment,t),c(O.$$.fragment,t),Zt=!1},d(t){t&&(s(d),s(w),s(D),s(K),s(T),s(tt),s(U),s(et),s(j),s(st),s(lt),s(R),s(nt),s(at),s(C),s(it),s(pt),s(V),s(ot),s(rt),s(mt),s(ct),s(ut),s(dt),s(ht),s(X),s(bt),s(ft),s(_),s(wt),s(Mt),s(k),s(yt),s(Jt),s(S),s(gt),s(Tt),s(z),s(Ut),s(jt),s(P),s($t),s(Rt),s(vt),s(q),s(Ct),s(A)),s(i),u(g,t),u($,t),u(v,t),u(Z,t),u(x,t),u(M,t),u(G,t),u(N,t),u(y,t),u(I,t),u(W,t),u(B,t),u(E,t),u(Q,t),u(H,t),u(F,t),u(O,t)}}}const ae='{"title":"Accelerated inference on AMD GPUs supported by ROCm","local":"accelerated-inference-on-amd-gpus-supported-by-rocm","sections":[{"title":"Installation","local":"installation","sections":[{"title":"1. ROCm Installation","local":"1-rocm-installation","sections":[],"depth":4},{"title":"2. PyTorch Installation with ROCm Support","local":"2-pytorch-installation-with-rocm-support","sections":[],"depth":4},{"title":"3. ONNX Runtime installation with ROCm Execution Provider","local":"3-onnx-runtime-installation-with-rocm-execution-provider","sections":[],"depth":3},{"title":"Checking the ROCm installation is successful","local":"checking-the-rocm-installation-is-successful","sections":[],"depth":3},{"title":"Use ROCM Execution Provider with ORT models","local":"use-rocm-execution-provider-with-ort-models","sections":[],"depth":3},{"title":"Observed time gains","local":"observed-time-gains","sections":[],"depth":3}],"depth":2}],"depth":1}';function ie(L){return At(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ue extends Dt{constructor(i){super(),Kt(this,i,ie,ne,Lt,{})}}export{ue as component};
