import{s as rt,n as Ct,o as It}from"../chunks/scheduler.dd9e4dcc.js";import{S as bt,i as dt,e as M,s as n,c as U,h as ht,a as p,d as s,b as a,f as ct,g as y,j as i,k as mt,l as Qt,m as e,n as J,t as o,o as T,p as j}from"../chunks/index.cf32bc90.js";import{C as gt,H as Yl,E as Vt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.428ee8cc.js";import{C as u}from"../chunks/CodeBlock.b68af46a.js";import{D as Bt}from"../chunks/DocNotebookDropdown.0704d2ae.js";function ft(Hl){let w,nl,sl,al,c,Ml,m,pl,r,il,C,zl="이 튜토리얼에서는 <code>smolagents</code>를 사용해 SQL을 다루는 에이전트를 구현해보겠습니다.",Ul,I,Ll="<p>먼저 중요한 질문 하나로 시작하겠습니다. 그냥 간단하게 일반적인 text-to-SQL 파이프라인을 쓰면 안 될까요?</p>",yl,b,Dl="표준 text-to-SQL 파이프라인은 안정성이 떨어지는 경우가 많습니다. 쿼리가 잘못 생성될 수 있고, 심지어는 오류 없이 틀리거나 쓸모없는 결과를 반환할 수도 있습니다.",Jl,d,Ol="👉 반면, 에이전트 시스템은 출력 결과를 비판적으로 점검할 수 있고 쿼리를 수정할 필요가 있는지 스스로 결정할 수 있이 성능이 크게 향상됩니다.",ol,h,Pl="이제 이 에이전트를 직접 만들어봅시다! 💪",Tl,Q,Kl="아래 명령어를 실행해 필요한 의존성을 설치하세요:",jl,g,ul,V,lt=`추론 프로바이더를 호출하려면 환경 변수 <code>HF_TOKEN</code>에 유효한 토큰이 설정되어 있어야 합니다.
python-dotenv를 이용해 환경 변수를 불러오겠습니다.`,wl,B,cl,f,tt="다음으로, SQL 환경을 구성하겠습니다:",ml,q,rl,k,Cl,N,st="이제 도구를 활용해 SQL 테이블을 조회할 수 있도록 만들어봅시다.",Il,E,et="툴의 설명 속성은 에이전트 시스템에 의해 LLM 프롬프트에 포함되는 부분으로, LLM이 해당 도구를 어떻게 사용할 수 있는지에 대한 정보를 제공합니다. 바로 이 부분에 우리가 정의한 SQL 테이블의 설명을 작성하면 됩니다.",bl,A,dl,R,hl,_,nt='이제 우리만의 툴을 만들어봅시다. 도구은 아래와 같은 요소를 필요로 합니다. (자세한 내용은 <a href="../tutorials/tools">도구 문서</a>를 참고하세요)',Ql,Z,at="<li>인자(<code>Args:</code>) 목록이 포함된 docstring</li> <li>입력과 출력에 대한 타입 힌트</li>",gl,S,Vl,W,Mt="이제 이 도구를 사용하는 에이전트를 만들어보겠습니다.",Bl,G,pt="여기서는 smolagent의 메인 에이전트 클래스인 <code>CodeAgent</code>를 사용합니다. <code>CodeAgent</code>는 코드로 액션을 작성하고 ReAct 프레임워크에 따라 이전 출력 결과를 반복적으로 개선할 수 있습니다.",fl,v,it="모델은 에이전트 시스템을 구동하는 LLM을 의미합니다. <code>InferenceClientModel</code>을 사용하면 허깅페이스의 Inference API를 통해 서버리스 또는 Dedicated 엔드포인트 방식으로 LLM을 호출할 수 있으며, 필요에 따라 다른 사설 API를 사용할 수도 있습니다.",ql,$,kl,x,Nl,F,Ut="이제 좀 더 어려운 과제를 해결해 볼까요? 에이전트가 여러 테이블에 걸친 조인을 처리하도록 만들어 보겠습니다.",El,X,yt="이를 위해 각 <code>receipt_id</code>에 해당하는 웨이터의 이름을 기록하는 두 번째 테이블을 만들어 보겠습니다.",Al,Y,Rl,H,Jt="테이블이 변경되었기 때문에 LLM이 테이블 정보를 올바르게 활용할 수 있도록 <code>sql_engine</code>의 설명을 업데이트하겠습니다.",_l,z,Zl,L,ot='이번 요청은 이전보다 조금 더 어려우므로, 더 강력한 <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a> 모델을 사용하도록 LLM 엔진을 바꾸겠습니다!',Sl,D,Wl,O,Tt="바로 성공입니다! 놀라울 만큼 간단하게 설정되지 않았나요?",Gl,P,jt="이번 예제는 여기까지입니다! 지금까지 다음과 같은 개념들을 살펴보았습니다.",vl,K,ut="<li>새로운 도구 만들기</li> <li>도구 설명 업데이트하기</li> <li>더 강력한 LLM으로 에이전트 추론 능력 향상시키기</li>",$l,ll,wt="✅ 이제 여러분이 꿈꿔왔던 text-to-SQL 시스템을 직접 만들어 보세요! ✨",xl,tl,Fl,el,Xl;return c=new gt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),m=new Yl({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),r=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/ko/tensorflow/text_to_sql.ipynb"}]}}),g=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcHl0aG9uLWRvdGVudiUyMHNxbGFsY2hlbXklMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:"!pip install smolagents python-dotenv sqlalchemy --upgrade -q",wrap:!1}}),B=new u({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),q=new u({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBZGVmJTIwaW5zZXJ0X3Jvd3NfaW50b190YWJsZShyb3dzJTJDJTIwdGFibGUlMkMlMjBlbmdpbmUlM0RlbmdpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwcm93JTIwaW4lMjByb3dzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RtdCUyMCUzRCUyMGluc2VydCh0YWJsZSkudmFsdWVzKCoqcm93KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBlbmdpbmUuYmVnaW4oKSUyMGFzJTIwY29ubmVjdGlvbiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbm5lY3Rpb24uZXhlY3V0ZShzdG10KSUwQSUwQXRhYmxlX25hbWUlMjAlM0QlMjAlMjJyZWNlaXB0cyUyMiUwQXJlY2VpcHRzJTIwJTNEJTIwVGFibGUoJTBBJTIwJTIwJTIwJTIwdGFibGVfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhX29iaiUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJyZWNlaXB0X2lkJTIyJTJDJTIwSW50ZWdlciUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIyY3VzdG9tZXJfbmFtZSUyMiUyQyUyMFN0cmluZygxNiklMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnByaWNlJTIyJTJDJTIwRmxvYXQpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnRpcCUyMiUyQyUyMEZsb2F0KSUyQyUwQSklMEFtZXRhZGF0YV9vYmouY3JlYXRlX2FsbChlbmdpbmUpJTBBJTBBcm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFpbnNlcnRfcm93c19pbnRvX3RhYmxlKHJvd3MlMkMlMjByZWNlaXB0cyk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">insert_rows_into_table</span>(<span class="hljs-params">rows, table, engine=engine</span>):
    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
        stmt = insert(table).values(**row)
        <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
            connection.execute(stmt)

table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
insert_rows_into_table(rows, receipts)`,wrap:!1}}),k=new Yl({props:{title:"에이전트 만들기",local:"build-our-agent",headingTag:"h3"}}),A=new u({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),R=new u({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),S=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCVFRCU4NSU4QyVFQyU5RCVCNCVFQiVCOCU5NCVFQyU5NyU5MCUyMFNRTCUyMCVFQyVCRiVCQyVFQiVBNiVBQyVFQiVBNSVCQyUyMCVFQyU4OCU5OCVFRCU5NiU4OSVFRCU5NSVBMCUyMCVFQyU4OCU5OCUyMCVFQyU5RSU4OCVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNC4lMjAlRUElQjIlQjAlRUElQjMlQkMlRUIlQTUlQkMlMjAlRUIlQUMlQjglRUMlOUUlOTAlRUMlOTclQjQlRUIlQTElOUMlMjAlRUIlQjAlOTglRUQlOTklOTglRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBJTIwJTIwJTIwJTIwJUVEJTg1JThDJUVDJTlEJUI0JUVCJUI4JTk0JTIwJUVDJTlEJUI0JUVCJUE2JTg0JUVDJTlEJTgwJTIwJ3JlY2VpcHRzJyVFQyU5RCVCNCVFQiVBOSVCMCUyQyUyMCVFQyU4NCVBNCVFQiVBQSU4NSVFQyU5RCU4MCUyMCVFQiU4QiVBNCVFQyU5RCU4QyVFQSVCMyVCQyUyMCVFQSVCMCU5OSVFQyU4QSVCNSVFQiU4QiU4OCVFQiU4QiVBNCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMENvbHVtbnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtJTIwcmVjZWlwdF9pZCUzQSUyMElOVEVHRVIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtJTIwY3VzdG9tZXJfbmFtZSUzQSUyMFZBUkNIQVIoMTYpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHByaWNlJTNBJTIwRkxPQVQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAtJTIwdGlwJTNBJTIwRkxPQVQlMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnklM0ElMjAlRUMlODglOTglRUQlOTYlODklRUQlOTUlQTAlMjAlRUMlQkYlQkMlRUIlQTYlQUMlRUMlOUUlODUlRUIlOEIlODglRUIlOEIlQTQuJTIwJUVDJTk4JUFDJUVCJUIwJTk0JUVCJUE1JUI4JTIwU1FMJUVDJTlEJUI0JUVDJTk2JUI0JUVDJTk1JUJDJTIwJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMHdpdGglMjBlbmdpbmUuY29ubmVjdCgpJTIwYXMlMjBjb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb3dzJTIwJTNEJTIwY29uLmV4ZWN1dGUodGV4dChxdWVyeSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwcm93JTIwaW4lMjByb3dzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTJCJTNEJTIwJTIyJTVDbiUyMiUyMCUyQiUyMHN0cihyb3cpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    테이블에 SQL 쿼리를 수행할 수 있습니다. 결과를 문자열로 반환합니다.
    테이블 이름은 &#x27;receipts&#x27;이며, 설명은 다음과 같습니다:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: 수행할 쿼리입니다. 올바른 SQL이어야 합니다.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),$=new u({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSUyQyUwQSklMEFhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2xpZW50JTIwd2hvJTIwZ290JTIwdGhlJTIwbW9zdCUyMGV4cGVuc2l2ZSUyMHJlY2VpcHQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),x=new Yl({props:{title:"레벨 업: 테이블 조인",local:"level-2-table-joins",headingTag:"h3"}}),Y=new u({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEF3YWl0ZXJzJTIwJTNEJTIwVGFibGUoJTBBJTIwJTIwJTIwJTIwdGFibGVfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhX29iaiUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJyZWNlaXB0X2lkJTIyJTJDJTIwSW50ZWdlciUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIyd2FpdGVyX25hbWUlMjIlMkMlMjBTdHJpbmcoMTYpJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSklMEFtZXRhZGF0YV9vYmouY3JlYXRlX2FsbChlbmdpbmUpJTBBJTBBcm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJDb3JleSUyMEpvaG5zb24lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMiUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWljaGFlbCUyMFdhdHRzJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDMlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjA0JTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTdEJTJDJTBBJTVEJTBBaW5zZXJ0X3Jvd3NfaW50b190YWJsZShyb3dzJTJDJTIwd2FpdGVycyk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
waiters = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
insert_rows_into_table(rows, waiters)`,wrap:!1}}),z=new u({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),D=new u({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),tl=new Vt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/ko/examples/text_to_sql.md"}}),{c(){w=M("meta"),nl=n(),sl=M("p"),al=n(),U(c.$$.fragment),Ml=n(),U(m.$$.fragment),pl=n(),U(r.$$.fragment),il=n(),C=M("p"),C.innerHTML=zl,Ul=n(),I=M("blockquote"),I.innerHTML=Ll,yl=n(),b=M("p"),b.textContent=Dl,Jl=n(),d=M("p"),d.textContent=Ol,ol=n(),h=M("p"),h.textContent=Pl,Tl=n(),Q=M("p"),Q.textContent=Kl,jl=n(),U(g.$$.fragment),ul=n(),V=M("p"),V.innerHTML=lt,wl=n(),U(B.$$.fragment),cl=n(),f=M("p"),f.textContent=tt,ml=n(),U(q.$$.fragment),rl=n(),U(k.$$.fragment),Cl=n(),N=M("p"),N.textContent=st,Il=n(),E=M("p"),E.textContent=et,bl=n(),U(A.$$.fragment),dl=n(),U(R.$$.fragment),hl=n(),_=M("p"),_.innerHTML=nt,Ql=n(),Z=M("ul"),Z.innerHTML=at,gl=n(),U(S.$$.fragment),Vl=n(),W=M("p"),W.textContent=Mt,Bl=n(),G=M("p"),G.innerHTML=pt,fl=n(),v=M("p"),v.innerHTML=it,ql=n(),U($.$$.fragment),kl=n(),U(x.$$.fragment),Nl=n(),F=M("p"),F.textContent=Ut,El=n(),X=M("p"),X.innerHTML=yt,Al=n(),U(Y.$$.fragment),Rl=n(),H=M("p"),H.innerHTML=Jt,_l=n(),U(z.$$.fragment),Zl=n(),L=M("p"),L.innerHTML=ot,Sl=n(),U(D.$$.fragment),Wl=n(),O=M("p"),O.textContent=Tt,Gl=n(),P=M("p"),P.textContent=jt,vl=n(),K=M("ul"),K.innerHTML=ut,$l=n(),ll=M("p"),ll.textContent=wt,xl=n(),U(tl.$$.fragment),Fl=n(),el=M("p"),this.h()},l(l){const t=ht("svelte-u9bgzb",document.head);w=p(t,"META",{name:!0,content:!0}),t.forEach(s),nl=a(l),sl=p(l,"P",{}),ct(sl).forEach(s),al=a(l),y(c.$$.fragment,l),Ml=a(l),y(m.$$.fragment,l),pl=a(l),y(r.$$.fragment,l),il=a(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-13dstk6"&&(C.innerHTML=zl),Ul=a(l),I=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(I)!=="svelte-1ikljlx"&&(I.innerHTML=Ll),yl=a(l),b=p(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-g5lnky"&&(b.textContent=Dl),Jl=a(l),d=p(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1v5lrwx"&&(d.textContent=Ol),ol=a(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-cbvetl"&&(h.textContent=Pl),Tl=a(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1fbovla"&&(Q.textContent=Kl),jl=a(l),y(g.$$.fragment,l),ul=a(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-118l2e"&&(V.innerHTML=lt),wl=a(l),y(B.$$.fragment,l),cl=a(l),f=p(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-16ss1rh"&&(f.textContent=tt),ml=a(l),y(q.$$.fragment,l),rl=a(l),y(k.$$.fragment,l),Cl=a(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1nrlsq7"&&(N.textContent=st),Il=a(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-3e74wm"&&(E.textContent=et),bl=a(l),y(A.$$.fragment,l),dl=a(l),y(R.$$.fragment,l),hl=a(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-10vsy3u"&&(_.innerHTML=nt),Ql=a(l),Z=p(l,"UL",{"data-svelte-h":!0}),i(Z)!=="svelte-1b2eezm"&&(Z.innerHTML=at),gl=a(l),y(S.$$.fragment,l),Vl=a(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1yzitq4"&&(W.textContent=Mt),Bl=a(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1uki3as"&&(G.innerHTML=pt),fl=a(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-u38hz5"&&(v.innerHTML=it),ql=a(l),y($.$$.fragment,l),kl=a(l),y(x.$$.fragment,l),Nl=a(l),F=p(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-hibzfv"&&(F.textContent=Ut),El=a(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-r9y53z"&&(X.innerHTML=yt),Al=a(l),y(Y.$$.fragment,l),Rl=a(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-c6lwa0"&&(H.innerHTML=Jt),_l=a(l),y(z.$$.fragment,l),Zl=a(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-lzjvgj"&&(L.innerHTML=ot),Sl=a(l),y(D.$$.fragment,l),Wl=a(l),O=p(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-dg1nco"&&(O.textContent=Tt),Gl=a(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-1vks9f4"&&(P.textContent=jt),vl=a(l),K=p(l,"UL",{"data-svelte-h":!0}),i(K)!=="svelte-wxkiue"&&(K.innerHTML=ut),$l=a(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-b3m8r8"&&(ll.textContent=wt),xl=a(l),y(tl.$$.fragment,l),Fl=a(l),el=p(l,"P",{}),ct(el).forEach(s),this.h()},h(){mt(w,"name","hf:doc:metadata"),mt(w,"content",qt)},m(l,t){Qt(document.head,w),e(l,nl,t),e(l,sl,t),e(l,al,t),J(c,l,t),e(l,Ml,t),J(m,l,t),e(l,pl,t),J(r,l,t),e(l,il,t),e(l,C,t),e(l,Ul,t),e(l,I,t),e(l,yl,t),e(l,b,t),e(l,Jl,t),e(l,d,t),e(l,ol,t),e(l,h,t),e(l,Tl,t),e(l,Q,t),e(l,jl,t),J(g,l,t),e(l,ul,t),e(l,V,t),e(l,wl,t),J(B,l,t),e(l,cl,t),e(l,f,t),e(l,ml,t),J(q,l,t),e(l,rl,t),J(k,l,t),e(l,Cl,t),e(l,N,t),e(l,Il,t),e(l,E,t),e(l,bl,t),J(A,l,t),e(l,dl,t),J(R,l,t),e(l,hl,t),e(l,_,t),e(l,Ql,t),e(l,Z,t),e(l,gl,t),J(S,l,t),e(l,Vl,t),e(l,W,t),e(l,Bl,t),e(l,G,t),e(l,fl,t),e(l,v,t),e(l,ql,t),J($,l,t),e(l,kl,t),J(x,l,t),e(l,Nl,t),e(l,F,t),e(l,El,t),e(l,X,t),e(l,Al,t),J(Y,l,t),e(l,Rl,t),e(l,H,t),e(l,_l,t),J(z,l,t),e(l,Zl,t),e(l,L,t),e(l,Sl,t),J(D,l,t),e(l,Wl,t),e(l,O,t),e(l,Gl,t),e(l,P,t),e(l,vl,t),e(l,K,t),e(l,$l,t),e(l,ll,t),e(l,xl,t),J(tl,l,t),e(l,Fl,t),e(l,el,t),Xl=!0},p:Ct,i(l){Xl||(o(c.$$.fragment,l),o(m.$$.fragment,l),o(r.$$.fragment,l),o(g.$$.fragment,l),o(B.$$.fragment,l),o(q.$$.fragment,l),o(k.$$.fragment,l),o(A.$$.fragment,l),o(R.$$.fragment,l),o(S.$$.fragment,l),o($.$$.fragment,l),o(x.$$.fragment,l),o(Y.$$.fragment,l),o(z.$$.fragment,l),o(D.$$.fragment,l),o(tl.$$.fragment,l),Xl=!0)},o(l){T(c.$$.fragment,l),T(m.$$.fragment,l),T(r.$$.fragment,l),T(g.$$.fragment,l),T(B.$$.fragment,l),T(q.$$.fragment,l),T(k.$$.fragment,l),T(A.$$.fragment,l),T(R.$$.fragment,l),T(S.$$.fragment,l),T($.$$.fragment,l),T(x.$$.fragment,l),T(Y.$$.fragment,l),T(z.$$.fragment,l),T(D.$$.fragment,l),T(tl.$$.fragment,l),Xl=!1},d(l){l&&(s(nl),s(sl),s(al),s(Ml),s(pl),s(il),s(C),s(Ul),s(I),s(yl),s(b),s(Jl),s(d),s(ol),s(h),s(Tl),s(Q),s(jl),s(ul),s(V),s(wl),s(cl),s(f),s(ml),s(rl),s(Cl),s(N),s(Il),s(E),s(bl),s(dl),s(hl),s(_),s(Ql),s(Z),s(gl),s(Vl),s(W),s(Bl),s(G),s(fl),s(v),s(ql),s(kl),s(Nl),s(F),s(El),s(X),s(Al),s(Rl),s(H),s(_l),s(Zl),s(L),s(Sl),s(Wl),s(O),s(Gl),s(P),s(vl),s(K),s($l),s(ll),s(xl),s(Fl),s(el)),s(w),j(c,l),j(m,l),j(r,l),j(g,l),j(B,l),j(q,l),j(k,l),j(A,l),j(R,l),j(S,l),j($,l),j(x,l),j(Y,l),j(z,l),j(D,l),j(tl,l)}}}const qt='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"에이전트 만들기","local":"build-our-agent","sections":[],"depth":3},{"title":"레벨 업: 테이블 조인","local":"level-2-table-joins","sections":[],"depth":3}],"depth":1}';function kt(Hl){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends bt{constructor(w){super(),dt(this,w,kt,ft,rt,{})}}export{Zt as component};
