import{s as gl,o as kl,n as el}from"../chunks/scheduler.85c25b89.js";import{S as $l,i as Wl,g as o,s as n,r as M,A as vl,h as T,f as t,c as i,j as _l,u as d,x as p,k as ll,y as Al,a,v as w,d as y,t as h,w as u}from"../chunks/index.c9bcf812.js";import{T as Ke}from"../chunks/Tip.d8f753fa.js";import{C as _}from"../chunks/CodeBlock.c004bd26.js";import{H as A}from"../chunks/getInferenceSnippets.f73e27a5.js";function zl(B){let s,b="All the example scripts provided in the optimum-neuron repo have those features implemented via the <code>NeuronTrainer</code>.";return{c(){s=o("p"),s.innerHTML=b},l(m){s=T(m,"P",{"data-svelte-h":!0}),p(s)!=="svelte-18pumv8"&&(s.innerHTML=b)},m(m,J){a(m,s,J)},p:el,d(m){m&&t(s)}}}function Zl(B){let s,b=`Since the example scripts use the <code>NeuronTrainer</code>, you can enable ZeRO-1 when using them by add the <code>--zero_1</code> flag
to your command line.`,m,J,I="For example:",f,c,j;return c=new _({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMGV4YW1wbGVzJTJGbGFuZ3VhZ2UtbW9kZWxpbmclMkZydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBUaW55TGxhbWElMkZUaW55TGxhbWEtMS4xQi1DaGF0LXYwLjYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmYxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0temVyb18xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwbXlfdHJhaW5pbmclMkYlMEE=",highlighted:`torchrun --nproc_per_node=2 examples/language-modeling/run_clm.py \\
    --model_name_or_path TinyLlama/TinyLlama-1.1B-Chat-v0.6 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --zero_1 \\
    --output_dir my_training/
`,wrap:!1}}),{c(){s=o("p"),s.innerHTML=b,m=n(),J=o("p"),J.textContent=I,f=n(),M(c.$$.fragment)},l(r){s=T(r,"P",{"data-svelte-h":!0}),p(s)!=="svelte-1971m31"&&(s.innerHTML=b),m=i(r),J=T(r,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1gkqha7"&&(J.textContent=I),f=i(r),d(c.$$.fragment,r)},m(r,U){a(r,s,U),a(r,m,U),a(r,J,U),a(r,f,U),w(c,r,U),j=!0},p:el,i(r){j||(y(c.$$.fragment,r),j=!0)},o(r){h(c.$$.fragment,r),j=!1},d(r){r&&(t(s),t(m),t(J),t(f)),u(c,r)}}}function Rl(B){let s,b=`Since the example scripts use the <code>NeuronTrainer</code>, you can enable Tensor Parallelism when using them by specifying the <code>--tensor_parallel_size</code> argument, and optionally the <code>disable_embedding_parallelization</code> and <code>disable_sequence_parallel</code> flags.
to your command line.`,m,J,I="For example:",f,c,j;return c=new _({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMGV4YW1wbGVzJTJGbGFuZ3VhZ2UtbW9kZWxpbmclMkZydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBUaW55TGxhbWElMkZUaW55TGxhbWEtMS4xQi1DaGF0LXYwLjYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmYxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjAyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwbXlfdHJhaW5pbmclMkY=",highlighted:`torchrun --nproc_per_node=2 examples/language-modeling/run_clm.py \\
    --model_name_or_path TinyLlama/TinyLlama-1.1B-Chat-v0.6 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --tensor_parallel_size 2 \\
    --output_dir my_training/`,wrap:!1}}),{c(){s=o("p"),s.innerHTML=b,m=n(),J=o("p"),J.textContent=I,f=n(),M(c.$$.fragment)},l(r){s=T(r,"P",{"data-svelte-h":!0}),p(s)!=="svelte-ar8hdp"&&(s.innerHTML=b),m=i(r),J=T(r,"P",{"data-svelte-h":!0}),p(J)!=="svelte-1gkqha7"&&(J.textContent=I),f=i(r),d(c.$$.fragment,r)},m(r,U){a(r,s,U),a(r,m,U),a(r,J,U),a(r,f,U),w(c,r,U),j=!0},p:el,i(r){j||(y(c.$$.fragment,r),j=!0)},o(r){h(c.$$.fragment,r),j=!1},d(r){r&&(t(s),t(m),t(J),t(f)),u(c,r)}}}function Cl(B){let s,b="The sharded checkpoints are saved under a directory called <code>tensor_parallel_shards</code>. The <code>optimum-cli neuron consolidate</code> command accept as input both a directory that contains a <code>tensor_parallel_shards</code> directory, or the <code>tensor_parallel_shards</code> directory itself.";return{c(){s=o("p"),s.innerHTML=b},l(m){s=T(m,"P",{"data-svelte-h":!0}),p(s)!=="svelte-1rjmyzp"&&(s.innerHTML=b)},m(m,J){a(m,s,J)},p:el,d(m){m&&t(s)}}}function Xl(B){let s,b,m,J,I,f,c,j='<a href="https://aws.amazon.com/machine-learning/trainium/" rel="nofollow">AWS Trainium instances</a> are great to train models. They can contain up to 16 Neuron devices, each device containing 2 Neuron cores and has 32GB of memory (16GB per core). For example a <code>trn1.32xlarge</code> instance has 32 x 16 = 512GB of memory.',r,U,tl="But there is a caveat: each Neuron core is an independent data-parallel worker by default. It means that the model, the gradient state and the optimizer state, amounting to approximately 4 times the model size, must fit in each of the Neuron cores (16GB) to be able to train. If that is the case, then the activations must also fit in the remaining memory.",ce,z,al="To alleviate that, <code>optimum-neuron</code> supports parallelism features enabling you to harness the full power of your Trainium instance:",Me,Z,nl='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: It is an optimization of data-parallelism which consists in sharding the optimizer state (which usually represents half of the memory needed on the device) over the data-parallel ranks.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: It is a technique which consists in sharding each of your model matrix-multiplications along a given axis (row or column) on multiple devices. It also known as intra-layer model parallelism. The number of devices to shard your parameters on is called the <code>tensor_parallel_size</code>.</li> <li><a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a>: It is an optimization over Tensor Parallelism which shards the activations on the sequence axis outside of the tensor parallel regions. It is useful because it saves memory by sharding the activations.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: It consists in sharding the model block layers on multiple devices. It is also known as inter-layer model parallelism. The number of devices to shard your layers on is called the <code>pipeline_parallel_size</code>.</li>',de,R,il="The good news is that is it possible to combine those techniques, and <code>optimum-neuron</code> makes it very easy!",we,g,ye,C,he,X,rl='Whether you use the <a href="/docs/optimum.neuron/v0.2.2/en/package_reference/trainer#optimum.neuron.NeuronTrainer">NeuronTrainer</a> or decide to have your own training script that uses the <code>NeuronAccelerator</code>, it is very easy to enable the ZeRO-1 optimization.',ue,Q,Ue,G,be,k,fe,V,Ie,N,sl="There is a little bit more work to do when not using the <code>NeuronTrainer</code>:",je,E,ol="<li>(Optional) Wrap the optimizer class to make it lazy. When ZeRO-1 is enabled the original optimizer is overridden to use a sharded version of it. Hence, it is possible to load the original optimizer lazily so that the optimizer state is not materialized until it is actually sharded.</li>",Be,Y,_e,$,Tl="<li>Set the <code>zero_1</code> argument to <code>True</code> when instantiating the <code>NeuronAccelerator</code>.</li>",ge,F,ke,x,$e,H,ml='Just as for ZeRO-1, it is possible to apply Tensor Parallelism either with the <a href="/docs/optimum.neuron/v0.2.2/en/package_reference/trainer#optimum.neuron.NeuronTrainer">NeuronTrainer</a> or the <code>NeuronAccelerator</code>.',We,O,pl="When doing Tensor Parallelism, you have different settings:",ve,L,Jl=`<li>The <code>tensor_parallel_size</code>. Ideally it should be smallest value for which the model fits.</li> <li>Whether or not sequence parallelism should be enabled. <a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a> shards the activations on the sequence axis outside of the tensor parallel regions.
It is useful because it saves memory by sharding the activations.</li> <li>Whether or not parallelization of the embedding layer should be done. By default it is done because it offers multiple benefits:</li>`,Ae,S,cl=`<li>Parallelizing the embedding layer saves memory, which can enable fitting a bigger batch size and/or sequence length.</li> <li>For language models, where the embedding layer weights and the language-modeling head weights are usually tied, the language-modeling head ends up parallel
and does not require to <code>all-gather</code> its output since it is fed to a cross entropy loss compatible with parallelism, saving expensive communication.</li>`,ze,D,Ml="When using distributed training, the training script is called by <code>torchrun</code>, which will dispatch it to workers, one worker per core. Each worker will load the model normally, and then the model will be parallelized across the workers.",Ze,P,Re,q,Ce,W,Xe,K,Qe,ee,dl="Just as for ZeRO-1, it is possible to wrap the optimizer class to make it lazy. Since the model parameters are going to be sharded, it is not needed to materialize the optimizer state prior to model parallelization: the wrapper makes sure that it stays unmaterialized.",Ge,le,Ve,te,Ne,ae,wl="Since Tensor Parallelism consists in sharding the model weights across different workers, only sharded checkpoints will be saved during training. It is necessary to consolidate the sharded checkpoints to be able to share and use them outside of the specific training configuration there were created under.",Ee,ne,yl="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate</code> command:",Ye,ie,Fe,re,hl=`All you need to do is specify the sharded checkpoints directory and the output directory that will contain the consolidated checkpoints, and the command takes care of the rest.
It is also possible to specify the output format of the consolidated checkpoints, by default it will export them to the <code>safetensors</code> format, which is the recommend format to use.`,xe,se,ul="Example:",He,oe,Ul="Training with Tensor Parallelism just completed and the output dir is called <code>my_training</code>. The directory looks like the following:",Oe,Te,Le,me,bl="It is possible to consolidate the sharded checkpoints in <code>my_training/tensor_parallel_shards</code>, which correspond to the sharded checkpoints saved at the end of the training, by running the following command:",Se,pe,De,v,Pe,Je,qe;return I=new A({props:{title:"Distributed Training with optimum-neuron",local:"distributed-training-with-optimum-neuron",headingTag:"h1"}}),g=new Ke({props:{$$slots:{default:[zl]},$$scope:{ctx:B}}}),C=new A({props:{title:"How to enable ZeRO-1?",local:"how-to-enable-zero-1",headingTag:"h2"}}),Q=new A({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),G=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTIzJTIwVG8lMjBlbmFibGUlMjBaZVJPLTElMkMlMjBzZXQlMjB0aGUlMjAlNjB6ZXJvXzElNjAlMjBhcmd1bWVudCUyMHRvJTIwJTYwVHJ1ZSU2MCUyMGluJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMuJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyME5ldXJvblRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHplcm9fMSUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyME5ldXJvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer

<span class="hljs-comment"># To enable ZeRO-1, set the \`zero_1\` argument to \`True\` in the training arguments.</span>
training_args = NeuronTrainingArguments(
    ...,
    zero_1=<span class="hljs-literal">True</span>,
)

trainer = NeuronTrainer(
    model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),k=new Ke({props:{$$slots:{default:[Zl]},$$scope:{ctx:B}}}),V=new A({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),Y=new _({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24uZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBtYWtlX29wdGltaXplcl9jb25zdHJ1Y3Rvcl9sYXp5JTBBJTBBbGF6eV9hZGFtdyUyMCUzRCUyMG1ha2Vfb3B0aW1pemVyX2NvbnN0cnVjdG9yX2xhenkoQWRhbVcp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> make_optimizer_constructor_lazy

lazy_adamw = make_optimizer_constructor_lazy(AdamW)`,wrap:!1}}),F=new _({props:{code:"YWNjZWxlcmF0b3IlMjAlM0QlMjBOZXVyb25BY2NlbGVyYXRvciglMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjB6ZXJvXzElM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwLi4uJTBBbGF6eV9vcHRpbWl6ZXIlMjAlM0QlMjBsYXp5X2FkYW13KC4uLiklMjAlMjMlMjBBY3R1YWxseSUyMGluc3RhbnRpYXRlJTIwdGhlJTIwb3B0aW1pemVyLiUwQSUwQSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZShtb2RlbCUyQyUyMGxhenlfb3B0aW1pemVyKQ==",highlighted:`accelerator = NeuronAccelerator(
    ...
    zero_1=<span class="hljs-literal">True</span>,
)

model = ...
lazy_optimizer = lazy_adamw(...) <span class="hljs-comment"># Actually instantiate the optimizer.</span>


model, optimizer = accelerator.prepare(model, lazy_optimizer)`,wrap:!1}}),x=new A({props:{title:"How to enable Tensor Parallelism?",local:"how-to-enable-tensor-parallelism",headingTag:"h2"}}),P=new A({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),q=new _({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTIzJTIwU3BlY2lmeSUyMHRoZSUyMCU2MHRlbnNvcl9wYXJhbGxlbF9zaXplJTYwJTIwaW4lMjB0aGUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cy4lMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwdGVuc29yX3BhcmFsbGVsX3NpemUlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwZGlzYWJsZV9lbWJlZGRpbmdfcGFyYWxsZWxpemF0aW9uJTNERmFsc2UlMkMlMjAlMjMlMjBJdCUyMGlzJTIwJTYwRmFsc2UlNjAlMjBieSUyMGRlZmF1bHQuJTBBJTIwJTIwJTIwJTIwZGlzYWJsZV9zZXF1ZW5jZV9wYXJhbGxlbCUzREZhbHNlJTJDJTIwJTIzJTIwSXQlMjBpcyUyMCU2MEZhbHNlJTYwJTIwYnklMjBkZWZhdWx0LiUwQSklMEElMEFtb2RlbCUyMCUzRCUyMC4uLiUwQSUwQSUwQXRyYWluZXIlMjAlM0QlMjBOZXVyb25UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfZGF0YXNldCUzRGV2YWxfZGF0YXNldCUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer

<span class="hljs-comment"># Specify the \`tensor_parallel_size\` in the training arguments.</span>
training_args = NeuronTrainingArguments(
    ...,
    tensor_parallel_size=<span class="hljs-number">8</span>,
    disable_embedding_parallelization=<span class="hljs-literal">False</span>, <span class="hljs-comment"># It is \`False\` by default.</span>
    disable_sequence_parallel=<span class="hljs-literal">False</span>, <span class="hljs-comment"># It is \`False\` by default.</span>
)

model = ...


trainer = NeuronTrainer(
    model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),W=new Ke({props:{$$slots:{default:[Rl]},$$scope:{ctx:B}}}),K=new A({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),le=new _({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25BY2NlbGVyYXRvciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5tb2RlbHMudHJhaW5pbmcuY29uZmlnJTIwaW1wb3J0JTIwVHJhaW5pbmdOZXVyb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24uZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBtYWtlX29wdGltaXplcl9jb25zdHJ1Y3Rvcl9sYXp5JTBBJTBBdGVuc29yX3BhcmFsbGVsX3NpemUlMjAlM0QlMjA4JTBBdHJuX2NvbmZpZyUyMCUzRCUyMFRyYWluaW5nTmV1cm9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwcGFyYWxsZWxpemVfZW1iZWRkaW5ncyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzZXF1ZW5jZV9wYXJhbGxlbF9lbmFibGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNoZWNrcG9pbnRfZGlyJTNETm9uZSUyQyUyMCUyMyUyMENhbiUyMGJlJTIwc3BlY2lmaWVkJTIwd2hlbiUyMHJlc3VtaW5nJTIwZnJvbSUyMGNoZWNrcG9pbnQuJTBBKSUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwTmV1cm9uQWNjZWxlcmF0b3IoJTBBJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdHJuX2NvbmZpZyUzRHRybl9jb25maWclMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjAuLi4lMEElMEFsYXp5X2FkYW13JTIwJTNEJTIwbWFrZV9vcHRpbWl6ZXJfY29uc3RydWN0b3JfbGF6eShBZGFtVyklMEFsYXp5X29wdGltaXplciUyMCUzRCUyMGxhenlfYWRhbXcoLi4uKSUyMCUyMyUyMEFjdHVhbGx5JTIwaW5zdGFudGlhdGUlMjB0aGUlMjBvcHRpbWl6ZXIuJTBBJTBBbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwbGF6eV9vcHRpbWl6ZXIp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronAccelerator
<span class="hljs-keyword">from</span> optimum.neuron.models.training.config <span class="hljs-keyword">import</span> TrainingNeuronConfig
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> make_optimizer_constructor_lazy

tensor_parallel_size = <span class="hljs-number">8</span>
trn_config = TrainingNeuronConfig(
    tensor_parallel_size,
    parallelize_embeddings=<span class="hljs-literal">True</span>,
    sequence_parallel_enabled=<span class="hljs-literal">True</span>,
    checkpoint_dir=<span class="hljs-literal">None</span>, <span class="hljs-comment"># Can be specified when resuming from checkpoint.</span>
)

accelerator = NeuronAccelerator(
    ...
    trn_config=trn_config,
)

model = ...

lazy_adamw = make_optimizer_constructor_lazy(AdamW)
lazy_optimizer = lazy_adamw(...) <span class="hljs-comment"># Actually instantiate the optimizer.</span>

model, optimizer = accelerator.prepare(model, lazy_optimizer)`,wrap:!1}}),te=new A({props:{title:"Checkpoint consolidation",local:"checkpoint-consolidation",headingTag:"h3"}}),ie=new _({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMC0taGVscCUwQSUwQXVzYWdlJTNBJTIwb3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMCU1Qi1oJTVEJTIwJTVCLWYlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlNUQlMjBjaGVja3BvaW50X2RpciUyMG91dHB1dF9kaXIlMEElMEFwb3NpdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwY2hlY2twb2ludF9kaXIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBwYXRoJTIwdG8lMjB0aGUlMjBkaXJlY3RvcnklMjBjb250YWluaW5nJTIwdGhlJTIwY2hlY2twb2ludHMuJTBBJTIwJTIwb3V0cHV0X2RpciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRoZSUyMHBhdGglMjB0byUyMHRoZSUyMG91dHB1dCUyMGRpcmVjdG9yeSUyMGNvbnRhaW5pbmclMjB0aGUlMjBjb25zb2xpZGF0ZWQlMjBjaGVja3BvaW50LiUwQSUwQW9wdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwLWglMkMlMjAtLWhlbHAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaG93JTIwdGhpcyUyMGhlbHAlMjBtZXNzYWdlJTIwYW5kJTIwZXhpdCUwQSUyMCUyMC1mJTIwJTdCcHl0b3JjaCUyQ3NhZmV0ZW5zb3JzJTdEJTJDJTIwLS1mb3JtYXQlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBmb3JtYXQlMjB1c2VkJTIwdG8lMjBzYXZlJTIwdGhlJTIwY29uc29saWRhdGVkJTIwY2hlY2twb2ludC4lMEE=",highlighted:`optimum-cli neuron consolidate --help

usage: optimum-cli neuron consolidate [-h] [-f {pytorch,safetensors}] checkpoint_dir output_dir

positional arguments:
  checkpoint_dir        The path to the directory containing the checkpoints.
  output_dir            The path to the output directory containing the consolidated checkpoint.

optional arguments:
  -h, --help            show this help message and <span class="hljs-keyword">exit</span>
  -f {pytorch,safetensors}, --format {pytorch,safetensors}
                        The format used to save the consolidated checkpoint.
`,wrap:!1}}),Te=new _({props:{code:"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",highlighted:`my_training/
├── README.md
├── all_results.json 
├── checkpoint-10 
│   ├── config.json
│   ├── scheduler.pt
│   ├── special_tokens_map.json
│   ├── tensor_parallel_shards
│   ├── tokenizer.json
│   ├── tokenizer.model
│   ├── tokenizer_config.json
│   ├── trainer_state.json
│   └── training_args.bin
├── config.json
├── special_tokens_map.json
├── tensor_parallel_shards
│   ├── tp_rank_00_pp_rank_00
│   ├── tp_rank_01_pp_rank_00
│   ├── tp_rank_02_pp_rank_00
│   ├── tp_rank_03_pp_rank_00
│   ├── tp_rank_04_pp_rank_00
│   ├── tp_rank_05_pp_rank_00
│   ├── tp_rank_06_pp_rank_00
│   └── tp_rank_07_pp_rank_00
├── tokenizer.json
├── tokenizer.model
├── tokenizer_config.json
├── train_results.json
├── trainer_state.json
└── training_args.bin`,wrap:!1}}),pe=new _({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMG15X3RyYWluaW5nJTIwbXlfdHJhaW5pbmdfY29uc29saWRhdGVkX2NoZWNrcG9pbnQ=",highlighted:"optimum-cli neuron consolidate my_training my_training_consolidated_checkpoint",wrap:!1}}),v=new Ke({props:{$$slots:{default:[Cl]},$$scope:{ctx:B}}}),{c(){s=o("meta"),b=n(),m=o("p"),J=n(),M(I.$$.fragment),f=n(),c=o("p"),c.innerHTML=j,r=n(),U=o("p"),U.textContent=tl,ce=n(),z=o("p"),z.innerHTML=al,Me=n(),Z=o("ol"),Z.innerHTML=nl,de=n(),R=o("p"),R.innerHTML=il,we=n(),M(g.$$.fragment),ye=n(),M(C.$$.fragment),he=n(),X=o("p"),X.innerHTML=rl,ue=n(),M(Q.$$.fragment),Ue=n(),M(G.$$.fragment),be=n(),M(k.$$.fragment),fe=n(),M(V.$$.fragment),Ie=n(),N=o("p"),N.innerHTML=sl,je=n(),E=o("ol"),E.innerHTML=ol,Be=n(),M(Y.$$.fragment),_e=n(),$=o("ol"),$.innerHTML=Tl,ge=n(),M(F.$$.fragment),ke=n(),M(x.$$.fragment),$e=n(),H=o("p"),H.innerHTML=ml,We=n(),O=o("p"),O.textContent=pl,ve=n(),L=o("ol"),L.innerHTML=Jl,Ae=n(),S=o("ul"),S.innerHTML=cl,ze=n(),D=o("p"),D.innerHTML=Ml,Ze=n(),M(P.$$.fragment),Re=n(),M(q.$$.fragment),Ce=n(),M(W.$$.fragment),Xe=n(),M(K.$$.fragment),Qe=n(),ee=o("p"),ee.textContent=dl,Ge=n(),M(le.$$.fragment),Ve=n(),M(te.$$.fragment),Ne=n(),ae=o("p"),ae.textContent=wl,Ee=n(),ne=o("p"),ne.innerHTML=yl,Ye=n(),M(ie.$$.fragment),Fe=n(),re=o("p"),re.innerHTML=hl,xe=n(),se=o("p"),se.textContent=ul,He=n(),oe=o("p"),oe.innerHTML=Ul,Oe=n(),M(Te.$$.fragment),Le=n(),me=o("p"),me.innerHTML=bl,Se=n(),M(pe.$$.fragment),De=n(),M(v.$$.fragment),Pe=n(),Je=o("p"),this.h()},l(e){const l=vl("svelte-u9bgzb",document.head);s=T(l,"META",{name:!0,content:!0}),l.forEach(t),b=i(e),m=T(e,"P",{}),_l(m).forEach(t),J=i(e),d(I.$$.fragment,e),f=i(e),c=T(e,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1cdv2fm"&&(c.innerHTML=j),r=i(e),U=T(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-trqv6g"&&(U.textContent=tl),ce=i(e),z=T(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1rlk2kz"&&(z.innerHTML=al),Me=i(e),Z=T(e,"OL",{"data-svelte-h":!0}),p(Z)!=="svelte-pdytp0"&&(Z.innerHTML=nl),de=i(e),R=T(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-ogaike"&&(R.innerHTML=il),we=i(e),d(g.$$.fragment,e),ye=i(e),d(C.$$.fragment,e),he=i(e),X=T(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1of2pif"&&(X.innerHTML=rl),ue=i(e),d(Q.$$.fragment,e),Ue=i(e),d(G.$$.fragment,e),be=i(e),d(k.$$.fragment,e),fe=i(e),d(V.$$.fragment,e),Ie=i(e),N=T(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-la2f2b"&&(N.innerHTML=sl),je=i(e),E=T(e,"OL",{"data-svelte-h":!0}),p(E)!=="svelte-6khx73"&&(E.innerHTML=ol),Be=i(e),d(Y.$$.fragment,e),_e=i(e),$=T(e,"OL",{start:!0,"data-svelte-h":!0}),p($)!=="svelte-1ufjyew"&&($.innerHTML=Tl),ge=i(e),d(F.$$.fragment,e),ke=i(e),d(x.$$.fragment,e),$e=i(e),H=T(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1bwvnvj"&&(H.innerHTML=ml),We=i(e),O=T(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-c14p9h"&&(O.textContent=pl),ve=i(e),L=T(e,"OL",{"data-svelte-h":!0}),p(L)!=="svelte-gly1sh"&&(L.innerHTML=Jl),Ae=i(e),S=T(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-19rx9yl"&&(S.innerHTML=cl),ze=i(e),D=T(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1uoalmz"&&(D.innerHTML=Ml),Ze=i(e),d(P.$$.fragment,e),Re=i(e),d(q.$$.fragment,e),Ce=i(e),d(W.$$.fragment,e),Xe=i(e),d(K.$$.fragment,e),Qe=i(e),ee=T(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1gks0nu"&&(ee.textContent=dl),Ge=i(e),d(le.$$.fragment,e),Ve=i(e),d(te.$$.fragment,e),Ne=i(e),ae=T(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-rvqzxu"&&(ae.textContent=wl),Ee=i(e),ne=T(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-24042q"&&(ne.innerHTML=yl),Ye=i(e),d(ie.$$.fragment,e),Fe=i(e),re=T(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1xib7ue"&&(re.innerHTML=hl),xe=i(e),se=T(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-11lpom8"&&(se.textContent=ul),He=i(e),oe=T(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-u3s5ug"&&(oe.innerHTML=Ul),Oe=i(e),d(Te.$$.fragment,e),Le=i(e),me=T(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-14t9mzj"&&(me.innerHTML=bl),Se=i(e),d(pe.$$.fragment,e),De=i(e),d(v.$$.fragment,e),Pe=i(e),Je=T(e,"P",{}),_l(Je).forEach(t),this.h()},h(){ll(s,"name","hf:doc:metadata"),ll(s,"content",Ql),ll($,"start","2")},m(e,l){Al(document.head,s),a(e,b,l),a(e,m,l),a(e,J,l),w(I,e,l),a(e,f,l),a(e,c,l),a(e,r,l),a(e,U,l),a(e,ce,l),a(e,z,l),a(e,Me,l),a(e,Z,l),a(e,de,l),a(e,R,l),a(e,we,l),w(g,e,l),a(e,ye,l),w(C,e,l),a(e,he,l),a(e,X,l),a(e,ue,l),w(Q,e,l),a(e,Ue,l),w(G,e,l),a(e,be,l),w(k,e,l),a(e,fe,l),w(V,e,l),a(e,Ie,l),a(e,N,l),a(e,je,l),a(e,E,l),a(e,Be,l),w(Y,e,l),a(e,_e,l),a(e,$,l),a(e,ge,l),w(F,e,l),a(e,ke,l),w(x,e,l),a(e,$e,l),a(e,H,l),a(e,We,l),a(e,O,l),a(e,ve,l),a(e,L,l),a(e,Ae,l),a(e,S,l),a(e,ze,l),a(e,D,l),a(e,Ze,l),w(P,e,l),a(e,Re,l),w(q,e,l),a(e,Ce,l),w(W,e,l),a(e,Xe,l),w(K,e,l),a(e,Qe,l),a(e,ee,l),a(e,Ge,l),w(le,e,l),a(e,Ve,l),w(te,e,l),a(e,Ne,l),a(e,ae,l),a(e,Ee,l),a(e,ne,l),a(e,Ye,l),w(ie,e,l),a(e,Fe,l),a(e,re,l),a(e,xe,l),a(e,se,l),a(e,He,l),a(e,oe,l),a(e,Oe,l),w(Te,e,l),a(e,Le,l),a(e,me,l),a(e,Se,l),w(pe,e,l),a(e,De,l),w(v,e,l),a(e,Pe,l),a(e,Je,l),qe=!0},p(e,[l]){const fl={};l&2&&(fl.$$scope={dirty:l,ctx:e}),g.$set(fl);const Il={};l&2&&(Il.$$scope={dirty:l,ctx:e}),k.$set(Il);const jl={};l&2&&(jl.$$scope={dirty:l,ctx:e}),W.$set(jl);const Bl={};l&2&&(Bl.$$scope={dirty:l,ctx:e}),v.$set(Bl)},i(e){qe||(y(I.$$.fragment,e),y(g.$$.fragment,e),y(C.$$.fragment,e),y(Q.$$.fragment,e),y(G.$$.fragment,e),y(k.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(F.$$.fragment,e),y(x.$$.fragment,e),y(P.$$.fragment,e),y(q.$$.fragment,e),y(W.$$.fragment,e),y(K.$$.fragment,e),y(le.$$.fragment,e),y(te.$$.fragment,e),y(ie.$$.fragment,e),y(Te.$$.fragment,e),y(pe.$$.fragment,e),y(v.$$.fragment,e),qe=!0)},o(e){h(I.$$.fragment,e),h(g.$$.fragment,e),h(C.$$.fragment,e),h(Q.$$.fragment,e),h(G.$$.fragment,e),h(k.$$.fragment,e),h(V.$$.fragment,e),h(Y.$$.fragment,e),h(F.$$.fragment,e),h(x.$$.fragment,e),h(P.$$.fragment,e),h(q.$$.fragment,e),h(W.$$.fragment,e),h(K.$$.fragment,e),h(le.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),h(Te.$$.fragment,e),h(pe.$$.fragment,e),h(v.$$.fragment,e),qe=!1},d(e){e&&(t(b),t(m),t(J),t(f),t(c),t(r),t(U),t(ce),t(z),t(Me),t(Z),t(de),t(R),t(we),t(ye),t(he),t(X),t(ue),t(Ue),t(be),t(fe),t(Ie),t(N),t(je),t(E),t(Be),t(_e),t($),t(ge),t(ke),t($e),t(H),t(We),t(O),t(ve),t(L),t(Ae),t(S),t(ze),t(D),t(Ze),t(Re),t(Ce),t(Xe),t(Qe),t(ee),t(Ge),t(Ve),t(Ne),t(ae),t(Ee),t(ne),t(Ye),t(Fe),t(re),t(xe),t(se),t(He),t(oe),t(Oe),t(Le),t(me),t(Se),t(De),t(Pe),t(Je)),t(s),u(I,e),u(g,e),u(C,e),u(Q,e),u(G,e),u(k,e),u(V,e),u(Y,e),u(F,e),u(x,e),u(P,e),u(q,e),u(W,e),u(K,e),u(le,e),u(te,e),u(ie,e),u(Te,e),u(pe,e),u(v,e)}}}const Ql='{"title":"Distributed Training with optimum-neuron","local":"distributed-training-with-optimum-neuron","sections":[{"title":"How to enable ZeRO-1?","local":"how-to-enable-zero-1","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3}],"depth":2},{"title":"How to enable Tensor Parallelism?","local":"how-to-enable-tensor-parallelism","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3},{"title":"Checkpoint consolidation","local":"checkpoint-consolidation","sections":[],"depth":3}],"depth":2}],"depth":1}';function Gl(B){return kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xl extends $l{constructor(s){super(),Wl(this,s,Gl,Xl,gl,{})}}export{xl as component};
