import{s as Ee,a as ke,n as qe,o as Qe}from"../chunks/scheduler.56725da7.js";import{S as Re,i as Ye,e as s,s as l,c as r,h as ze,a as o,d as n,b as a,f as $e,g as p,j as f,k as y,l as Je,m as i,n as m,t as u,o as c,p as h}from"../chunks/index.18a26576.js";import{C as Fe}from"../chunks/CopyLLMTxtMenu.d7849104.js";import{D as He}from"../chunks/Docstring.d363b5ed.js";import{C as ve}from"../chunks/CodeBlock.446b613c.js";import{H as k}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.6e374671.js";function De(je){let d,Y,Q,z,w,F,x,D,T,O,$,Ue='<a href="https://huggingface.co/papers/2403.04692" rel="nofollow">PixArt-Σ: Weak-to-Strong Training of Diffusion Transformer for 4K Text-to-Image Generation</a> is Junsong Chen, Jincheng Yu, Chongjian Ge, Lewei Yao, Enze Xie, Yue Wu, Zhongdao Wang, James Kwok, Ping Luo, Huchuan Lu, and Zhenguo Li.',K,_,Xe="Some notes about this pipeline:",ee,J,Ie='<li>It uses a Transformer backbone (instead of a UNet) for denoising. As such it has a similar architecture as <a href="https://hf.co/docs/transformers/model_doc/dit" rel="nofollow">DiT</a>.</li> <li>It was trained using text conditions computed from T5. This aspect makes the pipeline better at following complex text prompts with intricate details.</li> <li>It is good at producing high-resolution images at different aspect ratios. To get the best results, the authors recommend some size brackets which can be found <a href="https://github.com/PixArt-alpha/PixArt-sigma/blob/master/diffusion/data/datasets/utils.py" rel="nofollow">here</a>.</li> <li>It rivals the quality of state-of-the-art text-to-image generation systems (as of this writing) such as PixArt-α, Stable Diffusion XL, Playground V2.0 and DALL-E 3, while being more efficient than them.</li> <li>It shows the ability of generating super high resolution images, such as 2048px or even 4K.</li> <li>It shows that text-to-image models can grow from a weak model to a stronger one through several improvements (VAEs, datasets, and so on.)</li>',te,v,Ce="🤗 <code>Optimum</code> extends <code>Diffusers</code> to support inference on the second generation of Neuron devices(powering Trainium and Inferentia 2). It aims at inheriting the ease of Diffusers on Neuron.",ne,j,ie,U,Pe="To deploy models in the PixArt-Σ pipeline, you will need to compile them to TorchScript optimized for AWS Neuron. There are four components which need to be exported to the <code>.neuron</code> format to boost the performance:",le,X,Ge="<li>Text encoder</li> <li>Transformer</li> <li>VAE encoder</li> <li>VAE decoder</li>",ae,I,Ae="You can either compile and export a PixArt-Σ Checkpoint via CLI or <code>NeuronPixArtSigmaPipeline</code> class.",se,C,oe,P,re,b,Be="<p>We recommend using a <code>inf2.8xlarge</code> or a larger instance for the model compilation. You will also be able to compile the model with the Optimum CLI on a CPU-only instance (needs ~35 GB memory), and then run the pre-compiled model on <code>inf2.xlarge</code> to reduce the expenses. In this case, don’t forget to disable validation of inference by adding the <code>--disable-validation</code> argument.</p>",pe,G,me,A,ue,B,ce,W,We="<code>NeuronPixArtSigmaPipeline</code> class allows you to generate images from a text prompt on neuron devices similar to the experience with <code>Diffusers</code>.",he,V,Ve="With pre-compiled PixArt-Σ models, now generate an image with a prompt on Neuron:",fe,S,de,g,Se,ge,L,Me,N,Le="Pipeline for text-to-image generation using PixArt-Σ.",ye,M,Z,_e,q,H,be,E,Ne='Are there any other diffusion features that you want us to support in 🤗<code>Optimum-neuron</code>? Please file an issue to <a href="https://github.com/huggingface/optimum-neuron" rel="nofollow"><code>Optimum-neuron</code> Github repo</a> or discuss with us on <a href="https://discuss.huggingface.co/c/optimum/" rel="nofollow">HuggingFace’s community forum</a>, cheers 🤗 !',we,R,xe;return w=new Fe({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),x=new k({props:{title:"PixArt-Σ",local:"pixart-σ",headingTag:"h1"}}),T=new k({props:{title:"Overview",local:"overview",headingTag:"h2"}}),j=new k({props:{title:"Export to Neuron",local:"export-to-neuron",headingTag:"h2"}}),C=new k({props:{title:"Option 1: CLI",local:"option-1-cli",headingTag:"h3"}}),P=new ve({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBuZXVyb24lMjAtLW1vZGVsJTIwSmluZ3lhJTJGcGl4YXJ0X3NpZ21hX3BpcGVfeGxfMl81MTJfbXMlMjAtLWJhdGNoX3NpemUlMjAxJTIwLS1oZWlnaHQlMjA1MTIlMjAtLXdpZHRoJTIwNTEyJTIwLS1udW1faW1hZ2VzX3Blcl9wcm9tcHQlMjAxJTIwLS10b3JjaF9kdHlwZSUyMGJmbG9hdDE2JTIwLS1zZXF1ZW5jZV9sZW5ndGglMjAxMjAlMjBwaXhhcnRfc2lnbWFfbmV1cm9uXzUxMiUyRg==",highlighted:'optimum-cli <span class="hljs-built_in">export</span> neuron --model Jingya/pixart_sigma_pipe_xl_2_512_ms --batch_size 1 --height 512 --width 512 --num_images_per_prompt 1 --torch_dtype bfloat16 --sequence_length 120 pixart_sigma_neuron_512/',wrap:!1}}),G=new k({props:{title:"Option 2: Python API",local:"option-2-python-api",headingTag:"h3"}}),A=new ve({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25QaXhBcnRTaWdtYVBpcGVsaW5lJTBBJTBBJTIzJTIwQ29tcGlsZSUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJhdXRvX2Nhc3QlMjIlM0ElMjAlMjJub25lJTIyJTdEJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJoZWlnaHQlMjIlM0ElMjA1MTIlMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDUxMiUyQyUyMCUyMnNlcXVlbmNlX2xlbmd0aCUyMiUzQSUyMDEyMCU3RCUwQSUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvblBpeEFydFNpZ21hUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRnBpeGFydF9zaWdtYV9waXBlX3hsXzJfNTEyX21zJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjBkaXNhYmxlX25ldXJvbl9jYWNoZSUzRFRydWUlMkMlMjAqKmNvbXBpbGVyX2FyZ3MlMkMlMjAqKmlucHV0X3NoYXBlcyklMEElMEElMjMlMjBTYXZlJTIwbG9jYWxseSUwQW5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIycGl4YXJ0X3NpZ21hX25ldXJvbl81MTIlMkYlMjIpJTBBJTBBJTIzJTIwVXBsb2FkJTIwdG8lMjB0aGUlMjBIdWdnaW5nRmFjZSUyMEh1YiUwQW5ldXJvbl9tb2RlbC5wdXNoX3RvX2h1YiglMEElMjAlMjAlMjAlMjAlMjJwaXhhcnRfc2lnbWFfbmV1cm9uXzUxMiUyRiUyMiUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJvcHRpbXVtJTJGcGl4YXJ0X3NpZ21hX3BpcGVfeGxfMl81MTJfbXNfbmV1cm9ueCUyMiUyMCUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIweW91ciUyMEhGJTIwSHViJTIwcmVwbyUyMGlkJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronPixArtSigmaPipeline

<span class="hljs-comment"># Compile</span>
compiler_args = {<span class="hljs-string">&quot;auto_cast&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">512</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">120</span>}

neuron_model = NeuronPixArtSigmaPipeline.from_pretrained(<span class="hljs-string">&quot;Jingya/pixart_sigma_pipe_xl_2_512_ms&quot;</span>, torch_dtype=torch.bfloat16, export=<span class="hljs-literal">True</span>, disable_neuron_cache=<span class="hljs-literal">True</span>, **compiler_args, **input_shapes)

<span class="hljs-comment"># Save locally</span>
neuron_model.save_pretrained(<span class="hljs-string">&quot;pixart_sigma_neuron_512/&quot;</span>)

<span class="hljs-comment"># Upload to the HuggingFace Hub</span>
neuron_model.push_to_hub(
    <span class="hljs-string">&quot;pixart_sigma_neuron_512/&quot;</span>, repository_id=<span class="hljs-string">&quot;optimum/pixart_sigma_pipe_xl_2_512_ms_neuronx&quot;</span>  <span class="hljs-comment"># Replace with your HF Hub repo id</span>
)`,wrap:!1}}),B=new k({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h2"}}),S=new ve({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uUGl4QXJ0U2lnbWFQaXBlbGluZSUwQSUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvblBpeEFydFNpZ21hUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnBpeGFydF9zaWdtYV9uZXVyb25fNTEyJTJGJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMk9wcGVuaGVpbWVyJTIwc2l0cyUyMG9uJTIwdGhlJTIwYmVhY2glMjBvbiUyMGElMjBjaGFpciUyQyUyMHdhdGNoaW5nJTIwYSUyMG51Y2xlYXIlMjBleHBvc2l0aW9uJTIwd2l0aCUyMGElMjBodWdlJTIwbXVzaHJvb20lMjBjbG91ZCUyQyUyMDEyMG1tLiUyMiUwQWltYWdlJTIwJTNEJTIwbmV1cm9uX21vZGVsKHByb21wdCUzRHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronPixArtSigmaPipeline

neuron_model = NeuronPixArtSigmaPipeline.from_pretrained(<span class="hljs-string">&quot;pixart_sigma_neuron_512/&quot;</span>)
prompt = <span class="hljs-string">&quot;Oppenheimer sits on the beach on a chair, watching a nuclear exposition with a huge mushroom cloud, 120mm.&quot;</span>
image = neuron_model(prompt=prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),L=new k({props:{title:"NeuronPixArtSigmaPipeline",local:"optimum.neuron.NeuronPixArtSigmaPipeline",headingTag:"h2"}}),Z=new He({props:{name:"class optimum.neuron.NeuronPixArtSigmaPipeline",anchor:"optimum.neuron.NeuronPixArtSigmaPipeline",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.0/optimum/neuron/modeling_diffusion.py#L1588"}}),H=new He({props:{name:"__call__",anchor:"optimum.neuron.NeuronPixArtSigmaPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.4.0/optimum/neuron/modeling_diffusion.py#L1106"}}),{c(){d=s("meta"),Y=l(),Q=s("p"),z=l(),r(w.$$.fragment),F=l(),r(x.$$.fragment),D=l(),r(T.$$.fragment),O=l(),$=s("p"),$.innerHTML=Ue,K=l(),_=s("p"),_.textContent=Xe,ee=l(),J=s("ul"),J.innerHTML=Ie,te=l(),v=s("p"),v.innerHTML=Ce,ne=l(),r(j.$$.fragment),ie=l(),U=s("p"),U.innerHTML=Pe,le=l(),X=s("ul"),X.innerHTML=Ge,ae=l(),I=s("p"),I.innerHTML=Ae,se=l(),r(C.$$.fragment),oe=l(),r(P.$$.fragment),re=l(),b=s("blockquote"),b.innerHTML=Be,pe=l(),r(G.$$.fragment),me=l(),r(A.$$.fragment),ue=l(),r(B.$$.fragment),ce=l(),W=s("p"),W.innerHTML=We,he=l(),V=s("p"),V.textContent=Ve,fe=l(),r(S.$$.fragment),de=l(),g=s("img"),ge=l(),r(L.$$.fragment),Me=l(),N=s("p"),N.textContent=Le,ye=l(),M=s("div"),r(Z.$$.fragment),_e=l(),q=s("div"),r(H.$$.fragment),be=l(),E=s("p"),E.innerHTML=Ne,we=l(),R=s("p"),this.h()},l(e){const t=ze("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(n),Y=a(e),Q=o(e,"P",{}),$e(Q).forEach(n),z=a(e),p(w.$$.fragment,e),F=a(e),p(x.$$.fragment,e),D=a(e),p(T.$$.fragment,e),O=a(e),$=o(e,"P",{"data-svelte-h":!0}),f($)!=="svelte-1i25npg"&&($.innerHTML=Ue),K=a(e),_=o(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-v1sn1g"&&(_.textContent=Xe),ee=a(e),J=o(e,"UL",{"data-svelte-h":!0}),f(J)!=="svelte-8ca6jo"&&(J.innerHTML=Ie),te=a(e),v=o(e,"P",{"data-svelte-h":!0}),f(v)!=="svelte-1g87d8z"&&(v.innerHTML=Ce),ne=a(e),p(j.$$.fragment,e),ie=a(e),U=o(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-1rwzdir"&&(U.innerHTML=Pe),le=a(e),X=o(e,"UL",{"data-svelte-h":!0}),f(X)!=="svelte-bwcnjm"&&(X.innerHTML=Ge),ae=a(e),I=o(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1r6trkt"&&(I.innerHTML=Ae),se=a(e),p(C.$$.fragment,e),oe=a(e),p(P.$$.fragment,e),re=a(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),f(b)!=="svelte-6gfoqi"&&(b.innerHTML=Be),pe=a(e),p(G.$$.fragment,e),me=a(e),p(A.$$.fragment,e),ue=a(e),p(B.$$.fragment,e),ce=a(e),W=o(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-afe7pm"&&(W.innerHTML=We),he=a(e),V=o(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-t9any9"&&(V.textContent=Ve),fe=a(e),p(S.$$.fragment,e),de=a(e),g=o(e,"IMG",{src:!0,width:!0,height:!0,alt:!0}),ge=a(e),p(L.$$.fragment,e),Me=a(e),N=o(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-13ua61c"&&(N.textContent=Le),ye=a(e),M=o(e,"DIV",{class:!0});var Te=$e(M);p(Z.$$.fragment,Te),_e=a(Te),q=o(Te,"DIV",{class:!0});var Ze=$e(q);p(H.$$.fragment,Ze),Ze.forEach(n),Te.forEach(n),be=a(e),E=o(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1wos5lv"&&(E.innerHTML=Ne),we=a(e),R=o(e,"P",{}),$e(R).forEach(n),this.h()},h(){y(d,"name","hf:doc:metadata"),y(d,"content",Oe),y(b,"class","tip"),ke(g.src,Se="https://huggingface.co/datasets/Jingya/document_images/resolve/main/optimum/neuron/pixart-sigma-oppenheimer.png")||y(g,"src",Se),y(g,"width","256"),y(g,"height","256"),y(g,"alt","PixArt-Σ generated image."),y(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),y(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){Je(document.head,d),i(e,Y,t),i(e,Q,t),i(e,z,t),m(w,e,t),i(e,F,t),m(x,e,t),i(e,D,t),m(T,e,t),i(e,O,t),i(e,$,t),i(e,K,t),i(e,_,t),i(e,ee,t),i(e,J,t),i(e,te,t),i(e,v,t),i(e,ne,t),m(j,e,t),i(e,ie,t),i(e,U,t),i(e,le,t),i(e,X,t),i(e,ae,t),i(e,I,t),i(e,se,t),m(C,e,t),i(e,oe,t),m(P,e,t),i(e,re,t),i(e,b,t),i(e,pe,t),m(G,e,t),i(e,me,t),m(A,e,t),i(e,ue,t),m(B,e,t),i(e,ce,t),i(e,W,t),i(e,he,t),i(e,V,t),i(e,fe,t),m(S,e,t),i(e,de,t),i(e,g,t),i(e,ge,t),m(L,e,t),i(e,Me,t),i(e,N,t),i(e,ye,t),i(e,M,t),m(Z,M,null),Je(M,_e),Je(M,q),m(H,q,null),i(e,be,t),i(e,E,t),i(e,we,t),i(e,R,t),xe=!0},p:qe,i(e){xe||(u(w.$$.fragment,e),u(x.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(C.$$.fragment,e),u(P.$$.fragment,e),u(G.$$.fragment,e),u(A.$$.fragment,e),u(B.$$.fragment,e),u(S.$$.fragment,e),u(L.$$.fragment,e),u(Z.$$.fragment,e),u(H.$$.fragment,e),xe=!0)},o(e){c(w.$$.fragment,e),c(x.$$.fragment,e),c(T.$$.fragment,e),c(j.$$.fragment,e),c(C.$$.fragment,e),c(P.$$.fragment,e),c(G.$$.fragment,e),c(A.$$.fragment,e),c(B.$$.fragment,e),c(S.$$.fragment,e),c(L.$$.fragment,e),c(Z.$$.fragment,e),c(H.$$.fragment,e),xe=!1},d(e){e&&(n(Y),n(Q),n(z),n(F),n(D),n(O),n($),n(K),n(_),n(ee),n(J),n(te),n(v),n(ne),n(ie),n(U),n(le),n(X),n(ae),n(I),n(se),n(oe),n(re),n(b),n(pe),n(me),n(ue),n(ce),n(W),n(he),n(V),n(fe),n(de),n(g),n(ge),n(Me),n(N),n(ye),n(M),n(be),n(E),n(we),n(R)),n(d),h(w,e),h(x,e),h(T,e),h(j,e),h(C,e),h(P,e),h(G,e),h(A,e),h(B,e),h(S,e),h(L,e),h(Z),h(H)}}}const Oe='{"title":"PixArt-Σ","local":"pixart-σ","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Export to Neuron","local":"export-to-neuron","sections":[{"title":"Option 1: CLI","local":"option-1-cli","sections":[],"depth":3},{"title":"Option 2: Python API","local":"option-2-python-api","sections":[],"depth":3}],"depth":2},{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":2},{"title":"NeuronPixArtSigmaPipeline","local":"optimum.neuron.NeuronPixArtSigmaPipeline","sections":[],"depth":2}],"depth":1}';function Ke(je){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class st extends Re{constructor(d){super(),Ye(this,d,Ke,De,Ee,{})}}export{st as component};
