# 🤗 Optimum Neuron

🤗 Optimum Neuron is the interface between the 🤗 Transformers library and AWS Accelerators including [AWS Trainium](https://aws.amazon.com/machine-learning/trainium/?nc1=h_ls) and [AWS Inferentia](https://aws.amazon.com/machine-learning/inferentia/?nc1=h_ls).
It provides a set of tools enabling easy model loading, training and inference on single- and multi-Accelerator settings for different downstream tasks.
The list of officially validated models and tasks is available [here](https://huggingface.co/docs/optimum-neuron/package_reference/configuration#supported-architectures).

<div class="mt-10">
  <div class="w-full flex flex-col space-y-4 md:space-y-0 md:grid md:grid-cols-2 md:gap-y-4 md:gap-x-5">
    <a
      class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg"
      href="./tutorials/fine_tune_bert"
    >
      <div class="w-full text-center bg-gradient-to-br from-blue-400 to-blue-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">
        Tutorials
      </div>
      <p class="text-gray-700">
        Learn the basics and become familiar with training & deploying transformers on AWS Trainium and AWS Inferentia.
        Start here if you are using 🤗 Optimum Neuron for the first time!
      </p>
    </a>
    <a class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" href="./guides/setup_aws_instance">
      <div class="w-full text-center bg-gradient-to-br from-indigo-400 to-indigo-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">
        How-to guides
      </div>
      <p class="text-gray-700">
        Practical guides to help you achieve a specific goal. Take a look at these guides to learn how to use 🤗 Optimum
        Neuron to solve real-world problems.
      </p>
    </a>
    <a
      class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg"
      href="./package_reference/trainer"
    >
      <div class="w-full text-center bg-gradient-to-br from-purple-400 to-purple-500 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">
        Reference
      </div>
      <p class="text-gray-700">Technical descriptions of how the classes and methods of 🤗 Optimum Neuron work.</p>
    </a>
    <a
      class="!no-underline border dark:border-gray-700 p-5 rounded-lg shadow hover:shadow-lg" 
      onclick="event.preventDefault(); window.open('https://huggingface.co/datasets/sanhitsa/AWS-White-Papers-and-Blogs/resolve/main/Whitepaper-Scale-production-AI-with-Hugging-Face-Optimum-Neuron-and-AWS-Trainium-and-Inferentia.pdf', '_blank');"
    >
      <div 
        class="w-full text-center bg-gradient-to-br from-red-600 to-red-600 rounded-lg py-1.5 font-semibold mb-5 text-white text-lg leading-relaxed">
        White Paper 
      </div>
      <p 
        class="text-gray-700">To learn more about how Optimum Neuron and AWS Inferentia and Trainium are being used by companies, read the White Paper.
      </p>
    </a>
  </div>
</div>