import{s as gn,a as _,n as dn,o as fn}from"../chunks/scheduler.4048030c.js";import{S as un,i as vn,e as l,s as n,c as d,r as c,H as I,h as yn,a as o,d as e,b as i,f as E,g as f,j as p,u as h,v as K,k as m,q as w,l as r,m as a,n as u,t as v,o as y,p as b}from"../chunks/index.30ed9803.js";import{C as bn,H as k,E as wn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.38ad0808.js";function xn(Ye){let C,at,Zs,nt,W,it,U,lt,N,Ze="In this section, we’ll build a foundation in classical robotics that will help you understand why learning-based methods are so powerful.",ot,X,sa="We’ll start by exploring how robots generate motion, look at common types of robot movement, and work through a concrete example before discussing the limitations that motivate modern approaches.",pt,x,V,Se,Qs,ta="Learning-based approaches to robotics address fundamental challenges that traditional methods struggle with.",Fe,Ws,ea="Modern robotics needs methods that can work across different tasks and robot types, allowing one approach to work effectively in many situations rather than requiring custom solutions for each problem. We also need to reduce our dependency on human experts who manually design rules and models for every situation. Finally, the field needs approaches that can take advantage of the rapidly growing collection of robotics datasets, learning from the collective knowledge captured in these large-scale data collections.",mt,Y,rt,Z,aa="Let’s start with the big picture: how do different approaches make robots move?",ct,D,na,ht,ss,ia="Different methods for generating robot motion can be grouped based on whether they use explicit mathematical models or learn patterns implicitly from data.",gt,ts,la="This is merely an overview of different methods to generate motion, and is clearly non-exhaustive. Still, it provides a good primer on what the most common approaches are in this circumstance. The most important grouping by far depend on whether the different methods explicitly (<em>dynamics-based</em>) or implicitly (<em>learning-based</em>) model robot-environment interactions.",dt,es,oa="Further, knowledge of mechanical, electrical, and software engineering, as well as rigid‑body mechanics and control theory have proven quintessential in robotics since the field first developed in the 1950s. More recently, Machine Learning (ML) has also proved effective in robotics, complementing these more traditional disciplines.",ft,as,pa="As a direct consequence of its multi‑disciplinary nature (to the very least, combining hardware and software), robotics has developed as a wide array of methods, all concerned with the main purpose of <strong>producing artificial motion in the physical world</strong>.",ut,ns,ma="In this section, our goal is to introduce where classical methods excel, where they struggle, and why <strong>learning‑based approaches</strong> are helpful.",vt,j,ra="<p><strong>Explicit vs Implicit Models:</strong></p> <p><strong>Implicit (learning-based) approaches</strong> take a fundamentally different strategy by learning patterns directly from data rather than requiring explicit mathematical models. These methods require less domain-specific engineering and can adapt to complex, uncertain environments that would be difficult to model analytically. Neural networks and reinforcement learning algorithms are prime examples of this approach.</p> <p><strong>Explicit (dynamics-based) approaches</strong> rely on hand-crafted mathematical models of physics and require deep domain expertise to be implemented effectively. These methods work exceptionally well for well-understood, controlled scenarios where the physics can be precisely modeled. Classic examples include PID controllers and Model Predictive Control systems that have been the backbone of industrial robotics for decades.</p> <p><strong>Hybrid approaches</strong> represent an exciting middle ground, combining the reliability of physics knowledge with the adaptability of learning systems. These methods use physics knowledge to guide and constrain the learning process, often achieving better performance than either approach alone.</p>",yt,is,bt,ls,ca="Now that we have the big picture, we can situate the problem: what kinds of motion do robots typically perform?",wt,O,ha,xt,os,ga="Different kinds of motions are achieved with potentially very different robotic platforms. From left to right, top to bottom: ViperX, SO-100, Boston Dynamics’ Spot, Open-Duck, 1X’s NEO, Boston Dynamics’ Atlas. This is an example list of robotic platforms and is (very) far from being exhaustive.",kt,ps,da="At a high level, most systems you’ll encounter fall into one of these three categories. Knowing which bucket you’re in helps you choose models, datasets, and controllers appropriately.",$t,ms,fa="In the vast majority of instances, robotics deals with producing motion via actuating joints connecting nearly entirely-rigid links. A key distinction between focus areas in robotics is based on whether the generated motion modifies the absolute state of the environment through dexterous interactions, changes the relative state of the robot with respect to its environment through mobility, or combines both capabilities.",_t,rs,ua="<strong>Manipulation</strong> involves generating motion to perform actions that induce desirable modifications in the environment. These effects are typically achieved <em>through</em> the robot - for example, a robotic arm grasping objects, assembling components, or using tools. The robot changes the world around it while remaining in a fixed location.",Ct,cs,va="<strong>Locomotion</strong> encompasses motions that result in changes to the robot’s physical location within its environment. This general category includes both <em>wheeled locomotion</em> (like mobile bases and autonomous vehicles) and <em>legged locomotion</em> (like walking robots and quadrupeds), depending on the mechanism the robot uses to move through its environment.",Mt,R,ya="<p>Quick classifier: ask “what changes?” If mainly the world changes (object pose/state), you’re in manipulation. If mainly the robot state changes, you’re in locomotion. If both change meaningfully within the task, you’re in mobile manipulation. This simple test helps when designing observations, actions, and evaluation.</p>",Tt,hs,ba="We’ll reuse this taxonomy when discussing datasets (what sensors you need) and policies (what action spaces you predict) in the next sections.",Lt,gs,qt,ds,wa="Let’s ground the ideas with a concrete, minimal example you can reason about step by step.",zt,fs,xa="Robot manipulators typically consist of a series of links and joints, articulated in a chain finally connected to an <em>end-effector</em>. Actuated joints are considered responsible for generating motion of the links, while the end effector is instead used to perform specific actions at the target location (e.g., grasping/releasing objects via closing/opening a gripper end-effector, using a specialized tool like a screwdriver, etc.).",Pt,us,ka="Recently, the development of low-cost manipulators like the ALOHA, ALOHA-2 and SO-100/SO-101 platforms significantly lowered the barrier to entry to robotics, considering the increased accessibility of these robots compared to more traditional platforms like the Franka Emika Panda arm.",Ht,A,$a,It,vs,_a="Cheaper, more accessible robots are starting to rival traditional platforms like the Panda arm platforms in adoption in resource-constrained scenarios. The SO-100, in particular, has a cost in the 100s of Euros, and can be entirely 3D-printed in hours, while the industrially-manufactured Panda arm costs tens of thousands of Euros and is not openly available.",Et,ys,Kt,S,Ca,Dt,bs,Ma="The SO-100 arm simplified to a 2D planar manipulator by preventing some joints from moving.",jt,ws,Ta="Consider a simplified version of the SO-100 where we prevent some joints from moving. This reduces the complexity from 6 degrees of freedom to just 2 (plus the gripper). We can control two angles θ₁ and θ₂, which together define the robot’s configuration: q = [θ₁, θ₂].",Ot,M,La,Rt,xs,qa="<em>Free to move</em>",At,T,za,St,ks,Pa="<em>Constrained by the surface</em>",Ft,L,Ha,Jt,$s,Ia="<em>Constrained by surface and (fixed) obstacle</em>",Gt,q,Je,Bt,an='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>p</mi><mo>∈</mo><msup><mi mathvariant="double-struck">R</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex">p \\in \\mathbb{R}^2</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7335em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">p</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathbb">R</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Qt,Wt,nn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>p</mi><mo stretchy="false">(</mo><mi>q</mi><mo stretchy="false">)</mo><mo>=</mo><mrow><mo fence="true">(</mo><mtable rowspacing="0.16em" columnalign="center" columnspacing="1em"><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mi>l</mi><mi>cos</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>θ</mi><mn>1</mn></msub><mo stretchy="false">)</mo><mo>+</mo><mi>l</mi><mi>cos</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>θ</mi><mn>1</mn></msub><mo>+</mo><msub><mi>θ</mi><mn>2</mn></msub><mo stretchy="false">)</mo></mrow></mstyle></mtd></mtr><mtr><mtd><mstyle scriptlevel="0" displaystyle="false"><mrow><mi>l</mi><mi>sin</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>θ</mi><mn>1</mn></msub><mo stretchy="false">)</mo><mo>+</mo><mi>l</mi><mi>sin</mi><mo>⁡</mo><mo stretchy="false">(</mo><msub><mi>θ</mi><mn>1</mn></msub><mo>+</mo><msub><mi>θ</mi><mn>2</mn></msub><mo stretchy="false">)</mo></mrow></mstyle></mtd></mtr></mtable><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">p(q) = \\begin{pmatrix} l \\cos(\\theta_1) + l \\cos(\\theta_1 + \\theta_2) \\\\ l \\sin(\\theta_1) + l \\sin(\\theta_1 + \\theta_2) \\end{pmatrix}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal">p</span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.4em;vertical-align:-0.95em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size3">(</span></span><span class="mord"><span class="mtable"><span class="col-align-c"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.45em;"><span style="top:-3.61em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">cos</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">cos</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span><span style="top:-2.41em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">sin</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">sin</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0278em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.95em;"><span></span></span></span></span></span></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size3">)</span></span></span></span></span></span></span>',Ut,_s,Ea="<strong>Forward Kinematics (FK)</strong> maps a robot configuration into the corresponding end-effector pose, whereas <strong>Inverse Kinematics (IK)</strong> is used to reconstruct the configuration(s) given an end-effector pose.",Nt,z,Ge,Xt,ln='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>p</mi><mo>∗</mo></msup></mrow><annotation encoding="application/x-tex">p^*</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8831em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.6887em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mbin mtight">∗</span></span></span></span></span></span></span></span></span></span></span>',Vt,Yt,on='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><munder><mrow><mi>min</mi><mo>⁡</mo></mrow><mrow><mi>q</mi><mo>∈</mo><mi mathvariant="script">Q</mi></mrow></munder><mi mathvariant="normal">∥</mi><mi>p</mi><mo stretchy="false">(</mo><mi>q</mi><mo stretchy="false">)</mo><mo>−</mo><msup><mi>p</mi><mo>∗</mo></msup><msubsup><mi mathvariant="normal">∥</mi><mn>2</mn><mn>2</mn></msubsup></mrow><annotation encoding="application/x-tex">\\min_{q \\in \\mathcal{Q}} \\|p(q) - p^*\\|_2^2</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.6304em;vertical-align:-0.8804em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-2.3557em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">q</span><span class="mrel mtight">∈</span><span class="mord mathcal mtight">Q</span></span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">min</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.8804em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">∥</span><span class="mord mathnormal">p</span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1141em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7387em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mbin mtight">∗</span></span></span></span></span></span></span></span><span class="mord"><span class="mord">∥</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span></span></span></span>',Zt,Cs,Ka="Exact analytical solutions to IK are even less appealing when one considers the presence of obstacles in the robot’s workspace, resulting in constraints on the possible values of $q$.",se,F,Da="<p>If the math feels dense, focus on the mapping: FK answers “where is the hand given the joints?”, IK asks “what joints reach that hand position?“. The rest of the unit shows why the IK direction becomes hard in realistic settings.</p>",te,Ms,ee,Ts,ja="When IK is hard to solve directly, we can often make progress by working with small motions (velocities) instead of absolute positions.",ae,J,Be,ne,pn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>J</mi><mo stretchy="false">(</mo><mi>q</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">J(q)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.09618em;">J</span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mclose">)</span></span></span></span>',ie,le,g,Qe,oe,mn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mover accent="true"><mi>q</mi><mo>˙</mo></mover><mo stretchy="false">(</mo><mi>t</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\dot{q}(t)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.0556em;"><span class="mord">˙</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="mopen">(</span><span class="mord mathnormal">t</span><span class="mclose">)</span></span></span></span>',pe,Us,Oa="velocities",We,Ns,Ra="configurations",Ue,me,rn='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mover accent="true"><mi>q</mi><mo>˙</mo></mover><mo stretchy="false">(</mo><mi>t</mi><mo stretchy="false">)</mo><mo>=</mo><mi>arg</mi><mo>⁡</mo><munder><mrow><mi>min</mi><mo>⁡</mo></mrow><mi>ν</mi></munder><mi mathvariant="normal">∥</mi><mi>J</mi><mo stretchy="false">(</mo><mi>q</mi><mo stretchy="false">(</mo><mi>t</mi><mo stretchy="false">)</mo><mo stretchy="false">)</mo><mi>ν</mi><mo>−</mo><msup><mover accent="true"><mi>p</mi><mo>˙</mo></mover><mo>∗</mo></msup><mo stretchy="false">(</mo><mi>t</mi><mo stretchy="false">)</mo><msubsup><mi mathvariant="normal">∥</mi><mn>2</mn><mn>2</mn></msubsup></mrow><annotation encoding="application/x-tex">\\dot{q}(t) = \\arg\\min_\\nu \\|J(q(t)) \\nu - \\dot{p}^*(t)\\|_2^2</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.0556em;"><span class="mord">˙</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="mopen">(</span><span class="mord mathnormal">t</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.45em;vertical-align:-0.7em;"></span><span class="mop">ar<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-2.4em;margin-left:0em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.06366em;">ν</span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span><span class="mop">min</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.7em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">∥</span><span class="mord mathnormal" style="margin-right:0.09618em;">J</span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mopen">(</span><span class="mord mathnormal">t</span><span class="mclose">))</span><span class="mord mathnormal" style="margin-right:0.06366em;">ν</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1141em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6679em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathnormal">p</span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.0556em;"><span class="mord">˙</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7387em;"><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mbin mtight">∗</span></span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord mathnormal">t</span><span class="mclose">)</span><span class="mord"><span class="mord">∥</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8641em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span></span></span></span></span>',re,G,Ne,ce,cn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>J</mi><mo>+</mo></msup><mo stretchy="false">(</mo><mi>q</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">J^+(q)</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0213em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.09618em;">J</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7713em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mbin mtight">+</span></span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mclose">)</span></span></span></span>',he,ge,Ls,de,B,Aa,fe,qs,Sa="While very effective when a goal trajectory has been well specified, the performance of differential IK can degrade significantly in the presence of modeling/tracking errors, or in the presence of non-modeled dynamics in the environment.",ue,$,Xe,Xs,Fa="- p(q)$, hereby modifying the control applied to $\\dot{q} = J(q)^+ (\\dot{p}^",Ve,ve,hn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>k</mi><mi>p</mi></msub></mrow><annotation encoding="application/x-tex">k_p</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0315em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">p</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',ye,be,zs,Ja="More advanced techniques for control consisting in feedback linearization, PID control, Linear Quadratic Regulator (LQR) or Model-Predictive Control (MPC) can be employed to stabilize tracking and reject moderate perturbations.",we,Ps,xe,Hs,Ga="This brings us to the “so what?”: where do these classical tools struggle in practice, and why does that motivate learning?",ke,Is,Ba="Despite the last 60+ years of robotics research, autonomous robots are still largely incapable of performing tasks at human-level performance in the physical world generalizing across (1) robot embodiments (different manipulators, different locomotion platforms, etc.) and (2) tasks (tying shoe-laces, manipulating a diverse set of objects).",$e,Q,Qa,_e,Es,Wa="Dynamics-based approaches to robotics suffer from several limitations: (1) orchestrating multiple components poses integration challenges; (2) the need to develop custom processing pipelines for the sensing modalities and tasks considered hinders scalability; (3) simplified analytical models of physical phenomena limit real-world performance. Lastly, (4) dynamics-based methods overlook trends in the availability and growth of robotics data.",Ce,Ks,Me,Ds,Ua=`<strong>1. Integration Challenges</strong>
Dynamics-based robotics pipelines have historically been <strong>developed sequentially, engineering the different blocks</strong> now within most architectures for specific purposes. That is, sensing, state estimation, mapping, planning, (diff-)IK, and low-level control have been traditionally developed as distinct modules with fixed interfaces. Pipelining these specific modules proved error-prone, and brittleness emerges—alongside compounding errors—whenever changes incur.`,Te,js,Na=`<strong>2. Limited Scalability</strong>
Classical planners operate on compact, assumed-sufficient state representations; extending them to reason directly over raw, heterogeneous and noisy data streams is non-trivial. This results in a <strong>limited scalability to multimodal data and multitask settings</strong>, as incorporating high-dimensional perceptual inputs (RGB, depth, tactile, audio) traditionally required extensive engineering efforts to extract meaningful features for control.`,Le,Os,Xa=`<strong>3. Modeling Limitations</strong>
Setting aside integration and scalability challenges: developing accurate modeling of contact, friction, and compliance for complicated systems remains difficult. Rigid-body approximations are often insufficient in the presence of deformable objects, and <strong>relying on approximated models hinders real-world applicability</strong> of the methods developed.`,qe,Rs,Va=`<strong>4. Overlooking Data Trends</strong>
Lastly, dynamics-based methods (naturally) overlook the rather recent <strong>increase in availability of openly-available robotics datasets</strong>. The curation of academic datasets by large centralized groups of human experts in robotics is now increasingly complemented by a <strong>growing number of robotics datasets contributed in a decentralized fashion</strong> by individuals with varied expertise.`,ze,As,Ya="Taken together, these limitations motivate the exploration of learning-based approaches that can:",Pe,Ss,Za="<li><strong>Integrate perception and control more tightly</strong></li> <li><strong>Adapt across tasks and embodiments</strong> with reduced expert modeling interventions</li> <li><strong>Scale gracefully in performance</strong> as more robotics data becomes available</li>",He,P,sn,Ie,Fs,Ee,Js,tn='For a full list of references, check out the <a href="https://huggingface.co/spaces/lerobot/robot-learning-tutorial" rel="nofollow">tutorial</a>.',Ke,Gs,en=`<li><p><strong>Modern Robotics: Mechanics, Planning, and Control</strong> (2017)<br/>
Kevin M. Lynch and Frank C. Park<br/>
A comprehensive textbook covering the foundations of classical robotics, including kinematics, dynamics, and control. Essential reading for understanding the traditional approaches discussed in this unit.<br/> <a href="http://hades.mech.northwestern.edu/index.php/Modern_Robotics" rel="nofollow">Book Website</a></p></li> <li><p><strong>Springer Handbook of Robotics</strong> (2016)<br/>
Edited by Bruno Siciliano and Oussama Khatib<br/>
An authoritative reference covering all aspects of robotics, from classical control theory to emerging learning-based approaches.<br/> <a href="https://doi.org/10.1007/978-3-319-32552-1" rel="nofollow">DOI:10.1007/978-3-319-32552-1</a></p></li>`,De,Bs,je,st,Oe;return W=new bn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new k({props:{title:"Classical Robotics",local:"classical-robotics",headingTag:"h1"}}),V=new k({props:{title:"Key Takeaway",local:"key-takeaway",headingTag:"h2"}}),Y=new k({props:{title:"Different Approaches to Robot Motion",local:"different-approaches-to-robot-motion",headingTag:"h2"}}),is=new k({props:{title:"Different Types of Motion",local:"different-types-of-motion",headingTag:"h2"}}),gs=new k({props:{title:"Example: Planar Manipulation",local:"example-planar-manipulation",headingTag:"h2"}}),ys=new k({props:{title:"Forward and Inverse Kinematics",local:"forward-and-inverse-kinematics",headingTag:"h3"}}),Ms=new k({props:{title:"Differential Inverse Kinematics",local:"differential-inverse-kinematics",headingTag:"h3"}}),Ls=new k({props:{title:"Adding Feedback Loops",local:"adding-feedback-loops",headingTag:"h3"}}),Ps=new k({props:{title:"Limitations of Dynamics-based Robotics",local:"limitations-of-dynamics-based-robotics",headingTag:"h2"}}),Ks=new k({props:{title:"Key Limitations",local:"key-limitations",headingTag:"h3"}}),Fs=new k({props:{title:"References",local:"references",headingTag:"h2"}}),Bs=new wn({props:{source:"https://github.com/huggingface/robotics-course/blob/main/units/en/unit2/1.mdx"}}),{c(){C=l("meta"),at=n(),Zs=l("p"),nt=n(),d(W.$$.fragment),it=n(),d(U.$$.fragment),lt=n(),N=l("p"),N.textContent=Ze,ot=n(),X=l("p"),X.textContent=sa,pt=n(),x=l("blockquote"),d(V.$$.fragment),Se=n(),Qs=l("p"),Qs.textContent=ta,Fe=n(),Ws=l("p"),Ws.textContent=ea,mt=n(),d(Y.$$.fragment),rt=n(),Z=l("p"),Z.textContent=aa,ct=n(),D=l("img"),ht=n(),ss=l("p"),ss.textContent=ia,gt=n(),ts=l("p"),ts.innerHTML=la,dt=n(),es=l("p"),es.textContent=oa,ft=n(),as=l("p"),as.innerHTML=pa,ut=n(),ns=l("p"),ns.innerHTML=ma,vt=n(),j=l("blockquote"),j.innerHTML=ra,yt=n(),d(is.$$.fragment),bt=n(),ls=l("p"),ls.textContent=ca,wt=n(),O=l("img"),xt=n(),os=l("p"),os.textContent=ga,kt=n(),ps=l("p"),ps.textContent=da,$t=n(),ms=l("p"),ms.textContent=fa,_t=n(),rs=l("p"),rs.innerHTML=ua,Ct=n(),cs=l("p"),cs.innerHTML=va,Mt=n(),R=l("blockquote"),R.innerHTML=ya,Tt=n(),hs=l("p"),hs.textContent=ba,Lt=n(),d(gs.$$.fragment),qt=n(),ds=l("p"),ds.textContent=wa,zt=n(),fs=l("p"),fs.innerHTML=xa,Pt=n(),us=l("p"),us.textContent=ka,Ht=n(),A=l("img"),It=n(),vs=l("p"),vs.textContent=_a,Et=n(),d(ys.$$.fragment),Kt=n(),S=l("img"),Dt=n(),bs=l("p"),bs.textContent=Ma,jt=n(),ws=l("p"),ws.textContent=Ta,Ot=n(),M=l("img"),Rt=n(),xs=l("p"),xs.innerHTML=qa,At=n(),T=l("img"),St=n(),ks=l("p"),ks.innerHTML=Pa,Ft=n(),L=l("img"),Jt=n(),$s=l("p"),$s.innerHTML=Ia,Gt=n(),q=l("p"),Je=c("Considering this example, we can analytically write the end-effector’s position "),Bt=new I(!1),Qt=c(` as a function of the robot’s configuration, $p = p(q)$:
`),Wt=new I(!1),Ut=n(),_s=l("p"),_s.innerHTML=Ea,Nt=n(),z=l("p"),Ge=c("In the simplified case here considered, one can solve the problem of controlling the end-effector’s location to reach a goal position "),Xt=new I(!1),Vt=c(` by solving analytically for $q: p(q) = p^*$. However, in the general case, one might not be able to solve this problem analytically, and can typically resort to iterative optimization methods:
`),Yt=new I(!1),Zt=n(),Cs=l("p"),Cs.textContent=Ka,se=n(),F=l("blockquote"),F.innerHTML=Da,te=n(),d(Ms.$$.fragment),ee=n(),Ts=l("p"),Ts.textContent=ja,ae=n(),J=l("p"),Be=c("Let "),ne=new I(!1),ie=c(" denote the Jacobian matrix of (partial) derivatives of the FK-function. Then, one can apply the chain rule to any $p(q)$, deriving $\\dot{p} = J(q) \\dot{q}$, and thus finally relating variations in the robot configurations to variations in pose."),le=n(),g=l("p"),Qe=c("Given a desired end-effector trajectory, differential IK finds "),oe=new I(!1),pe=c(" solving for joints’ "),Us=l("em"),Us.textContent=Oa,We=c(" instead of "),Ns=l("em"),Ns.textContent=Ra,Ue=c(`:
`),me=new I(!1),re=n(),G=l("p"),Ne=c("This often admits the closed-form solution $\\dot{q} = J(q)^+ \\dot{p}^*$, where "),ce=new I(!1),he=c(" denotes the Moore-Penrose pseudo-inverse of $J(q)$."),ge=n(),d(Ls.$$.fragment),de=n(),B=l("img"),fe=n(),qs=l("p"),qs.textContent=Sa,ue=n(),$=l("p"),Xe=c("To mitigate the effect of modeling errors, sensing noise and other disturbances, classical pipelines indeed do augment differential IK with feedback control looping back quantities of interest. In practice, following a trajectory with a closed feedback loop might consist in backwarding the error between the target and measured pose, $\\Delta p = p^"),Xs=l("em"),Xs.textContent=Fa,Ve=c(" + k_p \\Delta p)$, with "),ve=new I(!1),ye=c(" defined as the (proportional) gain."),be=n(),zs=l("p"),zs.textContent=Ja,we=n(),d(Ps.$$.fragment),xe=n(),Hs=l("p"),Hs.textContent=Ga,ke=n(),Is=l("p"),Is.textContent=Ba,$e=n(),Q=l("img"),_e=n(),Es=l("p"),Es.textContent=Wa,Ce=n(),d(Ks.$$.fragment),Me=n(),Ds=l("p"),Ds.innerHTML=Ua,Te=n(),js=l("p"),js.innerHTML=Na,Le=n(),Os=l("p"),Os.innerHTML=Xa,qe=n(),Rs=l("p"),Rs.innerHTML=Va,ze=n(),As=l("p"),As.textContent=Ya,Pe=n(),Ss=l("ol"),Ss.innerHTML=Za,He=n(),P=l("img"),Ie=n(),d(Fs.$$.fragment),Ee=n(),Js=l("p"),Js.innerHTML=tn,Ke=n(),Gs=l("ul"),Gs.innerHTML=en,De=n(),d(Bs.$$.fragment),je=n(),st=l("p"),this.h()},l(s){const t=yn("svelte-u9bgzb",document.head);C=o(t,"META",{name:!0,content:!0}),t.forEach(e),at=i(s),Zs=o(s,"P",{}),E(Zs).forEach(e),nt=i(s),f(W.$$.fragment,s),it=i(s),f(U.$$.fragment,s),lt=i(s),N=o(s,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1l1cytn"&&(N.textContent=Ze),ot=i(s),X=o(s,"P",{"data-svelte-h":!0}),p(X)!=="svelte-11cp8bl"&&(X.textContent=sa),pt=i(s),x=o(s,"BLOCKQUOTE",{class:!0});var Vs=E(x);f(V.$$.fragment,Vs),Se=i(Vs),Qs=o(Vs,"P",{"data-svelte-h":!0}),p(Qs)!=="svelte-1wd6tra"&&(Qs.textContent=ta),Fe=i(Vs),Ws=o(Vs,"P",{"data-svelte-h":!0}),p(Ws)!=="svelte-u5m0h4"&&(Ws.textContent=ea),Vs.forEach(e),mt=i(s),f(Y.$$.fragment,s),rt=i(s),Z=o(s,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1b5gn8h"&&(Z.textContent=aa),ct=i(s),D=o(s,"IMG",{src:!0,alt:!0,style:!0}),ht=i(s),ss=o(s,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-hjzqd"&&(ss.textContent=ia),gt=i(s),ts=o(s,"P",{"data-svelte-h":!0}),p(ts)!=="svelte-1ytrnes"&&(ts.innerHTML=la),dt=i(s),es=o(s,"P",{"data-svelte-h":!0}),p(es)!=="svelte-14tiwxf"&&(es.textContent=oa),ft=i(s),as=o(s,"P",{"data-svelte-h":!0}),p(as)!=="svelte-1c9kw4j"&&(as.innerHTML=pa),ut=i(s),ns=o(s,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-pvsn4i"&&(ns.innerHTML=ma),vt=i(s),j=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-f1bvew"&&(j.innerHTML=ra),yt=i(s),f(is.$$.fragment,s),bt=i(s),ls=o(s,"P",{"data-svelte-h":!0}),p(ls)!=="svelte-13dc09m"&&(ls.textContent=ca),wt=i(s),O=o(s,"IMG",{src:!0,alt:!0,style:!0}),xt=i(s),os=o(s,"P",{"data-svelte-h":!0}),p(os)!=="svelte-1vssg7s"&&(os.textContent=ga),kt=i(s),ps=o(s,"P",{"data-svelte-h":!0}),p(ps)!=="svelte-1y85yf8"&&(ps.textContent=da),$t=i(s),ms=o(s,"P",{"data-svelte-h":!0}),p(ms)!=="svelte-ajzv57"&&(ms.textContent=fa),_t=i(s),rs=o(s,"P",{"data-svelte-h":!0}),p(rs)!=="svelte-1cm3z03"&&(rs.innerHTML=ua),Ct=i(s),cs=o(s,"P",{"data-svelte-h":!0}),p(cs)!=="svelte-1kx7tuc"&&(cs.innerHTML=va),Mt=i(s),R=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-1e6ls59"&&(R.innerHTML=ya),Tt=i(s),hs=o(s,"P",{"data-svelte-h":!0}),p(hs)!=="svelte-uvsk9q"&&(hs.textContent=ba),Lt=i(s),f(gs.$$.fragment,s),qt=i(s),ds=o(s,"P",{"data-svelte-h":!0}),p(ds)!=="svelte-1qspp1l"&&(ds.textContent=wa),zt=i(s),fs=o(s,"P",{"data-svelte-h":!0}),p(fs)!=="svelte-1wgqgk2"&&(fs.innerHTML=xa),Pt=i(s),us=o(s,"P",{"data-svelte-h":!0}),p(us)!=="svelte-ia9bl8"&&(us.textContent=ka),Ht=i(s),A=o(s,"IMG",{src:!0,alt:!0,style:!0}),It=i(s),vs=o(s,"P",{"data-svelte-h":!0}),p(vs)!=="svelte-159ql2f"&&(vs.textContent=_a),Et=i(s),f(ys.$$.fragment,s),Kt=i(s),S=o(s,"IMG",{src:!0,alt:!0,style:!0}),Dt=i(s),bs=o(s,"P",{"data-svelte-h":!0}),p(bs)!=="svelte-4gci0z"&&(bs.textContent=Ma),jt=i(s),ws=o(s,"P",{"data-svelte-h":!0}),p(ws)!=="svelte-1w1yplx"&&(ws.textContent=Ta),Ot=i(s),M=o(s,"IMG",{src:!0,alt:!0,style:!0}),Rt=i(s),xs=o(s,"P",{"data-svelte-h":!0}),p(xs)!=="svelte-mfs8on"&&(xs.innerHTML=qa),At=i(s),T=o(s,"IMG",{src:!0,alt:!0,style:!0}),St=i(s),ks=o(s,"P",{"data-svelte-h":!0}),p(ks)!=="svelte-r6hico"&&(ks.innerHTML=Pa),Ft=i(s),L=o(s,"IMG",{src:!0,alt:!0,style:!0}),Jt=i(s),$s=o(s,"P",{"data-svelte-h":!0}),p($s)!=="svelte-1ypykwu"&&($s.innerHTML=Ia),Gt=i(s),q=o(s,"P",{});var tt=E(q);Je=h(tt,"Considering this example, we can analytically write the end-effector’s position "),Bt=K(tt,!1),Qt=h(tt,` as a function of the robot’s configuration, $p = p(q)$:
`),Wt=K(tt,!1),tt.forEach(e),Ut=i(s),_s=o(s,"P",{"data-svelte-h":!0}),p(_s)!=="svelte-19vzl0i"&&(_s.innerHTML=Ea),Nt=i(s),z=o(s,"P",{});var et=E(z);Ge=h(et,"In the simplified case here considered, one can solve the problem of controlling the end-effector’s location to reach a goal position "),Xt=K(et,!1),Vt=h(et,` by solving analytically for $q: p(q) = p^*$. However, in the general case, one might not be able to solve this problem analytically, and can typically resort to iterative optimization methods:
`),Yt=K(et,!1),et.forEach(e),Zt=i(s),Cs=o(s,"P",{"data-svelte-h":!0}),p(Cs)!=="svelte-p3k4n3"&&(Cs.textContent=Ka),se=i(s),F=o(s,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(F)!=="svelte-1ngaqrp"&&(F.innerHTML=Da),te=i(s),f(Ms.$$.fragment,s),ee=i(s),Ts=o(s,"P",{"data-svelte-h":!0}),p(Ts)!=="svelte-a206w4"&&(Ts.textContent=ja),ae=i(s),J=o(s,"P",{});var Re=E(J);Be=h(Re,"Let "),ne=K(Re,!1),ie=h(Re," denote the Jacobian matrix of (partial) derivatives of the FK-function. Then, one can apply the chain rule to any $p(q)$, deriving $\\dot{p} = J(q) \\dot{q}$, and thus finally relating variations in the robot configurations to variations in pose."),Re.forEach(e),le=i(s),g=o(s,"P",{});var H=E(g);Qe=h(H,"Given a desired end-effector trajectory, differential IK finds "),oe=K(H,!1),pe=h(H," solving for joints’ "),Us=o(H,"EM",{"data-svelte-h":!0}),p(Us)!=="svelte-15c8dgt"&&(Us.textContent=Oa),We=h(H," instead of "),Ns=o(H,"EM",{"data-svelte-h":!0}),p(Ns)!=="svelte-i9sgst"&&(Ns.textContent=Ra),Ue=h(H,`:
`),me=K(H,!1),H.forEach(e),re=i(s),G=o(s,"P",{});var Ae=E(G);Ne=h(Ae,"This often admits the closed-form solution $\\dot{q} = J(q)^+ \\dot{p}^*$, where "),ce=K(Ae,!1),he=h(Ae," denotes the Moore-Penrose pseudo-inverse of $J(q)$."),Ae.forEach(e),ge=i(s),f(Ls.$$.fragment,s),de=i(s),B=o(s,"IMG",{src:!0,alt:!0,style:!0}),fe=i(s),qs=o(s,"P",{"data-svelte-h":!0}),p(qs)!=="svelte-vv6dyo"&&(qs.textContent=Sa),ue=i(s),$=o(s,"P",{});var Ys=E($);Xe=h(Ys,"To mitigate the effect of modeling errors, sensing noise and other disturbances, classical pipelines indeed do augment differential IK with feedback control looping back quantities of interest. In practice, following a trajectory with a closed feedback loop might consist in backwarding the error between the target and measured pose, $\\Delta p = p^"),Xs=o(Ys,"EM",{"data-svelte-h":!0}),p(Xs)!=="svelte-48pyu1"&&(Xs.textContent=Fa),Ve=h(Ys," + k_p \\Delta p)$, with "),ve=K(Ys,!1),ye=h(Ys," defined as the (proportional) gain."),Ys.forEach(e),be=i(s),zs=o(s,"P",{"data-svelte-h":!0}),p(zs)!=="svelte-os8zhw"&&(zs.textContent=Ja),we=i(s),f(Ps.$$.fragment,s),xe=i(s),Hs=o(s,"P",{"data-svelte-h":!0}),p(Hs)!=="svelte-1an4t2s"&&(Hs.textContent=Ga),ke=i(s),Is=o(s,"P",{"data-svelte-h":!0}),p(Is)!=="svelte-1l9vek8"&&(Is.textContent=Ba),$e=i(s),Q=o(s,"IMG",{src:!0,alt:!0,style:!0}),_e=i(s),Es=o(s,"P",{"data-svelte-h":!0}),p(Es)!=="svelte-1031q92"&&(Es.textContent=Wa),Ce=i(s),f(Ks.$$.fragment,s),Me=i(s),Ds=o(s,"P",{"data-svelte-h":!0}),p(Ds)!=="svelte-15yo2sv"&&(Ds.innerHTML=Ua),Te=i(s),js=o(s,"P",{"data-svelte-h":!0}),p(js)!=="svelte-a0i3ry"&&(js.innerHTML=Na),Le=i(s),Os=o(s,"P",{"data-svelte-h":!0}),p(Os)!=="svelte-a2cnyg"&&(Os.innerHTML=Xa),qe=i(s),Rs=o(s,"P",{"data-svelte-h":!0}),p(Rs)!=="svelte-l6le9u"&&(Rs.innerHTML=Va),ze=i(s),As=o(s,"P",{"data-svelte-h":!0}),p(As)!=="svelte-1femgk0"&&(As.textContent=Ya),Pe=i(s),Ss=o(s,"OL",{"data-svelte-h":!0}),p(Ss)!=="svelte-5tqpxy"&&(Ss.innerHTML=Za),He=i(s),P=o(s,"IMG",{src:!0,alt:!0,width:!0,height:!0}),Ie=i(s),f(Fs.$$.fragment,s),Ee=i(s),Js=o(s,"P",{"data-svelte-h":!0}),p(Js)!=="svelte-12jfyok"&&(Js.innerHTML=tn),Ke=i(s),Gs=o(s,"UL",{"data-svelte-h":!0}),p(Gs)!=="svelte-17cc811"&&(Gs.innerHTML=en),De=i(s),f(Bs.$$.fragment,s),je=i(s),st=o(s,"P",{}),E(st).forEach(e),this.h()},h(){m(C,"name","hf:doc:metadata"),m(C,"content",kn),m(x,"class","tip"),_(D.src,na="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-approaches.png")||m(D,"src",na),m(D,"alt","A diagram showing different approaches to robot motion generation, organized into two main categories: explicit dynamics-based methods on the left (including classical control, model predictive control, and trajectory optimization) and implicit learning-based methods on the right (including reinforcement learning, imitation learning, and neural networks). The diagram illustrates the spectrum from model-based to data-driven approaches in robotics."),w(D,"width","50%"),m(j,"class","tip"),_(O.src,ha="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-platforms.png")||m(O,"src",ha),m(O,"alt","A collection of six different robotic platforms showing the diversity of robot designs: ViperX (a small desktop robotic arm), SO-100 (an open-source 3D-printable arm), Boston Dynamics' Spot (a four-legged walking robot), Open-Duck (a wheeled mobile robot), 1X's NEO (a humanoid robot), and Boston Dynamics' Atlas (an advanced bipedal humanoid robot). The image demonstrates how different robot designs are optimized for different types of motion and tasks."),w(O,"width","70%"),m(R,"class","tip"),_(A.src,$a="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-cost-accessibility.png")||m(A,"src",$a),m(A,"alt","Robot Cost Comparison"),w(A,"width","40%"),_(S.src,Ca="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-so100-to-planar-manipulator.png")||m(S,"src",Ca),m(S,"alt","SO-100 to Planar Manipulator"),w(S,"width","70%"),_(M.src,La="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-planar-manipulator-free.png")||m(M,"src",La),m(M,"alt","Free Motion"),w(M,"width","100%"),w(M,"max-width","200px"),_(T.src,za="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-planar-manipulator-floor.png")||m(T,"src",za),m(T,"alt","Floor Constraint"),w(T,"width","100%"),w(T,"max-width","200px"),_(L.src,Ha="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-planar-manipulator-floor-shelf.png")||m(L,"src",Ha),m(L,"alt","Multiple Constraints"),w(L,"width","100%"),w(L,"max-width","200px"),Bt.a=Qt,Wt.a=null,Xt.a=Vt,Yt.a=null,m(F,"class","tip"),ne.a=ie,oe.a=pe,me.a=null,ce.a=he,_(B.src,Aa="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-planar-manipulator-floor-box.png")||m(B,"src",Aa),m(B,"alt","Moving Obstacle"),w(B,"width","100%"),ve.a=ye,_(Q.src,Qa="https://huggingface.co/robotics-course/images/resolve/main/ch2/ch2-classical-limitations.png")||m(Q,"src",Qa),m(Q,"alt","Classical Limitations"),w(Q,"width","90%"),_(P.src,sn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/robotics-course/classical-vs-robot-learning.png")||m(P,"src",sn),m(P,"alt","Classical vs Robot Learning"),m(P,"width","600"),m(P,"height","200")},m(s,t){r(document.head,C),a(s,at,t),a(s,Zs,t),a(s,nt,t),u(W,s,t),a(s,it,t),u(U,s,t),a(s,lt,t),a(s,N,t),a(s,ot,t),a(s,X,t),a(s,pt,t),a(s,x,t),u(V,x,null),r(x,Se),r(x,Qs),r(x,Fe),r(x,Ws),a(s,mt,t),u(Y,s,t),a(s,rt,t),a(s,Z,t),a(s,ct,t),a(s,D,t),a(s,ht,t),a(s,ss,t),a(s,gt,t),a(s,ts,t),a(s,dt,t),a(s,es,t),a(s,ft,t),a(s,as,t),a(s,ut,t),a(s,ns,t),a(s,vt,t),a(s,j,t),a(s,yt,t),u(is,s,t),a(s,bt,t),a(s,ls,t),a(s,wt,t),a(s,O,t),a(s,xt,t),a(s,os,t),a(s,kt,t),a(s,ps,t),a(s,$t,t),a(s,ms,t),a(s,_t,t),a(s,rs,t),a(s,Ct,t),a(s,cs,t),a(s,Mt,t),a(s,R,t),a(s,Tt,t),a(s,hs,t),a(s,Lt,t),u(gs,s,t),a(s,qt,t),a(s,ds,t),a(s,zt,t),a(s,fs,t),a(s,Pt,t),a(s,us,t),a(s,Ht,t),a(s,A,t),a(s,It,t),a(s,vs,t),a(s,Et,t),u(ys,s,t),a(s,Kt,t),a(s,S,t),a(s,Dt,t),a(s,bs,t),a(s,jt,t),a(s,ws,t),a(s,Ot,t),a(s,M,t),a(s,Rt,t),a(s,xs,t),a(s,At,t),a(s,T,t),a(s,St,t),a(s,ks,t),a(s,Ft,t),a(s,L,t),a(s,Jt,t),a(s,$s,t),a(s,Gt,t),a(s,q,t),r(q,Je),Bt.m(an,q),r(q,Qt),Wt.m(nn,q),a(s,Ut,t),a(s,_s,t),a(s,Nt,t),a(s,z,t),r(z,Ge),Xt.m(ln,z),r(z,Vt),Yt.m(on,z),a(s,Zt,t),a(s,Cs,t),a(s,se,t),a(s,F,t),a(s,te,t),u(Ms,s,t),a(s,ee,t),a(s,Ts,t),a(s,ae,t),a(s,J,t),r(J,Be),ne.m(pn,J),r(J,ie),a(s,le,t),a(s,g,t),r(g,Qe),oe.m(mn,g),r(g,pe),r(g,Us),r(g,We),r(g,Ns),r(g,Ue),me.m(rn,g),a(s,re,t),a(s,G,t),r(G,Ne),ce.m(cn,G),r(G,he),a(s,ge,t),u(Ls,s,t),a(s,de,t),a(s,B,t),a(s,fe,t),a(s,qs,t),a(s,ue,t),a(s,$,t),r($,Xe),r($,Xs),r($,Ve),ve.m(hn,$),r($,ye),a(s,be,t),a(s,zs,t),a(s,we,t),u(Ps,s,t),a(s,xe,t),a(s,Hs,t),a(s,ke,t),a(s,Is,t),a(s,$e,t),a(s,Q,t),a(s,_e,t),a(s,Es,t),a(s,Ce,t),u(Ks,s,t),a(s,Me,t),a(s,Ds,t),a(s,Te,t),a(s,js,t),a(s,Le,t),a(s,Os,t),a(s,qe,t),a(s,Rs,t),a(s,ze,t),a(s,As,t),a(s,Pe,t),a(s,Ss,t),a(s,He,t),a(s,P,t),a(s,Ie,t),u(Fs,s,t),a(s,Ee,t),a(s,Js,t),a(s,Ke,t),a(s,Gs,t),a(s,De,t),u(Bs,s,t),a(s,je,t),a(s,st,t),Oe=!0},p:dn,i(s){Oe||(v(W.$$.fragment,s),v(U.$$.fragment,s),v(V.$$.fragment,s),v(Y.$$.fragment,s),v(is.$$.fragment,s),v(gs.$$.fragment,s),v(ys.$$.fragment,s),v(Ms.$$.fragment,s),v(Ls.$$.fragment,s),v(Ps.$$.fragment,s),v(Ks.$$.fragment,s),v(Fs.$$.fragment,s),v(Bs.$$.fragment,s),Oe=!0)},o(s){y(W.$$.fragment,s),y(U.$$.fragment,s),y(V.$$.fragment,s),y(Y.$$.fragment,s),y(is.$$.fragment,s),y(gs.$$.fragment,s),y(ys.$$.fragment,s),y(Ms.$$.fragment,s),y(Ls.$$.fragment,s),y(Ps.$$.fragment,s),y(Ks.$$.fragment,s),y(Fs.$$.fragment,s),y(Bs.$$.fragment,s),Oe=!1},d(s){s&&(e(at),e(Zs),e(nt),e(it),e(lt),e(N),e(ot),e(X),e(pt),e(x),e(mt),e(rt),e(Z),e(ct),e(D),e(ht),e(ss),e(gt),e(ts),e(dt),e(es),e(ft),e(as),e(ut),e(ns),e(vt),e(j),e(yt),e(bt),e(ls),e(wt),e(O),e(xt),e(os),e(kt),e(ps),e($t),e(ms),e(_t),e(rs),e(Ct),e(cs),e(Mt),e(R),e(Tt),e(hs),e(Lt),e(qt),e(ds),e(zt),e(fs),e(Pt),e(us),e(Ht),e(A),e(It),e(vs),e(Et),e(Kt),e(S),e(Dt),e(bs),e(jt),e(ws),e(Ot),e(M),e(Rt),e(xs),e(At),e(T),e(St),e(ks),e(Ft),e(L),e(Jt),e($s),e(Gt),e(q),e(Ut),e(_s),e(Nt),e(z),e(Zt),e(Cs),e(se),e(F),e(te),e(ee),e(Ts),e(ae),e(J),e(le),e(g),e(re),e(G),e(ge),e(de),e(B),e(fe),e(qs),e(ue),e($),e(be),e(zs),e(we),e(xe),e(Hs),e(ke),e(Is),e($e),e(Q),e(_e),e(Es),e(Ce),e(Me),e(Ds),e(Te),e(js),e(Le),e(Os),e(qe),e(Rs),e(ze),e(As),e(Pe),e(Ss),e(He),e(P),e(Ie),e(Ee),e(Js),e(Ke),e(Gs),e(De),e(je),e(st)),e(C),b(W,s),b(U,s),b(V),b(Y,s),b(is,s),b(gs,s),b(ys,s),b(Ms,s),b(Ls,s),b(Ps,s),b(Ks,s),b(Fs,s),b(Bs,s)}}}const kn='{"title":"Classical Robotics","local":"classical-robotics","sections":[{"title":"Key Takeaway","local":"key-takeaway","sections":[],"depth":2},{"title":"Different Approaches to Robot Motion","local":"different-approaches-to-robot-motion","sections":[],"depth":2},{"title":"Different Types of Motion","local":"different-types-of-motion","sections":[],"depth":2},{"title":"Example: Planar Manipulation","local":"example-planar-manipulation","sections":[{"title":"Forward and Inverse Kinematics","local":"forward-and-inverse-kinematics","sections":[],"depth":3},{"title":"Differential Inverse Kinematics","local":"differential-inverse-kinematics","sections":[],"depth":3},{"title":"Adding Feedback Loops","local":"adding-feedback-loops","sections":[],"depth":3}],"depth":2},{"title":"Limitations of Dynamics-based Robotics","local":"limitations-of-dynamics-based-robotics","sections":[{"title":"Key Limitations","local":"key-limitations","sections":[],"depth":3}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function $n(Ye){return fn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tn extends un{constructor(C){super(),vn(this,C,$n,xn,gn,{})}}export{Tn as component};
