# Introduction to Robot Learning

Robot learning starts with a simple idea: teach robots to improve from data and experience instead of hand‑coding every behavior. In practice, that means using examples (videos, sensor data, demonstrations) and feedback to help a robot get better at tasks like picking, placing, pushing, or walking.

Why now? Two trends make this possible: modern machine learning is increasingly good at finding intricate patterns, and robotics datasets are becoming easier to collect and share. Together, they let us move from classical "write the physics and the controller" approaches to learning‑based methods that adapt from data.

For example, a robot arm can learn to grasp a block by trying actions and getting rewards for progress (reinforcement learning), or even by watching and imitating human demonstrations (imitation learning). Over time, the same ideas scale to many tasks and even different robot bodies.

> [!TIP]
> By the end of this unit, you will:
> - Understand in plain terms what "robot learning" means and why it's useful
> - See concrete examples of learning from demonstrations and from trial‑and‑error
> - Know what we'll build toward in the next units and how LeRobot fits in

# Some History

Robotics is about helping humans with repetitive, tiring or dangerous tasks. People have been working on this challenge since the 1950s. Recently, advances in machine learning have opened up new ways to build robots. Instead of requiring human experts to write detailed instructions and models for every task, we can now use large amounts of data and computation to help robots learn behaviors on their own.

> [!TIP]
> Some context...
>
> The 1950s saw the birth of both artificial intelligence and robotics as distinct fields. The first robot ever was [Unimate](https://en.wikipedia.org/wiki/Unimate), invented in 1961. It's taken nearly 70 years for these fields to converge in meaningful ways through robot learning!

# The Future of Robotics

Today's robotics researchers are moving away from the traditional approach of writing detailed models and control systems. Instead, they're embracing machine learning to create robots that can:

- Learn direct connections from what they see to what they do, without needing separate systems for perception and control.
- Extract useful information from many types of sensors (cameras, touch sensors, microphones) using data-driven methods.
- Work effectively without needing perfect models of how the world behaves.
- Take advantage of the growing number of open robotics datasets that anyone can access and learn from.
- Work effectively without needing perfect models of how the world behaves.

You can watch [this video](https://www.youtube.com/watch?v=VEs1QYEgOQo) to get a better sense of the paradigm shift currently undergoing in robotics.

> [!WARNING]
> **Key Insight:** This shift represents a fundamental change in how we think about robotics - from engineering precise solutions to learning adaptive behaviors from data.

This trend is especially important because it mirrors how foundation models like GPT and CLIP were developed. These machine learning, or Artificial Intelligence, systems learned to understand and work with text and images by training on massive datasets. As robotics datasets grow larger and robots get equipped with more diverse sensors (regular cameras, infrared cameras, LIDAR, microphones), applying similar learning approaches to robotics becomes increasingly powerful.

Robotics naturally requires expertise in both software and hardware. Adding machine learning to the mix means robotics practitioners need an even broader set of skills, which raises the bar for both research and real-world applications.

## References

For a full list of references, check out the [tutorial](https://huggingface.co/spaces/lerobot/robot-learning-tutorial).

- **ALVINN: An Autonomous Land Vehicle in a Neural Network** (1988)  
  Dean A. Pomerleau  
  This seminal paper introduced one of the first demonstrations of end-to-end learning for autonomous driving, where a neural network learned to map sensor inputs directly to steering commands.  
  [Paper](https://proceedings.neurips.cc/paper_files/paper/1988/file/812b4ba287f5ee0bc9d43bbf5bbe87fb-Paper.pdf)

- **Reinforcement Learning: An Introduction** (2018)  
  Richard S. Sutton and Andrew G. Barto  
  The foundational textbook on reinforcement learning, covering the principles that underlie how robots learn through trial and error.  
  [Book Website](http://incompleteideas.net/book/the-book-2nd.html)


<EditOnGithub source="https://github.com/huggingface/robotics-course/blob/main/units/en/unit1/1.mdx" />