# From Classical to Learning-Based Robotics

This chapter ties the classical tools you’ve learned to the motivations for learning‑based methods, then points you to what comes next. We’ll keep it concise and add signposts so you know where to focus.

> [!TIP]
> Don't worry if this page is a bit dense, we'll break it down in the next few units.

## What We've Learned So Far

First, a quick recap of the important concepts covered across the foundational units.

<!-- TODO: Small timeline diagram with milestones: Classical → Kinematics → Control → Limitations → Learning motivation. -->

**Motivation for Learning-Based Robotics:** You've explored the fundamental shift occurring in robotics today, moving from classical model-based approaches toward data-driven learning methods. We've established why robot learning is becoming essential for creating more capable and generalizable robotic systems, and how tools like LeRobot are making these advanced techniques accessible to a broader community of researchers and practitioners.

**LeRobot Ecosystem:** You've gained a fundamental understanding of LeRobot's approach to robotics. This includes understanding the vision behind LeRobot as an end-to-end robotics library, aiming at integrating the different aspects of robotics altogether. You have also learned about the LeRobotDataset format, which handles the complexity of multi-modal robotics data, and got practical experience with loading and processing real robotics datasets for machine learning applications.

Next, you will learn how to synthetize autonomous control behaviors directly from data, and deploy them on real-world robots using lerobot.

**Classical Robotics Foundations:** We've examined the traditional approaches to robotics in detail, covering different types of robot motion including manipulation, locomotion, and mobile manipulation. You've learned about forward and inverse kinematics, differential kinematics, and feedback control systems. Most importantly, you've developed an understanding of why classical approaches, despite their mathematical rigor, struggle with the complexity and variability of real-world robotic applications.

## The Learning Revolution

Through our exploration of classical robotics, you've gained a clear understanding of why learning-based approaches represent such a significant advancement in the field.

**Classical approaches face fundamental limitations** that become apparent when dealing with real-world complexity. These methods require extensive mathematical modeling of every aspect of the robot's environment and interactions, which becomes prohibitively difficult for complex scenarios.

They struggle to integrate multi-modal data sources like vision, touch, and proprioception in a unified way. Perhaps most importantly, classical approaches don't scale well across different tasks or robot embodiments—each new application typically requires significant re-engineering and expert knowledge.

**Learning-based approaches offer compelling advantages** that directly address these limitations. Instead of requiring experts to model every aspect of the problem, these methods can learn appropriate behaviors and representations directly from data.

They naturally handle multi-modal, high-dimensional inputs through neural network architectures designed for such complexity, can generalize across different tasks and even different robot embodiments, and scale with the availability of data and computational resources.

<!-- TODO: graphic of pros and cons of classical and learning-based approaches -->

## What's Coming Next

The foundational knowledge you've gained prepares you for the advanced topics that follow. 

**Reinforcement Learning for Robotics** will explore how robots can learn optimal behaviors through trial and error interactions with their environment. You'll learn about designing appropriate reward signals for robotics tasks, understand reinforcement learning methods that enable robots to improve their performance over time, and tackle the crucial challenge of sample efficiency—learning effectively with limited real-world interaction data. We'll also cover how LeRobot implements these reinforcement learning algorithms in practice.

**Imitation Learning via Behavioral Cloning** will demonstrate how robots can acquire complex skills by observing and copying expert demonstrations. This approach is particularly valuable because it allows robots to learn from real-world human expertise without requiring explicit reward engineering, sidestepping the criticalities associated with using RL in practice. You'll understand how to handle the distribution shift problem that occurs when robots encounter situations not seen in training data, explore advanced imitation learning techniques beyond simple behavioral cloning, and gain practical experience implementing these methods using LeRobot's tools.

**Foundation Models for Robotics** will cover the cutting-edge developments that are creating more general and capable robotic systems. You'll explore how multi-task learning enables knowledge sharing across different robotic platforms and tasks, understand language-conditioned policies that allow robots to follow natural language instructions, and learn about scaling laws that govern how performance improves with larger models and datasets. This section will prepare you to understand and contribute to the development of truly generalist robotic systems.

## Practical Skills Gained

Through this foundational section of the course, you've developed both technical capabilities and conceptual understanding that will serve as the foundation for more advanced topics.

**Technical Skills:** You now understand how robotics data differs from traditional machine learning datasets and why specialized formats are necessary. You've gained practical experience working with the LeRobotDataset API, including loading and processing multi-modal robotics data that combines vision, proprioception, and action information. You've also learned about streaming large datasets efficiently, which is crucial for working with the massive datasets that power modern robot learning systems.

**Conceptual Understanding:** Perhaps most importantly, you've developed a clear mental model of the evolution occurring in robotics today. You understand the historical context of classical approaches, their mathematical foundations, and their fundamental limitations when applied to complex, real-world scenarios. You've gained insight into how learning-based approaches address these limitations and why the availability of large-scale robotics data is transforming what's possible in the field.

## Ready for the Next Challenge?

> [!WARNING]
> **You're now ready for advanced robot learning!** The concepts you've learned about data handling, multi-modal processing, and the limitations of classical approaches will be essential as we dive into:
>
> - **Reinforcement Learning** - How robots learn optimal behaviors through trial and error
> - **Imitation Learning** - How robots learn by watching human demonstrations  
> - **Foundation Models** - How large-scale models are creating general-purpose robotic intelligence
>
> **Coming soon:** These advanced units will build directly on the foundations you've just mastered.


## Course Summary
- Robot learning represents a paradigm shift from model-based to data-driven approaches
- LeRobot democratizes access to state-of-the-art robot learning techniques
- Classical robotics provides important foundations but has fundamental scalability limitations
- Learning-based methods can generalize across tasks, robots, and environments
- The future lies in combining classical insights with learning capabilities
- Large-scale datasets and foundation models are transforming what's possible in robotics

## Community and Resources

As you continue your robot learning journey:

**Keep Learning:**
- [Explore LeRobot documentation](https://huggingface.co/docs/lerobot)
- [Try LeRobot examples](https://github.com/huggingface/lerobot)
- [Give a read to our in-detail tutorial](https://huggingface.co/spaces/lerobot/robot-learning-tutorial)
- [Join the community discussions](https://huggingface.co/lerobot)

**Get Involved:**
- Contribute datasets to the community
- Share your robot learning experiments
- Help improve LeRobot tools and documentation

> [!TIP]
> If you're choosing a first project, start with a small imitation learning task using LeRobotDataset (pick‑and‑place on SO‑100/SO‑101). You'll get end‑to‑end experience—data, model, evaluation—without needing reward design or simulators.

---

**Congratulations on completing the foundational units!** You're now ready to dive into the exciting world of learning-based robotics algorithms.

## References

For a full list of references, check out the [tutorial](https://huggingface.co/spaces/lerobot/robot-learning-tutorial).

- **End-to-End Training of Deep Visuomotor Policies** (2016)  
  Sergey Levine et al.  
  A landmark paper demonstrating how deep learning can be used for direct visuomotor control, bypassing traditional perception and planning modules. This represents a key step in the transition from classical to learning-based robotics.  
  [arXiv:1504.00702](https://huggingface.co/papers/1504.00702)

- **Learning Dexterous In-Hand Manipulation** (2018)  
  OpenAI et al.  
  This paper demonstrates how reinforcement learning with domain randomization can solve complex manipulation tasks that would be extremely difficult to program using classical methods, highlighting the advantages of learning-based approaches.  
  [arXiv:1808.00177](https://huggingface.co/papers/1808.00177)

## Final Chapter Quiz

Test your understanding of the Classical Robotics unit. Choose the best answer for each question.

### 1. Which set best categorizes types of robot motion discussed in this unit?

<Question
	choices={[
		{
			text: "Navigation, mapping, and planning",
			explain: "These are pipeline functions, not motion categories."
		},
		{
			text: "Manipulation, locomotion, and mobile manipulation",
			explain: "These are the three motion categories described in the unit and latex section.",
	            correct: true
		},
		{
			text: "Simulation, perception, and control",
			explain: "These refer to environments or pipeline components, not motion categories."
		},
	        {
			text: "End-effector, joints, and sensors",
			explain: "These are components, not motion categories."
		}
	]}
/>

### 2. What is the essential difference between forward kinematics (FK) and inverse kinematics (IK)?

<Question
	choices={[
		{
			text: "FK maps joint angles to end-effector pose, whereas IK maps a desired pose to joint angles",
			explain: "Matches the unit and latex definition of FK and IK.",
	            correct: true
		},
		{
			text: "FK is about velocities and IK is about positions",
			explain: "Velocities are handled in differential kinematics; FK/IK are mappings between configuration and task space."
		},
		{
			text: "FK is only for 2‑DoF robots",
			explain: "FK/IK apply to robots with arbitrary DoF."
		},
	        {
			text: "IK is always faster to compute than FK",
			explain: "IK is generally harder; FK is usually straightforward."
		}
	]}
/>

### 3. In differential kinematics, what does the Jacobian J(q) represent?

<Question
	choices={[
		{
			text: "A mapping from joint velocities to end‑effector velocities",
			explain: "ṗ = J(q) q̇ is the fundamental relation (latex Section 02).",
	            correct: true
		},
		{
			text: "A mapping from end‑effector positions to joint torques",
			explain: "That would involve dynamics, not the kinematic Jacobian here."
		},
		{
			text: "The feasible workspace of the robot",
			explain: "Workspace depends on link lengths and limits, not J(q) alone."
		},
	        {
			text: "A motion planner for obstacle avoidance",
			explain: "Planning is a separate module."
		}
	]}
/>

### 4. The closed‑form differential IK solution uses J(q)^+. What does the superscript '+' denote?

<Question
	choices={[
		{
			text: "The Moore–Penrose pseudo‑inverse",
			explain: "This is stated explicitly in the unit and latex.",
	            correct: true
		},
		{
			text: "The transpose of the Jacobian",
			explain: "J^T is not what '+' denotes."
		},
		{
			text: "The determinant of the Jacobian",
			explain: "Determinant is a scalar; '+' indicates pseudo‑inverse."
		},
	        {
			text: "The adjugate of the Jacobian",
			explain: "Not used here."
		}
	]}
/>

### 5. How do obstacles and joint limits affect IK in the planar manipulator example?

<Question
	choices={[
		{
			text: "They restrict the feasible set of configurations and make IK harder",
			explain: "Latex Section 02 shows constraints narrowing Q and complicating IK.",
	            correct: true
		},
		{
			text: "They have no effect on IK solutions",
			explain: "This contradicts the constraints discussion."
		},
		{
			text: "They only change the FK mapping",
			explain: "FK formula stays the same; feasibility changes."
		},
	        {
			text: "They guarantee a unique IK solution",
			explain: "Constraints can remove solutions or make multiple remain."
		}
	]}
/>

### 6. Which statement best characterizes classical robotics pipelines as presented in this unit?

<Question
	choices={[
		{
			text: "They are modular stacks with fixed interfaces (perception, state estimation, planning, control)",
			explain: "Matches the modular pipeline described in latex Section 02.",
	            correct: true
		},
		{
			text: "They are single end‑to‑end learned policies",
			explain: "That describes learning‑based approaches, not classical."
		},
		{
			text: "They do not require expert tuning",
			explain: "Expert tuning is a known limitation of classical pipelines."
		},
	        {
			text: "They inherently integrate raw high‑dimensional inputs",
			explain: "Integration of high‑dimensional inputs is a challenge for classical methods."
		}
	]}
/>

### 7. Which set lists the core limitations highlighted for dynamics‑based approaches?

<Question
	choices={[
		{
			text: "Integration challenges, limited scalability, modeling limitations, and overlooking data trends",
			explain: "This is the exact set emphasized in the unit and latex figure.",
	            correct: true
		},
		{
			text: "Cost, accuracy, speed, and energy consumption",
			explain: "Not the four core limitations discussed here."
		},
		{
			text: "Hardware reliability, software licensing, and safety standards",
			explain: "Important topics but not the four cited limitations."
		},
	        {
			text: "Planner optimality, sensor calibration, and actuator wear",
			explain: "These are narrower engineering issues, not the core set."
		}
	]}
/>

### 8. What key advantage of learning‑based approaches is emphasized as a contrast to classical methods?

<Question
	choices={[
		{
			text: "They can learn end‑to‑end from data and generalize across tasks/embodiments",
			explain: "Consistent with the latex and unit discussion on generalization and end‑to‑end training.",
	            correct: true
		},
		{
			text: "They eliminate the need for sensors",
			explain: "Sensors remain essential."
		},
		{
			text: "They require no compute resources",
			explain: "Compute and data scale are central to learning."
		},
	        {
			text: "They do not need datasets",
			explain: "Learning approaches rely on data."
		}
	]}
/>

### 9. Why does the availability of open robotics datasets matter in this unit’s context?

<Question
	choices={[
		{
			text: "It enables learning‑based methods to scale and transfer knowledge",
			explain: "Matches the latex discussion of data trends motivating learning.",
	            correct: true
		},
		{
			text: "It reduces manufacturing costs of robot arms",
			explain: "Manufacturing costs are separate from dataset availability."
		},
		{
			text: "It removes the need for control theory entirely",
			explain: "Control insights still matter, even with learning."
		},
	        {
			text: "It guarantees perfect generalization",
			explain: "No method guarantees perfect generalization."
		}
	]}
/>


<EditOnGithub source="https://github.com/huggingface/robotics-course/blob/main/units/en/unit2/5.mdx" />