import{s as Pe,f as He,o as Je,n as Ie}from"../chunks/scheduler.f6319a2a.js";import{S as je,i as Ue,g as i,s as l,r as d,A as qe,h as a,f as n,c as s,j as Ae,u as f,x as r,k as Yt,y as Ge,a as o,v as c,d as w,t as g,w as y}from"../chunks/index.85aa684c.js";import{T as Se}from"../chunks/Tip.3d397a88.js";import{C as We}from"../chunks/CodeBlock.3400fc53.js";import{H as it,E as Be}from"../chunks/getInferenceSnippets.65c384ba.js";function Ee(at){let u,v="AI Agents are <strong>programs where LLM outputs control the workflow</strong>.";return{c(){u=i("p"),u.innerHTML=v},l(p){u=a(p,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1w9gkhf"&&(u.innerHTML=v)},m(p,ot){o(p,u,ot)},p:Ie,d(p){p&&n(u)}}}function Re(at){let u,v,p,ot,x,rt,M,ut,b,Zt="Any efficient system using AI will need to provide LLMs some kind of access to the real world: for instance the possibility to call a search tool to get external information, or to act on certain programs in order to solve a task. In other words, LLMs should have <strong><em>agency</em></strong>. Agentic programs are the gateway to the outside world for LLMs.",pt,m,mt,L,Qt="Any system leveraging LLMs will integrate the LLM outputs into code. The influence of the LLM’s input on the code workflow is the level of agency of LLMs in the system.",ht,C,Dt="Note that with this definition, “agent” is not a discrete, 0 or 1 definition: instead, “agency” evolves on a continuous spectrum, as you give more or less power to the LLM on your workflow.",dt,_,Kt="See in the table below how agency can vary across systems:",ft,k,te="<thead><tr><th>Agency Level</th> <th>Description</th> <th>Short name</th> <th>Example Code</th></tr></thead> <tbody><tr><td>☆☆☆</td> <td>LLM output has no impact on program flow</td> <td>Simple processor</td> <td><code>process_llm_output(llm_response)</code></td></tr> <tr><td>★☆☆</td> <td>LLM output controls an if/else switch</td> <td>Router</td> <td><code>if llm_decision(): path_a() else: path_b()</code></td></tr> <tr><td>★★☆</td> <td>LLM output controls function execution</td> <td>Tool call</td> <td><code>run_function(llm_chosen_tool, llm_chosen_args)</code></td></tr> <tr><td>★★☆</td> <td>LLM output controls iteration and program continuation</td> <td>Multi-step Agent</td> <td><code>while llm_should_continue(): execute_next_step()</code></td></tr> <tr><td>★★★</td> <td>One agentic workflow can start another agentic workflow</td> <td>Multi-Agent</td> <td><code>if llm_trigger(): execute_agent()</code></td></tr> <tr><td>★★★</td> <td>LLM acts in code, can define its own tools / start other agents</td> <td>Code Agents</td> <td><code>def custom_tool(args): ...</code></td></tr></tbody>",ct,$,ee="The multi-step agent has this code structure:",wt,T,gt,A,ne="This agentic system runs in a loop, executing a new action at each step (the action can involve calling some pre-determined <em>tools</em> that are just functions), until its observations make it apparent that a satisfactory state has been reached to solve the given task. Here’s an example of how a multi-step agent can solve a simple math question:",yt,h,oe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Agent_ManimCE.gif"/>',vt,P,xt,H,le=`Agents are useful when you need an LLM to determine the workflow of an app. But they’re often overkill. The question is: do I really need flexibility in the workflow to efficiently solve the task at hand?
If the pre-determined workflow falls short too often, that means you need more flexibility.
Let’s take an example: say you’re making an app that handles customer requests on a surfing trip website.`,Mt,J,se="You could know in advance that the requests will belong to either of 2 buckets (based on user choice), and you have a predefined workflow for each of these 2 cases.",bt,I,ie="<li>Want some knowledge on the trips? ⇒ give them access to a search bar to search your knowledge base</li> <li>Wants to talk to sales? ⇒ let them type in a contact form.</li>",Lt,j,ae="If that deterministic workflow fits all queries, by all means just code everything! This will give you a 100% reliable system with no risk of error introduced by letting unpredictable LLMs meddle in your workflow. For the sake of simplicity and robustness, it’s advised to regularize towards not using any agentic behaviour.",Ct,U,re="But what if the workflow can’t be determined that well in advance?",_t,q,ue="For instance, a user wants to ask: <code>&quot;I can come on Monday, but I forgot my passport so risk being delayed to Wednesday, is it possible to take me and my stuff to surf on Tuesday morning, with a cancellation insurance?&quot;</code> This question hinges on many factors, and probably none of the predetermined criteria above will suffice for this request.",kt,G,pe="If the pre-determined workflow falls short too often, that means you need more flexibility.",$t,S,me="That is where an agentic setup helps.",Tt,W,he="In the above example, you could just make a multi-step agent that has access to a weather API for weather forecasts, Google Maps API to compute travel distance, an employee availability dashboard and a RAG system on your knowledge base.",At,B,de="Until recently, computer programs were restricted to pre-determined workflows, trying to handle complexity by piling up  if/else switches. They focused on extremely narrow tasks, like “compute the sum of these numbers” or “find the shortest path in this graph”. But actually, most real-life tasks, like our trip example above, do not fit in pre-determined workflows. Agentic systems open up the vast world of real-world tasks to programs!",Pt,E,Ht,R,fe="For some low-level agentic use cases, like chains or routers, you can write all the code yourself. You’ll be much better that way, since it will let you control and understand your system better.",Jt,V,ce="But once you start going for more complicated behaviours like letting an LLM call a function (that’s “tool calling”) or letting an LLM run a while loop (“multi-step agent”), some abstractions become necessary:",It,N,we="<li>For tool calling, you need to parse the agent’s output, so this output needs a predefined format like “Thought: I should call tool ‘get_weather’. Action: get_weather(Paris).”, that you parse with a predefined function, and system prompt given to the LLM should notify it about this format.</li> <li>For a multi-step agent where the LLM output determines the loop, you need to give a different prompt to the LLM based on what happened in the last loop iteration: so you need some kind of memory.</li>",jt,z,ge="See? With these two examples, we already found the need for a few items to help us:",Ut,O,ye="<li>Of course, an LLM that acts as the engine powering the system</li> <li>A list of tools that the agent can access</li> <li>A parser that extracts tool calls from the LLM output</li> <li>A system prompt synced with the parser</li> <li>A memory</li>",qt,F,ve="But wait, since we give room to LLMs in decisions, surely they will make mistakes: so we need error logging and retry mechanisms.",Gt,X,xe="All these elements need tight coupling to make a well-functioning system. That’s why we decided we needed to make basic building blocks to make all this stuff work together.",St,Y,Wt,Z,Me="In a multi-step agent, at each step, the LLM can write an action, in the form of some calls to external tools. A common format (used by Anthropic, OpenAI, and many others) for writing these actions is generally different shades of “writing actions as a JSON of tools names and arguments to use, which you then parse to know which tool to execute and with which arguments”.",Bt,Q,be='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLMs actions written as code snippets is a more natural and flexible way of writing them.',Et,D,Le=`The reason for this simply that <em>we crafted our code languages specifically to express the actions performed by a computer</em>.
In other words, our agent is going to write programs in order to solve the user’s issues : do you think their programming will be easier in blocks of Python or JSON?`,Rt,K,Ce='The figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>, illustrates some advantages of writing actions in code:',Vt,lt,_e,Nt,tt,ke="Writing actions in code rather than JSON-like snippets provides better:",zt,et,$e="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training data:</strong> plenty of quality code actions are already included in LLMs’ training data which means they’re already trained for this!</li>",Ot,nt,Ft,st,Xt;return x=new it({props:{title:"Introduction to Agents",local:"introduction-to-agents",headingTag:"h1"}}),M=new it({props:{title:"🤔 What are agents?",local:"-what-are-agents",headingTag:"h2"}}),m=new Se({props:{warning:!1,$$slots:{default:[Ee]},$$scope:{ctx:at}}}),T=new We({props:{code:"bWVtb3J5JTIwJTNEJTIwJTVCdXNlcl9kZWZpbmVkX3Rhc2slNUQlMEF3aGlsZSUyMGxsbV9zaG91bGRfY29udGludWUobWVtb3J5KSUzQSUyMCUyMyUyMHRoaXMlMjBsb29wJTIwaXMlMjB0aGUlMjBtdWx0aS1zdGVwJTIwcGFydCUwQSUyMCUyMCUyMCUyMGFjdGlvbiUyMCUzRCUyMGxsbV9nZXRfbmV4dF9hY3Rpb24obWVtb3J5KSUyMCUyMyUyMHRoaXMlMjBpcyUyMHRoZSUyMHRvb2wtY2FsbGluZyUyMHBhcnQlMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbnMlMjAlM0QlMjBleGVjdXRlX2FjdGlvbihhY3Rpb24pJTBBJTIwJTIwJTIwJTIwbWVtb3J5JTIwJTJCJTNEJTIwJTVCYWN0aW9uJTJDJTIwb2JzZXJ2YXRpb25zJTVE",highlighted:`memory = [user_defined_task]
<span class="hljs-keyword">while</span> llm_should_continue(memory): <span class="hljs-comment"># this loop is the multi-step part</span>
    action = llm_get_next_action(memory) <span class="hljs-comment"># this is the tool-calling part</span>
    observations = execute_action(action)
    memory += [action, observations]`,wrap:!1}}),P=new it({props:{title:"✅ When to use agents / ⛔ when to avoid them",local:"-when-to-use-agents---when-to-avoid-them",headingTag:"h2"}}),E=new it({props:{title:"Why smolagents ?",local:"why-smolagents-",headingTag:"h2"}}),Y=new it({props:{title:"Code agents",local:"code-agents",headingTag:"h2"}}),nt=new Be({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/conceptual_guides/intro_agents.mdx"}}),{c(){u=i("meta"),v=l(),p=i("p"),ot=l(),d(x.$$.fragment),rt=l(),d(M.$$.fragment),ut=l(),b=i("p"),b.innerHTML=Zt,pt=l(),d(m.$$.fragment),mt=l(),L=i("p"),L.textContent=Qt,ht=l(),C=i("p"),C.textContent=Dt,dt=l(),_=i("p"),_.textContent=Kt,ft=l(),k=i("table"),k.innerHTML=te,ct=l(),$=i("p"),$.textContent=ee,wt=l(),d(T.$$.fragment),gt=l(),A=i("p"),A.innerHTML=ne,yt=l(),h=i("div"),h.innerHTML=oe,vt=l(),d(P.$$.fragment),xt=l(),H=i("p"),H.textContent=le,Mt=l(),J=i("p"),J.textContent=se,bt=l(),I=i("ol"),I.innerHTML=ie,Lt=l(),j=i("p"),j.textContent=ae,Ct=l(),U=i("p"),U.textContent=re,_t=l(),q=i("p"),q.innerHTML=ue,kt=l(),G=i("p"),G.textContent=pe,$t=l(),S=i("p"),S.textContent=me,Tt=l(),W=i("p"),W.textContent=he,At=l(),B=i("p"),B.textContent=de,Pt=l(),d(E.$$.fragment),Ht=l(),R=i("p"),R.textContent=fe,Jt=l(),V=i("p"),V.textContent=ce,It=l(),N=i("ul"),N.innerHTML=we,jt=l(),z=i("p"),z.textContent=ge,Ut=l(),O=i("ul"),O.innerHTML=ye,qt=l(),F=i("p"),F.textContent=ve,Gt=l(),X=i("p"),X.textContent=xe,St=l(),d(Y.$$.fragment),Wt=l(),Z=i("p"),Z.textContent=Me,Bt=l(),Q=i("p"),Q.innerHTML=be,Et=l(),D=i("p"),D.innerHTML=Le,Rt=l(),K=i("p"),K.innerHTML=Ce,Vt=l(),lt=i("img"),Nt=l(),tt=i("p"),tt.textContent=ke,zt=l(),et=i("ul"),et.innerHTML=$e,Ot=l(),d(nt.$$.fragment),Ft=l(),st=i("p"),this.h()},l(t){const e=qe("svelte-u9bgzb",document.head);u=a(e,"META",{name:!0,content:!0}),e.forEach(n),v=s(t),p=a(t,"P",{}),Ae(p).forEach(n),ot=s(t),f(x.$$.fragment,t),rt=s(t),f(M.$$.fragment,t),ut=s(t),b=a(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-t8xwkl"&&(b.innerHTML=Zt),pt=s(t),f(m.$$.fragment,t),mt=s(t),L=a(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-hvpo8l"&&(L.textContent=Qt),ht=s(t),C=a(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1ocrk28"&&(C.textContent=Dt),dt=s(t),_=a(t,"P",{"data-svelte-h":!0}),r(_)!=="svelte-15ep98q"&&(_.textContent=Kt),ft=s(t),k=a(t,"TABLE",{"data-svelte-h":!0}),r(k)!=="svelte-167gmr2"&&(k.innerHTML=te),ct=s(t),$=a(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1xdd6c8"&&($.textContent=ee),wt=s(t),f(T.$$.fragment,t),gt=s(t),A=a(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1n725h4"&&(A.innerHTML=ne),yt=s(t),h=a(t,"DIV",{class:!0,"data-svelte-h":!0}),r(h)!=="svelte-znws87"&&(h.innerHTML=oe),vt=s(t),f(P.$$.fragment,t),xt=s(t),H=a(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1vnvz56"&&(H.textContent=le),Mt=s(t),J=a(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-16gbieh"&&(J.textContent=se),bt=s(t),I=a(t,"OL",{"data-svelte-h":!0}),r(I)!=="svelte-1v0rus5"&&(I.innerHTML=ie),Lt=s(t),j=a(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-d38gnh"&&(j.textContent=ae),Ct=s(t),U=a(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-16wqlg"&&(U.textContent=re),_t=s(t),q=a(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1qwedk6"&&(q.innerHTML=ue),kt=s(t),G=a(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-j2eqzu"&&(G.textContent=pe),$t=s(t),S=a(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-lqbq6n"&&(S.textContent=me),Tt=s(t),W=a(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-eus48c"&&(W.textContent=he),At=s(t),B=a(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-4d8m3z"&&(B.textContent=de),Pt=s(t),f(E.$$.fragment,t),Ht=s(t),R=a(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1o6p1sy"&&(R.textContent=fe),Jt=s(t),V=a(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-olr701"&&(V.textContent=ce),It=s(t),N=a(t,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-5j7kqn"&&(N.innerHTML=we),jt=s(t),z=a(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-19q6xk9"&&(z.textContent=ge),Ut=s(t),O=a(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-oysp1q"&&(O.innerHTML=ye),qt=s(t),F=a(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-95dd5s"&&(F.textContent=ve),Gt=s(t),X=a(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-19mjig0"&&(X.textContent=xe),St=s(t),f(Y.$$.fragment,t),Wt=s(t),Z=a(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1i79ci0"&&(Z.textContent=Me),Bt=s(t),Q=a(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qdqtni"&&(Q.innerHTML=be),Et=s(t),D=a(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-ysoq7h"&&(D.innerHTML=Le),Rt=s(t),K=a(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1k33473"&&(K.innerHTML=Ce),Vt=s(t),lt=a(t,"IMG",{src:!0}),Nt=s(t),tt=a(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-18lekkw"&&(tt.textContent=ke),zt=s(t),et=a(t,"UL",{"data-svelte-h":!0}),r(et)!=="svelte-1qmn0c3"&&(et.innerHTML=$e),Ot=s(t),f(nt.$$.fragment,t),Ft=s(t),st=a(t,"P",{}),Ae(st).forEach(n),this.h()},h(){Yt(u,"name","hf:doc:metadata"),Yt(u,"content",Ve),Yt(h,"class","flex justify-center"),He(lt.src,_e="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||Yt(lt,"src",_e)},m(t,e){Ge(document.head,u),o(t,v,e),o(t,p,e),o(t,ot,e),c(x,t,e),o(t,rt,e),c(M,t,e),o(t,ut,e),o(t,b,e),o(t,pt,e),c(m,t,e),o(t,mt,e),o(t,L,e),o(t,ht,e),o(t,C,e),o(t,dt,e),o(t,_,e),o(t,ft,e),o(t,k,e),o(t,ct,e),o(t,$,e),o(t,wt,e),c(T,t,e),o(t,gt,e),o(t,A,e),o(t,yt,e),o(t,h,e),o(t,vt,e),c(P,t,e),o(t,xt,e),o(t,H,e),o(t,Mt,e),o(t,J,e),o(t,bt,e),o(t,I,e),o(t,Lt,e),o(t,j,e),o(t,Ct,e),o(t,U,e),o(t,_t,e),o(t,q,e),o(t,kt,e),o(t,G,e),o(t,$t,e),o(t,S,e),o(t,Tt,e),o(t,W,e),o(t,At,e),o(t,B,e),o(t,Pt,e),c(E,t,e),o(t,Ht,e),o(t,R,e),o(t,Jt,e),o(t,V,e),o(t,It,e),o(t,N,e),o(t,jt,e),o(t,z,e),o(t,Ut,e),o(t,O,e),o(t,qt,e),o(t,F,e),o(t,Gt,e),o(t,X,e),o(t,St,e),c(Y,t,e),o(t,Wt,e),o(t,Z,e),o(t,Bt,e),o(t,Q,e),o(t,Et,e),o(t,D,e),o(t,Rt,e),o(t,K,e),o(t,Vt,e),o(t,lt,e),o(t,Nt,e),o(t,tt,e),o(t,zt,e),o(t,et,e),o(t,Ot,e),c(nt,t,e),o(t,Ft,e),o(t,st,e),Xt=!0},p(t,[e]){const Te={};e&2&&(Te.$$scope={dirty:e,ctx:t}),m.$set(Te)},i(t){Xt||(w(x.$$.fragment,t),w(M.$$.fragment,t),w(m.$$.fragment,t),w(T.$$.fragment,t),w(P.$$.fragment,t),w(E.$$.fragment,t),w(Y.$$.fragment,t),w(nt.$$.fragment,t),Xt=!0)},o(t){g(x.$$.fragment,t),g(M.$$.fragment,t),g(m.$$.fragment,t),g(T.$$.fragment,t),g(P.$$.fragment,t),g(E.$$.fragment,t),g(Y.$$.fragment,t),g(nt.$$.fragment,t),Xt=!1},d(t){t&&(n(v),n(p),n(ot),n(rt),n(ut),n(b),n(pt),n(mt),n(L),n(ht),n(C),n(dt),n(_),n(ft),n(k),n(ct),n($),n(wt),n(gt),n(A),n(yt),n(h),n(vt),n(xt),n(H),n(Mt),n(J),n(bt),n(I),n(Lt),n(j),n(Ct),n(U),n(_t),n(q),n(kt),n(G),n($t),n(S),n(Tt),n(W),n(At),n(B),n(Pt),n(Ht),n(R),n(Jt),n(V),n(It),n(N),n(jt),n(z),n(Ut),n(O),n(qt),n(F),n(Gt),n(X),n(St),n(Wt),n(Z),n(Bt),n(Q),n(Et),n(D),n(Rt),n(K),n(Vt),n(lt),n(Nt),n(tt),n(zt),n(et),n(Ot),n(Ft),n(st)),n(u),y(x,t),y(M,t),y(m,t),y(T,t),y(P,t),y(E,t),y(Y,t),y(nt,t)}}}const Ve='{"title":"Introduction to Agents","local":"introduction-to-agents","sections":[{"title":"🤔 What are agents?","local":"-what-are-agents","sections":[],"depth":2},{"title":"✅ When to use agents / ⛔ when to avoid them","local":"-when-to-use-agents---when-to-avoid-them","sections":[],"depth":2},{"title":"Why smolagents ?","local":"why-smolagents-","sections":[],"depth":2},{"title":"Code agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function Ne(at){return Je(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ze extends je{constructor(u){super(),Ue(this,u,Ne,Re,Pe,{})}}export{Ze as component};
