import{s as xT,n as _T,o as $T}from"../chunks/scheduler.3d32dc09.js";import{S as qT,i as LT,e as t,s as M,c as s,q as zT,h as PT,a,d as T,b as e,f as Wl,g as n,j as i,r as ET,k as UT,l as h,m as J,n as y,t as o,o as w,p as C}from"../chunks/index.f9718211.js";import{C as KT,H as p,E as lJ}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.51c38499.js";import{C as d}from"../chunks/CodeBlock.ab331c21.js";import{D as UJ}from"../chunks/DocNotebookDropdown.79c5aa63.js";function TJ(TT){let I,fl,Ol,vl,N,Al,r,Yl,b,Xl,u,JT=`There’s a world of difference between building an agent that works and one that doesn’t.
How can we build agents that fall into the former category?
In this guide, we’re going to talk about best practices for building agents.`,Dl,g,MT='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',Hl,m,Sl,V,eT="Giving an LLM some agency in your workflow introduces some risk of errors.",zl,k,tT="Well-programmed agentic systems have good error logging and retry mechanisms anyway, so the LLM engine has a chance to self-correct their mistake. But to reduce the risk of LLM error to the maximum, you should simplify your workflow!",El,F,aT=`Let’s revisit the example from the <a href="../conceptual_guides/intro_agents">intro to agents</a>: a bot that answers user queries for a surf trip company.
Instead of letting the agent do 2 different calls for “travel distance API” and “weather API” each time they are asked about a new surf spot, you could just make one unified tool “return_spot_information”, a function that calls both APIs at once and returns their concatenated outputs to the user.`,xl,R,iT="This will reduce costs, latency, and error risk!",_l,j,sT="The main guideline is: Reduce the number of LLM calls as much as you can.",$l,B,nT="This leads to a few takeaways:",ql,G,yT="<li>Whenever possible, group 2 tools in one, like in our example of the two APIs.</li> <li>Whenever possible, logic should be based on deterministic functions rather than agentic decisions.</li>",Ll,Q,Pl,O,oT="Remember that your LLM engine is like an <em>intelligent</em> robot, trapped into a room with the only communication with the outside world being notes passed under a door.",Kl,Z,wT="It won’t know of anything that happened if you don’t explicitly put that into its prompt.",lU,W,CT=`So first start with making your task very clear!
Since an agent is powered by an LLM, minor variations in your task formulation might yield completely different results.`,UU,f,dT="Then, improve the information flow towards your agent in tool use.",TU,v,cT="Particular guidelines to follow:",JU,A,IT="<li>Each tool should log (by simply using <code>print</code> statements inside the tool’s <code>forward</code> method) everything that could be useful for the LLM engine.<ul><li>In particular, logging detail on tool execution errors would help a lot!</li></ul></li>",MU,Y,pT="For instance, here’s a tool that retrieves weather data based on location and date-time:",eU,X,gT="First, here’s a poor version:",tU,D,aU,H,hT="Why is it bad?",iU,S,NT="<li>there’s no precision of the format that should be used for <code>date_time</code></li> <li>there’s no detail on how location should be specified.</li> <li>there’s no logging mechanism trying to make explicit failure cases like location not being in a proper format, or date_time not being properly formatted.</li> <li>the output format is hard to understand</li>",sU,z,rT="If the tool call fails, the error trace logged in memory can help the LLM reverse engineer the tool to fix the errors. But why leave it with so much heavy lifting to do?",nU,E,bT="A better way to build this tool would have been the following:",yU,x,oU,_,uT="In general, to ease the load on your LLM, the good question to ask yourself is: “How easy would it be for me, if I was dumb and using this tool for the first time ever, to program with this tool and correct my own errors?“.",wU,$,CU,q,mT="To pass some additional objects to your agent beyond the simple string describing the task, you can use the <code>additional_args</code> argument to pass any type of object:",dU,L,cU,P,VT="For instance, you can use this <code>additional_args</code> argument to pass images or strings that you want your agent to leverage.",IU,K,pU,ll,gU,Ul,kT=`In an agentic workflows, some of the errors are actual errors, some other are the fault of your LLM engine not reasoning properly.
For instance, consider this trace for an <code>CodeAgent</code> that I asked to create a car picture:`,hU,Tl,NU,Jl,FT=`The user sees, instead of an image being returned, a path being returned to them.
It could look like a bug from the system, but actually the agentic system didn’t cause the error: it’s just that the LLM brain did the mistake of not saving the image output into a variable.
Thus it cannot access the image again except by leveraging the path that was logged while saving the image, so it returns the path instead of an image.`,rU,Ml,RT="The first step to debugging your agent is thus “Use a more powerful LLM”. Alternatives like <code>Qwen2/5-72B-Instruct</code> wouldn’t have made that mistake.",bU,el,uU,tl,jT="You can also use less powerful models, provided you guide them more effectively.",mU,al,BT="Put yourself in the shoes of your model: if you were the model solving the task, would you struggle with the information available to you (from the system prompt + task formulation + tool description) ?",VU,il,GT="Would you need detailed instructions?",kU,sl,QT="<li>If the instruction is to always be given to the agent (as we generally understand a system prompt to work): you can pass it as a string under argument <code>instructions</code> upon agent initialization. <em>(Note: instructions are appended to the system prompt, not replacing it.)</em></li> <li>If it’s about a specific task to solve: add all these details to the task. The task could be very long, like dozens of pages.</li> <li>If it’s about how to use specific tools: include it in the <code>description</code> attribute of these tools.</li>",FU,nl,RU,yl,OT="If above clarifications are not sufficient, you can change the agent’s prompt templates.",jU,ol,ZT='Let’s see how it works. For example, let us check the default prompt templates for the <a href="/docs/smolagents/v1.22.0/en/reference/agents#smolagents.CodeAgent">CodeAgent</a> (below version is shortened by skipping zero-shot examples).',BU,wl,GU,Cl,WT="Here is what you get:",QU,dl,OU,cl,fT="As you can see, there are placeholders like <code>&quot;{{ tool.description }}&quot;</code>: these will be used upon agent initialization to insert certain automatically generated descriptions of tools or managed agents.",ZU,Il,vT="So while you can overwrite this system prompt template by passing your custom prompt as an argument to the <code>system_prompt</code> parameter, your new system prompt can contain the following placeholders:",WU,c,jl,$U,pl,qU,Bl,LU,gl,PU,Gl,AT="For <code>CodeAgent</code> only, to insert the list of authorized imports: <code>&quot;{{authorized_imports}}&quot;</code>",fU,hl,YT="Then you can change the system prompt as follows:",vU,Nl,AU,rl,XT='This also works with the <a href="/docs/smolagents/v1.22.0/en/reference/agents#smolagents.ToolCallingAgent">ToolCallingAgent</a>.',YU,bl,DT="But generally it’s just simpler to pass argument <code>instructions</code> upon agent initalization, like:",XU,ul,DU,ml,HT="Note that <code>instructions</code> are appended to the system prompt, not replacing it.",HU,Vl,SU,kl,ST="We provide a model for a supplementary planning step, that an agent can run regularly in-between normal action steps. In this step, there is no tool call, the LLM is simply asked to update a list of facts it knows and to reflect on what steps it should take next based on those facts.",zU,Fl,EU,Rl,xU,Zl,_U;return N=new KT({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),r=new p({props:{title:"Building good agents",local:"building-good-agents",headingTag:"h1"}}),b=new UJ({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/building_good_agents.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/building_good_agents.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/building_good_agents.ipynb"}]}}),m=new p({props:{title:"The best agentic systems are the simplest: simplify the workflow as much as you can",local:"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can",headingTag:"h3"}}),Q=new p({props:{title:"Improve the information flow to the LLM engine",local:"improve-the-information-flow-to-the-llm-engine",headingTag:"h3"}}),D=new d({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMHRvb2wlMEElMEFkZWYlMjBnZXRfd2VhdGhlcl9yZXBvcnRfYXRfY29vcmRpbmF0ZXMoY29vcmRpbmF0ZXMlMkMlMjBkYXRlX3RpbWUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRHVtbXklMjBmdW5jdGlvbiUyQyUyMHJldHVybnMlMjBhJTIwbGlzdCUyMG9mJTIwJTVCdGVtcGVyYXR1cmUlMjBpbiUyMCVDMiVCMEMlMkMlMjByaXNrJTIwb2YlMjByYWluJTIwb24lMjBhJTIwc2NhbGUlMjAwLTElMkMlMjB3YXZlJTIwaGVpZ2h0JTIwaW4lMjBtJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCMjguMCUyQyUyMDAuMzUlMkMlMjAwLjg1JTVEJTBBJTBBZGVmJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBSZXR1cm5zJTIwZHVtbXklMjBjb29yZGluYXRlcyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU1QjMuMyUyQyUyMC00Mi4wJTVEJTBBJTBBJTQwdG9vbCUwQWRlZiUyMGdldF93ZWF0aGVyX2FwaShsb2NhdGlvbiUzQSUyMHN0ciUyQyUyMGRhdGVfdGltZSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwUmV0dXJucyUyMHRoZSUyMHdlYXRoZXIlMjByZXBvcnQuJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvY2F0aW9uJTNBJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwcGxhY2UlMjB0aGF0JTIweW91JTIwd2FudCUyMHRoZSUyMHdlYXRoZXIlMjBmb3IuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0ZV90aW1lJTNBJTIwdGhlJTIwZGF0ZSUyMGFuZCUyMHRpbWUlMjBmb3IlMjB3aGljaCUyMHlvdSUyMHdhbnQlMjB0aGUlMjByZXBvcnQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbG9uJTJDJTIwbGF0JTIwJTNEJTIwY29udmVydF9sb2NhdGlvbl90b19jb29yZGluYXRlcyhsb2NhdGlvbiklMEElMjAlMjAlMjAlMjBkYXRlX3RpbWUlMjAlM0QlMjBkYXRldGltZS5zdHJwdGltZShkYXRlX3RpbWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGdldF93ZWF0aGVyX3JlcG9ydF9hdF9jb29yZGluYXRlcygobG9uJTJDJTIwbGF0KSUyQyUyMGRhdGVfdGltZSkp",highlighted:`<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_report_at_coordinates</span>(<span class="hljs-params">coordinates, date_time</span>):
    <span class="hljs-comment"># Dummy function, returns a list of [temperature in °C, risk of rain on a scale 0-1, wave height in m]</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">28.0</span>, <span class="hljs-number">0.35</span>, <span class="hljs-number">0.85</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">convert_location_to_coordinates</span>(<span class="hljs-params">location</span>):
    <span class="hljs-comment"># Returns dummy coordinates</span>
    <span class="hljs-keyword">return</span> [<span class="hljs-number">3.3</span>, -<span class="hljs-number">42.0</span>]

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for.
        date_time: the date and time for which you want the report.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(get_weather_report_at_coordinates((lon, lat), date_time))`,wrap:!1}}),x=new d({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather_api</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, date_time: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Returns the weather report.

    Args:
        location: the name of the place that you want the weather for. Should be a place name, followed by possibly a city name, then a country, like &quot;Anchor Point, Taghazout, Morocco&quot;.
        date_time: the date and time for which you want the report, formatted as &#x27;%m/%d/%y %H:%M:%S&#x27;.
    &quot;&quot;&quot;</span>
    lon, lat = convert_location_to_coordinates(location)
    <span class="hljs-keyword">try</span>:
        date_time = datetime.strptime(date_time)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">&quot;Conversion of \`date_time\` to datetime format failed, make sure to provide a string in format &#x27;%m/%d/%y %H:%M:%S&#x27;. Full trace:&quot;</span> + <span class="hljs-built_in">str</span>(e))
    temperature_celsius, risk_of_rain, wave_height = get_weather_report_at_coordinates((lon, lat), date_time)
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Weather report for <span class="hljs-subst">{location}</span>, <span class="hljs-subst">{date_time}</span>: Temperature will be <span class="hljs-subst">{temperature_celsius}</span>°C, risk of rain is <span class="hljs-subst">{risk_of_rain*<span class="hljs-number">100</span>:<span class="hljs-number">.0</span>f}</span>%, wave height is <span class="hljs-subst">{wave_height}</span>m.&quot;</span>`,wrap:!1}}),$=new p({props:{title:"Give more arguments to the agent",local:"give-more-arguments-to-the-agent",headingTag:"h3"}}),L=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMy03MEItSW5zdHJ1Y3QlMjIlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0Rtb2RlbF9pZCklMkMlMjBhZGRfYmFzZV90b29scyUzRFRydWUpJTBBJTBBYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMldoeSUyMGRvZXMlMjBNaWtlJTIwbm90JTIwa25vdyUyMG1hbnklMjBwZW9wbGUlMjBpbiUyME5ldyUyMFlvcmslM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGRpdGlvbmFsX2FyZ3MlM0QlN0IlMjJtcDNfc291bmRfZmlsZV91cmwlMjIlM0EnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmVjb3JkaW5nLm1wMyclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.3-70B-Instruct&quot;</span>

agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), add_base_tools=<span class="hljs-literal">True</span>)

agent.run(
    <span class="hljs-string">&quot;Why does Mike not know many people in New York?&quot;</span>,
    additional_args={<span class="hljs-string">&quot;mp3_sound_file_url&quot;</span>:<span class="hljs-string">&#x27;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/recording.mp3&#x27;</span>}
)`,wrap:!1}}),K=new p({props:{title:"How to debug your agent",local:"how-to-debug-your-agent",headingTag:"h2"}}),ll=new p({props:{title:"1. Use a stronger LLM",local:"1-use-a-stronger-llm",headingTag:"h3"}}),Tl=new d({props:{code:"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",highlighted:`==================================================================================================== <span class="hljs-keyword">New</span> <span class="hljs-keyword">task</span> ====================================================================================================
Make me a cool car picture
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
image_generator(prompt=<span class="hljs-string">&quot;A cool, futuristic sports car with LED headlights, aerodynamic design, and vibrant color, high-res, photorealistic&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Step</span> <span class="hljs-number">1</span>:

- Time taken: <span class="hljs-number">16.35</span> seconds
- Input tokens: <span class="hljs-number">1</span>,<span class="hljs-number">383</span>
- Output tokens: <span class="hljs-number">77</span>
──────────────────────────────────────────────────────────────────────────────────────────────────── <span class="hljs-keyword">New</span> <span class="hljs-keyword">step</span> ────────────────────────────────────────────────────────────────────────────────────────────────────
Agent is executing the code below: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
final_answer(<span class="hljs-string">&quot;/var/folders/6m/9b1tts6d5w960j80wbw9tx3m0000gn/T/tmpx09qfsdd/652f0007-3ee9-44e2-94ac-90dae6bb89a4.png&quot;</span>)
──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-keyword">Print</span> outputs:

Last output <span class="hljs-keyword">from</span> code snippet: ───────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png
<span class="hljs-keyword">Final</span> answer:
<span class="hljs-regexp">/var/</span>folders<span class="hljs-regexp">/6m/</span><span class="hljs-number">9</span>b1tts6d5w960j80wbw9tx3m0000gn<span class="hljs-regexp">/T/</span>tmpx09qfsdd/<span class="hljs-number">652</span>f0007-<span class="hljs-number">3</span>ee9-<span class="hljs-number">44</span>e2-<span class="hljs-number">94</span>ac-<span class="hljs-number">90</span>dae6bb89a4.png`,wrap:!1}}),el=new p({props:{title:"2. Provide more information or specific instructions",local:"2-provide-more-information-or-specific-instructions",headingTag:"h3"}}),nl=new p({props:{title:"3. Change the prompt templates (generally not advised)",local:"3-change-the-prompt-templates-generally-not-advised",headingTag:"h3"}}),wl=new d({props:{code:"cHJpbnQoYWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQp",highlighted:'<span class="hljs-built_in">print</span>(agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>])',wrap:!1}}),dl=new d({props:{code:"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",highlighted:`You are an expert assistant who can solve any task using code blobs. You will be given a task to solve as best you can.
To do so, you have been given access to a list of tools: these tools are basically Python functions which you can call with code.
To solve the task, you must plan forward to proceed in a series of steps, in a cycle of Thought, Code, and Observation sequences.

At each step, in the &#x27;Thought:&#x27; sequence, you should first explain your reasoning towards solving the task and the tools that you want to use.
Then in the Code sequence you should write the code in simple Python. The code sequence must be opened with &#x27;{{code_block_opening_tag}}&#x27;, and closed with &#x27;{{code_block_closing_tag}}&#x27;.
During each intermediate step, you can use &#x27;print()&#x27; to save whatever important information you will then need.
These print outputs will then appear in the &#x27;Observation:&#x27; field, which will be available as input for the next step.
In the end you have to return a final answer using the \`final_answer\` tool.

Here are a few examples using notional tools:
---
Task: &quot;Generate an image of the oldest person in this document.&quot;

Thought: I will proceed step by step and use the following tools: \`document_qa\` to find the oldest person in the document, then \`image_generator\` to generate an image according to the answer.
{{code_block_opening_tag}}
answer = document_qa(document=document, question=&quot;Who is the oldest person mentioned?&quot;)
print(answer)
{{code_block_closing_tag}}
Observation: &quot;The oldest person in the document is John Doe, a 55 year old lumberjack living in Newfoundland.&quot;

Thought: I will now generate an image showcasing the oldest person.
{{code_block_opening_tag}}
image = image_generator(&quot;A portrait of John Doe, a 55-year-old man living in Canada.&quot;)
final_answer(image)
{{code_block_closing_tag}}

---
Task: &quot;What is the result of the following operation: 5 + 3 + 1294.678?&quot;

Thought: I will use python code to compute the result of the operation and then return the final answer using the \`final_answer\` tool
{{code_block_opening_tag}}
result = 5 + 3 + 1294.678
final_answer(result)
{{code_block_closing_tag}}

---
Task:
&quot;Answer the question in the variable \`question\` about the image stored in the variable \`image\`. The question is in French.
You have been provided with these additional arguments, that you can access using the keys as variables in your python code:
{&#x27;question&#x27;: &#x27;Quel est l&#x27;animal sur l&#x27;image?&#x27;, &#x27;image&#x27;: &#x27;path/to/image.jpg&#x27;}&quot;

Thought: I will use the following tools: \`translator\` to translate the question into English and then \`image_qa\` to answer the question on the input image.
{{code_block_opening_tag}}
translated_question = translator(question=question, src_lang=&quot;French&quot;, tgt_lang=&quot;English&quot;)
print(f&quot;The translated question is {translated_question}.&quot;)
answer = image_qa(image=image, question=translated_question)
final_answer(f&quot;The answer is {answer}&quot;)
{{code_block_closing_tag}}

---
Task:
In a 1979 interview, Stanislaus Ulam discusses with Martin Sherwin about other great physicists of his time, including Oppenheimer.
What does he say was the consequence of Einstein learning too much math on his creativity, in one word?

Thought: I need to find and read the 1979 interview of Stanislaus Ulam with Martin Sherwin.
{{code_block_opening_tag}}
pages = web_search(query=&quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;)
print(pages)
{{code_block_closing_tag}}
Observation:
No result found for query &quot;1979 interview Stanislaus Ulam Martin Sherwin physicists Einstein&quot;.

Thought: The query was maybe too restrictive and did not find any results. Let&#x27;s try again with a broader query.
{{code_block_opening_tag}}
pages = web_search(query=&quot;1979 interview Stanislaus Ulam&quot;)
print(pages)
{{code_block_closing_tag}}
Observation:
Found 6 pages:
[Stanislaus Ulam 1979 interview](https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/)

[Ulam discusses Manhattan Project](https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/)

(truncated)

Thought: I will read the first 2 pages to know more.
{{code_block_opening_tag}}
for url in [&quot;https://ahf.nuclearmuseum.org/voices/oral-histories/stanislaus-ulams-interview-1979/&quot;, &quot;https://ahf.nuclearmuseum.org/manhattan-project/ulam-manhattan-project/&quot;]:
    whole_page = visit_webpage(url)
    print(whole_page)
    print(&quot;\\n&quot; + &quot;=&quot;*80 + &quot;\\n&quot;)  # Print separator between pages
{{code_block_closing_tag}}
Observation:
Manhattan Project Locations:
Los Alamos, NM
Stanislaus Ulam was a Polish-American mathematician. He worked on the Manhattan Project at Los Alamos and later helped design the hydrogen bomb. In this interview, he discusses his work at
(truncated)

Thought: I now have the final answer: from the webpages visited, Stanislaus Ulam says of Einstein: &quot;He learned too much mathematics and sort of diminished, it seems to me personally, it seems to me his purely physics creativity.&quot; Let&#x27;s answer in one word.
{{code_block_opening_tag}}
final_answer(&quot;diminished&quot;)
{{code_block_closing_tag}}

---
Task: &quot;Which city has the highest population: Guangzhou or Shanghai?&quot;

Thought: I need to get the populations for both cities and compare them: I will use the tool \`web_search\` to get the population of both cities.
{{code_block_opening_tag}}
for city in [&quot;Guangzhou&quot;, &quot;Shanghai&quot;]:
    print(f&quot;Population {city}:&quot;, web_search(f&quot;{city} population&quot;)
{{code_block_closing_tag}}
Observation:
Population Guangzhou: [&#x27;Guangzhou has a population of 15 million inhabitants as of 2021.&#x27;]
Population Shanghai: &#x27;26 million (2019)&#x27;

Thought: Now I know that Shanghai has the highest population.
{{code_block_opening_tag}}
final_answer(&quot;Shanghai&quot;)
{{code_block_closing_tag}}

---
Task: &quot;What is the current age of the pope, raised to the power 0.36?&quot;

Thought: I will use the tool \`wikipedia_search\` to get the age of the pope, and confirm that with a web search.
{{code_block_opening_tag}}
pope_age_wiki = wikipedia_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per wikipedia:&quot;, pope_age_wiki)
pope_age_search = web_search(query=&quot;current pope age&quot;)
print(&quot;Pope age as per google search:&quot;, pope_age_search)
{{code_block_closing_tag}}
Observation:
Pope age: &quot;The pope Francis is currently 88 years old.&quot;

Thought: I know that the pope is 88 years old. Let&#x27;s compute the result using python code.
{{code_block_opening_tag}}
pope_current_age = 88 ** 0.36
final_answer(pope_current_age)
{{code_block_closing_tag}}

Above example were using notional tools that might not exist for you. On top of performing computations in the Python code snippets that you create, you only have access to these tools, behaving like regular python functions:
{{code_block_opening_tag}}
{%- for tool in tools.values() %}
{{ tool.to_code_prompt() }}
{% endfor %}
{{code_block_closing_tag}}

{%- if managed_agents and managed_agents.values() | list %}
You can also give tasks to team members.
Calling a team member works similarly to calling a tool: provide the task description as the &#x27;task&#x27; argument. Since this team member is a real human, be as detailed and verbose as necessary in your task description.
You can also include any relevant variables or context using the &#x27;additional_args&#x27; argument.
Here is a list of the team members that you can call:
{{code_block_opening_tag}}
{%- for agent in managed_agents.values() %}
def {{ agent.name }}(task: str, additional_args: dict[str, Any]) -&gt; str:
    &quot;&quot;&quot;{{ agent.description }}

    Args:
        task: Long detailed description of the task.
        additional_args: Dictionary of extra inputs to pass to the managed agent, e.g. images, dataframes, or any other contextual data it may need.
    &quot;&quot;&quot;
{% endfor %}
{{code_block_closing_tag}}
{%- endif %}

Here are the rules you should always follow to solve your task:
1. Always provide a &#x27;Thought:&#x27; sequence, and a &#x27;{{code_block_opening_tag}}&#x27; sequence ending with &#x27;{{code_block_closing_tag}}&#x27;, else you will fail.
2. Use only variables that you have defined!
3. Always use the right arguments for the tools. DO NOT pass the arguments as a dict as in &#x27;answer = wikipedia_search({&#x27;query&#x27;: &quot;What is the place where James Bond lives?&quot;})&#x27;, but use the arguments directly as in &#x27;answer = wikipedia_search(query=&quot;What is the place where James Bond lives?&quot;)&#x27;.
4. For tools WITHOUT JSON output schema: Take care to not chain too many sequential tool calls in the same code block, as their output format is unpredictable. For instance, a call to wikipedia_search without a JSON output schema has an unpredictable return format, so do not have another tool call that depends on its output in the same block: rather output results with print() to use them in the next block.
5. For tools WITH JSON output schema: You can confidently chain multiple tool calls and directly access structured output fields in the same code block! When a tool has a JSON output schema, you know exactly what fields and data types to expect, allowing you to write robust code that directly accesses the structured response (e.g., result[&#x27;field_name&#x27;]) without needing intermediate print() statements.
6. Call a tool only when needed, and never re-do a tool call that you previously did with the exact same parameters.
7. Don&#x27;t name any new variable with the same name as a tool: for instance don&#x27;t name a variable &#x27;final_answer&#x27;.
8. Never create any notional variables in our code, as having these in your logs will derail you from the true variables.
9. You can use imports in your code, but only from the following list of modules: {{authorized_imports}}
10. The state persists between code executions: so if in one step you&#x27;ve created variables or imported modules, these will all persist.
11. Don&#x27;t give up! You&#x27;re in charge of solving the task, not providing directions to solve it.

{%- if custom_instructions %}
{{custom_instructions}}
{%- endif %}

Now Begin!`,wrap:!1}}),pl=new d({props:{code:"JTdCJTI1LSUyMGZvciUyMHRvb2wlMjBpbiUyMHRvb2xzLnZhbHVlcygpJTIwJTI1JTdEJTBBLSUyMCU3QiU3QiUyMHRvb2wudG9fdG9vbF9jYWxsaW5nX3Byb21wdCgpJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">for</span></span> tool <span class="hljs-keyword">in</span> tools.values() %}</span><span class="language-xml">
- </span><span class="hljs-template-variable">{{ tool.to_tool_calling_prompt() }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%- <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),gl=new d({props:{code:"JTdCJTI1LSUyMGlmJTIwbWFuYWdlZF9hZ2VudHMlMjBhbmQlMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCU3QyUyMGxpc3QlMjAlMjUlN0QlMEFZb3UlMjBjYW4lMjBhbHNvJTIwZ2l2ZSUyMHRhc2tzJTIwdG8lMjB0ZWFtJTIwbWVtYmVycy4lMEFDYWxsaW5nJTIwYSUyMHRlYW0lMjBtZW1iZXIlMjB3b3JrcyUyMHNpbWlsYXJseSUyMHRvJTIwY2FsbGluZyUyMGElMjB0b29sJTNBJTIwcHJvdmlkZSUyMHRoZSUyMHRhc2slMjBkZXNjcmlwdGlvbiUyMGFzJTIwdGhlJTIwJ3Rhc2snJTIwYXJndW1lbnQuJTIwU2luY2UlMjB0aGlzJTIwdGVhbSUyMG1lbWJlciUyMGlzJTIwYSUyMHJlYWwlMjBodW1hbiUyQyUyMGJlJTIwYXMlMjBkZXRhaWxlZCUyMGFuZCUyMHZlcmJvc2UlMjBhcyUyMG5lY2Vzc2FyeSUyMGluJTIweW91ciUyMHRhc2slMjBkZXNjcmlwdGlvbi4lMEFZb3UlMjBjYW4lMjBhbHNvJTIwaW5jbHVkZSUyMGFueSUyMHJlbGV2YW50JTIwdmFyaWFibGVzJTIwb3IlMjBjb250ZXh0JTIwdXNpbmclMjB0aGUlMjAnYWRkaXRpb25hbF9hcmdzJyUyMGFyZ3VtZW50LiUwQUhlcmUlMjBpcyUyMGElMjBsaXN0JTIwb2YlMjB0aGUlMjB0ZWFtJTIwbWVtYmVycyUyMHRoYXQlMjB5b3UlMjBjYW4lMjBjYWxsJTNBJTBBJTdCJTI1LSUyMGZvciUyMGFnZW50JTIwaW4lMjBtYW5hZ2VkX2FnZW50cy52YWx1ZXMoKSUyMCUyNSU3RCUwQS0lMjAlN0IlN0IlMjBhZ2VudC5uYW1lJTIwJTdEJTdEJTNBJTIwJTdCJTdCJTIwYWdlbnQuZGVzY3JpcHRpb24lMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">if</span> managed_agents <span class="hljs-built_in">and</span> managed_agents.<span class="hljs-built_in">values</span>() | <span class="hljs-keyword">list</span> %}
You can also give tasks <span class="hljs-keyword">to</span> team members.
Calling <span class="hljs-keyword">a</span> team member works similarly <span class="hljs-keyword">to</span> calling <span class="hljs-keyword">a</span> tool: provide the task description <span class="hljs-keyword">as</span> the <span class="hljs-string">&#x27;task&#x27;</span> <span class="hljs-keyword">argument</span>. Since this team member <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> real human, <span class="hljs-keyword">be</span> <span class="hljs-keyword">as</span> detailed <span class="hljs-built_in">and</span> <span class="hljs-keyword">verbose</span> <span class="hljs-keyword">as</span> necessary in your task description.
You can also include any relevant variables <span class="hljs-built_in">or</span> context using the <span class="hljs-string">&#x27;additional_args&#x27;</span> <span class="hljs-keyword">argument</span>.
Here <span class="hljs-keyword">is</span> <span class="hljs-keyword">a</span> <span class="hljs-keyword">list</span> of the team members that you can <span class="hljs-keyword">call</span>:
{%- <span class="hljs-keyword">for</span> agent in managed_agents.<span class="hljs-built_in">values</span>() %}
- {{ agent.name }}: {{ agent.description }}
{%- <span class="hljs-keyword">endfor</span> %}
{%- <span class="hljs-keyword">endif</span> %}`,wrap:!1}}),Nl=new d({props:{code:"YWdlbnQucHJvbXB0X3RlbXBsYXRlcyU1QiUyMnN5c3RlbV9wcm9tcHQlMjIlNUQlMjAlM0QlMjBhZ2VudC5wcm9tcHRfdGVtcGxhdGVzJTVCJTIyc3lzdGVtX3Byb21wdCUyMiU1RCUyMCUyQiUyMCUyMiU1Q25IZXJlJTIweW91JTIwZ28hJTIy",highlighted:'agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] = agent.prompt_templates[<span class="hljs-string">&quot;system_prompt&quot;</span>] + <span class="hljs-string">&quot;\\nHere you go!&quot;</span>',wrap:!1}}),ul=new d({props:{code:"YWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEbW9kZWxfaWQpJTJDJTIwaW5zdHJ1Y3Rpb25zJTNEJTIyQWx3YXlzJTIwdGFsayUyMGxpa2UlMjBhJTIwNSUyMHllYXIlMjBvbGQuJTIyKQ==",highlighted:'agent = CodeAgent(tools=[], model=InferenceClientModel(model_id=model_id), instructions=<span class="hljs-string">&quot;Always talk like a 5 year old.&quot;</span>)',wrap:!1}}),Vl=new p({props:{title:"4. Extra planning",local:"4-extra-planning",headingTag:"h3"}}),Fl=new d({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFdlYlNlYXJjaFRvb2wlMEFmcm9tJTIwZG90ZW52JTIwaW1wb3J0JTIwbG9hZF9kb3RlbnYlMEElMEFsb2FkX2RvdGVudigpJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwV2ViU2VhcmNoVG9vbCgpJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzZWFyY2hfdG9vbCUyQyUyMGltYWdlX2dlbmVyYXRpb25fdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBJTIwJTIwJTIwJTIwcGxhbm5pbmdfaW50ZXJ2YWwlM0QzJTIwJTIzJTIwVGhpcyUyMGlzJTIwd2hlcmUlMjB5b3UlMjBhY3RpdmF0ZSUyMHBsYW5uaW5nISUwQSklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySG93JTIwbG9uZyUyMHdvdWxkJTIwYSUyMGNoZWV0YWglMjBhdCUyMGZ1bGwlMjBzcGVlZCUyMHRha2UlMjB0byUyMHJ1biUyMHRoZSUyMGxlbmd0aCUyMG9mJTIwUG9udCUyMEFsZXhhbmRyZSUyMElJSSUzRiUyMiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, WebSearchTool
<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv

load_dotenv()

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

search_tool = WebSearchTool()

agent = CodeAgent(
    tools=[search_tool, image_generation_tool],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
    planning_interval=<span class="hljs-number">3</span> <span class="hljs-comment"># This is where you activate planning!</span>
)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;How long would a cheetah at full speed take to run the length of Pont Alexandre III?&quot;</span>,
)`,wrap:!1}}),Rl=new lJ({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/building_good_agents.md"}}),{c(){I=t("meta"),fl=M(),Ol=t("p"),vl=M(),s(N.$$.fragment),Al=M(),s(r.$$.fragment),Yl=M(),s(b.$$.fragment),Xl=M(),u=t("p"),u.textContent=JT,Dl=M(),g=t("blockquote"),g.innerHTML=MT,Hl=M(),s(m.$$.fragment),Sl=M(),V=t("p"),V.textContent=eT,zl=M(),k=t("p"),k.textContent=tT,El=M(),F=t("p"),F.innerHTML=aT,xl=M(),R=t("p"),R.textContent=iT,_l=M(),j=t("p"),j.textContent=sT,$l=M(),B=t("p"),B.textContent=nT,ql=M(),G=t("ul"),G.innerHTML=yT,Ll=M(),s(Q.$$.fragment),Pl=M(),O=t("p"),O.innerHTML=oT,Kl=M(),Z=t("p"),Z.textContent=wT,lU=M(),W=t("p"),W.textContent=CT,UU=M(),f=t("p"),f.textContent=dT,TU=M(),v=t("p"),v.textContent=cT,JU=M(),A=t("ul"),A.innerHTML=IT,MU=M(),Y=t("p"),Y.textContent=pT,eU=M(),X=t("p"),X.textContent=gT,tU=M(),s(D.$$.fragment),aU=M(),H=t("p"),H.textContent=hT,iU=M(),S=t("ul"),S.innerHTML=NT,sU=M(),z=t("p"),z.textContent=rT,nU=M(),E=t("p"),E.textContent=bT,yU=M(),s(x.$$.fragment),oU=M(),_=t("p"),_.textContent=uT,wU=M(),s($.$$.fragment),CU=M(),q=t("p"),q.innerHTML=mT,dU=M(),s(L.$$.fragment),cU=M(),P=t("p"),P.innerHTML=VT,IU=M(),s(K.$$.fragment),pU=M(),s(ll.$$.fragment),gU=M(),Ul=t("p"),Ul.innerHTML=kT,hU=M(),s(Tl.$$.fragment),NU=M(),Jl=t("p"),Jl.textContent=FT,rU=M(),Ml=t("p"),Ml.innerHTML=RT,bU=M(),s(el.$$.fragment),uU=M(),tl=t("p"),tl.textContent=jT,mU=M(),al=t("p"),al.textContent=BT,VU=M(),il=t("p"),il.textContent=GT,kU=M(),sl=t("ul"),sl.innerHTML=QT,FU=M(),s(nl.$$.fragment),RU=M(),yl=t("p"),yl.textContent=OT,jU=M(),ol=t("p"),ol.innerHTML=ZT,BU=M(),s(wl.$$.fragment),GU=M(),Cl=t("p"),Cl.textContent=WT,QU=M(),s(dl.$$.fragment),OU=M(),cl=t("p"),cl.innerHTML=fT,ZU=M(),Il=t("p"),Il.innerHTML=vT,WU=M(),c=t("ul"),jl=t("li"),$U=zT(`To insert tool descriptions:
	`),s(pl.$$.fragment),qU=M(),Bl=t("li"),LU=zT(`To insert the descriptions for managed agents if there are any:
	`),s(gl.$$.fragment),PU=M(),Gl=t("li"),Gl.innerHTML=AT,fU=M(),hl=t("p"),hl.textContent=YT,vU=M(),s(Nl.$$.fragment),AU=M(),rl=t("p"),rl.innerHTML=XT,YU=M(),bl=t("p"),bl.innerHTML=DT,XU=M(),s(ul.$$.fragment),DU=M(),ml=t("p"),ml.innerHTML=HT,HU=M(),s(Vl.$$.fragment),SU=M(),kl=t("p"),kl.textContent=ST,zU=M(),s(Fl.$$.fragment),EU=M(),s(Rl.$$.fragment),xU=M(),Zl=t("p"),this.h()},l(l){const U=PT("svelte-u9bgzb",document.head);I=a(U,"META",{name:!0,content:!0}),U.forEach(T),fl=e(l),Ol=a(l,"P",{}),Wl(Ol).forEach(T),vl=e(l),n(N.$$.fragment,l),Al=e(l),n(r.$$.fragment,l),Yl=e(l),n(b.$$.fragment,l),Xl=e(l),u=a(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-vt7d0l"&&(u.textContent=JT),Dl=e(l),g=a(l,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),i(g)!=="svelte-1eo9frz"&&(g.innerHTML=MT),Hl=e(l),n(m.$$.fragment,l),Sl=e(l),V=a(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-jydojv"&&(V.textContent=eT),zl=e(l),k=a(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-f19v2r"&&(k.textContent=tT),El=e(l),F=a(l,"P",{"data-svelte-h":!0}),i(F)!=="svelte-v4rmo7"&&(F.innerHTML=aT),xl=e(l),R=a(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1265t8d"&&(R.textContent=iT),_l=e(l),j=a(l,"P",{"data-svelte-h":!0}),i(j)!=="svelte-67t7fl"&&(j.textContent=sT),$l=e(l),B=a(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-zyva75"&&(B.textContent=nT),ql=e(l),G=a(l,"UL",{"data-svelte-h":!0}),i(G)!=="svelte-nty9k8"&&(G.innerHTML=yT),Ll=e(l),n(Q.$$.fragment,l),Pl=e(l),O=a(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1xcggba"&&(O.innerHTML=oT),Kl=e(l),Z=a(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1bz3os9"&&(Z.textContent=wT),lU=e(l),W=a(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-kvre75"&&(W.textContent=CT),UU=e(l),f=a(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-s4b558"&&(f.textContent=dT),TU=e(l),v=a(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-19k59ru"&&(v.textContent=cT),JU=e(l),A=a(l,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-sky73b"&&(A.innerHTML=IT),MU=e(l),Y=a(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1pp4kyh"&&(Y.textContent=pT),eU=e(l),X=a(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-14ogt9"&&(X.textContent=gT),tU=e(l),n(D.$$.fragment,l),aU=e(l),H=a(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1invwxb"&&(H.textContent=hT),iU=e(l),S=a(l,"UL",{"data-svelte-h":!0}),i(S)!=="svelte-1vekrxk"&&(S.innerHTML=NT),sU=e(l),z=a(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-73i6xx"&&(z.textContent=rT),nU=e(l),E=a(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-np4knk"&&(E.textContent=bT),yU=e(l),n(x.$$.fragment,l),oU=e(l),_=a(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-q0zmuw"&&(_.textContent=uT),wU=e(l),n($.$$.fragment,l),CU=e(l),q=a(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-jz4g6f"&&(q.innerHTML=mT),dU=e(l),n(L.$$.fragment,l),cU=e(l),P=a(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-usmqd6"&&(P.innerHTML=VT),IU=e(l),n(K.$$.fragment,l),pU=e(l),n(ll.$$.fragment,l),gU=e(l),Ul=a(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-jh63p8"&&(Ul.innerHTML=kT),hU=e(l),n(Tl.$$.fragment,l),NU=e(l),Jl=a(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-y1pddw"&&(Jl.textContent=FT),rU=e(l),Ml=a(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-y3io9r"&&(Ml.innerHTML=RT),bU=e(l),n(el.$$.fragment,l),uU=e(l),tl=a(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-1b7s4xp"&&(tl.textContent=jT),mU=e(l),al=a(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-ofl7w0"&&(al.textContent=BT),VU=e(l),il=a(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-1dth48k"&&(il.textContent=GT),kU=e(l),sl=a(l,"UL",{"data-svelte-h":!0}),i(sl)!=="svelte-lg04t0"&&(sl.innerHTML=QT),FU=e(l),n(nl.$$.fragment,l),RU=e(l),yl=a(l,"P",{"data-svelte-h":!0}),i(yl)!=="svelte-alcruo"&&(yl.textContent=OT),jU=e(l),ol=a(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1qvaco"&&(ol.innerHTML=ZT),BU=e(l),n(wl.$$.fragment,l),GU=e(l),Cl=a(l,"P",{"data-svelte-h":!0}),i(Cl)!=="svelte-174l3zr"&&(Cl.textContent=WT),QU=e(l),n(dl.$$.fragment,l),OU=e(l),cl=a(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-yb3mzp"&&(cl.innerHTML=fT),ZU=e(l),Il=a(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-148o4aa"&&(Il.innerHTML=vT),WU=e(l),c=a(l,"UL",{});var Ql=Wl(c);jl=a(Ql,"LI",{});var KU=Wl(jl);$U=ET(KU,`To insert tool descriptions:
	`),n(pl.$$.fragment,KU),KU.forEach(T),qU=e(Ql),Bl=a(Ql,"LI",{});var lT=Wl(Bl);LU=ET(lT,`To insert the descriptions for managed agents if there are any:
	`),n(gl.$$.fragment,lT),lT.forEach(T),PU=e(Ql),Gl=a(Ql,"LI",{"data-svelte-h":!0}),i(Gl)!=="svelte-1fwgx7s"&&(Gl.innerHTML=AT),Ql.forEach(T),fU=e(l),hl=a(l,"P",{"data-svelte-h":!0}),i(hl)!=="svelte-1gu6gc"&&(hl.textContent=YT),vU=e(l),n(Nl.$$.fragment,l),AU=e(l),rl=a(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-ddt1aq"&&(rl.innerHTML=XT),YU=e(l),bl=a(l,"P",{"data-svelte-h":!0}),i(bl)!=="svelte-5842wh"&&(bl.innerHTML=DT),XU=e(l),n(ul.$$.fragment,l),DU=e(l),ml=a(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1tl8tvc"&&(ml.innerHTML=HT),HU=e(l),n(Vl.$$.fragment,l),SU=e(l),kl=a(l,"P",{"data-svelte-h":!0}),i(kl)!=="svelte-f8c96r"&&(kl.textContent=ST),zU=e(l),n(Fl.$$.fragment,l),EU=e(l),n(Rl.$$.fragment,l),xU=e(l),Zl=a(l,"P",{}),Wl(Zl).forEach(T),this.h()},h(){UT(I,"name","hf:doc:metadata"),UT(I,"content",JJ),UT(g,"class","tip")},m(l,U){h(document.head,I),J(l,fl,U),J(l,Ol,U),J(l,vl,U),y(N,l,U),J(l,Al,U),y(r,l,U),J(l,Yl,U),y(b,l,U),J(l,Xl,U),J(l,u,U),J(l,Dl,U),J(l,g,U),J(l,Hl,U),y(m,l,U),J(l,Sl,U),J(l,V,U),J(l,zl,U),J(l,k,U),J(l,El,U),J(l,F,U),J(l,xl,U),J(l,R,U),J(l,_l,U),J(l,j,U),J(l,$l,U),J(l,B,U),J(l,ql,U),J(l,G,U),J(l,Ll,U),y(Q,l,U),J(l,Pl,U),J(l,O,U),J(l,Kl,U),J(l,Z,U),J(l,lU,U),J(l,W,U),J(l,UU,U),J(l,f,U),J(l,TU,U),J(l,v,U),J(l,JU,U),J(l,A,U),J(l,MU,U),J(l,Y,U),J(l,eU,U),J(l,X,U),J(l,tU,U),y(D,l,U),J(l,aU,U),J(l,H,U),J(l,iU,U),J(l,S,U),J(l,sU,U),J(l,z,U),J(l,nU,U),J(l,E,U),J(l,yU,U),y(x,l,U),J(l,oU,U),J(l,_,U),J(l,wU,U),y($,l,U),J(l,CU,U),J(l,q,U),J(l,dU,U),y(L,l,U),J(l,cU,U),J(l,P,U),J(l,IU,U),y(K,l,U),J(l,pU,U),y(ll,l,U),J(l,gU,U),J(l,Ul,U),J(l,hU,U),y(Tl,l,U),J(l,NU,U),J(l,Jl,U),J(l,rU,U),J(l,Ml,U),J(l,bU,U),y(el,l,U),J(l,uU,U),J(l,tl,U),J(l,mU,U),J(l,al,U),J(l,VU,U),J(l,il,U),J(l,kU,U),J(l,sl,U),J(l,FU,U),y(nl,l,U),J(l,RU,U),J(l,yl,U),J(l,jU,U),J(l,ol,U),J(l,BU,U),y(wl,l,U),J(l,GU,U),J(l,Cl,U),J(l,QU,U),y(dl,l,U),J(l,OU,U),J(l,cl,U),J(l,ZU,U),J(l,Il,U),J(l,WU,U),J(l,c,U),h(c,jl),h(jl,$U),y(pl,jl,null),h(c,qU),h(c,Bl),h(Bl,LU),y(gl,Bl,null),h(c,PU),h(c,Gl),J(l,fU,U),J(l,hl,U),J(l,vU,U),y(Nl,l,U),J(l,AU,U),J(l,rl,U),J(l,YU,U),J(l,bl,U),J(l,XU,U),y(ul,l,U),J(l,DU,U),J(l,ml,U),J(l,HU,U),y(Vl,l,U),J(l,SU,U),J(l,kl,U),J(l,zU,U),y(Fl,l,U),J(l,EU,U),y(Rl,l,U),J(l,xU,U),J(l,Zl,U),_U=!0},p:_T,i(l){_U||(o(N.$$.fragment,l),o(r.$$.fragment,l),o(b.$$.fragment,l),o(m.$$.fragment,l),o(Q.$$.fragment,l),o(D.$$.fragment,l),o(x.$$.fragment,l),o($.$$.fragment,l),o(L.$$.fragment,l),o(K.$$.fragment,l),o(ll.$$.fragment,l),o(Tl.$$.fragment,l),o(el.$$.fragment,l),o(nl.$$.fragment,l),o(wl.$$.fragment,l),o(dl.$$.fragment,l),o(pl.$$.fragment,l),o(gl.$$.fragment,l),o(Nl.$$.fragment,l),o(ul.$$.fragment,l),o(Vl.$$.fragment,l),o(Fl.$$.fragment,l),o(Rl.$$.fragment,l),_U=!0)},o(l){w(N.$$.fragment,l),w(r.$$.fragment,l),w(b.$$.fragment,l),w(m.$$.fragment,l),w(Q.$$.fragment,l),w(D.$$.fragment,l),w(x.$$.fragment,l),w($.$$.fragment,l),w(L.$$.fragment,l),w(K.$$.fragment,l),w(ll.$$.fragment,l),w(Tl.$$.fragment,l),w(el.$$.fragment,l),w(nl.$$.fragment,l),w(wl.$$.fragment,l),w(dl.$$.fragment,l),w(pl.$$.fragment,l),w(gl.$$.fragment,l),w(Nl.$$.fragment,l),w(ul.$$.fragment,l),w(Vl.$$.fragment,l),w(Fl.$$.fragment,l),w(Rl.$$.fragment,l),_U=!1},d(l){l&&(T(fl),T(Ol),T(vl),T(Al),T(Yl),T(Xl),T(u),T(Dl),T(g),T(Hl),T(Sl),T(V),T(zl),T(k),T(El),T(F),T(xl),T(R),T(_l),T(j),T($l),T(B),T(ql),T(G),T(Ll),T(Pl),T(O),T(Kl),T(Z),T(lU),T(W),T(UU),T(f),T(TU),T(v),T(JU),T(A),T(MU),T(Y),T(eU),T(X),T(tU),T(aU),T(H),T(iU),T(S),T(sU),T(z),T(nU),T(E),T(yU),T(oU),T(_),T(wU),T(CU),T(q),T(dU),T(cU),T(P),T(IU),T(pU),T(gU),T(Ul),T(hU),T(NU),T(Jl),T(rU),T(Ml),T(bU),T(uU),T(tl),T(mU),T(al),T(VU),T(il),T(kU),T(sl),T(FU),T(RU),T(yl),T(jU),T(ol),T(BU),T(GU),T(Cl),T(QU),T(OU),T(cl),T(ZU),T(Il),T(WU),T(c),T(fU),T(hl),T(vU),T(AU),T(rl),T(YU),T(bl),T(XU),T(DU),T(ml),T(HU),T(SU),T(kl),T(zU),T(EU),T(xU),T(Zl)),T(I),C(N,l),C(r,l),C(b,l),C(m,l),C(Q,l),C(D,l),C(x,l),C($,l),C(L,l),C(K,l),C(ll,l),C(Tl,l),C(el,l),C(nl,l),C(wl,l),C(dl,l),C(pl),C(gl),C(Nl,l),C(ul,l),C(Vl,l),C(Fl,l),C(Rl,l)}}}const JJ='{"title":"Building good agents","local":"building-good-agents","sections":[{"title":"The best agentic systems are the simplest: simplify the workflow as much as you can","local":"the-best-agentic-systems-are-the-simplest-simplify-the-workflow-as-much-as-you-can","sections":[],"depth":3},{"title":"Improve the information flow to the LLM engine","local":"improve-the-information-flow-to-the-llm-engine","sections":[],"depth":3},{"title":"Give more arguments to the agent","local":"give-more-arguments-to-the-agent","sections":[],"depth":3},{"title":"How to debug your agent","local":"how-to-debug-your-agent","sections":[{"title":"1. Use a stronger LLM","local":"1-use-a-stronger-llm","sections":[],"depth":3},{"title":"2. Provide more information or specific instructions","local":"2-provide-more-information-or-specific-instructions","sections":[],"depth":3},{"title":"3. Change the prompt templates (generally not advised)","local":"3-change-the-prompt-templates-generally-not-advised","sections":[],"depth":3},{"title":"4. Extra planning","local":"4-extra-planning","sections":[],"depth":3}],"depth":2}],"depth":1}';function MJ(TT){return $T(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nJ extends qT{constructor(I){super(),LT(this,I,MJ,TJ,xT,{})}}export{nJ as component};
