import{s as xt,n as zt,o as Rt}from"../chunks/scheduler.b9285784.js";import{S as Wt,i as qt,e as s,s as i,c as m,h as Bt,a as o,d as l,b as a,f as Ct,g as d,j as p,k as Xt,l as Ht,m as n,n as r,t as u,o as f,p as b}from"../chunks/index.26bc89a1.js";import{C as Yt,H as g,E as Ft}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.e364eac2.js";import{C as c}from"../chunks/CodeBlock.804615c8.js";function It(at){let h,re,me,ue,w,fe,M,be,y,ce,$,st="Accelerate brings <code>bitsandbytes</code> quantization to your model. You can now load any pytorch model in 8-bit or 4-bit with a few lines of code.",he,T,ot='If you want to use Transformers models with <code>bitsandbytes</code>, you should follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a>.',ge,_,pt='To learn more about how the <code>bitsandbytes</code> quantization works, check out the blog posts on <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">8-bit quantization</a> and <a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">4-bit quantization</a>.',we,J,Me,v,mt="You will need to install the following requirements:",ye,j,dt="<li>Install <code>bitsandbytes</code> library</li>",$e,G,Te,U,rt='For non-cuda devices, you can refer to the bitsandbytes installation guide <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">here</a>.',_e,Z,ut="<li>Install latest <code>accelerate</code> from source</li>",Je,k,ve,C,ft="<li>Install <code>minGPT</code> and <code>huggingface_hub</code> to run examples</li>",je,X,Ge,x,Ue,z,bt='First, we need to initialize our model. To save memory, we can initialize an empty model using the context manager <a href="/docs/accelerate/main/en/package_reference/big_modeling#accelerate.init_empty_weights">init_empty_weights()</a>.',Ze,R,ct="Let’s take the GPT2 model from minGPT library.",ke,W,Ce,q,ht="Then, we need to get the path to the weights of your model. The path can be the state_dict file (e.g. “pytorch_model.bin”) or a folder containing the sharded checkpoints.",Xe,B,xe,H,gt='Finally, you need to set your quantization configuration with <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig">BnbQuantizationConfig</a>.',ze,Y,wt="Here’s an example for 8-bit quantization:",Re,F,We,I,Mt="Here’s an example for 4-bit quantization:",qe,L,Be,P,yt='To quantize your empty model with the selected configuration, you need to use <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.load_and_quantize_model">load_and_quantize_model()</a>.',He,V,Ye,Q,Fe,N,$t='You can save your 8-bit model with accelerate using <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a>.',Ie,A,Le,E,Tt="Note that 4-bit model serialization is currently not supported.",Pe,S,Ve,D,_t=`You can offload some modules to cpu/disk if you don’t have enough space on the GPU to store the entire model on your GPUs.
This uses big model inference under the hood. Check this <a href="https://huggingface.co/docs/accelerate/usage_guides/big_modeling" rel="nofollow">documentation</a> for more details.`,Qe,K,Jt="For 8-bit quantization, the selected modules will be converted to 8-bit precision.",Ne,O,vt="For 4-bit quantization, the selected modules will be kept in <code>torch_dtype</code> that the user passed in <code>BnbQuantizationConfig</code>.  We will add support to convert these offloaded modules in 4-bit when 4-bit serialization will be possible.",Ae,ee,jt="You just need to pass a custom <code>device_map</code> in order to offload modules on cpu/disk. The offload modules will be dispatched on the GPU when needed. Here’s an example :",Ee,te,Se,le,De,ne,Gt='It is not possible to perform pure 8bit or 4bit training on these models. However, you can train these models by leveraging parameter efficient fine tuning methods (PEFT) and train for example adapters on top of them. Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow">peft</a> library for more details.',Ke,ie,Ut='Currently, you can’t add adapters on top of any quantized model. However, with the official support of adapters with Transformers models, you can fine-tune quantized models. If you want to finetune a Transformers model , follow this <a href="https://huggingface.co/docs/transformers/main_classes/quantization" rel="nofollow">documentation</a> instead. Check out this <a href="https://colab.research.google.com/drive/1VoYNfYDKcKRQRor98Zbf2-9VQTtGJ24k?usp=sharing" rel="nofollow">demo</a> on how to fine-tune a 4-bit Transformers model.',Oe,ae,Zt="Note that you don’t need to pass <code>device_map</code> when loading the model for training. It will automatically load your model on your GPU. Please note that <code>device_map=auto</code> should be used for inference only.",et,se,tt,oe,kt='Check out the Google Colab <a href="https://colab.research.google.com/drive/1T1pOgewAWVpR9gKpaEWw4orOrzPFb3yM?usp=sharing" rel="nofollow">demo</a> for running quantized models on a GPT2 model. The GPT2-1.5B model checkpoint is in FP32 which uses 6GB of memory. After quantization, it uses 1.6GB with 8-bit modules and 1.2GB with 4-bit modules.',lt,pe,nt,de,it;return w=new Yt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),M=new g({props:{title:"Model quantization",local:"model-quantization",headingTag:"h1"}}),y=new g({props:{title:"bitsandbytes Integration",local:"bitsandbytes-integration",headingTag:"h2"}}),J=new g({props:{title:"Pre-Requisites",local:"pre-requisites",headingTag:"h3"}}),G=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMGJpdHNhbmRieXRlcw==",highlighted:"pip install bitsandbytes",wrap:!1}}),k=new c({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGYWNjZWxlcmF0ZS5naXQ=",highlighted:"pip install git+https://github.com/huggingface/accelerate.git",wrap:!1}}),X=new c({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZrYXJwYXRoeSUyRm1pbkdQVC5naXQlMEFwaXAlMjBpbnN0YWxsJTIwbWluR1BUJTJGJTBBcGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/karpathy/minGPT.git
pip install minGPT/
pip install huggingface_hub`,wrap:!1}}),x=new g({props:{title:"How it works",local:"how-it-works",headingTag:"h3"}}),W=new c({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwbWluZ3B0Lm1vZGVsJTIwaW1wb3J0JTIwR1BUJTBBJTBBbW9kZWxfY29uZmlnJTIwJTNEJTIwR1BULmdldF9kZWZhdWx0X2NvbmZpZygpJTBBbW9kZWxfY29uZmlnLm1vZGVsX3R5cGUlMjAlM0QlMjAnZ3B0Mi14bCclMEFtb2RlbF9jb25maWcudm9jYWJfc2l6ZSUyMCUzRCUyMDUwMjU3JTBBbW9kZWxfY29uZmlnLmJsb2NrX3NpemUlMjAlM0QlMjAxMDI0JTBBJTBBd2l0aCUyMGluaXRfZW1wdHlfd2VpZ2h0cygpJTNBJTBBJTIwJTIwJTIwJTIwZW1wdHlfbW9kZWwlMjAlM0QlMjBHUFQobW9kZWxfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)`,wrap:!1}}),B=new c({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBd2VpZ2h0c19sb2NhdGlvbiUyMCUzRCUyMHNuYXBzaG90X2Rvd25sb2FkKHJlcG9faWQlM0QlMjJtYXJjc3VuMTMlMkZncHQyLXhsLWxpbmVhci1zaGFyZGVkJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
weights_location = snapshot_download(repo_id=<span class="hljs-string">&quot;marcsun13/gpt2-xl-linear-sharded&quot;</span>)`,wrap:!1}}),F=new c({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwbGxtX2ludDhfdGhyZXNob2xkJTIwJTNEJTIwNik=",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_8bit=<span class="hljs-literal">True</span>, llm_int8_threshold = <span class="hljs-number">6</span>)`,wrap:!1}}),L=new c({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBCbmJRdWFudGl6YXRpb25Db25maWclMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzRFRydWUlMkMlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig
bnb_quantization_config = BnbQuantizationConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>)`,wrap:!1}}),V=new c({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2FuZF9xdWFudGl6ZV9tb2RlbCUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> load_and_quantize_model
quantized_model = load_and_quantize_model(empty_model, weights_location=weights_location, bnb_quantization_config=bnb_quantization_config)`,wrap:!1}}),Q=new g({props:{title:"Saving and loading 8-bit model",local:"saving-and-loading-8-bit-model",headingTag:"h3"}}),A=new c({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdGUlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBbmV3X3dlaWdodHNfbG9jYXRpb24lMjAlM0QlMjAlMjJwYXRoJTJGdG8lMkZzYXZlX2RpcmVjdG9yeSUyMiUwQWFjY2VsZXJhdGUuc2F2ZV9tb2RlbChxdWFudGl6ZWRfbW9kZWwlMkMlMjBuZXdfd2VpZ2h0c19sb2NhdGlvbiklMEElMEFxdWFudGl6ZWRfbW9kZWxfZnJvbV9zYXZlZCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKGVtcHR5X21vZGVsJTJDJTIwd2VpZ2h0c19sb2NhdGlvbiUzRG5ld193ZWlnaHRzX2xvY2F0aW9uJTJDJTIwYm5iX3F1YW50aXphdGlvbl9jb25maWclM0RibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlMjAlM0QlMjAlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerate = Accelerator()
new_weights_location = <span class="hljs-string">&quot;path/to/save_directory&quot;</span>
accelerate.save_model(quantized_model, new_weights_location)

quantized_model_from_saved = load_and_quantize_model(empty_model, weights_location=new_weights_location, bnb_quantization_config=bnb_quantization_config, device_map = <span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),S=new g({props:{title:"Offload modules to cpu and disk",local:"offload-modules-to-cpu-and-disk",headingTag:"h3"}}),te=new c({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLnd0ZSUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53cGUlMjIlM0ElMjAwJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIuZHJvcCUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwJTIyY3B1JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXIubG5fZiUyMiUzQSUyMCUyMmRpc2slMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJsbV9oZWFkJTIyJTNBJTIwJTIyZGlzayUyMiUyQyUwQSU3RA==",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.wte&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.wpe&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.drop&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;disk&quot;</span>,
}`,wrap:!1}}),le=new g({props:{title:"Fine-tune a quantized model",local:"fine-tune-a-quantized-model",headingTag:"h3"}}),se=new g({props:{title:"Example demo - running GPT2 1.5b on a Google Colab",local:"example-demo---running-gpt2-15b-on-a-google-colab",headingTag:"h3"}}),pe=new Ft({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/usage_guides/quantization.md"}}),{c(){h=s("meta"),re=i(),me=s("p"),ue=i(),m(w.$$.fragment),fe=i(),m(M.$$.fragment),be=i(),m(y.$$.fragment),ce=i(),$=s("p"),$.innerHTML=st,he=i(),T=s("p"),T.innerHTML=ot,ge=i(),_=s("p"),_.innerHTML=pt,we=i(),m(J.$$.fragment),Me=i(),v=s("p"),v.textContent=mt,ye=i(),j=s("ul"),j.innerHTML=dt,$e=i(),m(G.$$.fragment),Te=i(),U=s("p"),U.innerHTML=rt,_e=i(),Z=s("ul"),Z.innerHTML=ut,Je=i(),m(k.$$.fragment),ve=i(),C=s("ul"),C.innerHTML=ft,je=i(),m(X.$$.fragment),Ge=i(),m(x.$$.fragment),Ue=i(),z=s("p"),z.innerHTML=bt,Ze=i(),R=s("p"),R.textContent=ct,ke=i(),m(W.$$.fragment),Ce=i(),q=s("p"),q.textContent=ht,Xe=i(),m(B.$$.fragment),xe=i(),H=s("p"),H.innerHTML=gt,ze=i(),Y=s("p"),Y.textContent=wt,Re=i(),m(F.$$.fragment),We=i(),I=s("p"),I.textContent=Mt,qe=i(),m(L.$$.fragment),Be=i(),P=s("p"),P.innerHTML=yt,He=i(),m(V.$$.fragment),Ye=i(),m(Q.$$.fragment),Fe=i(),N=s("p"),N.innerHTML=$t,Ie=i(),m(A.$$.fragment),Le=i(),E=s("p"),E.textContent=Tt,Pe=i(),m(S.$$.fragment),Ve=i(),D=s("p"),D.innerHTML=_t,Qe=i(),K=s("p"),K.textContent=Jt,Ne=i(),O=s("p"),O.innerHTML=vt,Ae=i(),ee=s("p"),ee.innerHTML=jt,Ee=i(),m(te.$$.fragment),Se=i(),m(le.$$.fragment),De=i(),ne=s("p"),ne.innerHTML=Gt,Ke=i(),ie=s("p"),ie.innerHTML=Ut,Oe=i(),ae=s("p"),ae.innerHTML=Zt,et=i(),m(se.$$.fragment),tt=i(),oe=s("p"),oe.innerHTML=kt,lt=i(),m(pe.$$.fragment),nt=i(),de=s("p"),this.h()},l(e){const t=Bt("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),re=a(e),me=o(e,"P",{}),Ct(me).forEach(l),ue=a(e),d(w.$$.fragment,e),fe=a(e),d(M.$$.fragment,e),be=a(e),d(y.$$.fragment,e),ce=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1uk3wou"&&($.innerHTML=st),he=a(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1p54xze"&&(T.innerHTML=ot),ge=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-hrid2v"&&(_.innerHTML=pt),we=a(e),d(J.$$.fragment,e),Me=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-50fa4n"&&(v.textContent=mt),ye=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-t2geh8"&&(j.innerHTML=dt),$e=a(e),d(G.$$.fragment,e),Te=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-s1psu3"&&(U.innerHTML=rt),_e=a(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-l0cm28"&&(Z.innerHTML=ut),Je=a(e),d(k.$$.fragment,e),ve=a(e),C=o(e,"UL",{"data-svelte-h":!0}),p(C)!=="svelte-1c2t6dx"&&(C.innerHTML=ft),je=a(e),d(X.$$.fragment,e),Ge=a(e),d(x.$$.fragment,e),Ue=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1x1205t"&&(z.innerHTML=bt),Ze=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1fwkss5"&&(R.textContent=ct),ke=a(e),d(W.$$.fragment,e),Ce=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-bbyjp5"&&(q.textContent=ht),Xe=a(e),d(B.$$.fragment,e),xe=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-194hcd9"&&(H.innerHTML=gt),ze=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-4hyyr7"&&(Y.textContent=wt),Re=a(e),d(F.$$.fragment,e),We=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1qtcdkv"&&(I.textContent=Mt),qe=a(e),d(L.$$.fragment,e),Be=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1yj9o2t"&&(P.innerHTML=yt),He=a(e),d(V.$$.fragment,e),Ye=a(e),d(Q.$$.fragment,e),Fe=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-13ka0pr"&&(N.innerHTML=$t),Ie=a(e),d(A.$$.fragment,e),Le=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1x0s82b"&&(E.textContent=Tt),Pe=a(e),d(S.$$.fragment,e),Ve=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1vy35js"&&(D.innerHTML=_t),Qe=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-11qxtld"&&(K.textContent=Jt),Ne=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-qaw7ck"&&(O.innerHTML=vt),Ae=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-gyjts5"&&(ee.innerHTML=jt),Ee=a(e),d(te.$$.fragment,e),Se=a(e),d(le.$$.fragment,e),De=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-rtwtrf"&&(ne.innerHTML=Gt),Ke=a(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-phiimi"&&(ie.innerHTML=Ut),Oe=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1n8dj9v"&&(ae.innerHTML=Zt),et=a(e),d(se.$$.fragment,e),tt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-19uggsw"&&(oe.innerHTML=kt),lt=a(e),d(pe.$$.fragment,e),nt=a(e),de=o(e,"P",{}),Ct(de).forEach(l),this.h()},h(){Xt(h,"name","hf:doc:metadata"),Xt(h,"content",Lt)},m(e,t){Ht(document.head,h),n(e,re,t),n(e,me,t),n(e,ue,t),r(w,e,t),n(e,fe,t),r(M,e,t),n(e,be,t),r(y,e,t),n(e,ce,t),n(e,$,t),n(e,he,t),n(e,T,t),n(e,ge,t),n(e,_,t),n(e,we,t),r(J,e,t),n(e,Me,t),n(e,v,t),n(e,ye,t),n(e,j,t),n(e,$e,t),r(G,e,t),n(e,Te,t),n(e,U,t),n(e,_e,t),n(e,Z,t),n(e,Je,t),r(k,e,t),n(e,ve,t),n(e,C,t),n(e,je,t),r(X,e,t),n(e,Ge,t),r(x,e,t),n(e,Ue,t),n(e,z,t),n(e,Ze,t),n(e,R,t),n(e,ke,t),r(W,e,t),n(e,Ce,t),n(e,q,t),n(e,Xe,t),r(B,e,t),n(e,xe,t),n(e,H,t),n(e,ze,t),n(e,Y,t),n(e,Re,t),r(F,e,t),n(e,We,t),n(e,I,t),n(e,qe,t),r(L,e,t),n(e,Be,t),n(e,P,t),n(e,He,t),r(V,e,t),n(e,Ye,t),r(Q,e,t),n(e,Fe,t),n(e,N,t),n(e,Ie,t),r(A,e,t),n(e,Le,t),n(e,E,t),n(e,Pe,t),r(S,e,t),n(e,Ve,t),n(e,D,t),n(e,Qe,t),n(e,K,t),n(e,Ne,t),n(e,O,t),n(e,Ae,t),n(e,ee,t),n(e,Ee,t),r(te,e,t),n(e,Se,t),r(le,e,t),n(e,De,t),n(e,ne,t),n(e,Ke,t),n(e,ie,t),n(e,Oe,t),n(e,ae,t),n(e,et,t),r(se,e,t),n(e,tt,t),n(e,oe,t),n(e,lt,t),r(pe,e,t),n(e,nt,t),n(e,de,t),it=!0},p:zt,i(e){it||(u(w.$$.fragment,e),u(M.$$.fragment,e),u(y.$$.fragment,e),u(J.$$.fragment,e),u(G.$$.fragment,e),u(k.$$.fragment,e),u(X.$$.fragment,e),u(x.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(A.$$.fragment,e),u(S.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(pe.$$.fragment,e),it=!0)},o(e){f(w.$$.fragment,e),f(M.$$.fragment,e),f(y.$$.fragment,e),f(J.$$.fragment,e),f(G.$$.fragment,e),f(k.$$.fragment,e),f(X.$$.fragment,e),f(x.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(L.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(A.$$.fragment,e),f(S.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(se.$$.fragment,e),f(pe.$$.fragment,e),it=!1},d(e){e&&(l(re),l(me),l(ue),l(fe),l(be),l(ce),l($),l(he),l(T),l(ge),l(_),l(we),l(Me),l(v),l(ye),l(j),l($e),l(Te),l(U),l(_e),l(Z),l(Je),l(ve),l(C),l(je),l(Ge),l(Ue),l(z),l(Ze),l(R),l(ke),l(Ce),l(q),l(Xe),l(xe),l(H),l(ze),l(Y),l(Re),l(We),l(I),l(qe),l(Be),l(P),l(He),l(Ye),l(Fe),l(N),l(Ie),l(Le),l(E),l(Pe),l(Ve),l(D),l(Qe),l(K),l(Ne),l(O),l(Ae),l(ee),l(Ee),l(Se),l(De),l(ne),l(Ke),l(ie),l(Oe),l(ae),l(et),l(tt),l(oe),l(lt),l(nt),l(de)),l(h),b(w,e),b(M,e),b(y,e),b(J,e),b(G,e),b(k,e),b(X,e),b(x,e),b(W,e),b(B,e),b(F,e),b(L,e),b(V,e),b(Q,e),b(A,e),b(S,e),b(te,e),b(le,e),b(se,e),b(pe,e)}}}const Lt='{"title":"Model quantization","local":"model-quantization","sections":[{"title":"bitsandbytes Integration","local":"bitsandbytes-integration","sections":[{"title":"Pre-Requisites","local":"pre-requisites","sections":[],"depth":3},{"title":"How it works","local":"how-it-works","sections":[],"depth":3},{"title":"Saving and loading 8-bit model","local":"saving-and-loading-8-bit-model","sections":[],"depth":3},{"title":"Offload modules to cpu and disk","local":"offload-modules-to-cpu-and-disk","sections":[],"depth":3},{"title":"Fine-tune a quantized model","local":"fine-tune-a-quantized-model","sections":[],"depth":3},{"title":"Example demo - running GPT2 1.5b on a Google Colab","local":"example-demo---running-gpt2-15b-on-a-google-colab","sections":[],"depth":3}],"depth":2}],"depth":1}';function Pt(at){return Rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Et extends Wt{constructor(h){super(),qt(this,h,Pt,It,xt,{})}}export{Et as component};
