import{s as Zi,o as Wi,n as Ri}from"../chunks/scheduler.0cf4ef2e.js";import{S as Di,i as Gi,e as l,s as a,c,h as Ki,a as s,d as i,b as o,f as Ei,g as u,j as r,k as Kt,l as Vi,m as n,n as m,t as d,o as f,p as h}from"../chunks/index.abc433bf.js";import{T as Oi}from"../chunks/Tip.15dd1ac8.js";import{C as Xi,H as b}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.f3fe7f8a.js";import{C as Pe}from"../chunks/CodeBlock.89cabb39.js";function Yi(Ue){let p,v=`Usually <code>round(a/S + Z)</code> corresponds to the smallest representable value in the considered data type, and <code>round(b/S + Z)</code>
to the biggest one. But this can vary, for instance when using a <em>symmetric quantization scheme</em> as you will see in the next
paragraph.`;return{c(){p=l("p"),p.innerHTML=v},l(g){p=s(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-d33l1n"&&(p.innerHTML=v)},m(g,w){n(g,p,w)},p:Ri,d(g){g&&i(p)}}}function en(Ue){let p,v=`The section is not fundamental to understand the rest. It explains in brief how numbers are represented in computers.
Since quantization is about going from one representation to another, it can be useful to have some basics, but it is
definitely not mandatory.`;return{c(){p=l("p"),p.textContent=v},l(g){p=s(g,"P",{"data-svelte-h":!0}),r(p)!=="svelte-193nbxk"&&(p.textContent=v)},m(g,w){n(g,p,w)},p:Ri,d(g){g&&i(p)}}}function tn(Ue){let p,v,g,w,M,Je,q,Se,z,Vt=`Quantization is a technique to reduce the computational and memory costs of running inference by representing the
weights and activations with low-precision data types like 8-bit integer (<code>int8</code>) instead of the usual 32-bit floating
point (<code>float32</code>).`,Ae,C,Xt=`Reducing the number of bits means the resulting model requires less memory storage, consumes less energy (in theory), and
operations like matrix multiplication can be performed much faster with integer arithmetic. It also allows to run models
on embedded devices, which sometimes only support integer data types.`,Qe,L,Ne,_,Yt=`The basic idea behind quantization is quite easy: going from high-precision representation (usually the regular 32-bit
floating-point) for weights and activations to a lower precision data type. The most common lower precision data types
are:`,Be,H,ei="<li><code>float16</code>, accumulation data type <code>float16</code></li> <li><code>bfloat16</code>, accumulation data type <code>float32</code></li> <li><code>int16</code>, accumulation data type <code>int32</code></li> <li><code>int8</code>, accumulation data type <code>int32</code></li>",Fe,k,ti=`The accumulation data type specifies the type of the result of accumulating (adding, multiplying, etc) values of the
data type in question. For example, let’s consider two <code>int8</code> values <code>A = 127</code>, <code>B = 127</code>, and let’s define <code>C</code> as the
sum of <code>A</code> and <code>B</code>:`,Ee,j,Oe,U,ii=`Here the result is much bigger than the biggest representable value in <code>int8</code>, which is <code>127</code>. Hence the need for a larger
precision data type to avoid a huge precision loss that would make the whole quantization process useless.`,Re,P,Ze,I,ni="The two most common quantization cases are <code>float32 -&gt; float16</code> and <code>float32 -&gt; int8</code>.",We,J,De,S,ai=`Performing quantization to go from <code>float32</code> to <code>float16</code> is quite straightforward since both data types follow the same
representation scheme. The questions to ask yourself when quantizing an operation to <code>float16</code> are:`,Ge,A,oi=`<li>Does my operation have a <code>float16</code> implementation?</li> <li>Does my hardware support <code>float16</code>? For instance, Intel CPUs <a href="https://scicomp.stackexchange.com/a/35193" rel="nofollow">have been supporting <code>float16</code> as a storage type, but
computation is done after converting to <code>float32</code></a>. Full support will come
in Cooper Lake and Sapphire Rapids.</li> <li>Is my operation sensitive to lower precision?
For instance the value of epsilon in <code>LayerNorm</code> is usually very small (~ <code>1e-12</code>), but the smallest representable value in
<code>float16</code> is ~ <code>6e-5</code>, this can cause <code>NaN</code> issues.  The same applies for big values.</li>`,Ke,Q,Ve,N,li=`Performing quantization to go from <code>float32</code> to <code>int8</code> is more tricky. Only 256 values can be represented in <code>int8</code>,
while <code>float32</code> can represent a very wide range of values. The idea is to find the best way to project our range <code>[a, b]</code>
of <code>float32</code> values  to the <code>int8</code> space.`,Xe,B,si=`Let’s consider a float <code>x</code> in <code>[a, b]</code>, then we can write the following quantization scheme, also called the <em>affine
quantization scheme</em>:`,Ye,F,et,E,ri="where:",tt,O,pi=`<li><code>x_q</code> is the quantized <code>int8</code> value associated to <code>x</code></li> <li><code>S</code> and <code>Z</code> are the quantization parameters<ul><li><code>S</code> is the scale, and is a positive <code>float32</code></li> <li><code>Z</code> is called the zero-point, it is the <code>int8</code> value corresponding to the value <code>0</code> in the <code>float32</code> realm. This is
important to be able to represent exactly the value <code>0</code> because it is used everywhere throughout machine learning
models.</li></ul></li>`,it,R,ci="The quantized value <code>x_q</code> of <code>x</code> in <code>[a, b]</code> can be computed as follows:",nt,Z,at,W,ui=`And <code>float32</code> values outside of the <code>[a, b]</code> range are clipped to the closest representable value, so for any
floating-point number <code>x</code>:`,ot,D,lt,$,st,G,rt,K,mi="The equation above is called the <em>affine quantization scheme</em> because the mapping from <code>[a, b]</code> to <code>int8</code> is an affine one.",pt,V,di=`A common special case of this scheme is the <em>symmetric quantization scheme</em>, where we consider a symmetric range of float values <code>[-a, a]</code>.
In this case the integer space is usually <code>[-127, 127]</code>, meaning that the <code>-128</code> is opted out of the regular <code>[-128, 127]</code> signed <code>int8</code> range.
The reason being that having a symmetric range allows to have <code>Z = 0</code>. While one value out of the 256 representable
values is lost, it can provide a speedup since a lot of addition operations can be skipped.`,ct,X,fi=`<strong>Note</strong>: To learn how the quantization parameters <code>S</code> and <code>Z</code> are computed, you can read the
<a href="https://arxiv.org/abs/1712.05877" rel="nofollow">Quantization and Training of Neural Networks for Efficient Integer-Arithmetic-Only Inference</a>
paper, or <a href="https://leimao.github.io/article/Neural-Networks-Quantization" rel="nofollow">Lei Mao’s blog post</a> on the subject.`,ut,Y,mt,ee,hi="Depending on the accuracy / latency trade-off you are targeting you can play with the granularity of the quantization parameters:",dt,te,gi=`<li>Quantization parameters can be computed on a <em>per-tensor</em> basis, meaning that one pair of <code>(S, Z)</code> will be used per
tensor.</li> <li>Quantization parameters can be computed on a <em>per-channel</em> basis, meaning that it is possible to store a pair of
<code>(S, Z)</code> per element along one of the dimensions of a tensor. For example for a tensor of shape <code>[N, C, H, W]</code>, having
<em>per-channel</em> quantization parameters for the second dimension would result in having <code>C</code> pairs of <code>(S, Z)</code>. While this
can give a better accuracy, it requires more memory.</li>`,ft,ie,ht,ne,bi=`The section above described how quantization from <code>float32</code> to <code>int8</code> works, but one question
remains: how is the <code>[a, b]</code> range of <code>float32</code> values determined? That is where calibration comes in to play.`,gt,ae,vi=`Calibration is the step during quantization where the <code>float32</code> ranges are computed. For weights it is quite easy since
the actual range is known at <em>quantization-time</em>. But it is less clear for activations, and different approaches exist:`,bt,oe,wi=`<li>Post training <strong>dynamic quantization</strong>: the range for each activation is computed on the fly at <em>runtime</em>. While this
gives great results without too much work, it can be a bit slower than static quantization because of the overhead
introduced by computing the range each time.
It is also not an option on certain hardware.</li> <li>Post training <strong>static quantization</strong>: the range for each activation is computed in advance at <em>quantization-time</em>,
typically by passing representative data through the model and recording the activation values. In practice, the steps are:<ol><li>Observers are put on activations to record their values.</li> <li>A certain number of forward passes on a calibration dataset is done (around <code>200</code> examples is enough).</li> <li>The ranges for each computation are computed according to some <em>calibration technique</em>.</li></ol></li> <li><strong>Quantization aware training</strong>: the range for each activation is computed at <em>training-time</em>, following the same idea
than post training static quantization. But “fake quantize” operators are used instead of observers: they record
values just as observers do, but they also simulate the error induced by quantization to let the model adapt to it.</li>`,vt,le,$i=`For both post training static quantization and quantization aware training, it is necessary to define calibration
techniques, the most common are:`,wt,se,Ti=`<li>Min-max: the computed range is <code>[min observed value, max observed value]</code>, this works well with weights.</li> <li>Moving average min-max: the computed range is <code>[moving average min observed value, moving average max observed value]</code>,
this works well with activations.</li> <li>Histogram: records a histogram of values along with min and max values, then chooses according to some criterion:<ul><li>Entropy: the range is computed as the one minimizing the error between the full-precision and the quantized data.</li> <li>Mean Square Error: the range is computed as the one minimizing the mean square error between the full-precision and
the quantized data.</li> <li>Percentile: the range is computed using a given percentile value <code>p</code> on the observed values. The idea is to try to have
<code>p%</code> of the observed values in the computed range. While this is possible when doing affine quantization, it is not always
possible to exactly match that when doing symmetric quantization. You can check <a href="https://github.com/microsoft/onnxruntime/blob/2cb12caf9317f1ded37f6db125cb03ba99320c40/onnxruntime/python/tools/quantization/calibrate.py#L698" rel="nofollow">how it is done in ONNX
Runtime</a>
for more details.</li></ul></li>`,$t,re,Tt,pe,yi="To effectively quantize a model to <code>int8</code>, the steps to follow are:",yt,ce,xi=`<li>Choose which operators to quantize. Good operators to quantize are the one dominating it terms of computation time,
for instance linear projections and matrix multiplications.</li> <li>Try post-training dynamic quantization, if it is fast enough stop here, otherwise continue to step 3.</li> <li>Try post-training static quantization which can be faster than dynamic quantization but often with a drop in terms of
accuracy. Apply observers to your models in places where you want to quantize.</li> <li>Choose a calibration technique and perform it.</li> <li>Convert the model to its quantized form: the observers are removed and the <code>float32</code> operators are converted to their <code>int8</code>
counterparts.</li> <li>Evaluate the quantized model: is the accuracy good enough? If yes, stop here, otherwise start again at step 3 but
with quantization aware training this time.</li>`,xt,ue,Mt,me,Mi="🤗 Optimum provides APIs to perform quantization using different tools for different targets:",qt,de,qi=`<li>The <code>optimum.onnxruntime</code> package allows to
<a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/quantization" rel="nofollow">quantize and run ONNX models</a> using the
ONNX Runtime tool.</li> <li>The <code>optimum.intel</code> package enables to <a href="https://huggingface.co/docs/optimum/intel/optimization_inc" rel="nofollow">quantize</a> 🤗 Transformers
models while respecting accuracy and latency constraints.</li> <li>The <code>optimum.fx</code> package provides wrappers around the
<a href="https://pytorch.org/docs/stable/quantization-support.html#torch-quantization-quantize-fx" rel="nofollow">PyTorch quantization functions</a>
to allow graph-mode quantization of 🤗 Transformers models in PyTorch. This is a lower-level API compared to the two
mentioned above, giving more flexibility, but requiring more work on your end.</li> <li>The <code>optimum.gptq</code> package allows to <a href="../llm_quantization/usage_guides/quantization">quantize and run LLM models</a> with GPTQ.</li>`,zt,fe,Ct,T,Lt,he,zi=`The most fundamental unit of representation for computers is the bit. Everything in computers is represented as a
sequence of bits, including numbers. But the representation varies whether the numbers in question are integers or
real numbers.`,_t,ge,Ht,be,Ci=`Integers are usually represented with the following bit lengths: <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>. When representing integers, two cases
are considered:`,kt,ve,Li=`<li>Unsigned (positive) integers: they are simply represented as a sequence of bits. Each bit corresponds to a power
of two (from <code>0</code> to <code>n-1</code> where <code>n</code> is the bit-length), and the resulting number is the sum of those powers of two.</li>`,jt,we,_i="Example: <code>19</code> is represented as an unsigned int8 as <code>00010011</code> because :",Ut,$e,Pt,y,Hi=`<li>Signed integers: it is less straightforward to represent signed integers, and multiple approaches exist, the most
common being the <em>two’s complement</em>. For more information, you can check the
<a href="https://en.wikipedia.org/wiki/Signed_number_representations" rel="nofollow">Wikipedia page</a> on the subject.</li>`,It,Te,Jt,ye,ki=`Real numbers are usually represented with the following bit lengths: <code>16</code>, <code>32</code>, <code>64</code>.
The two main ways of representing real numbers are:`,St,xe,ji="<li>Fixed-point: there are fixed number of digits reserved for representing the integer part and the fractional part.</li> <li>Floating-point: the number of digits for representing the integer and the fractional parts can vary.</li>",At,Me,Ui=`The floating-point representation can represent bigger ranges of values, and this is the one we will be focusing on
since it is the most commonly used. There are three components in the floating-point representation:`,Qt,qe,Pi="<li>The sign bit: this is the bit specifying the sign of the number.</li> <li>The exponent part</li>",Nt,ze,Ii="<li>5 bits in <code>float16</code></li> <li>8 bits in <code>bfloat16</code></li> <li>8 bits in <code>float32</code></li> <li>11 bits in <code>float64</code></li>",Bt,x,Ji="<li>The mantissa</li>",Ft,Ce,Si="<li>11 bits in <code>float16</code> (10 explicitly stored)</li> <li>8 bits in <code>bfloat16</code> (7 explicitly stored)</li> <li>24 bits in <code>float32</code> (23 explicitly stored)</li> <li>53 bits in <code>float64</code> (52 explicitly stored)</li>",Et,Le,Ai=`For more information on the bits allocation for each data type, check the nice illustration on the Wikipedia page about
the <a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16 floating-point format</a>.`,Ot,_e,Qi="For a real number <code>x</code> we have:",Rt,He,Zt,ke,Wt,je,Ni=`<li>The
<a href="https://arxiv.org/abs/1712.05877" rel="nofollow">Quantization and Training of Neural Networks for Efficient Integer-Arithmetic-Only Inference</a> paper</li> <li>The <a href="https://iq.opengenus.org/basics-of-quantization-in-ml/" rel="nofollow">Basics of Quantization in Machine Learning (ML) for Beginners</a>
blog post</li> <li>The <a href="https://tivadardanka.com/blog/neural-networks-quantization" rel="nofollow">How to accelerate and compress neural networks with quantization</a>
blog post</li> <li>The Wikipedia pages on integers representation <a href="https://en.wikipedia.org/wiki/Integer_(computer_science)" rel="nofollow">here</a> and
<a href="https://en.wikipedia.org/wiki/Signed_number_representations" rel="nofollow">here</a></li> <li>The Wikipedia pages on<ul><li><a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16 floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Half-precision_floating-point_format" rel="nofollow">Half-precision floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Single-precision_floating-point_format" rel="nofollow">Single-precision floating-point format</a></li> <li><a href="https://en.wikipedia.org/wiki/Double-precision_floating-point_format" rel="nofollow">Double-precision floating-point format</a></li></ul></li>`,Dt,Ie,Gt;return M=new Xi({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),q=new b({props:{title:"Quantization",local:"quantization",headingTag:"h1"}}),L=new b({props:{title:"Theory",local:"theory",headingTag:"h2"}}),j=new Pe({props:{code:"QyUyMCUzRCUyMEElMjAlMkIlMjBC",highlighted:'<span class="hljs-attr">C</span> = A + B',wrap:!1}}),P=new b({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),J=new b({props:{title:"Quantization to float16",local:"quantization-to-float16",headingTag:"h3"}}),Q=new b({props:{title:"Quantization to int8",local:"quantization-to-int8",headingTag:"h3"}}),F=new Pe({props:{code:"eCUyMCUzRCUyMFMlMjAqJTIwKHhfcSUyMC0lMjBaKQ==",highlighted:'<span class="hljs-attribute">x</span> <span class="hljs-operator">=</span> S * (x_q - Z)',wrap:!1}}),Z=new Pe({props:{code:"eF9xJTIwJTNEJTIwcm91bmQoeCUyRlMlMjAlMkIlMjBaKQ==",highlighted:'<span class="hljs-variable">x_q</span> = <span class="hljs-function"><span class="hljs-title"><span class="hljs-built_in">round</span></span>(<span class="hljs-variable">x</span>/<span class="hljs-variable">S</span> + <span class="hljs-variable">Z</span>)</span>',wrap:!1}}),D=new Pe({props:{code:"eF9xJTIwJTNEJTIwY2xpcChyb3VuZCh4JTJGUyUyMCUyQiUyMFopJTJDJTIwcm91bmQoYSUyRlMlMjAlMkIlMjBaKSUyQyUyMHJvdW5kKGIlMkZTJTIwJTJCJTIwWikpJTBB",highlighted:`x_q = <span class="hljs-built_in">clip</span>(<span class="hljs-built_in">round</span>(x/S + Z), <span class="hljs-built_in">round</span>(a/S + Z), <span class="hljs-built_in">round</span>(b/S + Z))
`,wrap:!1}}),$=new Oi({props:{$$slots:{default:[Yi]},$$scope:{ctx:Ue}}}),G=new b({props:{title:"Symmetric and affine quantization schemes",local:"symmetric-and-affine-quantization-schemes",headingTag:"h3"}}),Y=new b({props:{title:"Per-tensor and per-channel quantization",local:"per-tensor-and-per-channel-quantization",headingTag:"h3"}}),ie=new b({props:{title:"Calibration",local:"calibration",headingTag:"h3"}}),re=new b({props:{title:"Practical steps to follow to quantize a model to int8",local:"practical-steps-to-follow-to-quantize-a-model-to-int8",headingTag:"h3"}}),ue=new b({props:{title:"Supported tools to perform quantization in 🤗 Optimum",local:"supported-tools-to-perform-quantization-in--optimum",headingTag:"h2"}}),fe=new b({props:{title:"Going further: How do machines represent numbers?",local:"going-further-how-do-machines-represent-numbers",headingTag:"h2"}}),T=new Oi({props:{$$slots:{default:[en]},$$scope:{ctx:Ue}}}),ge=new b({props:{title:"Integer representation",local:"integer-representation",headingTag:"h4"}}),$e=new Pe({props:{code:"MTklMjAlM0QlMjAwJTIweCUyMDIlNUU3JTIwJTJCJTIwMCUyMHglMjAyJTVFNiUyMCUyQiUyMDAlMjB4JTIwMiU1RTUlMjAlMkIlMjAxJTIweCUyMDIlNUU0JTIwJTJCJTIwMCUyMHglMjAyJTVFMyUyMCUyQiUyMDAlMjB4JTIwMiU1RTIlMjAlMkIlMjAxJTIweCUyMDIlNUUxJTIwJTJCJTIwMSUyMHglMjAyJTVFMA==",highlighted:'<span class="hljs-attribute">19</span> = <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">7</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">6</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">5</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">4</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">3</span> + <span class="hljs-number">0</span> x <span class="hljs-number">2</span>^<span class="hljs-number">2</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">1</span> + <span class="hljs-number">1</span> x <span class="hljs-number">2</span>^<span class="hljs-number">0</span>',wrap:!1}}),Te=new b({props:{title:"Real numbers representation",local:"real-numbers-representation",headingTag:"h4"}}),He=new Pe({props:{code:"eCUyMCUzRCUyMHNpZ24lMjB4JTIwbWFudGlzc2ElMjB4JTIwKDIlNUVleHBvbmVudCk=",highlighted:'<span class="hljs-keyword">x</span> <span class="hljs-operator">=</span> sign <span class="hljs-keyword">x</span> mantissa <span class="hljs-keyword">x</span> (<span class="hljs-number">2</span>^exponent)',wrap:!1}}),ke=new b({props:{title:"References",local:"references",headingTag:"h2"}}),{c(){p=l("meta"),v=a(),g=l("p"),w=a(),c(M.$$.fragment),Je=a(),c(q.$$.fragment),Se=a(),z=l("p"),z.innerHTML=Vt,Ae=a(),C=l("p"),C.textContent=Xt,Qe=a(),c(L.$$.fragment),Ne=a(),_=l("p"),_.textContent=Yt,Be=a(),H=l("ul"),H.innerHTML=ei,Fe=a(),k=l("p"),k.innerHTML=ti,Ee=a(),c(j.$$.fragment),Oe=a(),U=l("p"),U.innerHTML=ii,Re=a(),c(P.$$.fragment),Ze=a(),I=l("p"),I.innerHTML=ni,We=a(),c(J.$$.fragment),De=a(),S=l("p"),S.innerHTML=ai,Ge=a(),A=l("ul"),A.innerHTML=oi,Ke=a(),c(Q.$$.fragment),Ve=a(),N=l("p"),N.innerHTML=li,Xe=a(),B=l("p"),B.innerHTML=si,Ye=a(),c(F.$$.fragment),et=a(),E=l("p"),E.textContent=ri,tt=a(),O=l("ul"),O.innerHTML=pi,it=a(),R=l("p"),R.innerHTML=ci,nt=a(),c(Z.$$.fragment),at=a(),W=l("p"),W.innerHTML=ui,ot=a(),c(D.$$.fragment),lt=a(),c($.$$.fragment),st=a(),c(G.$$.fragment),rt=a(),K=l("p"),K.innerHTML=mi,pt=a(),V=l("p"),V.innerHTML=di,ct=a(),X=l("p"),X.innerHTML=fi,ut=a(),c(Y.$$.fragment),mt=a(),ee=l("p"),ee.textContent=hi,dt=a(),te=l("ul"),te.innerHTML=gi,ft=a(),c(ie.$$.fragment),ht=a(),ne=l("p"),ne.innerHTML=bi,gt=a(),ae=l("p"),ae.innerHTML=vi,bt=a(),oe=l("ol"),oe.innerHTML=wi,vt=a(),le=l("p"),le.textContent=$i,wt=a(),se=l("ul"),se.innerHTML=Ti,$t=a(),c(re.$$.fragment),Tt=a(),pe=l("p"),pe.innerHTML=yi,yt=a(),ce=l("ol"),ce.innerHTML=xi,xt=a(),c(ue.$$.fragment),Mt=a(),me=l("p"),me.textContent=Mi,qt=a(),de=l("ul"),de.innerHTML=qi,zt=a(),c(fe.$$.fragment),Ct=a(),c(T.$$.fragment),Lt=a(),he=l("p"),he.textContent=zi,_t=a(),c(ge.$$.fragment),Ht=a(),be=l("p"),be.innerHTML=Ci,kt=a(),ve=l("ol"),ve.innerHTML=Li,jt=a(),we=l("p"),we.innerHTML=_i,Ut=a(),c($e.$$.fragment),Pt=a(),y=l("ol"),y.innerHTML=Hi,It=a(),c(Te.$$.fragment),Jt=a(),ye=l("p"),ye.innerHTML=ki,St=a(),xe=l("ol"),xe.innerHTML=ji,At=a(),Me=l("p"),Me.textContent=Ui,Qt=a(),qe=l("ol"),qe.innerHTML=Pi,Nt=a(),ze=l("ul"),ze.innerHTML=Ii,Bt=a(),x=l("ol"),x.innerHTML=Ji,Ft=a(),Ce=l("ul"),Ce.innerHTML=Si,Et=a(),Le=l("p"),Le.innerHTML=Ai,Ot=a(),_e=l("p"),_e.innerHTML=Qi,Rt=a(),c(He.$$.fragment),Zt=a(),c(ke.$$.fragment),Wt=a(),je=l("ul"),je.innerHTML=Ni,Dt=a(),Ie=l("p"),this.h()},l(e){const t=Ki("svelte-u9bgzb",document.head);p=s(t,"META",{name:!0,content:!0}),t.forEach(i),v=o(e),g=s(e,"P",{}),Ei(g).forEach(i),w=o(e),u(M.$$.fragment,e),Je=o(e),u(q.$$.fragment,e),Se=o(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-p89nc2"&&(z.innerHTML=Vt),Ae=o(e),C=s(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-525bhg"&&(C.textContent=Xt),Qe=o(e),u(L.$$.fragment,e),Ne=o(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-b9e65e"&&(_.textContent=Yt),Be=o(e),H=s(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-1jnatgf"&&(H.innerHTML=ei),Fe=o(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1vh20e4"&&(k.innerHTML=ti),Ee=o(e),u(j.$$.fragment,e),Oe=o(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-txsgkq"&&(U.innerHTML=ii),Re=o(e),u(P.$$.fragment,e),Ze=o(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-jca8pk"&&(I.innerHTML=ni),We=o(e),u(J.$$.fragment,e),De=o(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1vonttx"&&(S.innerHTML=ai),Ge=o(e),A=s(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1gtt2e8"&&(A.innerHTML=oi),Ke=o(e),u(Q.$$.fragment,e),Ve=o(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-w5smo0"&&(N.innerHTML=li),Xe=o(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1hvpx8c"&&(B.innerHTML=si),Ye=o(e),u(F.$$.fragment,e),et=o(e),E=s(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-uc2av9"&&(E.textContent=ri),tt=o(e),O=s(e,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-55l006"&&(O.innerHTML=pi),it=o(e),R=s(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-vbg2s5"&&(R.innerHTML=ci),nt=o(e),u(Z.$$.fragment,e),at=o(e),W=s(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-174sqfa"&&(W.innerHTML=ui),ot=o(e),u(D.$$.fragment,e),lt=o(e),u($.$$.fragment,e),st=o(e),u(G.$$.fragment,e),rt=o(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1mcqahw"&&(K.innerHTML=mi),pt=o(e),V=s(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14zssat"&&(V.innerHTML=di),ct=o(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-vjpm0g"&&(X.innerHTML=fi),ut=o(e),u(Y.$$.fragment,e),mt=o(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-4u8slf"&&(ee.textContent=hi),dt=o(e),te=s(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-1h6e562"&&(te.innerHTML=gi),ft=o(e),u(ie.$$.fragment,e),ht=o(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1fm4s9k"&&(ne.innerHTML=bi),gt=o(e),ae=s(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-9f9h6s"&&(ae.innerHTML=vi),bt=o(e),oe=s(e,"OL",{"data-svelte-h":!0}),r(oe)!=="svelte-1e9v2jr"&&(oe.innerHTML=wi),vt=o(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-bp3yi9"&&(le.textContent=$i),wt=o(e),se=s(e,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-1y2stc2"&&(se.innerHTML=Ti),$t=o(e),u(re.$$.fragment,e),Tt=o(e),pe=s(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-5xtk1x"&&(pe.innerHTML=yi),yt=o(e),ce=s(e,"OL",{"data-svelte-h":!0}),r(ce)!=="svelte-evhxa9"&&(ce.innerHTML=xi),xt=o(e),u(ue.$$.fragment,e),Mt=o(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-3ofdc8"&&(me.textContent=Mi),qt=o(e),de=s(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-163ivnk"&&(de.innerHTML=qi),zt=o(e),u(fe.$$.fragment,e),Ct=o(e),u(T.$$.fragment,e),Lt=o(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-h5k7ub"&&(he.textContent=zi),_t=o(e),u(ge.$$.fragment,e),Ht=o(e),be=s(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-pndq9n"&&(be.innerHTML=Ci),kt=o(e),ve=s(e,"OL",{"data-svelte-h":!0}),r(ve)!=="svelte-s3ctan"&&(ve.innerHTML=Li),jt=o(e),we=s(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-73e7m1"&&(we.innerHTML=_i),Ut=o(e),u($e.$$.fragment,e),Pt=o(e),y=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(y)!=="svelte-1guibqt"&&(y.innerHTML=Hi),It=o(e),u(Te.$$.fragment,e),Jt=o(e),ye=s(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1vnsbhs"&&(ye.innerHTML=ki),St=o(e),xe=s(e,"OL",{"data-svelte-h":!0}),r(xe)!=="svelte-acn83z"&&(xe.innerHTML=ji),At=o(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-vm5l3c"&&(Me.textContent=Ui),Qt=o(e),qe=s(e,"OL",{"data-svelte-h":!0}),r(qe)!=="svelte-1g2q9e4"&&(qe.innerHTML=Pi),Nt=o(e),ze=s(e,"UL",{"data-svelte-h":!0}),r(ze)!=="svelte-18dzkd8"&&(ze.innerHTML=Ii),Bt=o(e),x=s(e,"OL",{start:!0,"data-svelte-h":!0}),r(x)!=="svelte-48nw91"&&(x.innerHTML=Ji),Ft=o(e),Ce=s(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-1la102v"&&(Ce.innerHTML=Si),Et=o(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1ugjpds"&&(Le.innerHTML=Ai),Ot=o(e),_e=s(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-9ui238"&&(_e.innerHTML=Qi),Rt=o(e),u(He.$$.fragment,e),Zt=o(e),u(ke.$$.fragment,e),Wt=o(e),je=s(e,"UL",{"data-svelte-h":!0}),r(je)!=="svelte-ertv4x"&&(je.innerHTML=Ni),Dt=o(e),Ie=s(e,"P",{}),Ei(Ie).forEach(i),this.h()},h(){Kt(p,"name","hf:doc:metadata"),Kt(p,"content",nn),Kt(y,"start","2"),Kt(x,"start","2")},m(e,t){Vi(document.head,p),n(e,v,t),n(e,g,t),n(e,w,t),m(M,e,t),n(e,Je,t),m(q,e,t),n(e,Se,t),n(e,z,t),n(e,Ae,t),n(e,C,t),n(e,Qe,t),m(L,e,t),n(e,Ne,t),n(e,_,t),n(e,Be,t),n(e,H,t),n(e,Fe,t),n(e,k,t),n(e,Ee,t),m(j,e,t),n(e,Oe,t),n(e,U,t),n(e,Re,t),m(P,e,t),n(e,Ze,t),n(e,I,t),n(e,We,t),m(J,e,t),n(e,De,t),n(e,S,t),n(e,Ge,t),n(e,A,t),n(e,Ke,t),m(Q,e,t),n(e,Ve,t),n(e,N,t),n(e,Xe,t),n(e,B,t),n(e,Ye,t),m(F,e,t),n(e,et,t),n(e,E,t),n(e,tt,t),n(e,O,t),n(e,it,t),n(e,R,t),n(e,nt,t),m(Z,e,t),n(e,at,t),n(e,W,t),n(e,ot,t),m(D,e,t),n(e,lt,t),m($,e,t),n(e,st,t),m(G,e,t),n(e,rt,t),n(e,K,t),n(e,pt,t),n(e,V,t),n(e,ct,t),n(e,X,t),n(e,ut,t),m(Y,e,t),n(e,mt,t),n(e,ee,t),n(e,dt,t),n(e,te,t),n(e,ft,t),m(ie,e,t),n(e,ht,t),n(e,ne,t),n(e,gt,t),n(e,ae,t),n(e,bt,t),n(e,oe,t),n(e,vt,t),n(e,le,t),n(e,wt,t),n(e,se,t),n(e,$t,t),m(re,e,t),n(e,Tt,t),n(e,pe,t),n(e,yt,t),n(e,ce,t),n(e,xt,t),m(ue,e,t),n(e,Mt,t),n(e,me,t),n(e,qt,t),n(e,de,t),n(e,zt,t),m(fe,e,t),n(e,Ct,t),m(T,e,t),n(e,Lt,t),n(e,he,t),n(e,_t,t),m(ge,e,t),n(e,Ht,t),n(e,be,t),n(e,kt,t),n(e,ve,t),n(e,jt,t),n(e,we,t),n(e,Ut,t),m($e,e,t),n(e,Pt,t),n(e,y,t),n(e,It,t),m(Te,e,t),n(e,Jt,t),n(e,ye,t),n(e,St,t),n(e,xe,t),n(e,At,t),n(e,Me,t),n(e,Qt,t),n(e,qe,t),n(e,Nt,t),n(e,ze,t),n(e,Bt,t),n(e,x,t),n(e,Ft,t),n(e,Ce,t),n(e,Et,t),n(e,Le,t),n(e,Ot,t),n(e,_e,t),n(e,Rt,t),m(He,e,t),n(e,Zt,t),m(ke,e,t),n(e,Wt,t),n(e,je,t),n(e,Dt,t),n(e,Ie,t),Gt=!0},p(e,[t]){const Bi={};t&2&&(Bi.$$scope={dirty:t,ctx:e}),$.$set(Bi);const Fi={};t&2&&(Fi.$$scope={dirty:t,ctx:e}),T.$set(Fi)},i(e){Gt||(d(M.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d(j.$$.fragment,e),d(P.$$.fragment,e),d(J.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d($.$$.fragment,e),d(G.$$.fragment,e),d(Y.$$.fragment,e),d(ie.$$.fragment,e),d(re.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(T.$$.fragment,e),d(ge.$$.fragment,e),d($e.$$.fragment,e),d(Te.$$.fragment,e),d(He.$$.fragment,e),d(ke.$$.fragment,e),Gt=!0)},o(e){f(M.$$.fragment,e),f(q.$$.fragment,e),f(L.$$.fragment,e),f(j.$$.fragment,e),f(P.$$.fragment,e),f(J.$$.fragment,e),f(Q.$$.fragment,e),f(F.$$.fragment,e),f(Z.$$.fragment,e),f(D.$$.fragment,e),f($.$$.fragment,e),f(G.$$.fragment,e),f(Y.$$.fragment,e),f(ie.$$.fragment,e),f(re.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(T.$$.fragment,e),f(ge.$$.fragment,e),f($e.$$.fragment,e),f(Te.$$.fragment,e),f(He.$$.fragment,e),f(ke.$$.fragment,e),Gt=!1},d(e){e&&(i(v),i(g),i(w),i(Je),i(Se),i(z),i(Ae),i(C),i(Qe),i(Ne),i(_),i(Be),i(H),i(Fe),i(k),i(Ee),i(Oe),i(U),i(Re),i(Ze),i(I),i(We),i(De),i(S),i(Ge),i(A),i(Ke),i(Ve),i(N),i(Xe),i(B),i(Ye),i(et),i(E),i(tt),i(O),i(it),i(R),i(nt),i(at),i(W),i(ot),i(lt),i(st),i(rt),i(K),i(pt),i(V),i(ct),i(X),i(ut),i(mt),i(ee),i(dt),i(te),i(ft),i(ht),i(ne),i(gt),i(ae),i(bt),i(oe),i(vt),i(le),i(wt),i(se),i($t),i(Tt),i(pe),i(yt),i(ce),i(xt),i(Mt),i(me),i(qt),i(de),i(zt),i(Ct),i(Lt),i(he),i(_t),i(Ht),i(be),i(kt),i(ve),i(jt),i(we),i(Ut),i(Pt),i(y),i(It),i(Jt),i(ye),i(St),i(xe),i(At),i(Me),i(Qt),i(qe),i(Nt),i(ze),i(Bt),i(x),i(Ft),i(Ce),i(Et),i(Le),i(Ot),i(_e),i(Rt),i(Zt),i(Wt),i(je),i(Dt),i(Ie)),i(p),h(M,e),h(q,e),h(L,e),h(j,e),h(P,e),h(J,e),h(Q,e),h(F,e),h(Z,e),h(D,e),h($,e),h(G,e),h(Y,e),h(ie,e),h(re,e),h(ue,e),h(fe,e),h(T,e),h(ge,e),h($e,e),h(Te,e),h(He,e),h(ke,e)}}}const nn='{"title":"Quantization","local":"quantization","sections":[{"title":"Theory","local":"theory","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[{"title":"Quantization to float16","local":"quantization-to-float16","sections":[],"depth":3},{"title":"Quantization to int8","local":"quantization-to-int8","sections":[],"depth":3},{"title":"Symmetric and affine quantization schemes","local":"symmetric-and-affine-quantization-schemes","sections":[],"depth":3},{"title":"Per-tensor and per-channel quantization","local":"per-tensor-and-per-channel-quantization","sections":[],"depth":3},{"title":"Calibration","local":"calibration","sections":[],"depth":3},{"title":"Practical steps to follow to quantize a model to int8","local":"practical-steps-to-follow-to-quantize-a-model-to-int8","sections":[],"depth":3}],"depth":2},{"title":"Supported tools to perform quantization in 🤗 Optimum","local":"supported-tools-to-perform-quantization-in--optimum","sections":[],"depth":2},{"title":"Going further: How do machines represent numbers?","local":"going-further-how-do-machines-represent-numbers","sections":[{"title":"Integer representation","local":"integer-representation","sections":[],"depth":4},{"title":"Real numbers representation","local":"real-numbers-representation","sections":[],"depth":4}],"depth":2},{"title":"References","local":"references","sections":[],"depth":2}],"depth":1}';function an(Ue){return Wi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cn extends Di{constructor(p){super(),Gi(this,p,an,tn,Zi,{})}}export{cn as component};
