# Normalized Configurations

Model configuration classes in 🤗 Transformers are not standardized. Although Transformers implements an `attribute_map` attribute that mitigates the issue to some extent, it does not make it easy to reason on common configuration attributes in the code.
[NormalizedConfig](/docs/optimum/main/en/utils/normalized_config#optimum.utils.NormalizedConfig) classes try to fix that by allowing access to the configuration
attribute they wrap in a standardized way.


## Base class[[optimum.utils.NormalizedConfig]]

<Tip>

While it is possible to create `NormalizedConfig` subclasses for common use-cases, it is also possible to overwrite
the `original attribute name -> normalized attribute name` mapping directly using the
`with_args()` class method.

</Tip>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.NormalizedConfig</name><anchor>optimum.utils.NormalizedConfig</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/normalized_config.py#L25</source><parameters>[{"name": "config", "val": ": typing.Union[ForwardRef('PretrainedConfig'), typing.Dict]"}, {"name": "allow_new", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **config** (`PretrainedConfig`) --
  The config to normalize.</paramsdesc><paramgroups>0</paramgroups></docstring>

Handles the normalization of `PretrainedConfig` attribute names, allowing to access attributes in a general way.




</div>

## Existing normalized configurations[[optimum.utils.NormalizedTextConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.NormalizedTextConfig</name><anchor>optimum.utils.NormalizedTextConfig</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/normalized_config.py#L87</source><parameters>[{"name": "config", "val": ": typing.Union[ForwardRef('PretrainedConfig'), typing.Dict]"}, {"name": "allow_new", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.NormalizedSeq2SeqConfig</name><anchor>optimum.utils.NormalizedSeq2SeqConfig</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/normalized_config.py#L99</source><parameters>[{"name": "config", "val": ": typing.Union[ForwardRef('PretrainedConfig'), typing.Dict]"}, {"name": "allow_new", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.NormalizedVisionConfig</name><anchor>optimum.utils.NormalizedVisionConfig</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/normalized_config.py#L106</source><parameters>[{"name": "config", "val": ": typing.Union[ForwardRef('PretrainedConfig'), typing.Dict]"}, {"name": "allow_new", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class optimum.utils.NormalizedTextAndVisionConfig</name><anchor>optimum.utils.NormalizedTextAndVisionConfig</anchor><source>https://github.com/huggingface/optimum/blob/main/optimum/utils/normalized_config.py#L125</source><parameters>[{"name": "config", "val": ": typing.Union[ForwardRef('PretrainedConfig'), typing.Dict]"}, {"name": "allow_new", "val": ": bool = False"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>