precision mediump float;
varying vec4 v_uvCoord0;
varying vec4 v_uvCoord1;

#ifdef VTG_TEXEL0_EXTS
uniform samplerExternalOES u_sampler0;
#else
uniform sampler2D u_sampler0;
#endif

#ifdef VTG_TEXEL1_EXTS
uniform samplerExternalOES u_sampler1;
#else
uniform sampler2D u_sampler1;
#endif

uniform vec4 u_aOpacity;
void main() {
   vec4 bColor = texture2D(u_sampler0, v_uvCoord0.xy);
#if defined(VTG_TEXEL0_RGBX)
   bColor.a = 1.0;
#elif defined(VTG_TEXEL0_BGRX)
   bColor = vec4(bColor.bgr, 1.0);
#elif defined(VTG_TEXEL0_BGRA)
   bColor = bColor.bgra;
#endif

   vec4 uColor = texture2D(u_sampler1, v_uvCoord1.xy);
#if defined(VTG_TEXEL1_RGBX)
   uColor.a = 1.0;
#elif defined(VTG_TEXEL1_BGRX)
   uColor = vec4(uColor.bgr, 1.0);
#elif defined(VTG_TEXEL1_BGRA)
   uColor = uColor.bgra;
#endif

    vec4 sColor = bColor * uColor * 2.0;
    vec4 hColor = 1.0 - 2.0 * (1.0 - bColor) * (1.0 - uColor);
    vec4 mRatio = step(0.5, uColor);
    vec4 tColor = mix(sColor, hColor, mRatio);
    tColor = clamp(tColor, 0.0, 1.0);

    tColor = mix(tColor, uColor, step(bColor.a, 0.002));
    tColor = mix(bColor, tColor, uColor.a * u_aOpacity.x);
    gl_FragColor = tColor;
}