
#include <metal_stdlib>
using namespace metal;

typedef struct {
    float4 position [[position]];
    float4 uvCoord0;
    float4 uvCoord1;
} VertexOutput;

typedef struct {
    float4  aOpacity;
} PixelUniforms;

fragment float4 vtaebifxBlendFS(VertexOutput vtxOut [[stage_in]], constant PixelUniforms &pxlUfm [[buffer(2)]],
    texture2d<float> srcTex0 [[texture(0)]], texture2d<float> srcTex1 [[texture(1)]])
{
    constexpr sampler smp2dLL(mag_filter::linear, min_filter::linear);
    float4 bColor = srcTex0.sample(smp2dLL, vtxOut.uvCoord0.xy);
    float4 uColor = srcTex1.sample(smp2dLL, vtxOut.uvCoord1.xy);

    float4 tColor = bColor * uColor;
    tColor = clamp(tColor, 0.0, 1.0);

    tColor = mix(tColor, uColor, step(bColor.a, 0.002));
    tColor = mix(bColor, tColor, uColor.a * pxlUfm.aOpacity.x);

   return tColor;
}
