
#include <metal_stdlib>
using namespace metal;

typedef struct {
    float4 position [[position]];
    float4 uvCoord0;
    float4 uvCoord1;
} VertexOutput;

typedef struct {
    float4  aOpacity;
    float4  mixRatio;
    float4  mixParam;
} PixelUniforms;

fragment float4 vtaebifxMatteFS(VertexOutput vtxOut [[stage_in]], constant PixelUniforms &pxlUfm [[buffer(2)]],
    texture2d<float> srcTex0 [[texture(0)]], texture2d<float> srcTex1 [[texture(1)]])
{
    constexpr sampler smp2dLL(mag_filter::linear, min_filter::linear);
    float4 color0 = srcTex0.sample(smp2dLL, vtxOut.uvCoord0.xy);
    float4 color1 = srcTex1.sample(smp2dLL, vtxOut.uvCoord1.xy);

    float mRatio = dot(pxlUfm.mixRatio, color1);
    mRatio = abs(pxlUfm.mixParam.x - mRatio);
    mRatio = mRatio * pxlUfm.aOpacity.x;
    float4 tColor = color0 * mRatio;

   return tColor;
}
