
#include <metal_stdlib>
using namespace metal;

typedef struct {
    float4 position [[position]];
    float4 texCoord;
} VertexOutput;

typedef struct {
    float4  aOpacity;
} PixelUniforms;

fragment float4 vtaebifxTex1FS(VertexOutput vtxOut [[stage_in]], constant PixelUniforms &pxlUfm [[buffer(2)]], texture2d<float> srcTex [[texture(0)]])
{
    constexpr sampler smp2dLL(mag_filter::linear, min_filter::linear);
    float4 color0 = srcTex.sample(smp2dLL, vtxOut.texCoord.xy);
    color0 = color0 * pxlUfm.aOpacity.x;
    return color0;
}
