
#include <metal_stdlib>
using namespace metal;

typedef struct {
    float4 position [[attribute(0)]];
    float4 texCoord [[attribute(1)]];
} VertexSource;

typedef struct {
    float4 position [[position]];
    float4 texCoord;
} VertexOutput;

typedef struct {
    float4x4 mvpMatrix;
    float4x4 texMatrix;
} VertexUniforms;

vertex VertexOutput vtaebifxBaseVS(VertexSource vtxSrc [[stage_in]], constant VertexUniforms &vtxUfm [[buffer(1)]])
{
    VertexOutput vtxOut;
    vtxOut.position = vtxUfm.mvpMatrix * vtxSrc.position;
    float4 tfmTexuv = float4(vtxSrc.texCoord.xy, 0.0, 1.0);
    tfmTexuv = vtxUfm.texMatrix * tfmTexuv;
    vtxOut.texCoord.xy = tfmTexuv.xy;
    vtxOut.texCoord.zw = vtxSrc.texCoord.zw;

    vtxOut.position.y = -vtxOut.position.y;
    vtxOut.texCoord.y = 1.0 - vtxOut.texCoord.y;
    vtxOut.texCoord.w = 1.0 - vtxOut.texCoord.w;
   return vtxOut;
}
